# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AgentPropertiesArgs',
    'AuthInfoArgs',
    'BaseImageTriggerArgs',
    'CredentialsArgs',
    'CustomRegistryCredentialsArgs',
    'PlatformPropertiesArgs',
    'SecretObjectArgs',
    'SourcePropertiesArgs',
    'SourceRegistryCredentialsArgs',
    'SourceTriggerArgs',
    'TaskStepPropertiesArgs',
    'TriggerPropertiesArgs',
]

@pulumi.input_type
class AgentPropertiesArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[int]] = None):
        """
        The properties that determine the run agent configuration.
        :param pulumi.Input[int] cpu: The CPU configuration in terms of number of cores required for the run.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[int]]:
        """
        The CPU configuration in terms of number of cores required for the run.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu", value)


@pulumi.input_type
class AuthInfoArgs:
    def __init__(__self__, *,
                 token: pulumi.Input[str],
                 token_type: pulumi.Input[Union[str, 'TokenType']],
                 expires_in: Optional[pulumi.Input[int]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        The authorization properties for accessing the source code repository.
        :param pulumi.Input[str] token: The access token used to access the source control provider.
        :param pulumi.Input[Union[str, 'TokenType']] token_type: The type of Auth token.
        :param pulumi.Input[int] expires_in: Time in seconds that the token remains valid
        :param pulumi.Input[str] refresh_token: The refresh token used to refresh the access token.
        :param pulumi.Input[str] scope: The scope of the access token.
        """
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "token_type", token_type)
        if expires_in is not None:
            pulumi.set(__self__, "expires_in", expires_in)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The access token used to access the source control provider.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Input[Union[str, 'TokenType']]:
        """
        The type of Auth token.
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: pulumi.Input[Union[str, 'TokenType']]):
        pulumi.set(self, "token_type", value)

    @property
    @pulumi.getter(name="expiresIn")
    def expires_in(self) -> Optional[pulumi.Input[int]]:
        """
        Time in seconds that the token remains valid
        """
        return pulumi.get(self, "expires_in")

    @expires_in.setter
    def expires_in(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expires_in", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        The refresh token used to refresh the access token.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of the access token.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class BaseImageTriggerArgs:
    def __init__(__self__, *,
                 base_image_trigger_type: pulumi.Input[Union[str, 'BaseImageTriggerType']],
                 name: pulumi.Input[str],
                 status: Optional[pulumi.Input[Union[str, 'TriggerStatus']]] = None):
        """
        The trigger based on base image dependency.
        :param pulumi.Input[Union[str, 'BaseImageTriggerType']] base_image_trigger_type: The type of the auto trigger for base image dependency updates.
        :param pulumi.Input[str] name: The name of the trigger.
        :param pulumi.Input[Union[str, 'TriggerStatus']] status: The current status of trigger.
        """
        pulumi.set(__self__, "base_image_trigger_type", base_image_trigger_type)
        pulumi.set(__self__, "name", name)
        if status is None:
            status = 'Enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="baseImageTriggerType")
    def base_image_trigger_type(self) -> pulumi.Input[Union[str, 'BaseImageTriggerType']]:
        """
        The type of the auto trigger for base image dependency updates.
        """
        return pulumi.get(self, "base_image_trigger_type")

    @base_image_trigger_type.setter
    def base_image_trigger_type(self, value: pulumi.Input[Union[str, 'BaseImageTriggerType']]):
        pulumi.set(self, "base_image_trigger_type", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'TriggerStatus']]]:
        """
        The current status of trigger.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'TriggerStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class CredentialsArgs:
    def __init__(__self__, *,
                 custom_registries: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomRegistryCredentialsArgs']]]] = None,
                 source_registry: Optional[pulumi.Input['SourceRegistryCredentialsArgs']] = None):
        """
        The parameters that describes a set of credentials that will be used when a run is invoked.
        :param pulumi.Input[Mapping[str, pulumi.Input['CustomRegistryCredentialsArgs']]] custom_registries: Describes the credential parameters for accessing other custom registries. The key
               for the dictionary item will be the registry login server (myregistry.azurecr.io) and
               the value of the item will be the registry credentials for accessing the registry.
        :param pulumi.Input['SourceRegistryCredentialsArgs'] source_registry: Describes the credential parameters for accessing the source registry.
        """
        if custom_registries is not None:
            pulumi.set(__self__, "custom_registries", custom_registries)
        if source_registry is not None:
            pulumi.set(__self__, "source_registry", source_registry)

    @property
    @pulumi.getter(name="customRegistries")
    def custom_registries(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomRegistryCredentialsArgs']]]]:
        """
        Describes the credential parameters for accessing other custom registries. The key
        for the dictionary item will be the registry login server (myregistry.azurecr.io) and
        the value of the item will be the registry credentials for accessing the registry.
        """
        return pulumi.get(self, "custom_registries")

    @custom_registries.setter
    def custom_registries(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomRegistryCredentialsArgs']]]]):
        pulumi.set(self, "custom_registries", value)

    @property
    @pulumi.getter(name="sourceRegistry")
    def source_registry(self) -> Optional[pulumi.Input['SourceRegistryCredentialsArgs']]:
        """
        Describes the credential parameters for accessing the source registry.
        """
        return pulumi.get(self, "source_registry")

    @source_registry.setter
    def source_registry(self, value: Optional[pulumi.Input['SourceRegistryCredentialsArgs']]):
        pulumi.set(self, "source_registry", value)


@pulumi.input_type
class CustomRegistryCredentialsArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input['SecretObjectArgs']] = None,
                 user_name: Optional[pulumi.Input['SecretObjectArgs']] = None):
        """
        Describes the credentials that will be used to access a custom registry during a run.
        :param pulumi.Input['SecretObjectArgs'] password: The password for logging into the custom registry. The password is a secret 
               object that allows multiple ways of providing the value for it.
        :param pulumi.Input['SecretObjectArgs'] user_name: The username for logging into the custom registry.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['SecretObjectArgs']]:
        """
        The password for logging into the custom registry. The password is a secret 
        object that allows multiple ways of providing the value for it.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['SecretObjectArgs']]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input['SecretObjectArgs']]:
        """
        The username for logging into the custom registry.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input['SecretObjectArgs']]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class PlatformPropertiesArgs:
    def __init__(__self__, *,
                 os: pulumi.Input[Union[str, 'OS']],
                 architecture: Optional[pulumi.Input[Union[str, 'Architecture']]] = None,
                 variant: Optional[pulumi.Input[Union[str, 'Variant']]] = None):
        """
        The platform properties against which the run has to happen.
        :param pulumi.Input[Union[str, 'OS']] os: The operating system type required for the run.
        :param pulumi.Input[Union[str, 'Architecture']] architecture: The OS architecture.
        :param pulumi.Input[Union[str, 'Variant']] variant: Variant of the CPU.
        """
        pulumi.set(__self__, "os", os)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if variant is not None:
            pulumi.set(__self__, "variant", variant)

    @property
    @pulumi.getter
    def os(self) -> pulumi.Input[Union[str, 'OS']]:
        """
        The operating system type required for the run.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: pulumi.Input[Union[str, 'OS']]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[Union[str, 'Architecture']]]:
        """
        The OS architecture.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[Union[str, 'Architecture']]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def variant(self) -> Optional[pulumi.Input[Union[str, 'Variant']]]:
        """
        Variant of the CPU.
        """
        return pulumi.get(self, "variant")

    @variant.setter
    def variant(self, value: Optional[pulumi.Input[Union[str, 'Variant']]]):
        pulumi.set(self, "variant", value)


@pulumi.input_type
class SecretObjectArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'SecretObjectType']]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes the properties of a secret object value.
        :param pulumi.Input[Union[str, 'SecretObjectType']] type: The type of the secret object which determines how the value of the secret object has to be
               interpreted.
        :param pulumi.Input[str] value: The value of the secret. The format of this value will be determined
               based on the type of the secret object. If the type is Opaque, the value will be
               used as is without any modification.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'SecretObjectType']]]:
        """
        The type of the secret object which determines how the value of the secret object has to be
        interpreted.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'SecretObjectType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the secret. The format of this value will be determined
        based on the type of the secret object. If the type is Opaque, the value will be
        used as is without any modification.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SourcePropertiesArgs:
    def __init__(__self__, *,
                 repository_url: pulumi.Input[str],
                 source_control_type: pulumi.Input[Union[str, 'SourceControlType']],
                 branch: Optional[pulumi.Input[str]] = None,
                 source_control_auth_properties: Optional[pulumi.Input['AuthInfoArgs']] = None):
        """
        The properties of the source code repository.
        :param pulumi.Input[str] repository_url: The full URL to the source code repository
        :param pulumi.Input[Union[str, 'SourceControlType']] source_control_type: The type of source control service.
        :param pulumi.Input[str] branch: The branch name of the source code.
        :param pulumi.Input['AuthInfoArgs'] source_control_auth_properties: The authorization properties for accessing the source code repository and to set up
               webhooks for notifications.
        """
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "source_control_type", source_control_type)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if source_control_auth_properties is not None:
            pulumi.set(__self__, "source_control_auth_properties", source_control_auth_properties)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> pulumi.Input[str]:
        """
        The full URL to the source code repository
        """
        return pulumi.get(self, "repository_url")

    @repository_url.setter
    def repository_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_url", value)

    @property
    @pulumi.getter(name="sourceControlType")
    def source_control_type(self) -> pulumi.Input[Union[str, 'SourceControlType']]:
        """
        The type of source control service.
        """
        return pulumi.get(self, "source_control_type")

    @source_control_type.setter
    def source_control_type(self, value: pulumi.Input[Union[str, 'SourceControlType']]):
        pulumi.set(self, "source_control_type", value)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The branch name of the source code.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="sourceControlAuthProperties")
    def source_control_auth_properties(self) -> Optional[pulumi.Input['AuthInfoArgs']]:
        """
        The authorization properties for accessing the source code repository and to set up
        webhooks for notifications.
        """
        return pulumi.get(self, "source_control_auth_properties")

    @source_control_auth_properties.setter
    def source_control_auth_properties(self, value: Optional[pulumi.Input['AuthInfoArgs']]):
        pulumi.set(self, "source_control_auth_properties", value)


@pulumi.input_type
class SourceRegistryCredentialsArgs:
    def __init__(__self__, *,
                 login_mode: Optional[pulumi.Input[Union[str, 'SourceRegistryLoginMode']]] = None):
        """
        Describes the credential parameters for accessing the source registry.
        :param pulumi.Input[Union[str, 'SourceRegistryLoginMode']] login_mode: The authentication mode which determines the source registry login scope. The credentials for the source registry
               will be generated using the given scope. These credentials will be used to login to
               the source registry during the run.
        """
        if login_mode is not None:
            pulumi.set(__self__, "login_mode", login_mode)

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> Optional[pulumi.Input[Union[str, 'SourceRegistryLoginMode']]]:
        """
        The authentication mode which determines the source registry login scope. The credentials for the source registry
        will be generated using the given scope. These credentials will be used to login to
        the source registry during the run.
        """
        return pulumi.get(self, "login_mode")

    @login_mode.setter
    def login_mode(self, value: Optional[pulumi.Input[Union[str, 'SourceRegistryLoginMode']]]):
        pulumi.set(self, "login_mode", value)


@pulumi.input_type
class SourceTriggerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 source_repository: pulumi.Input['SourcePropertiesArgs'],
                 source_trigger_events: pulumi.Input[Sequence[pulumi.Input[Union[str, 'SourceTriggerEvent']]]],
                 status: Optional[pulumi.Input[Union[str, 'TriggerStatus']]] = None):
        """
        The properties of a source based trigger.
        :param pulumi.Input[str] name: The name of the trigger.
        :param pulumi.Input['SourcePropertiesArgs'] source_repository: The properties that describes the source(code) for the task.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'SourceTriggerEvent']]]] source_trigger_events: The source event corresponding to the trigger.
        :param pulumi.Input[Union[str, 'TriggerStatus']] status: The current status of trigger.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source_repository", source_repository)
        pulumi.set(__self__, "source_trigger_events", source_trigger_events)
        if status is None:
            status = 'Enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> pulumi.Input['SourcePropertiesArgs']:
        """
        The properties that describes the source(code) for the task.
        """
        return pulumi.get(self, "source_repository")

    @source_repository.setter
    def source_repository(self, value: pulumi.Input['SourcePropertiesArgs']):
        pulumi.set(self, "source_repository", value)

    @property
    @pulumi.getter(name="sourceTriggerEvents")
    def source_trigger_events(self) -> pulumi.Input[Sequence[pulumi.Input[Union[str, 'SourceTriggerEvent']]]]:
        """
        The source event corresponding to the trigger.
        """
        return pulumi.get(self, "source_trigger_events")

    @source_trigger_events.setter
    def source_trigger_events(self, value: pulumi.Input[Sequence[pulumi.Input[Union[str, 'SourceTriggerEvent']]]]):
        pulumi.set(self, "source_trigger_events", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'TriggerStatus']]]:
        """
        The current status of trigger.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'TriggerStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class TaskStepPropertiesArgs:
    def __init__(__self__, *,
                 context_access_token: Optional[pulumi.Input[str]] = None,
                 context_path: Optional[pulumi.Input[str]] = None):
        """
        Base properties for any task step.
        :param pulumi.Input[str] context_access_token: The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        :param pulumi.Input[str] context_path: The URL(absolute or relative) of the source context for the task step.
        """
        if context_access_token is not None:
            pulumi.set(__self__, "context_access_token", context_access_token)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)

    @property
    @pulumi.getter(name="contextAccessToken")
    def context_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        """
        return pulumi.get(self, "context_access_token")

    @context_access_token.setter
    def context_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_access_token", value)

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL(absolute or relative) of the source context for the task step.
        """
        return pulumi.get(self, "context_path")

    @context_path.setter
    def context_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_path", value)


@pulumi.input_type
class TriggerPropertiesArgs:
    def __init__(__self__, *,
                 base_image_trigger: Optional[pulumi.Input['BaseImageTriggerArgs']] = None,
                 source_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['SourceTriggerArgs']]]] = None):
        """
        The properties of a trigger.
        :param pulumi.Input['BaseImageTriggerArgs'] base_image_trigger: The trigger based on base image dependencies.
        :param pulumi.Input[Sequence[pulumi.Input['SourceTriggerArgs']]] source_triggers: The collection of triggers based on source code repository.
        """
        if base_image_trigger is not None:
            pulumi.set(__self__, "base_image_trigger", base_image_trigger)
        if source_triggers is not None:
            pulumi.set(__self__, "source_triggers", source_triggers)

    @property
    @pulumi.getter(name="baseImageTrigger")
    def base_image_trigger(self) -> Optional[pulumi.Input['BaseImageTriggerArgs']]:
        """
        The trigger based on base image dependencies.
        """
        return pulumi.get(self, "base_image_trigger")

    @base_image_trigger.setter
    def base_image_trigger(self, value: Optional[pulumi.Input['BaseImageTriggerArgs']]):
        pulumi.set(self, "base_image_trigger", value)

    @property
    @pulumi.getter(name="sourceTriggers")
    def source_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceTriggerArgs']]]]:
        """
        The collection of triggers based on source code repository.
        """
        return pulumi.get(self, "source_triggers")

    @source_triggers.setter
    def source_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceTriggerArgs']]]]):
        pulumi.set(self, "source_triggers", value)


