# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ListClusterStreamingJobsResult',
    'AwaitableListClusterStreamingJobsResult',
    'list_cluster_streaming_jobs',
    'list_cluster_streaming_jobs_output',
]

@pulumi.output_type
class ListClusterStreamingJobsResult:
    """
    A list of streaming jobs. Populated by a List operation.
    """
    def __init__(__self__, next_link=None, value=None):
        if next_link and not isinstance(next_link, str):
            raise TypeError("Expected argument 'next_link' to be a str")
        pulumi.set(__self__, "next_link", next_link)
        if value and not isinstance(value, list):
            raise TypeError("Expected argument 'value' to be a list")
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="nextLink")
    def next_link(self) -> str:
        """
        The URL to fetch the next set of streaming jobs.
        """
        return pulumi.get(self, "next_link")

    @property
    @pulumi.getter
    def value(self) -> Sequence['outputs.ClusterJobResponse']:
        """
        A list of streaming jobs.
        """
        return pulumi.get(self, "value")


class AwaitableListClusterStreamingJobsResult(ListClusterStreamingJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListClusterStreamingJobsResult(
            next_link=self.next_link,
            value=self.value)


def list_cluster_streaming_jobs(cluster_name: Optional[str] = None,
                                resource_group_name: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListClusterStreamingJobsResult:
    """
    A list of streaming jobs. Populated by a List operation.


    :param str cluster_name: The name of the cluster.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:streamanalytics/v20200301preview:listClusterStreamingJobs', __args__, opts=opts, typ=ListClusterStreamingJobsResult).value

    return AwaitableListClusterStreamingJobsResult(
        next_link=__ret__.next_link,
        value=__ret__.value)


@_utilities.lift_output_func(list_cluster_streaming_jobs)
def list_cluster_streaming_jobs_output(cluster_name: Optional[pulumi.Input[str]] = None,
                                       resource_group_name: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListClusterStreamingJobsResult]:
    """
    A list of streaming jobs. Populated by a List operation.


    :param str cluster_name: The name of the cluster.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
