# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetContactProfileResult',
    'AwaitableGetContactProfileResult',
    'get_contact_profile',
    'get_contact_profile_output',
]

@pulumi.output_type
class GetContactProfileResult:
    """
    Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
    """
    def __init__(__self__, auto_tracking_configuration=None, etag=None, id=None, links=None, location=None, minimum_elevation_degrees=None, minimum_viable_contact_duration=None, name=None, system_data=None, tags=None, type=None):
        if auto_tracking_configuration and not isinstance(auto_tracking_configuration, str):
            raise TypeError("Expected argument 'auto_tracking_configuration' to be a str")
        pulumi.set(__self__, "auto_tracking_configuration", auto_tracking_configuration)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if minimum_elevation_degrees and not isinstance(minimum_elevation_degrees, float):
            raise TypeError("Expected argument 'minimum_elevation_degrees' to be a float")
        pulumi.set(__self__, "minimum_elevation_degrees", minimum_elevation_degrees)
        if minimum_viable_contact_duration and not isinstance(minimum_viable_contact_duration, str):
            raise TypeError("Expected argument 'minimum_viable_contact_duration' to be a str")
        pulumi.set(__self__, "minimum_viable_contact_duration", minimum_viable_contact_duration)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autoTrackingConfiguration")
    def auto_tracking_configuration(self) -> Optional[str]:
        """
        Auto track configuration.
        """
        return pulumi.get(self, "auto_tracking_configuration")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def links(self) -> Sequence['outputs.ContactProfileLinkResponse']:
        """
        Links of the Contact Profile
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="minimumElevationDegrees")
    def minimum_elevation_degrees(self) -> Optional[float]:
        """
        Minimum viable elevation for the contact in decimal degrees.
        """
        return pulumi.get(self, "minimum_elevation_degrees")

    @property
    @pulumi.getter(name="minimumViableContactDuration")
    def minimum_viable_contact_duration(self) -> Optional[str]:
        """
        Minimum viable contact duration in ISO 8601 format.
        """
        return pulumi.get(self, "minimum_viable_contact_duration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetContactProfileResult(GetContactProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContactProfileResult(
            auto_tracking_configuration=self.auto_tracking_configuration,
            etag=self.etag,
            id=self.id,
            links=self.links,
            location=self.location,
            minimum_elevation_degrees=self.minimum_elevation_degrees,
            minimum_viable_contact_duration=self.minimum_viable_contact_duration,
            name=self.name,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_contact_profile(contact_profile_name: Optional[str] = None,
                        resource_group_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContactProfileResult:
    """
    Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.


    :param str contact_profile_name: Contact Profile Name
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['contactProfileName'] = contact_profile_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:orbital/v20210404preview:getContactProfile', __args__, opts=opts, typ=GetContactProfileResult).value

    return AwaitableGetContactProfileResult(
        auto_tracking_configuration=__ret__.auto_tracking_configuration,
        etag=__ret__.etag,
        id=__ret__.id,
        links=__ret__.links,
        location=__ret__.location,
        minimum_elevation_degrees=__ret__.minimum_elevation_degrees,
        minimum_viable_contact_duration=__ret__.minimum_viable_contact_duration,
        name=__ret__.name,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_contact_profile)
def get_contact_profile_output(contact_profile_name: Optional[pulumi.Input[str]] = None,
                               resource_group_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetContactProfileResult]:
    """
    Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.


    :param str contact_profile_name: Contact Profile Name
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
