# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetActivityLogAlertResult',
    'AwaitableGetActivityLogAlertResult',
    'get_activity_log_alert',
    'get_activity_log_alert_output',
]

@pulumi.output_type
class GetActivityLogAlertResult:
    """
    An activity log alert resource.
    """
    def __init__(__self__, actions=None, condition=None, description=None, enabled=None, id=None, location=None, name=None, scopes=None, tags=None, type=None):
        if actions and not isinstance(actions, dict):
            raise TypeError("Expected argument 'actions' to be a dict")
        pulumi.set(__self__, "actions", actions)
        if condition and not isinstance(condition, dict):
            raise TypeError("Expected argument 'condition' to be a dict")
        pulumi.set(__self__, "condition", condition)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def actions(self) -> 'outputs.ActivityLogAlertActionListResponse':
        """
        The actions that will activate when the condition is met.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ActivityLogAlertAllOfConditionResponse':
        """
        The condition that will cause this alert to activate.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of this activity log alert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates whether this activity log alert is enabled. If an activity log alert is not enabled, then none of its actions will be activated.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Azure resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        """
        A list of resourceIds that will be used as prefixes. The alert will only apply to activityLogs with resourceIds that fall under one of these prefixes. This list must include at least one item.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Azure resource type
        """
        return pulumi.get(self, "type")


class AwaitableGetActivityLogAlertResult(GetActivityLogAlertResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActivityLogAlertResult(
            actions=self.actions,
            condition=self.condition,
            description=self.description,
            enabled=self.enabled,
            id=self.id,
            location=self.location,
            name=self.name,
            scopes=self.scopes,
            tags=self.tags,
            type=self.type)


def get_activity_log_alert(activity_log_alert_name: Optional[str] = None,
                           resource_group_name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActivityLogAlertResult:
    """
    An activity log alert resource.


    :param str activity_log_alert_name: The name of the activity log alert.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['activityLogAlertName'] = activity_log_alert_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:insights/v20170401:getActivityLogAlert', __args__, opts=opts, typ=GetActivityLogAlertResult).value

    return AwaitableGetActivityLogAlertResult(
        actions=__ret__.actions,
        condition=__ret__.condition,
        description=__ret__.description,
        enabled=__ret__.enabled,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        scopes=__ret__.scopes,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_activity_log_alert)
def get_activity_log_alert_output(activity_log_alert_name: Optional[pulumi.Input[str]] = None,
                                  resource_group_name: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetActivityLogAlertResult]:
    """
    An activity log alert resource.


    :param str activity_log_alert_name: The name of the activity log alert.
    :param str resource_group_name: The name of the resource group.
    """
    ...
