# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs', 'PrivateEndpointConnectionControllerPrivateEndpointConnection']

@pulumi.input_type
class PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs:
    def __init__(__self__, *,
                 migrate_project_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 e_tag: Optional[pulumi.Input[str]] = None,
                 pe_connection_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['ConnectionStateRequestBodyPropertiesArgs']] = None):
        """
        The set of arguments for constructing a PrivateEndpointConnectionControllerPrivateEndpointConnection resource.
        :param pulumi.Input[str] migrate_project_name: Migrate project name.
        :param pulumi.Input[str] resource_group_name: Name of the Azure Resource Group that project is part of.
        :param pulumi.Input[str] e_tag: Gets the tag for optimistic concurrency control.
        :param pulumi.Input[str] pe_connection_name: Private endpoint connection name.
        :param pulumi.Input['ConnectionStateRequestBodyPropertiesArgs'] properties: Properties of Connection state request.
        """
        pulumi.set(__self__, "migrate_project_name", migrate_project_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if pe_connection_name is not None:
            pulumi.set(__self__, "pe_connection_name", pe_connection_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="migrateProjectName")
    def migrate_project_name(self) -> pulumi.Input[str]:
        """
        Migrate project name.
        """
        return pulumi.get(self, "migrate_project_name")

    @migrate_project_name.setter
    def migrate_project_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "migrate_project_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Name of the Azure Resource Group that project is part of.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the tag for optimistic concurrency control.
        """
        return pulumi.get(self, "e_tag")

    @e_tag.setter
    def e_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "e_tag", value)

    @property
    @pulumi.getter(name="peConnectionName")
    def pe_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        Private endpoint connection name.
        """
        return pulumi.get(self, "pe_connection_name")

    @pe_connection_name.setter
    def pe_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pe_connection_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ConnectionStateRequestBodyPropertiesArgs']]:
        """
        Properties of Connection state request.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ConnectionStateRequestBodyPropertiesArgs']]):
        pulumi.set(self, "properties", value)


class PrivateEndpointConnectionControllerPrivateEndpointConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 e_tag: Optional[pulumi.Input[str]] = None,
                 migrate_project_name: Optional[pulumi.Input[str]] = None,
                 pe_connection_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['ConnectionStateRequestBodyPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        REST model used to encapsulate the user visible state of a PrivateEndpoint.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] e_tag: Gets the tag for optimistic concurrency control.
        :param pulumi.Input[str] migrate_project_name: Migrate project name.
        :param pulumi.Input[str] pe_connection_name: Private endpoint connection name.
        :param pulumi.Input[pulumi.InputType['ConnectionStateRequestBodyPropertiesArgs']] properties: Properties of Connection state request.
        :param pulumi.Input[str] resource_group_name: Name of the Azure Resource Group that project is part of.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        REST model used to encapsulate the user visible state of a PrivateEndpoint.

        :param str resource_name: The name of the resource.
        :param PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 e_tag: Optional[pulumi.Input[str]] = None,
                 migrate_project_name: Optional[pulumi.Input[str]] = None,
                 pe_connection_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['ConnectionStateRequestBodyPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs.__new__(PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs)

            __props__.__dict__["e_tag"] = e_tag
            if migrate_project_name is None and not opts.urn:
                raise TypeError("Missing required property 'migrate_project_name'")
            __props__.__dict__["migrate_project_name"] = migrate_project_name
            __props__.__dict__["pe_connection_name"] = pe_connection_name
            __props__.__dict__["properties"] = properties
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        super(PrivateEndpointConnectionControllerPrivateEndpointConnection, __self__).__init__(
            'azure-native:migrate/v20200501:PrivateEndpointConnectionControllerPrivateEndpointConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PrivateEndpointConnectionControllerPrivateEndpointConnection':
        """
        Get an existing PrivateEndpointConnectionControllerPrivateEndpointConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs.__new__(PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs)

        __props__.__dict__["e_tag"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return PrivateEndpointConnectionControllerPrivateEndpointConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> pulumi.Output[str]:
        """
        Gets the tag for optimistic concurrency control.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Gets the name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.PrivateEndpointConnectionPropertiesResponse']:
        """
        Gets the properties of the object.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Gets the resource type.
        """
        return pulumi.get(self, "type")

