# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'HealthAlertActionArgs',
    'HealthAlertCriteriaArgs',
    'HealthStateArgs',
    'VmGuestHealthAlertCriterionArgs',
]

@pulumi.input_type
class HealthAlertActionArgs:
    def __init__(__self__, *,
                 action_group_id: Optional[pulumi.Input[str]] = None,
                 web_hook_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        An alert action.
        :param pulumi.Input[str] action_group_id: the id of the action group to use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] web_hook_properties: The properties of a webhook object.
        """
        if action_group_id is not None:
            pulumi.set(__self__, "action_group_id", action_group_id)
        if web_hook_properties is not None:
            pulumi.set(__self__, "web_hook_properties", web_hook_properties)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        the id of the action group to use.
        """
        return pulumi.get(self, "action_group_id")

    @action_group_id.setter
    def action_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_group_id", value)

    @property
    @pulumi.getter(name="webHookProperties")
    def web_hook_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The properties of a webhook object.
        """
        return pulumi.get(self, "web_hook_properties")

    @web_hook_properties.setter
    def web_hook_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "web_hook_properties", value)


@pulumi.input_type
class HealthAlertCriteriaArgs:
    def __init__(__self__, *,
                 all_of: Optional[pulumi.Input[Sequence[pulumi.Input['VmGuestHealthAlertCriterionArgs']]]] = None):
        """
        Specifies the resource health alert criteria for a single resource that has multiple metric criteria.
        :param pulumi.Input[Sequence[pulumi.Input['VmGuestHealthAlertCriterionArgs']]] all_of: The list of metric criteria for this 'all of' operation. 
        """
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmGuestHealthAlertCriterionArgs']]]]:
        """
        The list of metric criteria for this 'all of' operation. 
        """
        return pulumi.get(self, "all_of")

    @all_of.setter
    def all_of(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmGuestHealthAlertCriterionArgs']]]]):
        pulumi.set(self, "all_of", value)


@pulumi.input_type
class HealthStateArgs:
    def __init__(__self__, *,
                 health_state_name: pulumi.Input[Union[str, 'HealthStateName']],
                 severity: pulumi.Input[float]):
        """
        Specifies the health state to alert on and the corresponding severity
        :param pulumi.Input[Union[str, 'HealthStateName']] health_state_name: Health state name
        :param pulumi.Input[float] severity: Severity of alert fired
        """
        pulumi.set(__self__, "health_state_name", health_state_name)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="healthStateName")
    def health_state_name(self) -> pulumi.Input[Union[str, 'HealthStateName']]:
        """
        Health state name
        """
        return pulumi.get(self, "health_state_name")

    @health_state_name.setter
    def health_state_name(self, value: pulumi.Input[Union[str, 'HealthStateName']]):
        pulumi.set(self, "health_state_name", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[float]:
        """
        Severity of alert fired
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[float]):
        pulumi.set(self, "severity", value)


@pulumi.input_type
class VmGuestHealthAlertCriterionArgs:
    def __init__(__self__, *,
                 health_states: pulumi.Input[Sequence[pulumi.Input['HealthStateArgs']]],
                 namespace: pulumi.Input[str],
                 monitor_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 monitor_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Specifies the health alert criteria to alert on.
        :param pulumi.Input[Sequence[pulumi.Input['HealthStateArgs']]] health_states: Health states to alert on
        :param pulumi.Input[str] namespace: specifies the type of the alert criterion.
               Expected value is 'GuestVmHealth'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_names: Names of health monitor on which to define alert
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitor_types: Names of health monitor type on which to define alert
        """
        pulumi.set(__self__, "health_states", health_states)
        pulumi.set(__self__, "namespace", 'GuestVmHealth')
        if monitor_names is not None:
            pulumi.set(__self__, "monitor_names", monitor_names)
        if monitor_types is not None:
            pulumi.set(__self__, "monitor_types", monitor_types)

    @property
    @pulumi.getter(name="healthStates")
    def health_states(self) -> pulumi.Input[Sequence[pulumi.Input['HealthStateArgs']]]:
        """
        Health states to alert on
        """
        return pulumi.get(self, "health_states")

    @health_states.setter
    def health_states(self, value: pulumi.Input[Sequence[pulumi.Input['HealthStateArgs']]]):
        pulumi.set(self, "health_states", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        specifies the type of the alert criterion.
        Expected value is 'GuestVmHealth'.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="monitorNames")
    def monitor_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of health monitor on which to define alert
        """
        return pulumi.get(self, "monitor_names")

    @monitor_names.setter
    def monitor_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "monitor_names", value)

    @property
    @pulumi.getter(name="monitorTypes")
    def monitor_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of health monitor type on which to define alert
        """
        return pulumi.get(self, "monitor_types")

    @monitor_types.setter
    def monitor_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "monitor_types", value)


