# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLabelingJobResult',
    'AwaitableGetLabelingJobResult',
    'get_labeling_job',
    'get_labeling_job_output',
]

@pulumi.output_type
class GetLabelingJobResult:
    """
    Machine Learning labeling job object wrapped into ARM resource envelope.
    """
    def __init__(__self__, id=None, name=None, properties=None, system_data=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource URL of the entity (not URL encoded).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource entity.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.LabelingJobPropertiesResponse':
        """
        Definition of a labeling job.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource provider and type.
        """
        return pulumi.get(self, "type")


class AwaitableGetLabelingJobResult(GetLabelingJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLabelingJobResult(
            id=self.id,
            name=self.name,
            properties=self.properties,
            system_data=self.system_data,
            type=self.type)


def get_labeling_job(include_job_instructions: Optional[bool] = None,
                     include_label_categories: Optional[bool] = None,
                     labeling_job_id: Optional[str] = None,
                     resource_group_name: Optional[str] = None,
                     workspace_name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLabelingJobResult:
    """
    Machine Learning labeling job object wrapped into ARM resource envelope.
    API Version: 2020-09-01-preview.


    :param bool include_job_instructions: Boolean value to indicate whether to include JobInstructions in response.
    :param bool include_label_categories: Boolean value to indicate whether to include LabelCategories in response.
    :param str labeling_job_id: Name and identifier for LabelingJob.
    :param str resource_group_name: Name of the resource group in which workspace is located.
    :param str workspace_name: Name of Azure Machine Learning workspace.
    """
    __args__ = dict()
    __args__['includeJobInstructions'] = include_job_instructions
    __args__['includeLabelCategories'] = include_label_categories
    __args__['labelingJobId'] = labeling_job_id
    __args__['resourceGroupName'] = resource_group_name
    __args__['workspaceName'] = workspace_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:machinelearningservices:getLabelingJob', __args__, opts=opts, typ=GetLabelingJobResult).value

    return AwaitableGetLabelingJobResult(
        id=__ret__.id,
        name=__ret__.name,
        properties=__ret__.properties,
        system_data=__ret__.system_data,
        type=__ret__.type)


@_utilities.lift_output_func(get_labeling_job)
def get_labeling_job_output(include_job_instructions: Optional[pulumi.Input[Optional[bool]]] = None,
                            include_label_categories: Optional[pulumi.Input[Optional[bool]]] = None,
                            labeling_job_id: Optional[pulumi.Input[str]] = None,
                            resource_group_name: Optional[pulumi.Input[str]] = None,
                            workspace_name: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLabelingJobResult]:
    """
    Machine Learning labeling job object wrapped into ARM resource envelope.
    API Version: 2020-09-01-preview.


    :param bool include_job_instructions: Boolean value to indicate whether to include JobInstructions in response.
    :param bool include_label_categories: Boolean value to indicate whether to include LabelCategories in response.
    :param str labeling_job_id: Name and identifier for LabelingJob.
    :param str resource_group_name: Name of the resource group in which workspace is located.
    :param str workspace_name: Name of Azure Machine Learning workspace.
    """
    ...
