# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ManagedHostingEnvironmentArgs', 'ManagedHostingEnvironment']

@pulumi.input_type
class ManagedHostingEnvironmentArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 status: pulumi.Input['HostingEnvironmentStatus'],
                 allowed_multi_sizes: Optional[pulumi.Input[str]] = None,
                 allowed_worker_sizes: Optional[pulumi.Input[str]] = None,
                 api_management_account_id: Optional[pulumi.Input[str]] = None,
                 cluster_settings: Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 database_service_objective: Optional[pulumi.Input[str]] = None,
                 dns_suffix: Optional[pulumi.Input[str]] = None,
                 environment_capacities: Optional[pulumi.Input[Sequence[pulumi.Input['StampCapacityArgs']]]] = None,
                 environment_is_healthy: Optional[pulumi.Input[bool]] = None,
                 environment_status: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 internal_load_balancing_mode: Optional[pulumi.Input['InternalLoadBalancingMode']] = None,
                 ipssl_address_count: Optional[pulumi.Input[int]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 last_action: Optional[pulumi.Input[str]] = None,
                 last_action_result: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maximum_number_of_machines: Optional[pulumi.Input[int]] = None,
                 multi_role_count: Optional[pulumi.Input[int]] = None,
                 multi_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_access_control_list: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAccessControlEntryArgs']]]] = None,
                 provisioning_state: Optional[pulumi.Input['ProvisioningState']] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 upgrade_domains: Optional[pulumi.Input[int]] = None,
                 vip_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualIPMappingArgs']]]] = None,
                 virtual_network: Optional[pulumi.Input['VirtualNetworkProfileArgs']] = None,
                 vnet_name: Optional[pulumi.Input[str]] = None,
                 vnet_resource_group_name: Optional[pulumi.Input[str]] = None,
                 vnet_subnet_name: Optional[pulumi.Input[str]] = None,
                 worker_pools: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolArgs']]]] = None):
        """
        The set of arguments for constructing a ManagedHostingEnvironment resource.
        :param pulumi.Input[str] resource_group_name: Name of resource group
        :param pulumi.Input['HostingEnvironmentStatus'] status: Current status of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] allowed_multi_sizes: List of comma separated strings describing which VM sizes are allowed for front-ends
        :param pulumi.Input[str] allowed_worker_sizes: List of comma separated strings describing which VM sizes are allowed for workers
        :param pulumi.Input[str] api_management_account_id: Api Management Account associated with this Hosting Environment
        :param pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]] cluster_settings: Custom settings for changing the behavior of the hosting environment
        :param pulumi.Input[str] database_edition: Edition of the metadata database for the hostingEnvironment (App Service Environment) e.g. "Standard"
        :param pulumi.Input[str] database_service_objective: Service objective of the metadata database for the hostingEnvironment (App Service Environment) e.g. "S0"
        :param pulumi.Input[str] dns_suffix: DNS suffix of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[Sequence[pulumi.Input['StampCapacityArgs']]] environment_capacities: Current total, used, and available worker capacities
        :param pulumi.Input[bool] environment_is_healthy: True/false indicating whether the hostingEnvironment (App Service Environment) is healthy
        :param pulumi.Input[str] environment_status: Detailed message about with results of the last check of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input['InternalLoadBalancingMode'] internal_load_balancing_mode: Specifies which endpoints to serve internally in the hostingEnvironment's (App Service Environment) VNET
        :param pulumi.Input[int] ipssl_address_count: Number of IP SSL addresses reserved for this hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] last_action: Last deployment action on this hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] last_action_result: Result of the last deployment action on this hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[int] maximum_number_of_machines: Maximum number of VMs in this hostingEnvironment (App Service Environment)
        :param pulumi.Input[int] multi_role_count: Number of front-end instances
        :param pulumi.Input[str] multi_size: Front-end VM size, e.g. "Medium", "Large"
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAccessControlEntryArgs']]] network_access_control_list: Access control list for controlling traffic to the hostingEnvironment (App Service Environment)
        :param pulumi.Input['ProvisioningState'] provisioning_state: Provisioning state of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] resource_group: Resource group of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] subscription_id: Subscription of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[bool] suspended: True/false indicating whether the hostingEnvironment is suspended. The environment can be suspended e.g. when the management endpoint is no longer available
                           (most likely because NSG blocked the incoming traffic)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        :param pulumi.Input[int] upgrade_domains: Number of upgrade domains of this hostingEnvironment (App Service Environment)
        :param pulumi.Input[Sequence[pulumi.Input['VirtualIPMappingArgs']]] vip_mappings: Description of IP SSL mapping for this hostingEnvironment (App Service Environment)
        :param pulumi.Input['VirtualNetworkProfileArgs'] virtual_network: Description of the hostingEnvironment's (App Service Environment) virtual network
        :param pulumi.Input[str] vnet_name: Name of the hostingEnvironment's (App Service Environment) virtual network
        :param pulumi.Input[str] vnet_resource_group_name: Resource group of the hostingEnvironment's (App Service Environment) virtual network
        :param pulumi.Input[str] vnet_subnet_name: Subnet of the hostingEnvironment's (App Service Environment) virtual network
        :param pulumi.Input[Sequence[pulumi.Input['WorkerPoolArgs']]] worker_pools: Description of worker pools with worker size ids, VM sizes, and number of workers in each pool
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "status", status)
        if allowed_multi_sizes is not None:
            pulumi.set(__self__, "allowed_multi_sizes", allowed_multi_sizes)
        if allowed_worker_sizes is not None:
            pulumi.set(__self__, "allowed_worker_sizes", allowed_worker_sizes)
        if api_management_account_id is not None:
            pulumi.set(__self__, "api_management_account_id", api_management_account_id)
        if cluster_settings is not None:
            pulumi.set(__self__, "cluster_settings", cluster_settings)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if database_service_objective is not None:
            pulumi.set(__self__, "database_service_objective", database_service_objective)
        if dns_suffix is not None:
            pulumi.set(__self__, "dns_suffix", dns_suffix)
        if environment_capacities is not None:
            pulumi.set(__self__, "environment_capacities", environment_capacities)
        if environment_is_healthy is not None:
            pulumi.set(__self__, "environment_is_healthy", environment_is_healthy)
        if environment_status is not None:
            pulumi.set(__self__, "environment_status", environment_status)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if internal_load_balancing_mode is not None:
            pulumi.set(__self__, "internal_load_balancing_mode", internal_load_balancing_mode)
        if ipssl_address_count is not None:
            pulumi.set(__self__, "ipssl_address_count", ipssl_address_count)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if last_action is not None:
            pulumi.set(__self__, "last_action", last_action)
        if last_action_result is not None:
            pulumi.set(__self__, "last_action_result", last_action_result)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_number_of_machines is not None:
            pulumi.set(__self__, "maximum_number_of_machines", maximum_number_of_machines)
        if multi_role_count is not None:
            pulumi.set(__self__, "multi_role_count", multi_role_count)
        if multi_size is not None:
            pulumi.set(__self__, "multi_size", multi_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_access_control_list is not None:
            pulumi.set(__self__, "network_access_control_list", network_access_control_list)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if upgrade_domains is not None:
            pulumi.set(__self__, "upgrade_domains", upgrade_domains)
        if vip_mappings is not None:
            pulumi.set(__self__, "vip_mappings", vip_mappings)
        if virtual_network is not None:
            pulumi.set(__self__, "virtual_network", virtual_network)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)
        if vnet_resource_group_name is not None:
            pulumi.set(__self__, "vnet_resource_group_name", vnet_resource_group_name)
        if vnet_subnet_name is not None:
            pulumi.set(__self__, "vnet_subnet_name", vnet_subnet_name)
        if worker_pools is not None:
            pulumi.set(__self__, "worker_pools", worker_pools)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Name of resource group
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input['HostingEnvironmentStatus']:
        """
        Current status of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input['HostingEnvironmentStatus']):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="allowedMultiSizes")
    def allowed_multi_sizes(self) -> Optional[pulumi.Input[str]]:
        """
        List of comma separated strings describing which VM sizes are allowed for front-ends
        """
        return pulumi.get(self, "allowed_multi_sizes")

    @allowed_multi_sizes.setter
    def allowed_multi_sizes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_multi_sizes", value)

    @property
    @pulumi.getter(name="allowedWorkerSizes")
    def allowed_worker_sizes(self) -> Optional[pulumi.Input[str]]:
        """
        List of comma separated strings describing which VM sizes are allowed for workers
        """
        return pulumi.get(self, "allowed_worker_sizes")

    @allowed_worker_sizes.setter
    def allowed_worker_sizes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_worker_sizes", value)

    @property
    @pulumi.getter(name="apiManagementAccountId")
    def api_management_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Api Management Account associated with this Hosting Environment
        """
        return pulumi.get(self, "api_management_account_id")

    @api_management_account_id.setter
    def api_management_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_management_account_id", value)

    @property
    @pulumi.getter(name="clusterSettings")
    def cluster_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]]:
        """
        Custom settings for changing the behavior of the hosting environment
        """
        return pulumi.get(self, "cluster_settings")

    @cluster_settings.setter
    def cluster_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NameValuePairArgs']]]]):
        pulumi.set(self, "cluster_settings", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[str]]:
        """
        Edition of the metadata database for the hostingEnvironment (App Service Environment) e.g. "Standard"
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="databaseServiceObjective")
    def database_service_objective(self) -> Optional[pulumi.Input[str]]:
        """
        Service objective of the metadata database for the hostingEnvironment (App Service Environment) e.g. "S0"
        """
        return pulumi.get(self, "database_service_objective")

    @database_service_objective.setter
    def database_service_objective(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_service_objective", value)

    @property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        DNS suffix of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "dns_suffix")

    @dns_suffix.setter
    def dns_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_suffix", value)

    @property
    @pulumi.getter(name="environmentCapacities")
    def environment_capacities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StampCapacityArgs']]]]:
        """
        Current total, used, and available worker capacities
        """
        return pulumi.get(self, "environment_capacities")

    @environment_capacities.setter
    def environment_capacities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StampCapacityArgs']]]]):
        pulumi.set(self, "environment_capacities", value)

    @property
    @pulumi.getter(name="environmentIsHealthy")
    def environment_is_healthy(self) -> Optional[pulumi.Input[bool]]:
        """
        True/false indicating whether the hostingEnvironment (App Service Environment) is healthy
        """
        return pulumi.get(self, "environment_is_healthy")

    @environment_is_healthy.setter
    def environment_is_healthy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "environment_is_healthy", value)

    @property
    @pulumi.getter(name="environmentStatus")
    def environment_status(self) -> Optional[pulumi.Input[str]]:
        """
        Detailed message about with results of the last check of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "environment_status")

    @environment_status.setter
    def environment_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_status", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="internalLoadBalancingMode")
    def internal_load_balancing_mode(self) -> Optional[pulumi.Input['InternalLoadBalancingMode']]:
        """
        Specifies which endpoints to serve internally in the hostingEnvironment's (App Service Environment) VNET
        """
        return pulumi.get(self, "internal_load_balancing_mode")

    @internal_load_balancing_mode.setter
    def internal_load_balancing_mode(self, value: Optional[pulumi.Input['InternalLoadBalancingMode']]):
        pulumi.set(self, "internal_load_balancing_mode", value)

    @property
    @pulumi.getter(name="ipsslAddressCount")
    def ipssl_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of IP SSL addresses reserved for this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "ipssl_address_count")

    @ipssl_address_count.setter
    def ipssl_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipssl_address_count", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="lastAction")
    def last_action(self) -> Optional[pulumi.Input[str]]:
        """
        Last deployment action on this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "last_action")

    @last_action.setter
    def last_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_action", value)

    @property
    @pulumi.getter(name="lastActionResult")
    def last_action_result(self) -> Optional[pulumi.Input[str]]:
        """
        Result of the last deployment action on this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "last_action_result")

    @last_action_result.setter
    def last_action_result(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_action_result", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maximumNumberOfMachines")
    def maximum_number_of_machines(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of VMs in this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "maximum_number_of_machines")

    @maximum_number_of_machines.setter
    def maximum_number_of_machines(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_number_of_machines", value)

    @property
    @pulumi.getter(name="multiRoleCount")
    def multi_role_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of front-end instances
        """
        return pulumi.get(self, "multi_role_count")

    @multi_role_count.setter
    def multi_role_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "multi_role_count", value)

    @property
    @pulumi.getter(name="multiSize")
    def multi_size(self) -> Optional[pulumi.Input[str]]:
        """
        Front-end VM size, e.g. "Medium", "Large"
        """
        return pulumi.get(self, "multi_size")

    @multi_size.setter
    def multi_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkAccessControlList")
    def network_access_control_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAccessControlEntryArgs']]]]:
        """
        Access control list for controlling traffic to the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "network_access_control_list")

    @network_access_control_list.setter
    def network_access_control_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAccessControlEntryArgs']]]]):
        pulumi.set(self, "network_access_control_list", value)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[pulumi.Input['ProvisioningState']]:
        """
        Provisioning state of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "provisioning_state")

    @provisioning_state.setter
    def provisioning_state(self, value: Optional[pulumi.Input['ProvisioningState']]):
        pulumi.set(self, "provisioning_state", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        True/false indicating whether the hostingEnvironment is suspended. The environment can be suspended e.g. when the management endpoint is no longer available
                    (most likely because NSG blocked the incoming traffic)
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="upgradeDomains")
    def upgrade_domains(self) -> Optional[pulumi.Input[int]]:
        """
        Number of upgrade domains of this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "upgrade_domains")

    @upgrade_domains.setter
    def upgrade_domains(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "upgrade_domains", value)

    @property
    @pulumi.getter(name="vipMappings")
    def vip_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualIPMappingArgs']]]]:
        """
        Description of IP SSL mapping for this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "vip_mappings")

    @vip_mappings.setter
    def vip_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualIPMappingArgs']]]]):
        pulumi.set(self, "vip_mappings", value)

    @property
    @pulumi.getter(name="virtualNetwork")
    def virtual_network(self) -> Optional[pulumi.Input['VirtualNetworkProfileArgs']]:
        """
        Description of the hostingEnvironment's (App Service Environment) virtual network
        """
        return pulumi.get(self, "virtual_network")

    @virtual_network.setter
    def virtual_network(self, value: Optional[pulumi.Input['VirtualNetworkProfileArgs']]):
        pulumi.set(self, "virtual_network", value)

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the hostingEnvironment's (App Service Environment) virtual network
        """
        return pulumi.get(self, "vnet_name")

    @vnet_name.setter
    def vnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_name", value)

    @property
    @pulumi.getter(name="vnetResourceGroupName")
    def vnet_resource_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group of the hostingEnvironment's (App Service Environment) virtual network
        """
        return pulumi.get(self, "vnet_resource_group_name")

    @vnet_resource_group_name.setter
    def vnet_resource_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_resource_group_name", value)

    @property
    @pulumi.getter(name="vnetSubnetName")
    def vnet_subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet of the hostingEnvironment's (App Service Environment) virtual network
        """
        return pulumi.get(self, "vnet_subnet_name")

    @vnet_subnet_name.setter
    def vnet_subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_subnet_name", value)

    @property
    @pulumi.getter(name="workerPools")
    def worker_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolArgs']]]]:
        """
        Description of worker pools with worker size ids, VM sizes, and number of workers in each pool
        """
        return pulumi.get(self, "worker_pools")

    @worker_pools.setter
    def worker_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolArgs']]]]):
        pulumi.set(self, "worker_pools", value)


class ManagedHostingEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_multi_sizes: Optional[pulumi.Input[str]] = None,
                 allowed_worker_sizes: Optional[pulumi.Input[str]] = None,
                 api_management_account_id: Optional[pulumi.Input[str]] = None,
                 cluster_settings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NameValuePairArgs']]]]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 database_service_objective: Optional[pulumi.Input[str]] = None,
                 dns_suffix: Optional[pulumi.Input[str]] = None,
                 environment_capacities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StampCapacityArgs']]]]] = None,
                 environment_is_healthy: Optional[pulumi.Input[bool]] = None,
                 environment_status: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 internal_load_balancing_mode: Optional[pulumi.Input['InternalLoadBalancingMode']] = None,
                 ipssl_address_count: Optional[pulumi.Input[int]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 last_action: Optional[pulumi.Input[str]] = None,
                 last_action_result: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maximum_number_of_machines: Optional[pulumi.Input[int]] = None,
                 multi_role_count: Optional[pulumi.Input[int]] = None,
                 multi_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_access_control_list: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAccessControlEntryArgs']]]]] = None,
                 provisioning_state: Optional[pulumi.Input['ProvisioningState']] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input['HostingEnvironmentStatus']] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 upgrade_domains: Optional[pulumi.Input[int]] = None,
                 vip_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualIPMappingArgs']]]]] = None,
                 virtual_network: Optional[pulumi.Input[pulumi.InputType['VirtualNetworkProfileArgs']]] = None,
                 vnet_name: Optional[pulumi.Input[str]] = None,
                 vnet_resource_group_name: Optional[pulumi.Input[str]] = None,
                 vnet_subnet_name: Optional[pulumi.Input[str]] = None,
                 worker_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkerPoolArgs']]]]] = None,
                 __props__=None):
        """
        Description of an hostingEnvironment (App Service Environment)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allowed_multi_sizes: List of comma separated strings describing which VM sizes are allowed for front-ends
        :param pulumi.Input[str] allowed_worker_sizes: List of comma separated strings describing which VM sizes are allowed for workers
        :param pulumi.Input[str] api_management_account_id: Api Management Account associated with this Hosting Environment
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NameValuePairArgs']]]] cluster_settings: Custom settings for changing the behavior of the hosting environment
        :param pulumi.Input[str] database_edition: Edition of the metadata database for the hostingEnvironment (App Service Environment) e.g. "Standard"
        :param pulumi.Input[str] database_service_objective: Service objective of the metadata database for the hostingEnvironment (App Service Environment) e.g. "S0"
        :param pulumi.Input[str] dns_suffix: DNS suffix of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StampCapacityArgs']]]] environment_capacities: Current total, used, and available worker capacities
        :param pulumi.Input[bool] environment_is_healthy: True/false indicating whether the hostingEnvironment (App Service Environment) is healthy
        :param pulumi.Input[str] environment_status: Detailed message about with results of the last check of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input['InternalLoadBalancingMode'] internal_load_balancing_mode: Specifies which endpoints to serve internally in the hostingEnvironment's (App Service Environment) VNET
        :param pulumi.Input[int] ipssl_address_count: Number of IP SSL addresses reserved for this hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] last_action: Last deployment action on this hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] last_action_result: Result of the last deployment action on this hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[int] maximum_number_of_machines: Maximum number of VMs in this hostingEnvironment (App Service Environment)
        :param pulumi.Input[int] multi_role_count: Number of front-end instances
        :param pulumi.Input[str] multi_size: Front-end VM size, e.g. "Medium", "Large"
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAccessControlEntryArgs']]]] network_access_control_list: Access control list for controlling traffic to the hostingEnvironment (App Service Environment)
        :param pulumi.Input['ProvisioningState'] provisioning_state: Provisioning state of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] resource_group: Resource group of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] resource_group_name: Name of resource group
        :param pulumi.Input['HostingEnvironmentStatus'] status: Current status of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[str] subscription_id: Subscription of the hostingEnvironment (App Service Environment)
        :param pulumi.Input[bool] suspended: True/false indicating whether the hostingEnvironment is suspended. The environment can be suspended e.g. when the management endpoint is no longer available
                           (most likely because NSG blocked the incoming traffic)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        :param pulumi.Input[int] upgrade_domains: Number of upgrade domains of this hostingEnvironment (App Service Environment)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualIPMappingArgs']]]] vip_mappings: Description of IP SSL mapping for this hostingEnvironment (App Service Environment)
        :param pulumi.Input[pulumi.InputType['VirtualNetworkProfileArgs']] virtual_network: Description of the hostingEnvironment's (App Service Environment) virtual network
        :param pulumi.Input[str] vnet_name: Name of the hostingEnvironment's (App Service Environment) virtual network
        :param pulumi.Input[str] vnet_resource_group_name: Resource group of the hostingEnvironment's (App Service Environment) virtual network
        :param pulumi.Input[str] vnet_subnet_name: Subnet of the hostingEnvironment's (App Service Environment) virtual network
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkerPoolArgs']]]] worker_pools: Description of worker pools with worker size ids, VM sizes, and number of workers in each pool
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedHostingEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Description of an hostingEnvironment (App Service Environment)

        :param str resource_name: The name of the resource.
        :param ManagedHostingEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedHostingEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_multi_sizes: Optional[pulumi.Input[str]] = None,
                 allowed_worker_sizes: Optional[pulumi.Input[str]] = None,
                 api_management_account_id: Optional[pulumi.Input[str]] = None,
                 cluster_settings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NameValuePairArgs']]]]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 database_service_objective: Optional[pulumi.Input[str]] = None,
                 dns_suffix: Optional[pulumi.Input[str]] = None,
                 environment_capacities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StampCapacityArgs']]]]] = None,
                 environment_is_healthy: Optional[pulumi.Input[bool]] = None,
                 environment_status: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 internal_load_balancing_mode: Optional[pulumi.Input['InternalLoadBalancingMode']] = None,
                 ipssl_address_count: Optional[pulumi.Input[int]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 last_action: Optional[pulumi.Input[str]] = None,
                 last_action_result: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maximum_number_of_machines: Optional[pulumi.Input[int]] = None,
                 multi_role_count: Optional[pulumi.Input[int]] = None,
                 multi_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_access_control_list: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkAccessControlEntryArgs']]]]] = None,
                 provisioning_state: Optional[pulumi.Input['ProvisioningState']] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input['HostingEnvironmentStatus']] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 upgrade_domains: Optional[pulumi.Input[int]] = None,
                 vip_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualIPMappingArgs']]]]] = None,
                 virtual_network: Optional[pulumi.Input[pulumi.InputType['VirtualNetworkProfileArgs']]] = None,
                 vnet_name: Optional[pulumi.Input[str]] = None,
                 vnet_resource_group_name: Optional[pulumi.Input[str]] = None,
                 vnet_subnet_name: Optional[pulumi.Input[str]] = None,
                 worker_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkerPoolArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedHostingEnvironmentArgs.__new__(ManagedHostingEnvironmentArgs)

            __props__.__dict__["allowed_multi_sizes"] = allowed_multi_sizes
            __props__.__dict__["allowed_worker_sizes"] = allowed_worker_sizes
            __props__.__dict__["api_management_account_id"] = api_management_account_id
            __props__.__dict__["cluster_settings"] = cluster_settings
            __props__.__dict__["database_edition"] = database_edition
            __props__.__dict__["database_service_objective"] = database_service_objective
            __props__.__dict__["dns_suffix"] = dns_suffix
            __props__.__dict__["environment_capacities"] = environment_capacities
            __props__.__dict__["environment_is_healthy"] = environment_is_healthy
            __props__.__dict__["environment_status"] = environment_status
            __props__.__dict__["id"] = id
            __props__.__dict__["internal_load_balancing_mode"] = internal_load_balancing_mode
            __props__.__dict__["ipssl_address_count"] = ipssl_address_count
            __props__.__dict__["kind"] = kind
            __props__.__dict__["last_action"] = last_action
            __props__.__dict__["last_action_result"] = last_action_result
            __props__.__dict__["location"] = location
            __props__.__dict__["maximum_number_of_machines"] = maximum_number_of_machines
            __props__.__dict__["multi_role_count"] = multi_role_count
            __props__.__dict__["multi_size"] = multi_size
            __props__.__dict__["name"] = name
            __props__.__dict__["network_access_control_list"] = network_access_control_list
            __props__.__dict__["provisioning_state"] = provisioning_state
            __props__.__dict__["resource_group"] = resource_group
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["upgrade_domains"] = upgrade_domains
            __props__.__dict__["vip_mappings"] = vip_mappings
            __props__.__dict__["virtual_network"] = virtual_network
            __props__.__dict__["vnet_name"] = vnet_name
            __props__.__dict__["vnet_resource_group_name"] = vnet_resource_group_name
            __props__.__dict__["vnet_subnet_name"] = vnet_subnet_name
            __props__.__dict__["worker_pools"] = worker_pools
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:web:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20160901:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20180201:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20190801:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20200601:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20200901:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20201001:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20201201:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20210101:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20210115:ManagedHostingEnvironment"), pulumi.Alias(type_="azure-native:web/v20210201:ManagedHostingEnvironment")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ManagedHostingEnvironment, __self__).__init__(
            'azure-native:web/v20150801:ManagedHostingEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ManagedHostingEnvironment':
        """
        Get an existing ManagedHostingEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ManagedHostingEnvironmentArgs.__new__(ManagedHostingEnvironmentArgs)

        __props__.__dict__["allowed_multi_sizes"] = None
        __props__.__dict__["allowed_worker_sizes"] = None
        __props__.__dict__["api_management_account_id"] = None
        __props__.__dict__["cluster_settings"] = None
        __props__.__dict__["database_edition"] = None
        __props__.__dict__["database_service_objective"] = None
        __props__.__dict__["dns_suffix"] = None
        __props__.__dict__["environment_capacities"] = None
        __props__.__dict__["environment_is_healthy"] = None
        __props__.__dict__["environment_status"] = None
        __props__.__dict__["internal_load_balancing_mode"] = None
        __props__.__dict__["ipssl_address_count"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["last_action"] = None
        __props__.__dict__["last_action_result"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["maximum_number_of_machines"] = None
        __props__.__dict__["multi_role_count"] = None
        __props__.__dict__["multi_size"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_access_control_list"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["resource_group"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["subscription_id"] = None
        __props__.__dict__["suspended"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["upgrade_domains"] = None
        __props__.__dict__["vip_mappings"] = None
        __props__.__dict__["virtual_network"] = None
        __props__.__dict__["vnet_name"] = None
        __props__.__dict__["vnet_resource_group_name"] = None
        __props__.__dict__["vnet_subnet_name"] = None
        __props__.__dict__["worker_pools"] = None
        return ManagedHostingEnvironment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedMultiSizes")
    def allowed_multi_sizes(self) -> pulumi.Output[Optional[str]]:
        """
        List of comma separated strings describing which VM sizes are allowed for front-ends
        """
        return pulumi.get(self, "allowed_multi_sizes")

    @property
    @pulumi.getter(name="allowedWorkerSizes")
    def allowed_worker_sizes(self) -> pulumi.Output[Optional[str]]:
        """
        List of comma separated strings describing which VM sizes are allowed for workers
        """
        return pulumi.get(self, "allowed_worker_sizes")

    @property
    @pulumi.getter(name="apiManagementAccountId")
    def api_management_account_id(self) -> pulumi.Output[Optional[str]]:
        """
        Api Management Account associated with this Hosting Environment
        """
        return pulumi.get(self, "api_management_account_id")

    @property
    @pulumi.getter(name="clusterSettings")
    def cluster_settings(self) -> pulumi.Output[Optional[Sequence['outputs.NameValuePairResponse']]]:
        """
        Custom settings for changing the behavior of the hosting environment
        """
        return pulumi.get(self, "cluster_settings")

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> pulumi.Output[Optional[str]]:
        """
        Edition of the metadata database for the hostingEnvironment (App Service Environment) e.g. "Standard"
        """
        return pulumi.get(self, "database_edition")

    @property
    @pulumi.getter(name="databaseServiceObjective")
    def database_service_objective(self) -> pulumi.Output[Optional[str]]:
        """
        Service objective of the metadata database for the hostingEnvironment (App Service Environment) e.g. "S0"
        """
        return pulumi.get(self, "database_service_objective")

    @property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> pulumi.Output[Optional[str]]:
        """
        DNS suffix of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "dns_suffix")

    @property
    @pulumi.getter(name="environmentCapacities")
    def environment_capacities(self) -> pulumi.Output[Optional[Sequence['outputs.StampCapacityResponse']]]:
        """
        Current total, used, and available worker capacities
        """
        return pulumi.get(self, "environment_capacities")

    @property
    @pulumi.getter(name="environmentIsHealthy")
    def environment_is_healthy(self) -> pulumi.Output[Optional[bool]]:
        """
        True/false indicating whether the hostingEnvironment (App Service Environment) is healthy
        """
        return pulumi.get(self, "environment_is_healthy")

    @property
    @pulumi.getter(name="environmentStatus")
    def environment_status(self) -> pulumi.Output[Optional[str]]:
        """
        Detailed message about with results of the last check of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "environment_status")

    @property
    @pulumi.getter(name="internalLoadBalancingMode")
    def internal_load_balancing_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies which endpoints to serve internally in the hostingEnvironment's (App Service Environment) VNET
        """
        return pulumi.get(self, "internal_load_balancing_mode")

    @property
    @pulumi.getter(name="ipsslAddressCount")
    def ipssl_address_count(self) -> pulumi.Output[Optional[int]]:
        """
        Number of IP SSL addresses reserved for this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "ipssl_address_count")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastAction")
    def last_action(self) -> pulumi.Output[Optional[str]]:
        """
        Last deployment action on this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "last_action")

    @property
    @pulumi.getter(name="lastActionResult")
    def last_action_result(self) -> pulumi.Output[Optional[str]]:
        """
        Result of the last deployment action on this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "last_action_result")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maximumNumberOfMachines")
    def maximum_number_of_machines(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of VMs in this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "maximum_number_of_machines")

    @property
    @pulumi.getter(name="multiRoleCount")
    def multi_role_count(self) -> pulumi.Output[Optional[int]]:
        """
        Number of front-end instances
        """
        return pulumi.get(self, "multi_role_count")

    @property
    @pulumi.getter(name="multiSize")
    def multi_size(self) -> pulumi.Output[Optional[str]]:
        """
        Front-end VM size, e.g. "Medium", "Large"
        """
        return pulumi.get(self, "multi_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkAccessControlList")
    def network_access_control_list(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkAccessControlEntryResponse']]]:
        """
        Access control list for controlling traffic to the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "network_access_control_list")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[Optional[str]]:
        """
        Provisioning state of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[Optional[str]]:
        """
        Resource group of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Current status of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[Optional[str]]:
        """
        Subscription of the hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[Optional[bool]]:
        """
        True/false indicating whether the hostingEnvironment is suspended. The environment can be suspended e.g. when the management endpoint is no longer available
                    (most likely because NSG blocked the incoming traffic)
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="upgradeDomains")
    def upgrade_domains(self) -> pulumi.Output[Optional[int]]:
        """
        Number of upgrade domains of this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "upgrade_domains")

    @property
    @pulumi.getter(name="vipMappings")
    def vip_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualIPMappingResponse']]]:
        """
        Description of IP SSL mapping for this hostingEnvironment (App Service Environment)
        """
        return pulumi.get(self, "vip_mappings")

    @property
    @pulumi.getter(name="virtualNetwork")
    def virtual_network(self) -> pulumi.Output[Optional['outputs.VirtualNetworkProfileResponse']]:
        """
        Description of the hostingEnvironment's (App Service Environment) virtual network
        """
        return pulumi.get(self, "virtual_network")

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the hostingEnvironment's (App Service Environment) virtual network
        """
        return pulumi.get(self, "vnet_name")

    @property
    @pulumi.getter(name="vnetResourceGroupName")
    def vnet_resource_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        Resource group of the hostingEnvironment's (App Service Environment) virtual network
        """
        return pulumi.get(self, "vnet_resource_group_name")

    @property
    @pulumi.getter(name="vnetSubnetName")
    def vnet_subnet_name(self) -> pulumi.Output[Optional[str]]:
        """
        Subnet of the hostingEnvironment's (App Service Environment) virtual network
        """
        return pulumi.get(self, "vnet_subnet_name")

    @property
    @pulumi.getter(name="workerPools")
    def worker_pools(self) -> pulumi.Output[Optional[Sequence['outputs.WorkerPoolResponse']]]:
        """
        Description of worker pools with worker size ids, VM sizes, and number of workers in each pool
        """
        return pulumi.get(self, "worker_pools")

