# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DomainSecuritySettingsResponse',
    'HealthAlertResponse',
    'HealthMonitorResponse',
    'LdapsSettingsResponse',
    'NotificationSettingsResponse',
]

@pulumi.output_type
class DomainSecuritySettingsResponse(dict):
    """
    Domain Security Settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ntlmV1":
            suggest = "ntlm_v1"
        elif key == "syncNtlmPasswords":
            suggest = "sync_ntlm_passwords"
        elif key == "tlsV1":
            suggest = "tls_v1"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSecuritySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSecuritySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSecuritySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ntlm_v1: Optional[str] = None,
                 sync_ntlm_passwords: Optional[str] = None,
                 tls_v1: Optional[str] = None):
        """
        Domain Security Settings
        :param str ntlm_v1: A flag to determine whether or not NtlmV1 is enabled or disabled.
        :param str sync_ntlm_passwords: A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
        :param str tls_v1: A flag to determine whether or not TlsV1 is enabled or disabled.
        """
        if ntlm_v1 is not None:
            pulumi.set(__self__, "ntlm_v1", ntlm_v1)
        if sync_ntlm_passwords is not None:
            pulumi.set(__self__, "sync_ntlm_passwords", sync_ntlm_passwords)
        if tls_v1 is not None:
            pulumi.set(__self__, "tls_v1", tls_v1)

    @property
    @pulumi.getter(name="ntlmV1")
    def ntlm_v1(self) -> Optional[str]:
        """
        A flag to determine whether or not NtlmV1 is enabled or disabled.
        """
        return pulumi.get(self, "ntlm_v1")

    @property
    @pulumi.getter(name="syncNtlmPasswords")
    def sync_ntlm_passwords(self) -> Optional[str]:
        """
        A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
        """
        return pulumi.get(self, "sync_ntlm_passwords")

    @property
    @pulumi.getter(name="tlsV1")
    def tls_v1(self) -> Optional[str]:
        """
        A flag to determine whether or not TlsV1 is enabled or disabled.
        """
        return pulumi.get(self, "tls_v1")


@pulumi.output_type
class HealthAlertResponse(dict):
    """
    Health Alert Description
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastDetected":
            suggest = "last_detected"
        elif key == "resolutionUri":
            suggest = "resolution_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthAlertResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthAlertResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthAlertResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 issue: str,
                 last_detected: str,
                 name: str,
                 raised: str,
                 resolution_uri: str,
                 severity: str):
        """
        Health Alert Description
        :param str id: Health Alert Id
        :param str issue: Health Alert Issue
        :param str last_detected: Health Alert Last Detected DateTime
        :param str name: Health Alert Name
        :param str raised: Health Alert Raised DateTime
        :param str resolution_uri: Health Alert TSG Link
        :param str severity: Health Alert Severity
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "issue", issue)
        pulumi.set(__self__, "last_detected", last_detected)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "raised", raised)
        pulumi.set(__self__, "resolution_uri", resolution_uri)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Health Alert Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issue(self) -> str:
        """
        Health Alert Issue
        """
        return pulumi.get(self, "issue")

    @property
    @pulumi.getter(name="lastDetected")
    def last_detected(self) -> str:
        """
        Health Alert Last Detected DateTime
        """
        return pulumi.get(self, "last_detected")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Health Alert Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def raised(self) -> str:
        """
        Health Alert Raised DateTime
        """
        return pulumi.get(self, "raised")

    @property
    @pulumi.getter(name="resolutionUri")
    def resolution_uri(self) -> str:
        """
        Health Alert TSG Link
        """
        return pulumi.get(self, "resolution_uri")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Health Alert Severity
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class HealthMonitorResponse(dict):
    """
    Health Monitor Description
    """
    def __init__(__self__, *,
                 details: str,
                 id: str,
                 name: str):
        """
        Health Monitor Description
        :param str details: Health Monitor Details
        :param str id: Health Monitor Id
        :param str name: Health Monitor Name
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def details(self) -> str:
        """
        Health Monitor Details
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Health Monitor Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Health Monitor Name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LdapsSettingsResponse(dict):
    """
    Secure LDAP Settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateNotAfter":
            suggest = "certificate_not_after"
        elif key == "certificateThumbprint":
            suggest = "certificate_thumbprint"
        elif key == "externalAccessIpAddress":
            suggest = "external_access_ip_address"
        elif key == "publicCertificate":
            suggest = "public_certificate"
        elif key == "externalAccess":
            suggest = "external_access"
        elif key == "pfxCertificate":
            suggest = "pfx_certificate"
        elif key == "pfxCertificatePassword":
            suggest = "pfx_certificate_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LdapsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LdapsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LdapsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_not_after: str,
                 certificate_thumbprint: str,
                 external_access_ip_address: str,
                 public_certificate: str,
                 external_access: Optional[str] = None,
                 ldaps: Optional[str] = None,
                 pfx_certificate: Optional[str] = None,
                 pfx_certificate_password: Optional[str] = None):
        """
        Secure LDAP Settings
        :param str certificate_not_after: NotAfter DateTime of configure ldaps certificate.
        :param str certificate_thumbprint: Thumbprint of configure ldaps certificate.
        :param str external_access_ip_address: External access ip address.
        :param str public_certificate: Public certificate used to configure secure ldap.
        :param str external_access: A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
        :param str ldaps: A flag to determine whether or not Secure LDAP is enabled or disabled.
        :param str pfx_certificate: The certificate required to configure Secure LDAP. The parameter passed here should be a base64encoded representation of the certificate pfx file.
        :param str pfx_certificate_password: The password to decrypt the provided Secure LDAP certificate pfx file.
        """
        pulumi.set(__self__, "certificate_not_after", certificate_not_after)
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "external_access_ip_address", external_access_ip_address)
        pulumi.set(__self__, "public_certificate", public_certificate)
        if external_access is not None:
            pulumi.set(__self__, "external_access", external_access)
        if ldaps is not None:
            pulumi.set(__self__, "ldaps", ldaps)
        if pfx_certificate is not None:
            pulumi.set(__self__, "pfx_certificate", pfx_certificate)
        if pfx_certificate_password is not None:
            pulumi.set(__self__, "pfx_certificate_password", pfx_certificate_password)

    @property
    @pulumi.getter(name="certificateNotAfter")
    def certificate_not_after(self) -> str:
        """
        NotAfter DateTime of configure ldaps certificate.
        """
        return pulumi.get(self, "certificate_not_after")

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> str:
        """
        Thumbprint of configure ldaps certificate.
        """
        return pulumi.get(self, "certificate_thumbprint")

    @property
    @pulumi.getter(name="externalAccessIpAddress")
    def external_access_ip_address(self) -> str:
        """
        External access ip address.
        """
        return pulumi.get(self, "external_access_ip_address")

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> str:
        """
        Public certificate used to configure secure ldap.
        """
        return pulumi.get(self, "public_certificate")

    @property
    @pulumi.getter(name="externalAccess")
    def external_access(self) -> Optional[str]:
        """
        A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
        """
        return pulumi.get(self, "external_access")

    @property
    @pulumi.getter
    def ldaps(self) -> Optional[str]:
        """
        A flag to determine whether or not Secure LDAP is enabled or disabled.
        """
        return pulumi.get(self, "ldaps")

    @property
    @pulumi.getter(name="pfxCertificate")
    def pfx_certificate(self) -> Optional[str]:
        """
        The certificate required to configure Secure LDAP. The parameter passed here should be a base64encoded representation of the certificate pfx file.
        """
        return pulumi.get(self, "pfx_certificate")

    @property
    @pulumi.getter(name="pfxCertificatePassword")
    def pfx_certificate_password(self) -> Optional[str]:
        """
        The password to decrypt the provided Secure LDAP certificate pfx file.
        """
        return pulumi.get(self, "pfx_certificate_password")


@pulumi.output_type
class NotificationSettingsResponse(dict):
    """
    Settings for notification
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalRecipients":
            suggest = "additional_recipients"
        elif key == "notifyDcAdmins":
            suggest = "notify_dc_admins"
        elif key == "notifyGlobalAdmins":
            suggest = "notify_global_admins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_recipients: Optional[Sequence[str]] = None,
                 notify_dc_admins: Optional[str] = None,
                 notify_global_admins: Optional[str] = None):
        """
        Settings for notification
        :param Sequence[str] additional_recipients: The list of additional recipients
        :param str notify_dc_admins: Should domain controller admins be notified
        :param str notify_global_admins: Should global admins be notified
        """
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)
        if notify_dc_admins is not None:
            pulumi.set(__self__, "notify_dc_admins", notify_dc_admins)
        if notify_global_admins is not None:
            pulumi.set(__self__, "notify_global_admins", notify_global_admins)

    @property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[Sequence[str]]:
        """
        The list of additional recipients
        """
        return pulumi.get(self, "additional_recipients")

    @property
    @pulumi.getter(name="notifyDcAdmins")
    def notify_dc_admins(self) -> Optional[str]:
        """
        Should domain controller admins be notified
        """
        return pulumi.get(self, "notify_dc_admins")

    @property
    @pulumi.getter(name="notifyGlobalAdmins")
    def notify_global_admins(self) -> Optional[str]:
        """
        Should global admins be notified
        """
        return pulumi.get(self, "notify_global_admins")


