# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CacheExpirationActionParametersArgs',
    'CacheKeyQueryStringActionParametersArgs',
    'CookiesMatchConditionParametersArgs',
    'CustomRuleListArgs',
    'CustomRuleArgs',
    'DeepCreatedOriginArgs',
    'DeliveryRuleCacheExpirationActionArgs',
    'DeliveryRuleCacheKeyQueryStringActionArgs',
    'DeliveryRuleCookiesConditionArgs',
    'DeliveryRuleHttpVersionConditionArgs',
    'DeliveryRuleIsDeviceConditionArgs',
    'DeliveryRulePostArgsConditionArgs',
    'DeliveryRuleQueryStringConditionArgs',
    'DeliveryRuleRemoteAddressConditionArgs',
    'DeliveryRuleRequestBodyConditionArgs',
    'DeliveryRuleRequestHeaderActionArgs',
    'DeliveryRuleRequestHeaderConditionArgs',
    'DeliveryRuleRequestMethodConditionArgs',
    'DeliveryRuleRequestSchemeConditionArgs',
    'DeliveryRuleRequestUriConditionArgs',
    'DeliveryRuleResponseHeaderActionArgs',
    'DeliveryRuleUrlFileExtensionConditionArgs',
    'DeliveryRuleUrlFileNameConditionArgs',
    'DeliveryRuleUrlPathConditionArgs',
    'DeliveryRuleArgs',
    'EndpointPropertiesUpdateParametersDeliveryPolicyArgs',
    'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs',
    'GeoFilterArgs',
    'HeaderActionParametersArgs',
    'HttpVersionMatchConditionParametersArgs',
    'IsDeviceMatchConditionParametersArgs',
    'ManagedRuleGroupOverrideArgs',
    'ManagedRuleOverrideArgs',
    'ManagedRuleSetListArgs',
    'ManagedRuleSetArgs',
    'MatchConditionArgs',
    'PolicySettingsArgs',
    'PostArgsMatchConditionParametersArgs',
    'QueryStringMatchConditionParametersArgs',
    'RateLimitRuleListArgs',
    'RateLimitRuleArgs',
    'RemoteAddressMatchConditionParametersArgs',
    'RequestBodyMatchConditionParametersArgs',
    'RequestHeaderMatchConditionParametersArgs',
    'RequestMethodMatchConditionParametersArgs',
    'RequestSchemeMatchConditionParametersArgs',
    'RequestUriMatchConditionParametersArgs',
    'SkuArgs',
    'UrlFileExtensionMatchConditionParametersArgs',
    'UrlFileNameMatchConditionParametersArgs',
    'UrlPathMatchConditionParametersArgs',
    'UrlRedirectActionParametersArgs',
    'UrlRedirectActionArgs',
    'UrlRewriteActionParametersArgs',
    'UrlRewriteActionArgs',
]

@pulumi.input_type
class CacheExpirationActionParametersArgs:
    def __init__(__self__, *,
                 cache_behavior: pulumi.Input[Union[str, 'CacheBehavior']],
                 cache_type: pulumi.Input[Union[str, 'CacheType']],
                 odata_type: pulumi.Input[str],
                 cache_duration: Optional[pulumi.Input[str]] = None):
        """
        Defines the parameters for the cache expiration action.
        :param pulumi.Input[Union[str, 'CacheBehavior']] cache_behavior: Caching behavior for the requests
        :param pulumi.Input[Union[str, 'CacheType']] cache_type: The level at which the content needs to be cached.
        :param pulumi.Input[str] cache_duration: The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
        """
        pulumi.set(__self__, "cache_behavior", cache_behavior)
        pulumi.set(__self__, "cache_type", cache_type)
        pulumi.set(__self__, "odata_type", odata_type)
        if cache_duration is not None:
            pulumi.set(__self__, "cache_duration", cache_duration)

    @property
    @pulumi.getter(name="cacheBehavior")
    def cache_behavior(self) -> pulumi.Input[Union[str, 'CacheBehavior']]:
        """
        Caching behavior for the requests
        """
        return pulumi.get(self, "cache_behavior")

    @cache_behavior.setter
    def cache_behavior(self, value: pulumi.Input[Union[str, 'CacheBehavior']]):
        pulumi.set(self, "cache_behavior", value)

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> pulumi.Input[Union[str, 'CacheType']]:
        """
        The level at which the content needs to be cached.
        """
        return pulumi.get(self, "cache_type")

    @cache_type.setter
    def cache_type(self, value: pulumi.Input[Union[str, 'CacheType']]):
        pulumi.set(self, "cache_type", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="cacheDuration")
    def cache_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
        """
        return pulumi.get(self, "cache_duration")

    @cache_duration.setter
    def cache_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_duration", value)


@pulumi.input_type
class CacheKeyQueryStringActionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 query_string_behavior: pulumi.Input[Union[str, 'QueryStringBehavior']],
                 query_parameters: Optional[pulumi.Input[str]] = None):
        """
        Defines the parameters for the cache-key query string action.
        :param pulumi.Input[Union[str, 'QueryStringBehavior']] query_string_behavior: Caching behavior for the requests
        :param pulumi.Input[str] query_parameters: query parameters to include or exclude (comma separated).
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> pulumi.Input[Union[str, 'QueryStringBehavior']]:
        """
        Caching behavior for the requests
        """
        return pulumi.get(self, "query_string_behavior")

    @query_string_behavior.setter
    def query_string_behavior(self, value: pulumi.Input[Union[str, 'QueryStringBehavior']]):
        pulumi.set(self, "query_string_behavior", value)

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[pulumi.Input[str]]:
        """
        query parameters to include or exclude (comma separated).
        """
        return pulumi.get(self, "query_parameters")

    @query_parameters.setter
    def query_parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_parameters", value)


@pulumi.input_type
class CookiesMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'CookiesOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for Cookies match conditions
        :param pulumi.Input[Union[str, 'CookiesOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[str] selector: Name of Cookies to be matched
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'CookiesOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'CookiesOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Cookies to be matched
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class CustomRuleListArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRuleArgs']]]] = None):
        """
        Defines contents of custom rules
        :param pulumi.Input[Sequence[pulumi.Input['CustomRuleArgs']]] rules: List of rules
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomRuleArgs']]]]:
        """
        List of rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class CustomRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[Union[str, 'ActionType']],
                 match_conditions: pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]],
                 name: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 enabled_state: Optional[pulumi.Input[Union[str, 'CustomRuleEnabledState']]] = None):
        """
        Defines the common attributes for a custom rule that can be included in a waf policy
        :param pulumi.Input[Union[str, 'ActionType']] action: Describes what action to be applied when rule matches
        :param pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]] match_conditions: List of match conditions.
        :param pulumi.Input[str] name: Defines the name of the custom rule
        :param pulumi.Input[int] priority: Defines in what order this rule be evaluated in the overall list of custom rules
        :param pulumi.Input[Union[str, 'CustomRuleEnabledState']] enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match_conditions", match_conditions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[Union[str, 'ActionType']]:
        """
        Describes what action to be applied when rule matches
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[Union[str, 'ActionType']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]]:
        """
        List of match conditions.
        """
        return pulumi.get(self, "match_conditions")

    @match_conditions.setter
    def match_conditions(self, value: pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]]):
        pulumi.set(self, "match_conditions", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Defines the name of the custom rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Defines in what order this rule be evaluated in the overall list of custom rules
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'CustomRuleEnabledState']]]:
        """
        Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'CustomRuleEnabledState']]]):
        pulumi.set(self, "enabled_state", value)


@pulumi.input_type
class DeepCreatedOriginArgs:
    def __init__(__self__, *,
                 host_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 http_port: Optional[pulumi.Input[int]] = None,
                 https_port: Optional[pulumi.Input[int]] = None):
        """
        The main origin of CDN content which is added when creating a CDN endpoint.
        :param pulumi.Input[str] host_name: The address of the origin. It can be a domain name, IPv4 address, or IPv6 address.
        :param pulumi.Input[str] name: Origin name
        :param pulumi.Input[int] http_port: The value of the HTTP port. Must be between 1 and 65535
        :param pulumi.Input[int] https_port: The value of the HTTPS port. Must be between 1 and 65535
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "name", name)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[str]:
        """
        The address of the origin. It can be a domain name, IPv4 address, or IPv6 address.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Origin name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[int]]:
        """
        The value of the HTTP port. Must be between 1 and 65535
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[int]]:
        """
        The value of the HTTPS port. Must be between 1 and 65535
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "https_port", value)


@pulumi.input_type
class DeliveryRuleCacheExpirationActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['CacheExpirationActionParametersArgs']):
        """
        Defines the cache expiration action for the delivery rule.
        :param pulumi.Input[str] name: The name of the action for the delivery rule.
               Expected value is 'CacheExpiration'.
        :param pulumi.Input['CacheExpirationActionParametersArgs'] parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'CacheExpiration')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the action for the delivery rule.
        Expected value is 'CacheExpiration'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['CacheExpirationActionParametersArgs']:
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['CacheExpirationActionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleCacheKeyQueryStringActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['CacheKeyQueryStringActionParametersArgs']):
        """
        Defines the cache-key query string action for the delivery rule.
        :param pulumi.Input[str] name: The name of the action for the delivery rule.
               Expected value is 'CacheKeyQueryString'.
        :param pulumi.Input['CacheKeyQueryStringActionParametersArgs'] parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'CacheKeyQueryString')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the action for the delivery rule.
        Expected value is 'CacheKeyQueryString'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['CacheKeyQueryStringActionParametersArgs']:
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['CacheKeyQueryStringActionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleCookiesConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['CookiesMatchConditionParametersArgs']):
        """
        Defines the Cookies condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'Cookies'.
        :param pulumi.Input['CookiesMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'Cookies')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'Cookies'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['CookiesMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['CookiesMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleHttpVersionConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['HttpVersionMatchConditionParametersArgs']):
        """
        Defines the HttpVersion condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'HttpVersion'.
        :param pulumi.Input['HttpVersionMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'HttpVersion')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'HttpVersion'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['HttpVersionMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['HttpVersionMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleIsDeviceConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['IsDeviceMatchConditionParametersArgs']):
        """
        Defines the IsDevice condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'IsDevice'.
        :param pulumi.Input['IsDeviceMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'IsDevice')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'IsDevice'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['IsDeviceMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['IsDeviceMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRulePostArgsConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['PostArgsMatchConditionParametersArgs']):
        """
        Defines the PostArgs condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'PostArgs'.
        :param pulumi.Input['PostArgsMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'PostArgs')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'PostArgs'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['PostArgsMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['PostArgsMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleQueryStringConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['QueryStringMatchConditionParametersArgs']):
        """
        Defines the QueryString condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'QueryString'.
        :param pulumi.Input['QueryStringMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'QueryString')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'QueryString'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['QueryStringMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['QueryStringMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleRemoteAddressConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['RemoteAddressMatchConditionParametersArgs']):
        """
        Defines the RemoteAddress condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'RemoteAddress'.
        :param pulumi.Input['RemoteAddressMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RemoteAddress')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RemoteAddress'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['RemoteAddressMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['RemoteAddressMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleRequestBodyConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['RequestBodyMatchConditionParametersArgs']):
        """
        Defines the RequestBody condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'RequestBody'.
        :param pulumi.Input['RequestBodyMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestBody')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestBody'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['RequestBodyMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['RequestBodyMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleRequestHeaderActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['HeaderActionParametersArgs']):
        """
        Defines the request header action for the delivery rule.
        :param pulumi.Input[str] name: The name of the action for the delivery rule.
               Expected value is 'ModifyRequestHeader'.
        :param pulumi.Input['HeaderActionParametersArgs'] parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'ModifyRequestHeader')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the action for the delivery rule.
        Expected value is 'ModifyRequestHeader'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['HeaderActionParametersArgs']:
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['HeaderActionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleRequestHeaderConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['RequestHeaderMatchConditionParametersArgs']):
        """
        Defines the RequestHeader condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'RequestHeader'.
        :param pulumi.Input['RequestHeaderMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestHeader')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestHeader'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['RequestHeaderMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['RequestHeaderMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleRequestMethodConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['RequestMethodMatchConditionParametersArgs']):
        """
        Defines the RequestMethod condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'RequestMethod'.
        :param pulumi.Input['RequestMethodMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestMethod')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestMethod'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['RequestMethodMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['RequestMethodMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleRequestSchemeConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['RequestSchemeMatchConditionParametersArgs']):
        """
        Defines the RequestScheme condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'RequestScheme'.
        :param pulumi.Input['RequestSchemeMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestScheme')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestScheme'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['RequestSchemeMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['RequestSchemeMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleRequestUriConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['RequestUriMatchConditionParametersArgs']):
        """
        Defines the RequestUri condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'RequestUri'.
        :param pulumi.Input['RequestUriMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestUri')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestUri'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['RequestUriMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['RequestUriMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleResponseHeaderActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['HeaderActionParametersArgs']):
        """
        Defines the response header action for the delivery rule.
        :param pulumi.Input[str] name: The name of the action for the delivery rule.
               Expected value is 'ModifyResponseHeader'.
        :param pulumi.Input['HeaderActionParametersArgs'] parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'ModifyResponseHeader')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the action for the delivery rule.
        Expected value is 'ModifyResponseHeader'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['HeaderActionParametersArgs']:
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['HeaderActionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleUrlFileExtensionConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['UrlFileExtensionMatchConditionParametersArgs']):
        """
        Defines the UrlFileExtension condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'UrlFileExtension'.
        :param pulumi.Input['UrlFileExtensionMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'UrlFileExtension')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'UrlFileExtension'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['UrlFileExtensionMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['UrlFileExtensionMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleUrlFileNameConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['UrlFileNameMatchConditionParametersArgs']):
        """
        Defines the UrlFileName condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'UrlFileName'.
        :param pulumi.Input['UrlFileNameMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'UrlFileName')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'UrlFileName'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['UrlFileNameMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['UrlFileNameMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleUrlPathConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['UrlPathMatchConditionParametersArgs']):
        """
        Defines the UrlPath condition for the delivery rule.
        :param pulumi.Input[str] name: The name of the condition for the delivery rule.
               Expected value is 'UrlPath'.
        :param pulumi.Input['UrlPathMatchConditionParametersArgs'] parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'UrlPath')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the condition for the delivery rule.
        Expected value is 'UrlPath'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['UrlPathMatchConditionParametersArgs']:
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['UrlPathMatchConditionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class DeliveryRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input[Union['DeliveryRuleCacheExpirationActionArgs', 'DeliveryRuleCacheKeyQueryStringActionArgs', 'DeliveryRuleRequestHeaderActionArgs', 'DeliveryRuleResponseHeaderActionArgs', 'UrlRedirectActionArgs', 'UrlRewriteActionArgs']]]],
                 order: pulumi.Input[int],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeliveryRuleCookiesConditionArgs', 'DeliveryRuleHttpVersionConditionArgs', 'DeliveryRuleIsDeviceConditionArgs', 'DeliveryRulePostArgsConditionArgs', 'DeliveryRuleQueryStringConditionArgs', 'DeliveryRuleRemoteAddressConditionArgs', 'DeliveryRuleRequestBodyConditionArgs', 'DeliveryRuleRequestHeaderConditionArgs', 'DeliveryRuleRequestMethodConditionArgs', 'DeliveryRuleRequestSchemeConditionArgs', 'DeliveryRuleRequestUriConditionArgs', 'DeliveryRuleUrlFileExtensionConditionArgs', 'DeliveryRuleUrlFileNameConditionArgs', 'DeliveryRuleUrlPathConditionArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        A rule that specifies a set of actions and conditions
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeliveryRuleCacheExpirationActionArgs', 'DeliveryRuleCacheKeyQueryStringActionArgs', 'DeliveryRuleRequestHeaderActionArgs', 'DeliveryRuleResponseHeaderActionArgs', 'UrlRedirectActionArgs', 'UrlRewriteActionArgs']]]] actions: A list of actions that are executed when all the conditions of a rule are satisfied.
        :param pulumi.Input[int] order: The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeliveryRuleCookiesConditionArgs', 'DeliveryRuleHttpVersionConditionArgs', 'DeliveryRuleIsDeviceConditionArgs', 'DeliveryRulePostArgsConditionArgs', 'DeliveryRuleQueryStringConditionArgs', 'DeliveryRuleRemoteAddressConditionArgs', 'DeliveryRuleRequestBodyConditionArgs', 'DeliveryRuleRequestHeaderConditionArgs', 'DeliveryRuleRequestMethodConditionArgs', 'DeliveryRuleRequestSchemeConditionArgs', 'DeliveryRuleRequestUriConditionArgs', 'DeliveryRuleUrlFileExtensionConditionArgs', 'DeliveryRuleUrlFileNameConditionArgs', 'DeliveryRuleUrlPathConditionArgs']]]] conditions: A list of conditions that must be matched for the actions to be executed
        :param pulumi.Input[str] name: Name of the rule
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "order", order)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input[Union['DeliveryRuleCacheExpirationActionArgs', 'DeliveryRuleCacheKeyQueryStringActionArgs', 'DeliveryRuleRequestHeaderActionArgs', 'DeliveryRuleResponseHeaderActionArgs', 'UrlRedirectActionArgs', 'UrlRewriteActionArgs']]]]:
        """
        A list of actions that are executed when all the conditions of a rule are satisfied.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input[Union['DeliveryRuleCacheExpirationActionArgs', 'DeliveryRuleCacheKeyQueryStringActionArgs', 'DeliveryRuleRequestHeaderActionArgs', 'DeliveryRuleResponseHeaderActionArgs', 'UrlRedirectActionArgs', 'UrlRewriteActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[int]:
        """
        The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[int]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeliveryRuleCookiesConditionArgs', 'DeliveryRuleHttpVersionConditionArgs', 'DeliveryRuleIsDeviceConditionArgs', 'DeliveryRulePostArgsConditionArgs', 'DeliveryRuleQueryStringConditionArgs', 'DeliveryRuleRemoteAddressConditionArgs', 'DeliveryRuleRequestBodyConditionArgs', 'DeliveryRuleRequestHeaderConditionArgs', 'DeliveryRuleRequestMethodConditionArgs', 'DeliveryRuleRequestSchemeConditionArgs', 'DeliveryRuleRequestUriConditionArgs', 'DeliveryRuleUrlFileExtensionConditionArgs', 'DeliveryRuleUrlFileNameConditionArgs', 'DeliveryRuleUrlPathConditionArgs']]]]]:
        """
        A list of conditions that must be matched for the actions to be executed
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeliveryRuleCookiesConditionArgs', 'DeliveryRuleHttpVersionConditionArgs', 'DeliveryRuleIsDeviceConditionArgs', 'DeliveryRulePostArgsConditionArgs', 'DeliveryRuleQueryStringConditionArgs', 'DeliveryRuleRemoteAddressConditionArgs', 'DeliveryRuleRequestBodyConditionArgs', 'DeliveryRuleRequestHeaderConditionArgs', 'DeliveryRuleRequestMethodConditionArgs', 'DeliveryRuleRequestSchemeConditionArgs', 'DeliveryRuleRequestUriConditionArgs', 'DeliveryRuleUrlFileExtensionConditionArgs', 'DeliveryRuleUrlFileNameConditionArgs', 'DeliveryRuleUrlPathConditionArgs']]]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EndpointPropertiesUpdateParametersDeliveryPolicyArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['DeliveryRuleArgs']]],
                 description: Optional[pulumi.Input[str]] = None):
        """
        A policy that specifies the delivery rules to be used for an endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['DeliveryRuleArgs']]] rules: A list of the delivery rules.
        :param pulumi.Input[str] description: User-friendly description of the policy.
        """
        pulumi.set(__self__, "rules", rules)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['DeliveryRuleArgs']]]:
        """
        A list of the delivery rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['DeliveryRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-friendly description of the policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Defines the Web Application Firewall policy for the endpoint (if applicable)
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class GeoFilterArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['GeoFilterActions'],
                 country_codes: pulumi.Input[Sequence[pulumi.Input[str]]],
                 relative_path: pulumi.Input[str]):
        """
        Rules defining user's geo access within a CDN endpoint.
        :param pulumi.Input['GeoFilterActions'] action: Action of the geo filter, i.e. allow or block access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] country_codes: Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
        :param pulumi.Input[str] relative_path: Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "country_codes", country_codes)
        pulumi.set(__self__, "relative_path", relative_path)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['GeoFilterActions']:
        """
        Action of the geo filter, i.e. allow or block access.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['GeoFilterActions']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="countryCodes")
    def country_codes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
        """
        return pulumi.get(self, "country_codes")

    @country_codes.setter
    def country_codes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "country_codes", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> pulumi.Input[str]:
        """
        Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "relative_path", value)


@pulumi.input_type
class HeaderActionParametersArgs:
    def __init__(__self__, *,
                 header_action: pulumi.Input[Union[str, 'HeaderAction']],
                 header_name: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        Defines the parameters for the request header action.
        :param pulumi.Input[Union[str, 'HeaderAction']] header_action: Action to perform
        :param pulumi.Input[str] header_name: Name of the header to modify
        :param pulumi.Input[str] value: Value for the specified action
        """
        pulumi.set(__self__, "header_action", header_action)
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "odata_type", odata_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> pulumi.Input[Union[str, 'HeaderAction']]:
        """
        Action to perform
        """
        return pulumi.get(self, "header_action")

    @header_action.setter
    def header_action(self, value: pulumi.Input[Union[str, 'HeaderAction']]):
        pulumi.set(self, "header_action", value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[str]:
        """
        Name of the header to modify
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value for the specified action
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HttpVersionMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'HttpVersionOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None):
        """
        Defines the parameters for HttpVersion match conditions
        :param pulumi.Input[Union[str, 'HttpVersionOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'HttpVersionOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'HttpVersionOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)


@pulumi.input_type
class IsDeviceMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'IsDeviceOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for IsDevice match conditions
        :param pulumi.Input[Union[str, 'IsDeviceOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'IsDeviceOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'IsDeviceOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class ManagedRuleGroupOverrideArgs:
    def __init__(__self__, *,
                 rule_group_name: pulumi.Input[str],
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleOverrideArgs']]]] = None):
        """
        Defines a managed rule group override setting.
        :param pulumi.Input[str] rule_group_name: Describes the managed rule group within the rule set to override
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRuleOverrideArgs']]] rules: List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> pulumi.Input[str]:
        """
        Describes the managed rule group within the rule set to override
        """
        return pulumi.get(self, "rule_group_name")

    @rule_group_name.setter
    def rule_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_group_name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleOverrideArgs']]]]:
        """
        List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleOverrideArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class ManagedRuleOverrideArgs:
    def __init__(__self__, *,
                 rule_id: pulumi.Input[str],
                 action: Optional[pulumi.Input[Union[str, 'ActionType']]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'ManagedRuleEnabledState']]] = None):
        """
        Defines a managed rule group override setting.
        :param pulumi.Input[str] rule_id: Identifier for the managed rule.
        :param pulumi.Input[Union[str, 'ActionType']] action: Describes the override action to be applied when rule matches.
        :param pulumi.Input[Union[str, 'ManagedRuleEnabledState']] enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[str]:
        """
        Identifier for the managed rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'ActionType']]]:
        """
        Describes the override action to be applied when rule matches.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'ActionType']]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'ManagedRuleEnabledState']]]:
        """
        Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'ManagedRuleEnabledState']]]):
        pulumi.set(self, "enabled_state", value)


@pulumi.input_type
class ManagedRuleSetListArgs:
    def __init__(__self__, *,
                 managed_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleSetArgs']]]] = None):
        """
        Defines the list of managed rule sets for the policy.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRuleSetArgs']]] managed_rule_sets: List of rule sets.
        """
        if managed_rule_sets is not None:
            pulumi.set(__self__, "managed_rule_sets", managed_rule_sets)

    @property
    @pulumi.getter(name="managedRuleSets")
    def managed_rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleSetArgs']]]]:
        """
        List of rule sets.
        """
        return pulumi.get(self, "managed_rule_sets")

    @managed_rule_sets.setter
    def managed_rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleSetArgs']]]]):
        pulumi.set(self, "managed_rule_sets", value)


@pulumi.input_type
class ManagedRuleSetArgs:
    def __init__(__self__, *,
                 rule_set_type: pulumi.Input[str],
                 rule_set_version: pulumi.Input[str],
                 anomaly_score: Optional[pulumi.Input[int]] = None,
                 rule_group_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleGroupOverrideArgs']]]] = None):
        """
        Defines a managed rule set.
        :param pulumi.Input[str] rule_set_type: Defines the rule set type to use.
        :param pulumi.Input[str] rule_set_version: Defines the version of the rule set to use.
        :param pulumi.Input[int] anomaly_score: Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRuleGroupOverrideArgs']]] rule_group_overrides: Defines the rule overrides to apply to the rule set.
        """
        pulumi.set(__self__, "rule_set_type", rule_set_type)
        pulumi.set(__self__, "rule_set_version", rule_set_version)
        if anomaly_score is not None:
            pulumi.set(__self__, "anomaly_score", anomaly_score)
        if rule_group_overrides is not None:
            pulumi.set(__self__, "rule_group_overrides", rule_group_overrides)

    @property
    @pulumi.getter(name="ruleSetType")
    def rule_set_type(self) -> pulumi.Input[str]:
        """
        Defines the rule set type to use.
        """
        return pulumi.get(self, "rule_set_type")

    @rule_set_type.setter
    def rule_set_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_set_type", value)

    @property
    @pulumi.getter(name="ruleSetVersion")
    def rule_set_version(self) -> pulumi.Input[str]:
        """
        Defines the version of the rule set to use.
        """
        return pulumi.get(self, "rule_set_version")

    @rule_set_version.setter
    def rule_set_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_set_version", value)

    @property
    @pulumi.getter(name="anomalyScore")
    def anomaly_score(self) -> Optional[pulumi.Input[int]]:
        """
        Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
        """
        return pulumi.get(self, "anomaly_score")

    @anomaly_score.setter
    def anomaly_score(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "anomaly_score", value)

    @property
    @pulumi.getter(name="ruleGroupOverrides")
    def rule_group_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleGroupOverrideArgs']]]]:
        """
        Defines the rule overrides to apply to the rule set.
        """
        return pulumi.get(self, "rule_group_overrides")

    @rule_group_overrides.setter
    def rule_group_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleGroupOverrideArgs']]]]):
        pulumi.set(self, "rule_group_overrides", value)


@pulumi.input_type
class MatchConditionArgs:
    def __init__(__self__, *,
                 match_value: pulumi.Input[Sequence[pulumi.Input[str]]],
                 match_variable: pulumi.Input[Union[str, 'MatchVariable']],
                 operator: pulumi.Input[Union[str, 'Operator']],
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'TransformType']]]]] = None):
        """
        Define match conditions
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_value: List of possible match values.
        :param pulumi.Input[Union[str, 'MatchVariable']] match_variable: Match variable to compare against.
        :param pulumi.Input[Union[str, 'Operator']] operator: Describes operator to be matched
        :param pulumi.Input[bool] negate_condition: Describes if the result of this condition should be negated.
        :param pulumi.Input[str] selector: Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'TransformType']]]] transforms: List of transforms.
        """
        pulumi.set(__self__, "match_value", match_value)
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "operator", operator)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="matchValue")
    def match_value(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of possible match values.
        """
        return pulumi.get(self, "match_value")

    @match_value.setter
    def match_value(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "match_value", value)

    @property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> pulumi.Input[Union[str, 'MatchVariable']]:
        """
        Match variable to compare against.
        """
        return pulumi.get(self, "match_variable")

    @match_variable.setter
    def match_variable(self, value: pulumi.Input[Union[str, 'MatchVariable']]):
        pulumi.set(self, "match_variable", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'Operator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'Operator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if the result of this condition should be negated.
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'TransformType']]]]]:
        """
        List of transforms.
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'TransformType']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class PolicySettingsArgs:
    def __init__(__self__, *,
                 default_custom_block_response_body: Optional[pulumi.Input[str]] = None,
                 default_custom_block_response_status_code: Optional[pulumi.Input[int]] = None,
                 default_redirect_url: Optional[pulumi.Input[str]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'PolicyEnabledState']]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'PolicyMode']]] = None):
        """
        Defines contents of a web application firewall global configuration
        :param pulumi.Input[str] default_custom_block_response_body: If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[int] default_custom_block_response_status_code: If the action type is block, this field defines the default customer overridable http response status code.
        :param pulumi.Input[str] default_redirect_url: If action type is redirect, this field represents the default redirect URL for the client.
        :param pulumi.Input[Union[str, 'PolicyEnabledState']] enabled_state: describes if the policy is in enabled state or disabled state
        :param pulumi.Input[Union[str, 'PolicyMode']] mode: Describes if it is in detection mode or prevention mode at policy level.
        """
        if default_custom_block_response_body is not None:
            pulumi.set(__self__, "default_custom_block_response_body", default_custom_block_response_body)
        if default_custom_block_response_status_code is not None:
            pulumi.set(__self__, "default_custom_block_response_status_code", default_custom_block_response_status_code)
        if default_redirect_url is not None:
            pulumi.set(__self__, "default_redirect_url", default_redirect_url)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="defaultCustomBlockResponseBody")
    def default_custom_block_response_body(self) -> Optional[pulumi.Input[str]]:
        """
        If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
        """
        return pulumi.get(self, "default_custom_block_response_body")

    @default_custom_block_response_body.setter
    def default_custom_block_response_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_custom_block_response_body", value)

    @property
    @pulumi.getter(name="defaultCustomBlockResponseStatusCode")
    def default_custom_block_response_status_code(self) -> Optional[pulumi.Input[int]]:
        """
        If the action type is block, this field defines the default customer overridable http response status code.
        """
        return pulumi.get(self, "default_custom_block_response_status_code")

    @default_custom_block_response_status_code.setter
    def default_custom_block_response_status_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_custom_block_response_status_code", value)

    @property
    @pulumi.getter(name="defaultRedirectUrl")
    def default_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        If action type is redirect, this field represents the default redirect URL for the client.
        """
        return pulumi.get(self, "default_redirect_url")

    @default_redirect_url.setter
    def default_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_redirect_url", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'PolicyEnabledState']]]:
        """
        describes if the policy is in enabled state or disabled state
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'PolicyEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'PolicyMode']]]:
        """
        Describes if it is in detection mode or prevention mode at policy level.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'PolicyMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class PostArgsMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'PostArgsOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for PostArgs match conditions
        :param pulumi.Input[Union[str, 'PostArgsOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[str] selector: Name of PostArg to be matched
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'PostArgsOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'PostArgsOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Name of PostArg to be matched
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class QueryStringMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'QueryStringOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for QueryString match conditions
        :param pulumi.Input[Union[str, 'QueryStringOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'QueryStringOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'QueryStringOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class RateLimitRuleListArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RateLimitRuleArgs']]]] = None):
        """
        Defines contents of rate limit rules
        :param pulumi.Input[Sequence[pulumi.Input['RateLimitRuleArgs']]] rules: List of rules
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RateLimitRuleArgs']]]]:
        """
        List of rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RateLimitRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class RateLimitRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[Union[str, 'ActionType']],
                 match_conditions: pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]],
                 name: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 rate_limit_duration_in_minutes: pulumi.Input[int],
                 rate_limit_threshold: pulumi.Input[int],
                 enabled_state: Optional[pulumi.Input[Union[str, 'CustomRuleEnabledState']]] = None):
        """
        Defines a rate limiting rule that can be included in a waf policy
        :param pulumi.Input[Union[str, 'ActionType']] action: Describes what action to be applied when rule matches
        :param pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]] match_conditions: List of match conditions.
        :param pulumi.Input[str] name: Defines the name of the custom rule
        :param pulumi.Input[int] priority: Defines in what order this rule be evaluated in the overall list of custom rules
        :param pulumi.Input[int] rate_limit_duration_in_minutes: Defines rate limit duration. Default is 1 minute.
        :param pulumi.Input[int] rate_limit_threshold: Defines rate limit threshold.
        :param pulumi.Input[Union[str, 'CustomRuleEnabledState']] enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match_conditions", match_conditions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rate_limit_duration_in_minutes", rate_limit_duration_in_minutes)
        pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[Union[str, 'ActionType']]:
        """
        Describes what action to be applied when rule matches
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[Union[str, 'ActionType']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]]:
        """
        List of match conditions.
        """
        return pulumi.get(self, "match_conditions")

    @match_conditions.setter
    def match_conditions(self, value: pulumi.Input[Sequence[pulumi.Input['MatchConditionArgs']]]):
        pulumi.set(self, "match_conditions", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Defines the name of the custom rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Defines in what order this rule be evaluated in the overall list of custom rules
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="rateLimitDurationInMinutes")
    def rate_limit_duration_in_minutes(self) -> pulumi.Input[int]:
        """
        Defines rate limit duration. Default is 1 minute.
        """
        return pulumi.get(self, "rate_limit_duration_in_minutes")

    @rate_limit_duration_in_minutes.setter
    def rate_limit_duration_in_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "rate_limit_duration_in_minutes", value)

    @property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> pulumi.Input[int]:
        """
        Defines rate limit threshold.
        """
        return pulumi.get(self, "rate_limit_threshold")

    @rate_limit_threshold.setter
    def rate_limit_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "rate_limit_threshold", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'CustomRuleEnabledState']]]:
        """
        Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'CustomRuleEnabledState']]]):
        pulumi.set(self, "enabled_state", value)


@pulumi.input_type
class RemoteAddressMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'RemoteAddressOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for RemoteAddress match conditions
        :param pulumi.Input[Union[str, 'RemoteAddressOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'RemoteAddressOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'RemoteAddressOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class RequestBodyMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'RequestBodyOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for RequestBody match conditions
        :param pulumi.Input[Union[str, 'RequestBodyOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'RequestBodyOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'RequestBodyOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class RequestHeaderMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'RequestHeaderOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for RequestHeader match conditions
        :param pulumi.Input[Union[str, 'RequestHeaderOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[str] selector: Name of Header to be matched
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'RequestHeaderOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'RequestHeaderOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Header to be matched
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class RequestMethodMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'RequestMethodOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None):
        """
        Defines the parameters for RequestMethod match conditions
        :param pulumi.Input[Union[str, 'RequestMethodOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'RequestMethodOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'RequestMethodOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)


@pulumi.input_type
class RequestSchemeMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[str],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None):
        """
        Defines the parameters for RequestScheme match conditions 
        :param pulumi.Input[str] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[str]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)


@pulumi.input_type
class RequestUriMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'RequestUriOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for RequestUri match conditions
        :param pulumi.Input[Union[str, 'RequestUriOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'RequestUriOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'RequestUriOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'SkuName']]] = None):
        """
        The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
        :param pulumi.Input[Union[str, 'SkuName']] name: Name of the pricing tier.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'SkuName']]]:
        """
        Name of the pricing tier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'SkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class UrlFileExtensionMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'UrlFileExtensionOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for UrlFileExtension match conditions
        :param pulumi.Input[Union[str, 'UrlFileExtensionOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'UrlFileExtensionOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'UrlFileExtensionOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class UrlFileNameMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'UrlFileNameOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for UrlFilename match conditions
        :param pulumi.Input[Union[str, 'UrlFileNameOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'UrlFileNameOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'UrlFileNameOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class UrlPathMatchConditionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'UrlPathOperator']],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Defines the parameters for UrlPath match conditions
        :param pulumi.Input[Union[str, 'UrlPathOperator']] operator: Describes operator to be matched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_values: The match value for the condition of the delivery rule
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'UrlPathOperator']]:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'UrlPathOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "match_values", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class UrlRedirectActionParametersArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 redirect_type: pulumi.Input[Union[str, 'RedirectType']],
                 custom_fragment: Optional[pulumi.Input[str]] = None,
                 custom_hostname: Optional[pulumi.Input[str]] = None,
                 custom_path: Optional[pulumi.Input[str]] = None,
                 custom_query_string: Optional[pulumi.Input[str]] = None,
                 destination_protocol: Optional[pulumi.Input[Union[str, 'DestinationProtocol']]] = None):
        """
        Defines the parameters for the url redirect action.
        :param pulumi.Input[Union[str, 'RedirectType']] redirect_type: The redirect type the rule will use when redirecting traffic.
        :param pulumi.Input[str] custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        :param pulumi.Input[str] custom_hostname: Host to redirect. Leave empty to use the incoming host as the destination host.
        :param pulumi.Input[str] custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        :param pulumi.Input[str] custom_query_string: The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
        :param pulumi.Input[Union[str, 'DestinationProtocol']] destination_protocol: Protocol to use for the redirect. The default value is MatchRequest
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "redirect_type", redirect_type)
        if custom_fragment is not None:
            pulumi.set(__self__, "custom_fragment", custom_fragment)
        if custom_hostname is not None:
            pulumi.set(__self__, "custom_hostname", custom_hostname)
        if custom_path is not None:
            pulumi.set(__self__, "custom_path", custom_path)
        if custom_query_string is not None:
            pulumi.set(__self__, "custom_query_string", custom_query_string)
        if destination_protocol is not None:
            pulumi.set(__self__, "destination_protocol", destination_protocol)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> pulumi.Input[Union[str, 'RedirectType']]:
        """
        The redirect type the rule will use when redirecting traffic.
        """
        return pulumi.get(self, "redirect_type")

    @redirect_type.setter
    def redirect_type(self, value: pulumi.Input[Union[str, 'RedirectType']]):
        pulumi.set(self, "redirect_type", value)

    @property
    @pulumi.getter(name="customFragment")
    def custom_fragment(self) -> Optional[pulumi.Input[str]]:
        """
        Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        """
        return pulumi.get(self, "custom_fragment")

    @custom_fragment.setter
    def custom_fragment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_fragment", value)

    @property
    @pulumi.getter(name="customHostname")
    def custom_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Host to redirect. Leave empty to use the incoming host as the destination host.
        """
        return pulumi.get(self, "custom_hostname")

    @custom_hostname.setter
    def custom_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_hostname", value)

    @property
    @pulumi.getter(name="customPath")
    def custom_path(self) -> Optional[pulumi.Input[str]]:
        """
        The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        """
        return pulumi.get(self, "custom_path")

    @custom_path.setter
    def custom_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_path", value)

    @property
    @pulumi.getter(name="customQueryString")
    def custom_query_string(self) -> Optional[pulumi.Input[str]]:
        """
        The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
        """
        return pulumi.get(self, "custom_query_string")

    @custom_query_string.setter
    def custom_query_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_query_string", value)

    @property
    @pulumi.getter(name="destinationProtocol")
    def destination_protocol(self) -> Optional[pulumi.Input[Union[str, 'DestinationProtocol']]]:
        """
        Protocol to use for the redirect. The default value is MatchRequest
        """
        return pulumi.get(self, "destination_protocol")

    @destination_protocol.setter
    def destination_protocol(self, value: Optional[pulumi.Input[Union[str, 'DestinationProtocol']]]):
        pulumi.set(self, "destination_protocol", value)


@pulumi.input_type
class UrlRedirectActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['UrlRedirectActionParametersArgs']):
        """
        Defines the url redirect action for the delivery rule.
        :param pulumi.Input[str] name: The name of the action for the delivery rule.
               Expected value is 'UrlRedirect'.
        :param pulumi.Input['UrlRedirectActionParametersArgs'] parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'UrlRedirect')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the action for the delivery rule.
        Expected value is 'UrlRedirect'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['UrlRedirectActionParametersArgs']:
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['UrlRedirectActionParametersArgs']):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class UrlRewriteActionParametersArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 source_pattern: pulumi.Input[str],
                 preserve_unmatched_path: Optional[pulumi.Input[bool]] = None):
        """
        Defines the parameters for the url rewrite action.
        :param pulumi.Input[str] destination: Define the destination path for be used in the rewrite. This will overwrite the source pattern 
        :param pulumi.Input[str] source_pattern: define a request URI pattern that identifies the type of requests that may be rewritten. Currently, source pattern uses a prefix-based match. To match all URL paths, use "/" as the source pattern value. To match only the root directory and re-write this path, use the origin path field
        :param pulumi.Input[bool] preserve_unmatched_path: If True, the remaining path after the source pattern will be appended to the new destination path.  
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "source_pattern", source_pattern)
        if preserve_unmatched_path is not None:
            pulumi.set(__self__, "preserve_unmatched_path", preserve_unmatched_path)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        Define the destination path for be used in the rewrite. This will overwrite the source pattern 
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="sourcePattern")
    def source_pattern(self) -> pulumi.Input[str]:
        """
        define a request URI pattern that identifies the type of requests that may be rewritten. Currently, source pattern uses a prefix-based match. To match all URL paths, use "/" as the source pattern value. To match only the root directory and re-write this path, use the origin path field
        """
        return pulumi.get(self, "source_pattern")

    @source_pattern.setter
    def source_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_pattern", value)

    @property
    @pulumi.getter(name="preserveUnmatchedPath")
    def preserve_unmatched_path(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, the remaining path after the source pattern will be appended to the new destination path.  
        """
        return pulumi.get(self, "preserve_unmatched_path")

    @preserve_unmatched_path.setter
    def preserve_unmatched_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_unmatched_path", value)


@pulumi.input_type
class UrlRewriteActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input['UrlRewriteActionParametersArgs']):
        """
        Defines the url rewrite action for the delivery rule.
        :param pulumi.Input[str] name: The name of the action for the delivery rule.
               Expected value is 'UrlRewrite'.
        :param pulumi.Input['UrlRewriteActionParametersArgs'] parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'UrlRewrite')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the action for the delivery rule.
        Expected value is 'UrlRewrite'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['UrlRewriteActionParametersArgs']:
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['UrlRewriteActionParametersArgs']):
        pulumi.set(self, "parameters", value)


