# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceVulnerabilityAssessmentArgs', 'ManagedInstanceVulnerabilityAssessment']

@pulumi.input_type
class ManagedInstanceVulnerabilityAssessmentArgs:
    def __init__(__self__, *,
                 managed_instance_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 storage_container_path: pulumi.Input[str],
                 recurring_scans: Optional[pulumi.Input['VulnerabilityAssessmentRecurringScansPropertiesArgs']] = None,
                 storage_account_access_key: Optional[pulumi.Input[str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[str]] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ManagedInstanceVulnerabilityAssessment resource.
        :param pulumi.Input[str] managed_instance_name: The name of the managed instance for which the vulnerability assessment is defined.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] storage_container_path: A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
        :param pulumi.Input['VulnerabilityAssessmentRecurringScansPropertiesArgs'] recurring_scans: The recurring scans settings
        :param pulumi.Input[str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
        :param pulumi.Input[str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the vulnerability assessment.
        """
        pulumi.set(__self__, "managed_instance_name", managed_instance_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_container_path", storage_container_path)
        if recurring_scans is not None:
            pulumi.set(__self__, "recurring_scans", recurring_scans)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_container_sas_key is not None:
            pulumi.set(__self__, "storage_container_sas_key", storage_container_sas_key)
        if vulnerability_assessment_name is not None:
            pulumi.set(__self__, "vulnerability_assessment_name", vulnerability_assessment_name)

    @property
    @pulumi.getter(name="managedInstanceName")
    def managed_instance_name(self) -> pulumi.Input[str]:
        """
        The name of the managed instance for which the vulnerability assessment is defined.
        """
        return pulumi.get(self, "managed_instance_name")

    @managed_instance_name.setter
    def managed_instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_instance_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> pulumi.Input[str]:
        """
        A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
        """
        return pulumi.get(self, "storage_container_path")

    @storage_container_path.setter
    def storage_container_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_container_path", value)

    @property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> Optional[pulumi.Input['VulnerabilityAssessmentRecurringScansPropertiesArgs']]:
        """
        The recurring scans settings
        """
        return pulumi.get(self, "recurring_scans")

    @recurring_scans.setter
    def recurring_scans(self, value: Optional[pulumi.Input['VulnerabilityAssessmentRecurringScansPropertiesArgs']]):
        pulumi.set(self, "recurring_scans", value)

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> Optional[pulumi.Input[str]]:
        """
        A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
        """
        return pulumi.get(self, "storage_container_sas_key")

    @storage_container_sas_key.setter
    def storage_container_sas_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_container_sas_key", value)

    @property
    @pulumi.getter(name="vulnerabilityAssessmentName")
    def vulnerability_assessment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the vulnerability assessment.
        """
        return pulumi.get(self, "vulnerability_assessment_name")

    @vulnerability_assessment_name.setter
    def vulnerability_assessment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vulnerability_assessment_name", value)


class ManagedInstanceVulnerabilityAssessment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_name: Optional[pulumi.Input[str]] = None,
                 recurring_scans: Optional[pulumi.Input[pulumi.InputType['VulnerabilityAssessmentRecurringScansPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[str]] = None,
                 storage_container_path: Optional[pulumi.Input[str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[str]] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A managed instance vulnerability assessment.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] managed_instance_name: The name of the managed instance for which the vulnerability assessment is defined.
        :param pulumi.Input[pulumi.InputType['VulnerabilityAssessmentRecurringScansPropertiesArgs']] recurring_scans: The recurring scans settings
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
        :param pulumi.Input[str] storage_container_path: A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
        :param pulumi.Input[str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the vulnerability assessment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceVulnerabilityAssessmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A managed instance vulnerability assessment.

        :param str resource_name: The name of the resource.
        :param ManagedInstanceVulnerabilityAssessmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceVulnerabilityAssessmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_name: Optional[pulumi.Input[str]] = None,
                 recurring_scans: Optional[pulumi.Input[pulumi.InputType['VulnerabilityAssessmentRecurringScansPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[str]] = None,
                 storage_container_path: Optional[pulumi.Input[str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[str]] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceVulnerabilityAssessmentArgs.__new__(ManagedInstanceVulnerabilityAssessmentArgs)

            if managed_instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_name'")
            __props__.__dict__["managed_instance_name"] = managed_instance_name
            __props__.__dict__["recurring_scans"] = recurring_scans
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["storage_account_access_key"] = storage_account_access_key
            if storage_container_path is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_path'")
            __props__.__dict__["storage_container_path"] = storage_container_path
            __props__.__dict__["storage_container_sas_key"] = storage_container_sas_key
            __props__.__dict__["vulnerability_assessment_name"] = vulnerability_assessment_name
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:sql/v20210201preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-native:sql:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-nextgen:sql:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-native:sql/v20180601preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-nextgen:sql/v20180601preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-native:sql/v20200202preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-nextgen:sql/v20200202preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-native:sql/v20200801preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-nextgen:sql/v20200801preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-native:sql/v20201101preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-nextgen:sql/v20201101preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-native:sql/v20210501preview:ManagedInstanceVulnerabilityAssessment"), pulumi.Alias(type_="azure-nextgen:sql/v20210501preview:ManagedInstanceVulnerabilityAssessment")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ManagedInstanceVulnerabilityAssessment, __self__).__init__(
            'azure-native:sql/v20210201preview:ManagedInstanceVulnerabilityAssessment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ManagedInstanceVulnerabilityAssessment':
        """
        Get an existing ManagedInstanceVulnerabilityAssessment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ManagedInstanceVulnerabilityAssessmentArgs.__new__(ManagedInstanceVulnerabilityAssessmentArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["recurring_scans"] = None
        __props__.__dict__["type"] = None
        return ManagedInstanceVulnerabilityAssessment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> pulumi.Output[Optional['outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse']]:
        """
        The recurring scans settings
        """
        return pulumi.get(self, "recurring_scans")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

