# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SubscriptionFeatureRegistrationArgs', 'SubscriptionFeatureRegistration']

@pulumi.input_type
class SubscriptionFeatureRegistrationArgs:
    def __init__(__self__, *,
                 provider_namespace: pulumi.Input[str],
                 feature_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['SubscriptionFeatureRegistrationPropertiesArgs']] = None):
        """
        The set of arguments for constructing a SubscriptionFeatureRegistration resource.
        :param pulumi.Input[str] provider_namespace: The provider namespace.
        :param pulumi.Input[str] feature_name: The feature name.
        """
        pulumi.set(__self__, "provider_namespace", provider_namespace)
        if feature_name is not None:
            pulumi.set(__self__, "feature_name", feature_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="providerNamespace")
    def provider_namespace(self) -> pulumi.Input[str]:
        """
        The provider namespace.
        """
        return pulumi.get(self, "provider_namespace")

    @provider_namespace.setter
    def provider_namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_namespace", value)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> Optional[pulumi.Input[str]]:
        """
        The feature name.
        """
        return pulumi.get(self, "feature_name")

    @feature_name.setter
    def feature_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SubscriptionFeatureRegistrationPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SubscriptionFeatureRegistrationPropertiesArgs']]):
        pulumi.set(self, "properties", value)


class SubscriptionFeatureRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 feature_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['SubscriptionFeatureRegistrationPropertiesArgs']]] = None,
                 provider_namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Subscription feature registration details
        API Version: 2021-07-01.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] feature_name: The feature name.
        :param pulumi.Input[str] provider_namespace: The provider namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionFeatureRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Subscription feature registration details
        API Version: 2021-07-01.

        :param str resource_name: The name of the resource.
        :param SubscriptionFeatureRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionFeatureRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 feature_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['SubscriptionFeatureRegistrationPropertiesArgs']]] = None,
                 provider_namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionFeatureRegistrationArgs.__new__(SubscriptionFeatureRegistrationArgs)

            __props__.__dict__["feature_name"] = feature_name
            __props__.__dict__["properties"] = properties
            if provider_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'provider_namespace'")
            __props__.__dict__["provider_namespace"] = provider_namespace
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:features:SubscriptionFeatureRegistration"), pulumi.Alias(type_="azure-native:features/v20210701:SubscriptionFeatureRegistration"), pulumi.Alias(type_="azure-nextgen:features/v20210701:SubscriptionFeatureRegistration")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SubscriptionFeatureRegistration, __self__).__init__(
            'azure-native:features:SubscriptionFeatureRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SubscriptionFeatureRegistration':
        """
        Get an existing SubscriptionFeatureRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SubscriptionFeatureRegistrationArgs.__new__(SubscriptionFeatureRegistrationArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["type"] = None
        return SubscriptionFeatureRegistration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Azure resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.SubscriptionFeatureRegistrationResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Azure resource type.
        """
        return pulumi.get(self, "type")

