# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'SkuV3Args',
    'SqlDatabaseDataRetentionArgs',
]

@pulumi.input_type
class SkuV3Args:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 tier: Optional[pulumi.Input[str]] = None):
        """
        An ARM Resource SKU.
        :param pulumi.Input[str] name: The name of the SKU, typically, a letter + Number code, e.g. P3.
        :param pulumi.Input[str] tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU, typically, a letter + Number code, e.g. P3.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SqlDatabaseDataRetentionArgs:
    def __init__(__self__, *,
                 drop_retention_period: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[str]] = None):
        """
        Sql database data retention.
        :param pulumi.Input[str] drop_retention_period: Specifies the dropped database retention period (ISO8601 format).
        :param pulumi.Input[str] retention_period: Specifies the data retention period (ISO8601 format).
        """
        if drop_retention_period is not None:
            pulumi.set(__self__, "drop_retention_period", drop_retention_period)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="dropRetentionPeriod")
    def drop_retention_period(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dropped database retention period (ISO8601 format).
        """
        return pulumi.get(self, "drop_retention_period")

    @drop_retention_period.setter
    def drop_retention_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "drop_retention_period", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data retention period (ISO8601 format).
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_period", value)


