# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = ['CustomEntityStoreAssignmentArgs', 'CustomEntityStoreAssignment']

@pulumi.input_type
class CustomEntityStoreAssignmentArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 custom_entity_store_assignment_name: Optional[pulumi.Input[str]] = None,
                 principal: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CustomEntityStoreAssignment resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
        :param pulumi.Input[str] custom_entity_store_assignment_name: Name of the custom entity store assignment. Generated name is GUID.
        :param pulumi.Input[str] principal: The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if custom_entity_store_assignment_name is not None:
            pulumi.set(__self__, "custom_entity_store_assignment_name", custom_entity_store_assignment_name)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group within the user's subscription. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="customEntityStoreAssignmentName")
    def custom_entity_store_assignment_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the custom entity store assignment. Generated name is GUID.
        """
        return pulumi.get(self, "custom_entity_store_assignment_name")

    @custom_entity_store_assignment_name.setter
    def custom_entity_store_assignment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_entity_store_assignment_name", value)

    @property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[str]]:
        """
        The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal", value)


class CustomEntityStoreAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_entity_store_assignment_name: Optional[pulumi.Input[str]] = None,
                 principal: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Custom entity store assignment
        API Version: 2021-07-01-preview.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_entity_store_assignment_name: Name of the custom entity store assignment. Generated name is GUID.
        :param pulumi.Input[str] principal: The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
        :param pulumi.Input[str] resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomEntityStoreAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Custom entity store assignment
        API Version: 2021-07-01-preview.

        :param str resource_name: The name of the resource.
        :param CustomEntityStoreAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomEntityStoreAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_entity_store_assignment_name: Optional[pulumi.Input[str]] = None,
                 principal: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomEntityStoreAssignmentArgs.__new__(CustomEntityStoreAssignmentArgs)

            __props__.__dict__["custom_entity_store_assignment_name"] = custom_entity_store_assignment_name
            __props__.__dict__["principal"] = principal
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["entity_store_database_link"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:security:CustomEntityStoreAssignment"), pulumi.Alias(type_="azure-native:security/v20210701preview:CustomEntityStoreAssignment"), pulumi.Alias(type_="azure-nextgen:security/v20210701preview:CustomEntityStoreAssignment")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(CustomEntityStoreAssignment, __self__).__init__(
            'azure-native:security:CustomEntityStoreAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CustomEntityStoreAssignment':
        """
        Get an existing CustomEntityStoreAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CustomEntityStoreAssignmentArgs.__new__(CustomEntityStoreAssignmentArgs)

        __props__.__dict__["entity_store_database_link"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["principal"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return CustomEntityStoreAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="entityStoreDatabaseLink")
    def entity_store_database_link(self) -> pulumi.Output[Optional[str]]:
        """
        The link to entity store database.
        """
        return pulumi.get(self, "entity_store_database_link")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Output[Optional[str]]:
        """
        The principal assigned with entity store. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

