# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BotPropertiesResponse',
    'ConnectionSettingParameterResponse',
    'ConnectionSettingPropertiesResponse',
    'DirectLineChannelPropertiesResponse',
    'DirectLineChannelResponse',
    'DirectLineSiteResponse',
    'EmailChannelPropertiesResponse',
    'EmailChannelResponse',
    'FacebookChannelPropertiesResponse',
    'FacebookChannelResponse',
    'FacebookPageResponse',
    'KikChannelPropertiesResponse',
    'KikChannelResponse',
    'MsTeamsChannelPropertiesResponse',
    'MsTeamsChannelResponse',
    'ServiceProviderParameterResponse',
    'ServiceProviderPropertiesResponse',
    'ServiceProviderResponse',
    'SkuResponse',
    'SkypeChannelPropertiesResponse',
    'SkypeChannelResponse',
    'SlackChannelPropertiesResponse',
    'SlackChannelResponse',
    'SmsChannelPropertiesResponse',
    'SmsChannelResponse',
    'TelegramChannelPropertiesResponse',
    'TelegramChannelResponse',
    'WebChatChannelPropertiesResponse',
    'WebChatChannelResponse',
    'WebChatSiteResponse',
]

@pulumi.output_type
class BotPropertiesResponse(dict):
    """
    The parameters to provide for the Bot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configuredChannels":
            suggest = "configured_channels"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "enabledChannels":
            suggest = "enabled_channels"
        elif key == "endpointVersion":
            suggest = "endpoint_version"
        elif key == "msaAppId":
            suggest = "msa_app_id"
        elif key == "developerAppInsightKey":
            suggest = "developer_app_insight_key"
        elif key == "developerAppInsightsApiKey":
            suggest = "developer_app_insights_api_key"
        elif key == "developerAppInsightsApplicationId":
            suggest = "developer_app_insights_application_id"
        elif key == "iconUrl":
            suggest = "icon_url"
        elif key == "luisAppIds":
            suggest = "luis_app_ids"
        elif key == "luisKey":
            suggest = "luis_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configured_channels: Sequence[str],
                 display_name: str,
                 enabled_channels: Sequence[str],
                 endpoint: str,
                 endpoint_version: str,
                 msa_app_id: str,
                 description: Optional[str] = None,
                 developer_app_insight_key: Optional[str] = None,
                 developer_app_insights_api_key: Optional[str] = None,
                 developer_app_insights_application_id: Optional[str] = None,
                 icon_url: Optional[str] = None,
                 luis_app_ids: Optional[Sequence[str]] = None,
                 luis_key: Optional[str] = None):
        """
        The parameters to provide for the Bot.
        :param Sequence[str] configured_channels: Collection of channels for which the bot is configured
        :param str display_name: The Name of the bot
        :param Sequence[str] enabled_channels: Collection of channels for which the bot is enabled
        :param str endpoint: The bot's endpoint
        :param str endpoint_version: The bot's endpoint version
        :param str msa_app_id: Microsoft App Id for the bot
        :param str description: The description of the bot
        :param str developer_app_insight_key: The Application Insights key
        :param str developer_app_insights_api_key: The Application Insights Api Key
        :param str developer_app_insights_application_id: The Application Insights App Id
        :param str icon_url: The Icon Url of the bot
        :param Sequence[str] luis_app_ids: Collection of LUIS App Ids
        :param str luis_key: The LUIS Key
        """
        pulumi.set(__self__, "configured_channels", configured_channels)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "enabled_channels", enabled_channels)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "endpoint_version", endpoint_version)
        pulumi.set(__self__, "msa_app_id", msa_app_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if developer_app_insight_key is not None:
            pulumi.set(__self__, "developer_app_insight_key", developer_app_insight_key)
        if developer_app_insights_api_key is not None:
            pulumi.set(__self__, "developer_app_insights_api_key", developer_app_insights_api_key)
        if developer_app_insights_application_id is not None:
            pulumi.set(__self__, "developer_app_insights_application_id", developer_app_insights_application_id)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if luis_app_ids is not None:
            pulumi.set(__self__, "luis_app_ids", luis_app_ids)
        if luis_key is not None:
            pulumi.set(__self__, "luis_key", luis_key)

    @property
    @pulumi.getter(name="configuredChannels")
    def configured_channels(self) -> Sequence[str]:
        """
        Collection of channels for which the bot is configured
        """
        return pulumi.get(self, "configured_channels")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The Name of the bot
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enabledChannels")
    def enabled_channels(self) -> Sequence[str]:
        """
        Collection of channels for which the bot is enabled
        """
        return pulumi.get(self, "enabled_channels")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The bot's endpoint
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="endpointVersion")
    def endpoint_version(self) -> str:
        """
        The bot's endpoint version
        """
        return pulumi.get(self, "endpoint_version")

    @property
    @pulumi.getter(name="msaAppId")
    def msa_app_id(self) -> str:
        """
        Microsoft App Id for the bot
        """
        return pulumi.get(self, "msa_app_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the bot
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="developerAppInsightKey")
    def developer_app_insight_key(self) -> Optional[str]:
        """
        The Application Insights key
        """
        return pulumi.get(self, "developer_app_insight_key")

    @property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> Optional[str]:
        """
        The Application Insights Api Key
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> Optional[str]:
        """
        The Application Insights App Id
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[str]:
        """
        The Icon Url of the bot
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter(name="luisAppIds")
    def luis_app_ids(self) -> Optional[Sequence[str]]:
        """
        Collection of LUIS App Ids
        """
        return pulumi.get(self, "luis_app_ids")

    @property
    @pulumi.getter(name="luisKey")
    def luis_key(self) -> Optional[str]:
        """
        The LUIS Key
        """
        return pulumi.get(self, "luis_key")


@pulumi.output_type
class ConnectionSettingParameterResponse(dict):
    """
    Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
    """
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
        :param str key: Key for the Connection Setting Parameter.
        :param str value: Value associated with the Connection Setting Parameter.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key for the Connection Setting Parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value associated with the Connection Setting Parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionSettingPropertiesResponse(dict):
    """
    Properties for a Connection Setting Item
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "settingId":
            suggest = "setting_id"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "serviceProviderDisplayName":
            suggest = "service_provider_display_name"
        elif key == "serviceProviderId":
            suggest = "service_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSettingPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSettingPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSettingPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 setting_id: str,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.ConnectionSettingParameterResponse']] = None,
                 scopes: Optional[str] = None,
                 service_provider_display_name: Optional[str] = None,
                 service_provider_id: Optional[str] = None):
        """
        Properties for a Connection Setting Item
        :param str setting_id: Setting Id set by the service for the Connection Setting.
        :param str client_id: Client Id associated with the Connection Setting.
        :param str client_secret: Client Secret associated with the Connection Setting
        :param Sequence['ConnectionSettingParameterResponse'] parameters: Service Provider Parameters associated with the Connection Setting
        :param str scopes: Scopes associated with the Connection Setting
        :param str service_provider_display_name: Service Provider Display Name associated with the Connection Setting
        :param str service_provider_id: Service Provider Id associated with the Connection Setting
        """
        pulumi.set(__self__, "setting_id", setting_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if service_provider_display_name is not None:
            pulumi.set(__self__, "service_provider_display_name", service_provider_display_name)
        if service_provider_id is not None:
            pulumi.set(__self__, "service_provider_id", service_provider_id)

    @property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> str:
        """
        Setting Id set by the service for the Connection Setting.
        """
        return pulumi.get(self, "setting_id")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Client Id associated with the Connection Setting.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        Client Secret associated with the Connection Setting
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ConnectionSettingParameterResponse']]:
        """
        Service Provider Parameters associated with the Connection Setting
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[str]:
        """
        Scopes associated with the Connection Setting
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="serviceProviderDisplayName")
    def service_provider_display_name(self) -> Optional[str]:
        """
        Service Provider Display Name associated with the Connection Setting
        """
        return pulumi.get(self, "service_provider_display_name")

    @property
    @pulumi.getter(name="serviceProviderId")
    def service_provider_id(self) -> Optional[str]:
        """
        Service Provider Id associated with the Connection Setting
        """
        return pulumi.get(self, "service_provider_id")


@pulumi.output_type
class DirectLineChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Direct Line channel.
    """
    def __init__(__self__, *,
                 sites: Optional[Sequence['outputs.DirectLineSiteResponse']] = None):
        """
        The parameters to provide for the Direct Line channel.
        :param Sequence['DirectLineSiteResponse'] sites: The list of Direct Line sites
        """
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter
    def sites(self) -> Optional[Sequence['outputs.DirectLineSiteResponse']]:
        """
        The list of Direct Line sites
        """
        return pulumi.get(self, "sites")


@pulumi.output_type
class DirectLineChannelResponse(dict):
    """
    Direct Line channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectLineChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectLineChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectLineChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.DirectLineChannelPropertiesResponse'] = None):
        """
        Direct Line channel definition
        :param str channel_name: The channel name
               Expected value is 'DirectLineChannel'.
        :param 'DirectLineChannelPropertiesResponse' properties: The set of properties specific to Direct Line channel resource
        """
        pulumi.set(__self__, "channel_name", 'DirectLineChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'DirectLineChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DirectLineChannelPropertiesResponse']:
        """
        The set of properties specific to Direct Line channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class DirectLineSiteResponse(dict):
    """
    A site for the Direct Line channel
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "isV1Enabled":
            suggest = "is_v1_enabled"
        elif key == "isV3Enabled":
            suggest = "is_v3_enabled"
        elif key == "siteId":
            suggest = "site_id"
        elif key == "siteName":
            suggest = "site_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectLineSiteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectLineSiteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectLineSiteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 is_v1_enabled: bool,
                 is_v3_enabled: bool,
                 key: str,
                 key2: str,
                 site_id: str,
                 site_name: str):
        """
        A site for the Direct Line channel
        :param bool is_enabled: Whether this site is enabled for DirectLine channel
        :param bool is_v1_enabled: Whether this site is enabled for Bot Framework V1 protocol
        :param bool is_v3_enabled: Whether this site is enabled for Bot Framework V1 protocol
        :param str key: Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str key2: Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str site_id: Site Id
        :param str site_name: Site name
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "is_v1_enabled", is_v1_enabled)
        pulumi.set(__self__, "is_v3_enabled", is_v3_enabled)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "key2", key2)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "site_name", site_name)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this site is enabled for DirectLine channel
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isV1Enabled")
    def is_v1_enabled(self) -> bool:
        """
        Whether this site is enabled for Bot Framework V1 protocol
        """
        return pulumi.get(self, "is_v1_enabled")

    @property
    @pulumi.getter(name="isV3Enabled")
    def is_v3_enabled(self) -> bool:
        """
        Whether this site is enabled for Bot Framework V1 protocol
        """
        return pulumi.get(self, "is_v3_enabled")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def key2(self) -> str:
        """
        Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key2")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> str:
        """
        Site name
        """
        return pulumi.get(self, "site_name")


@pulumi.output_type
class EmailChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Email channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: str,
                 is_enabled: bool,
                 password: str):
        """
        The parameters to provide for the Email channel.
        :param str email_address: The email address
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str password: The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        The email address
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class EmailChannelResponse(dict):
    """
    Email channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.EmailChannelPropertiesResponse'] = None):
        """
        Email channel definition
        :param str channel_name: The channel name
               Expected value is 'EmailChannel'.
        :param 'EmailChannelPropertiesResponse' properties: The set of properties specific to email channel resource
        """
        pulumi.set(__self__, "channel_name", 'EmailChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'EmailChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.EmailChannelPropertiesResponse']:
        """
        The set of properties specific to email channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class FacebookChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Facebook channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appId":
            suggest = "app_id"
        elif key == "appSecret":
            suggest = "app_secret"
        elif key == "callbackUrl":
            suggest = "callback_url"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "verifyToken":
            suggest = "verify_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FacebookChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FacebookChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FacebookChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id: str,
                 app_secret: str,
                 callback_url: str,
                 is_enabled: bool,
                 verify_token: str,
                 pages: Optional[Sequence['outputs.FacebookPageResponse']] = None):
        """
        The parameters to provide for the Facebook channel.
        :param str app_id: Facebook application id
        :param str app_secret: Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str callback_url: Callback Url
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str verify_token: Verify token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param Sequence['FacebookPageResponse'] pages: The list of Facebook pages
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "app_secret", app_secret)
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "verify_token", verify_token)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> str:
        """
        Facebook application id
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appSecret")
    def app_secret(self) -> str:
        """
        Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "app_secret")

    @property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> str:
        """
        Callback Url
        """
        return pulumi.get(self, "callback_url")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="verifyToken")
    def verify_token(self) -> str:
        """
        Verify token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "verify_token")

    @property
    @pulumi.getter
    def pages(self) -> Optional[Sequence['outputs.FacebookPageResponse']]:
        """
        The list of Facebook pages
        """
        return pulumi.get(self, "pages")


@pulumi.output_type
class FacebookChannelResponse(dict):
    """
    Facebook channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FacebookChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FacebookChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FacebookChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.FacebookChannelPropertiesResponse'] = None):
        """
        Facebook channel definition
        :param str channel_name: The channel name
               Expected value is 'FacebookChannel'.
        :param 'FacebookChannelPropertiesResponse' properties: The set of properties specific to bot facebook channel
        """
        pulumi.set(__self__, "channel_name", 'FacebookChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'FacebookChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.FacebookChannelPropertiesResponse']:
        """
        The set of properties specific to bot facebook channel
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class FacebookPageResponse(dict):
    """
    A Facebook page for Facebook channel registration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FacebookPageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FacebookPageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FacebookPageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: str,
                 id: str):
        """
        A Facebook page for Facebook channel registration
        :param str access_token: Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str id: Page id
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> str:
        """
        Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Page id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class KikChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Kik channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "userName":
            suggest = "user_name"
        elif key == "isValidated":
            suggest = "is_validated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KikChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KikChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KikChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 is_enabled: bool,
                 user_name: str,
                 is_validated: Optional[bool] = None):
        """
        The parameters to provide for the Kik channel.
        :param str api_key: Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str user_name: The Kik user name
        :param bool is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "user_name", user_name)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The Kik user name
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[bool]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")


@pulumi.output_type
class KikChannelResponse(dict):
    """
    Kik channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KikChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KikChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KikChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.KikChannelPropertiesResponse'] = None):
        """
        Kik channel definition
        :param str channel_name: The channel name
               Expected value is 'KikChannel'.
        :param 'KikChannelPropertiesResponse' properties: The set of properties specific to Kik channel resource
        """
        pulumi.set(__self__, "channel_name", 'KikChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'KikChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.KikChannelPropertiesResponse']:
        """
        The set of properties specific to Kik channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class MsTeamsChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Microsoft Teams channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "callMode":
            suggest = "call_mode"
        elif key == "enableCalling":
            suggest = "enable_calling"
        elif key == "enableMediaCards":
            suggest = "enable_media_cards"
        elif key == "enableMessaging":
            suggest = "enable_messaging"
        elif key == "enableVideo":
            suggest = "enable_video"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MsTeamsChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MsTeamsChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MsTeamsChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 call_mode: Optional[str] = None,
                 enable_calling: Optional[bool] = None,
                 enable_media_cards: Optional[bool] = None,
                 enable_messaging: Optional[bool] = None,
                 enable_video: Optional[bool] = None):
        """
        The parameters to provide for the Microsoft Teams channel.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str call_mode: Enable messaging for Microsoft Teams channel
        :param bool enable_calling: Enable calling for Microsoft Teams channel
        :param bool enable_media_cards: Enable media cards for Microsoft Teams channel
        :param bool enable_messaging: Enable messaging for Microsoft Teams channel
        :param bool enable_video: Enable video for Microsoft Teams channel
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if call_mode is not None:
            pulumi.set(__self__, "call_mode", call_mode)
        if enable_calling is not None:
            pulumi.set(__self__, "enable_calling", enable_calling)
        if enable_media_cards is not None:
            pulumi.set(__self__, "enable_media_cards", enable_media_cards)
        if enable_messaging is not None:
            pulumi.set(__self__, "enable_messaging", enable_messaging)
        if enable_video is not None:
            pulumi.set(__self__, "enable_video", enable_video)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="callMode")
    def call_mode(self) -> Optional[str]:
        """
        Enable messaging for Microsoft Teams channel
        """
        return pulumi.get(self, "call_mode")

    @property
    @pulumi.getter(name="enableCalling")
    def enable_calling(self) -> Optional[bool]:
        """
        Enable calling for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_calling")

    @property
    @pulumi.getter(name="enableMediaCards")
    def enable_media_cards(self) -> Optional[bool]:
        """
        Enable media cards for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_media_cards")

    @property
    @pulumi.getter(name="enableMessaging")
    def enable_messaging(self) -> Optional[bool]:
        """
        Enable messaging for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_messaging")

    @property
    @pulumi.getter(name="enableVideo")
    def enable_video(self) -> Optional[bool]:
        """
        Enable video for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_video")


@pulumi.output_type
class MsTeamsChannelResponse(dict):
    """
    Microsoft Teams channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MsTeamsChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MsTeamsChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MsTeamsChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.MsTeamsChannelPropertiesResponse'] = None):
        """
        Microsoft Teams channel definition
        :param str channel_name: The channel name
               Expected value is 'MsTeamsChannel'.
        :param 'MsTeamsChannelPropertiesResponse' properties: The set of properties specific to Microsoft Teams channel resource
        """
        pulumi.set(__self__, "channel_name", 'MsTeamsChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'MsTeamsChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.MsTeamsChannelPropertiesResponse']:
        """
        The set of properties specific to Microsoft Teams channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class ServiceProviderParameterResponse(dict):
    """
    Extra Parameters specific to each Service Provider
    """
    def __init__(__self__, *,
                 default: str,
                 description: str,
                 display_name: str,
                 help_url: str,
                 name: str,
                 type: str):
        """
        Extra Parameters specific to each Service Provider
        :param str default: Default Name for the Service Provider
        :param str description: Description of the Service Provider
        :param str display_name: Display Name of the Service Provider
        :param str help_url: Help Url for the  Service Provider
        :param str name: Name of the Service Provider
        :param str type: Type of the Service Provider
        """
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "help_url", help_url)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def default(self) -> str:
        """
        Default Name for the Service Provider
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Service Provider
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display Name of the Service Provider
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> str:
        """
        Help Url for the  Service Provider
        """
        return pulumi.get(self, "help_url")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Service Provider
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Service Provider
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceProviderPropertiesResponse(dict):
    """
    The Object used to describe a Service Provider supported by Bot Service
    """
    def __init__(__self__, *,
                 dev_portal_url: str,
                 display_name: str,
                 icon_url: str,
                 id: str,
                 service_provider_name: str,
                 parameters: Optional[Sequence['outputs.ServiceProviderParameterResponse']] = None):
        """
        The Object used to describe a Service Provider supported by Bot Service
        :param str dev_portal_url: Display Name of the Service Provider
        :param str display_name: Display Name of the Service Provider
        :param str icon_url: Display Name of the Service Provider
        :param str id: Id for Service Provider
        :param str service_provider_name: Display Name of the Service Provider
        :param Sequence['ServiceProviderParameterResponse'] parameters: The list of parameters for the Service Provider
        """
        pulumi.set(__self__, "dev_portal_url", dev_portal_url)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "icon_url", icon_url)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_provider_name", service_provider_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="devPortalUrl")
    def dev_portal_url(self) -> str:
        """
        Display Name of the Service Provider
        """
        return pulumi.get(self, "dev_portal_url")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display Name of the Service Provider
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> str:
        """
        Display Name of the Service Provider
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id for Service Provider
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> str:
        """
        Display Name of the Service Provider
        """
        return pulumi.get(self, "service_provider_name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ServiceProviderParameterResponse']]:
        """
        The list of parameters for the Service Provider
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ServiceProviderResponse(dict):
    """
    Service Provider Definition
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.ServiceProviderPropertiesResponse'] = None):
        """
        Service Provider Definition
        :param 'ServiceProviderPropertiesResponse' properties: The Properties of a Service Provider Object
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ServiceProviderPropertiesResponse']:
        """
        The Properties of a Service Provider Object
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SkuResponse(dict):
    """
    The SKU of the cognitive services account.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str):
        """
        The SKU of the cognitive services account.
        :param str name: The sku name
        :param str tier: Gets the sku tier. This is based on the SKU name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The sku name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Gets the sku tier. This is based on the SKU name.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SkypeChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Microsoft Teams channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "callingWebHook":
            suggest = "calling_web_hook"
        elif key == "enableCalling":
            suggest = "enable_calling"
        elif key == "enableGroups":
            suggest = "enable_groups"
        elif key == "enableMediaCards":
            suggest = "enable_media_cards"
        elif key == "enableMessaging":
            suggest = "enable_messaging"
        elif key == "enableScreenSharing":
            suggest = "enable_screen_sharing"
        elif key == "enableVideo":
            suggest = "enable_video"
        elif key == "groupsMode":
            suggest = "groups_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkypeChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkypeChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkypeChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 calling_web_hook: Optional[str] = None,
                 enable_calling: Optional[bool] = None,
                 enable_groups: Optional[bool] = None,
                 enable_media_cards: Optional[bool] = None,
                 enable_messaging: Optional[bool] = None,
                 enable_screen_sharing: Optional[bool] = None,
                 enable_video: Optional[bool] = None,
                 groups_mode: Optional[str] = None):
        """
        The parameters to provide for the Microsoft Teams channel.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str calling_web_hook: Calling web hook for Skype channel
        :param bool enable_calling: Enable calling for Skype channel
        :param bool enable_groups: Enable groups for Skype channel
        :param bool enable_media_cards: Enable media cards for Skype channel
        :param bool enable_messaging: Enable messaging for Skype channel
        :param bool enable_screen_sharing: Enable screen sharing for Skype channel
        :param bool enable_video: Enable video for Skype channel
        :param str groups_mode: Group mode for Skype channel
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if calling_web_hook is not None:
            pulumi.set(__self__, "calling_web_hook", calling_web_hook)
        if enable_calling is not None:
            pulumi.set(__self__, "enable_calling", enable_calling)
        if enable_groups is not None:
            pulumi.set(__self__, "enable_groups", enable_groups)
        if enable_media_cards is not None:
            pulumi.set(__self__, "enable_media_cards", enable_media_cards)
        if enable_messaging is not None:
            pulumi.set(__self__, "enable_messaging", enable_messaging)
        if enable_screen_sharing is not None:
            pulumi.set(__self__, "enable_screen_sharing", enable_screen_sharing)
        if enable_video is not None:
            pulumi.set(__self__, "enable_video", enable_video)
        if groups_mode is not None:
            pulumi.set(__self__, "groups_mode", groups_mode)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="callingWebHook")
    def calling_web_hook(self) -> Optional[str]:
        """
        Calling web hook for Skype channel
        """
        return pulumi.get(self, "calling_web_hook")

    @property
    @pulumi.getter(name="enableCalling")
    def enable_calling(self) -> Optional[bool]:
        """
        Enable calling for Skype channel
        """
        return pulumi.get(self, "enable_calling")

    @property
    @pulumi.getter(name="enableGroups")
    def enable_groups(self) -> Optional[bool]:
        """
        Enable groups for Skype channel
        """
        return pulumi.get(self, "enable_groups")

    @property
    @pulumi.getter(name="enableMediaCards")
    def enable_media_cards(self) -> Optional[bool]:
        """
        Enable media cards for Skype channel
        """
        return pulumi.get(self, "enable_media_cards")

    @property
    @pulumi.getter(name="enableMessaging")
    def enable_messaging(self) -> Optional[bool]:
        """
        Enable messaging for Skype channel
        """
        return pulumi.get(self, "enable_messaging")

    @property
    @pulumi.getter(name="enableScreenSharing")
    def enable_screen_sharing(self) -> Optional[bool]:
        """
        Enable screen sharing for Skype channel
        """
        return pulumi.get(self, "enable_screen_sharing")

    @property
    @pulumi.getter(name="enableVideo")
    def enable_video(self) -> Optional[bool]:
        """
        Enable video for Skype channel
        """
        return pulumi.get(self, "enable_video")

    @property
    @pulumi.getter(name="groupsMode")
    def groups_mode(self) -> Optional[str]:
        """
        Group mode for Skype channel
        """
        return pulumi.get(self, "groups_mode")


@pulumi.output_type
class SkypeChannelResponse(dict):
    """
    Skype channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkypeChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkypeChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkypeChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.SkypeChannelPropertiesResponse'] = None):
        """
        Skype channel definition
        :param str channel_name: The channel name
               Expected value is 'SkypeChannel'.
        :param 'SkypeChannelPropertiesResponse' properties: The set of properties specific to Skype channel resource
        """
        pulumi.set(__self__, "channel_name", 'SkypeChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'SkypeChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.SkypeChannelPropertiesResponse']:
        """
        The set of properties specific to Skype channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SlackChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Slack channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "isValidated":
            suggest = "is_validated"
        elif key == "lastSubmissionId":
            suggest = "last_submission_id"
        elif key == "redirectAction":
            suggest = "redirect_action"
        elif key == "registerBeforeOAuthFlow":
            suggest = "register_before_o_auth_flow"
        elif key == "verificationToken":
            suggest = "verification_token"
        elif key == "landingPageUrl":
            suggest = "landing_page_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlackChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlackChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlackChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret: str,
                 is_enabled: bool,
                 is_validated: bool,
                 last_submission_id: str,
                 redirect_action: str,
                 register_before_o_auth_flow: bool,
                 verification_token: str,
                 landing_page_url: Optional[str] = None):
        """
        The parameters to provide for the Slack channel.
        :param str client_id: The Slack client id
        :param str client_secret: The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param bool is_validated: Whether this channel is validated for the bot
        :param str last_submission_id: The Sms auth token
        :param str redirect_action: The Slack redirect action
        :param bool register_before_o_auth_flow: Whether to register the settings before OAuth validation is performed. Recommended to True.
        :param str verification_token: The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str landing_page_url: The Slack landing page Url
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "is_validated", is_validated)
        pulumi.set(__self__, "last_submission_id", last_submission_id)
        pulumi.set(__self__, "redirect_action", redirect_action)
        pulumi.set(__self__, "register_before_o_auth_flow", register_before_o_auth_flow)
        pulumi.set(__self__, "verification_token", verification_token)
        if landing_page_url is not None:
            pulumi.set(__self__, "landing_page_url", landing_page_url)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The Slack client id
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> bool:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")

    @property
    @pulumi.getter(name="lastSubmissionId")
    def last_submission_id(self) -> str:
        """
        The Sms auth token
        """
        return pulumi.get(self, "last_submission_id")

    @property
    @pulumi.getter(name="redirectAction")
    def redirect_action(self) -> str:
        """
        The Slack redirect action
        """
        return pulumi.get(self, "redirect_action")

    @property
    @pulumi.getter(name="registerBeforeOAuthFlow")
    def register_before_o_auth_flow(self) -> bool:
        """
        Whether to register the settings before OAuth validation is performed. Recommended to True.
        """
        return pulumi.get(self, "register_before_o_auth_flow")

    @property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> str:
        """
        The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "verification_token")

    @property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> Optional[str]:
        """
        The Slack landing page Url
        """
        return pulumi.get(self, "landing_page_url")


@pulumi.output_type
class SlackChannelResponse(dict):
    """
    Slack channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlackChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlackChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlackChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.SlackChannelPropertiesResponse'] = None):
        """
        Slack channel definition
        :param str channel_name: The channel name
               Expected value is 'SlackChannel'.
        :param 'SlackChannelPropertiesResponse' properties: The set of properties specific to Slack channel resource
        """
        pulumi.set(__self__, "channel_name", 'SlackChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'SlackChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.SlackChannelPropertiesResponse']:
        """
        The set of properties specific to Slack channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SmsChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Sms channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountSID":
            suggest = "account_sid"
        elif key == "authToken":
            suggest = "auth_token"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "isValidated":
            suggest = "is_validated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SmsChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SmsChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SmsChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_sid: str,
                 auth_token: str,
                 is_enabled: bool,
                 phone: str,
                 is_validated: Optional[bool] = None):
        """
        The parameters to provide for the Sms channel.
        :param str account_sid: The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str auth_token: The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str phone: The Sms phone
        :param bool is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "account_sid", account_sid)
        pulumi.set(__self__, "auth_token", auth_token)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "phone", phone)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="accountSID")
    def account_sid(self) -> str:
        """
        The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "account_sid")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> str:
        """
        The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def phone(self) -> str:
        """
        The Sms phone
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[bool]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")


@pulumi.output_type
class SmsChannelResponse(dict):
    """
    Sms channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SmsChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SmsChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SmsChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.SmsChannelPropertiesResponse'] = None):
        """
        Sms channel definition
        :param str channel_name: The channel name
               Expected value is 'SmsChannel'.
        :param 'SmsChannelPropertiesResponse' properties: The set of properties specific to Sms channel resource
        """
        pulumi.set(__self__, "channel_name", 'SmsChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'SmsChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.SmsChannelPropertiesResponse']:
        """
        The set of properties specific to Sms channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class TelegramChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Telegram channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "isValidated":
            suggest = "is_validated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TelegramChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TelegramChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TelegramChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: str,
                 is_enabled: bool,
                 is_validated: Optional[bool] = None):
        """
        The parameters to provide for the Telegram channel.
        :param str access_token: The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param bool is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> str:
        """
        The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[bool]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")


@pulumi.output_type
class TelegramChannelResponse(dict):
    """
    Telegram channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TelegramChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TelegramChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TelegramChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.TelegramChannelPropertiesResponse'] = None):
        """
        Telegram channel definition
        :param str channel_name: The channel name
               Expected value is 'TelegramChannel'.
        :param 'TelegramChannelPropertiesResponse' properties: The set of properties specific to Telegram channel resource
        """
        pulumi.set(__self__, "channel_name", 'TelegramChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'TelegramChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.TelegramChannelPropertiesResponse']:
        """
        The set of properties specific to Telegram channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class WebChatChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Web Chat channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webChatEmbedCode":
            suggest = "web_chat_embed_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebChatChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebChatChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebChatChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 web_chat_embed_code: str,
                 sites: Optional[Sequence['outputs.WebChatSiteResponse']] = None):
        """
        The parameters to provide for the Web Chat channel.
        :param str web_chat_embed_code: Web chat control embed code
        :param Sequence['WebChatSiteResponse'] sites: The list of Web Chat sites
        """
        pulumi.set(__self__, "web_chat_embed_code", web_chat_embed_code)
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter(name="webChatEmbedCode")
    def web_chat_embed_code(self) -> str:
        """
        Web chat control embed code
        """
        return pulumi.get(self, "web_chat_embed_code")

    @property
    @pulumi.getter
    def sites(self) -> Optional[Sequence['outputs.WebChatSiteResponse']]:
        """
        The list of Web Chat sites
        """
        return pulumi.get(self, "sites")


@pulumi.output_type
class WebChatChannelResponse(dict):
    """
    Web Chat channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebChatChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebChatChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebChatChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 properties: Optional['outputs.WebChatChannelPropertiesResponse'] = None):
        """
        Web Chat channel definition
        :param str channel_name: The channel name
               Expected value is 'WebChatChannel'.
        :param 'WebChatChannelPropertiesResponse' properties: The set of properties specific to Web Chat channel resource
        """
        pulumi.set(__self__, "channel_name", 'WebChatChannel')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'WebChatChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.WebChatChannelPropertiesResponse']:
        """
        The set of properties specific to Web Chat channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class WebChatSiteResponse(dict):
    """
    A site for the Webchat channel
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePreview":
            suggest = "enable_preview"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "siteId":
            suggest = "site_id"
        elif key == "siteName":
            suggest = "site_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebChatSiteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebChatSiteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebChatSiteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_preview: bool,
                 is_enabled: bool,
                 key: str,
                 key2: str,
                 site_id: str,
                 site_name: str):
        """
        A site for the Webchat channel
        :param bool enable_preview: Whether this site is enabled for preview versions of Webchat
        :param bool is_enabled: Whether this site is enabled for DirectLine channel
        :param str key: Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str key2: Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str site_id: Site Id
        :param str site_name: Site name
        """
        pulumi.set(__self__, "enable_preview", enable_preview)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "key2", key2)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "site_name", site_name)

    @property
    @pulumi.getter(name="enablePreview")
    def enable_preview(self) -> bool:
        """
        Whether this site is enabled for preview versions of Webchat
        """
        return pulumi.get(self, "enable_preview")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this site is enabled for DirectLine channel
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def key2(self) -> str:
        """
        Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key2")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> str:
        """
        Site name
        """
        return pulumi.get(self, "site_name")


