# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccountEncryptionResponse',
    'EccTokenKeyResponse',
    'EndpointResponse',
    'JwtAuthenticationResponse',
    'KeyVaultPropertiesResponse',
    'ResourceIdentityResponse',
    'RsaTokenKeyResponse',
    'StorageAccountResponse',
    'SystemDataResponse',
    'TokenClaimResponse',
    'UserAssignedManagedIdentityResponse',
    'VideoAnalyzerIdentityResponse',
    'VideoFlagsResponse',
    'VideoMediaInfoResponse',
    'VideoStreamingResponse',
]

@pulumi.output_type
class AccountEncryptionResponse(dict):
    """
    Defines how the Video Analyzer account is (optionally) encrypted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 type: str,
                 identity: Optional['outputs.ResourceIdentityResponse'] = None,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None):
        """
        Defines how the Video Analyzer account is (optionally) encrypted.
        :param str status: The current status of the Key Vault mapping.
        :param str type: The type of key used to encrypt the Account Key.
        :param 'ResourceIdentityResponse' identity: The Key Vault identity.
        :param 'KeyVaultPropertiesResponse' key_vault_properties: The properties of the key used to encrypt the account.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the Key Vault mapping.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of key used to encrypt the Account Key.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ResourceIdentityResponse']:
        """
        The Key Vault identity.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        The properties of the key used to encrypt the account.
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class EccTokenKeyResponse(dict):
    """
    Required validation properties for tokens generated with Elliptical Curve algorithm.
    """
    def __init__(__self__, *,
                 alg: str,
                 kid: str,
                 type: str,
                 x: str,
                 y: str):
        """
        Required validation properties for tokens generated with Elliptical Curve algorithm.
        :param str alg: Elliptical curve algorithm to be used: ES256, ES384 or ES512.
        :param str kid: JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
        :param str x: X coordinate.
        :param str y: Y coordinate.
        """
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EccTokenKey')
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def alg(self) -> str:
        """
        Elliptical curve algorithm to be used: ES256, ES384 or ES512.
        """
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter
    def kid(self) -> str:
        """
        JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def x(self) -> str:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> str:
        """
        Y coordinate.
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class EndpointResponse(dict):
    """
    The endpoint details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointUrl":
            suggest = "endpoint_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 endpoint_url: Optional[str] = None):
        """
        The endpoint details.
        :param str type: The type of the endpoint.
        :param str endpoint_url: The URL of the endpoint.
        """
        pulumi.set(__self__, "type", type)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the endpoint.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[str]:
        """
        The URL of the endpoint.
        """
        return pulumi.get(self, "endpoint_url")


@pulumi.output_type
class JwtAuthenticationResponse(dict):
    """
    Properties for access validation based on JSON Web Tokens (JWT).
    """
    def __init__(__self__, *,
                 type: str,
                 audiences: Optional[Sequence[str]] = None,
                 claims: Optional[Sequence['outputs.TokenClaimResponse']] = None,
                 issuers: Optional[Sequence[str]] = None,
                 keys: Optional[Sequence[Any]] = None):
        """
        Properties for access validation based on JSON Web Tokens (JWT).
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
        :param Sequence[str] audiences: List of expected token audiences. Token audience is valid if it matches at least one of the given values.
        :param Sequence['TokenClaimResponse'] claims: List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
        :param Sequence[str] issuers: List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
        :param Sequence[Union['EccTokenKeyResponse', 'RsaTokenKeyResponse']] keys: List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.JwtAuthentication')
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if claims is not None:
            pulumi.set(__self__, "claims", claims)
        if issuers is not None:
            pulumi.set(__self__, "issuers", issuers)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def audiences(self) -> Optional[Sequence[str]]:
        """
        List of expected token audiences. Token audience is valid if it matches at least one of the given values.
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter
    def claims(self) -> Optional[Sequence['outputs.TokenClaimResponse']]:
        """
        List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
        """
        return pulumi.get(self, "claims")

    @property
    @pulumi.getter
    def issuers(self) -> Optional[Sequence[str]]:
        """
        List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
        """
        return pulumi.get(self, "issuers")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[Any]]:
        """
        List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
        """
        return pulumi.get(self, "keys")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    """
    The details for accessing the encryption keys in Key Vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentKeyIdentifier":
            suggest = "current_key_identifier"
        elif key == "keyIdentifier":
            suggest = "key_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_key_identifier: str,
                 key_identifier: str):
        """
        The details for accessing the encryption keys in Key Vault.
        :param str current_key_identifier: The current key used to encrypt Video Analyzer account, including the key version.
        :param str key_identifier: The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        pulumi.set(__self__, "current_key_identifier", current_key_identifier)
        pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="currentKeyIdentifier")
    def current_key_identifier(self) -> str:
        """
        The current key used to encrypt Video Analyzer account, including the key version.
        """
        return pulumi.get(self, "current_key_identifier")

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> str:
        """
        The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        return pulumi.get(self, "key_identifier")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    """
    The user assigned managed identity to use when accessing a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_assigned_identity: str):
        """
        The user assigned managed identity to use when accessing a resource.
        :param str user_assigned_identity: The user assigned managed identity's resource identifier to use when accessing a resource.
        """
        pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> str:
        """
        The user assigned managed identity's resource identifier to use when accessing a resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class RsaTokenKeyResponse(dict):
    """
    Required validation properties for tokens generated with RSA algorithm.
    """
    def __init__(__self__, *,
                 alg: str,
                 e: str,
                 kid: str,
                 n: str,
                 type: str):
        """
        Required validation properties for tokens generated with RSA algorithm.
        :param str alg: RSA algorithm to be used: RS256, RS384 or RS512.
        :param str e: RSA public key exponent.
        :param str kid: JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        :param str n: RSA public key modulus.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
        """
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "e", e)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "n", n)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.RsaTokenKey')

    @property
    @pulumi.getter
    def alg(self) -> str:
        """
        RSA algorithm to be used: RS256, RS384 or RS512.
        """
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter
    def e(self) -> str:
        """
        RSA public key exponent.
        """
        return pulumi.get(self, "e")

    @property
    @pulumi.getter
    def kid(self) -> str:
        """
        JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def n(self) -> str:
        """
        RSA public key modulus.
        """
        return pulumi.get(self, "n")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StorageAccountResponse(dict):
    """
    The details about the associated storage account.
    """
    def __init__(__self__, *,
                 status: str,
                 id: Optional[str] = None,
                 identity: Optional['outputs.ResourceIdentityResponse'] = None):
        """
        The details about the associated storage account.
        :param str status: The current status of the storage account mapping.
        :param str id: The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
        :param 'ResourceIdentityResponse' identity: A managed identity that Video Analyzer will use to access the storage account.
        """
        pulumi.set(__self__, "status", status)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the storage account mapping.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ResourceIdentityResponse']:
        """
        A managed identity that Video Analyzer will use to access the storage account.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TokenClaimResponse(dict):
    """
    Properties for expected token claims.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Properties for expected token claims.
        :param str name: Name of the claim which must be present on the token.
        :param str value: Expected value of the claim to be present on the token.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the claim which must be present on the token.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Expected value of the claim to be present on the token.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UserAssignedManagedIdentityResponse(dict):
    """
    The details of the user assigned managed identity used by the Video Analyzer resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        The details of the user assigned managed identity used by the Video Analyzer resource.
        :param str client_id: The client ID.
        :param str principal_id: The principal ID.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VideoAnalyzerIdentityResponse(dict):
    """
    The managed identity for the Video Analyzer resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoAnalyzerIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoAnalyzerIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoAnalyzerIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedManagedIdentityResponse']] = None):
        """
        The managed identity for the Video Analyzer resource.
        :param str type: The identity type.
        :param Mapping[str, 'UserAssignedManagedIdentityResponse'] user_assigned_identities: The User Assigned Managed Identities.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedManagedIdentityResponse']]:
        """
        The User Assigned Managed Identities.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class VideoFlagsResponse(dict):
    """
    Video flags contain information about the available video actions and its dynamic properties based on the current video state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canStream":
            suggest = "can_stream"
        elif key == "hasData":
            suggest = "has_data"
        elif key == "isRecording":
            suggest = "is_recording"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoFlagsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoFlagsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoFlagsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_stream: bool,
                 has_data: bool,
                 is_recording: bool):
        """
        Video flags contain information about the available video actions and its dynamic properties based on the current video state.
        :param bool can_stream: Value indicating whether or not the video can be streamed. Only "archive" type videos can be streamed.
        :param bool has_data: Value indicating whether or not there has ever been data recorded or uploaded into the video. Newly created videos have this value set to false.
        :param bool is_recording: Value indicating whether or not the video is currently being referenced be an active live pipeline. The fact that is being referenced, doesn't necessarily indicate that data is being received. For example, video recording may be gated on events or camera may not be accessible at the time.
        """
        pulumi.set(__self__, "can_stream", can_stream)
        pulumi.set(__self__, "has_data", has_data)
        pulumi.set(__self__, "is_recording", is_recording)

    @property
    @pulumi.getter(name="canStream")
    def can_stream(self) -> bool:
        """
        Value indicating whether or not the video can be streamed. Only "archive" type videos can be streamed.
        """
        return pulumi.get(self, "can_stream")

    @property
    @pulumi.getter(name="hasData")
    def has_data(self) -> bool:
        """
        Value indicating whether or not there has ever been data recorded or uploaded into the video. Newly created videos have this value set to false.
        """
        return pulumi.get(self, "has_data")

    @property
    @pulumi.getter(name="isRecording")
    def is_recording(self) -> bool:
        """
        Value indicating whether or not the video is currently being referenced be an active live pipeline. The fact that is being referenced, doesn't necessarily indicate that data is being received. For example, video recording may be gated on events or camera may not be accessible at the time.
        """
        return pulumi.get(self, "is_recording")


@pulumi.output_type
class VideoMediaInfoResponse(dict):
    """
    Contains information about the video and audio content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "segmentLength":
            suggest = "segment_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoMediaInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoMediaInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoMediaInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 segment_length: str):
        """
        Contains information about the video and audio content.
        :param str segment_length: Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
        """
        pulumi.set(__self__, "segment_length", segment_length)

    @property
    @pulumi.getter(name="segmentLength")
    def segment_length(self) -> str:
        """
        Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
        """
        return pulumi.get(self, "segment_length")


@pulumi.output_type
class VideoStreamingResponse(dict):
    """
    Video streaming holds information about video streaming URLs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveBaseUrl":
            suggest = "archive_base_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoStreamingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoStreamingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoStreamingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_base_url: Optional[str] = None):
        """
        Video streaming holds information about video streaming URLs.
        :param str archive_base_url: Video streaming base URL for the video archive. When present, archived video can be played through the Azure Video Analyzer player. Alternatively, this URL can be used with compatible DASH or HLS players by appending the following to the base URL:
               
                 - HLSv4:     /manifest(format=m3u8-aapl).m3u8
                 - HLS CMAF:  /manifest(format=m3u8-cmaf)
                 - DASH CMAF: /manifest(format=mpd-time-cmaf)
               
               Moreover, an ongoing video recording can be played in "live mode" with latencies which are approximately double of the chosen video segment length.
        """
        if archive_base_url is not None:
            pulumi.set(__self__, "archive_base_url", archive_base_url)

    @property
    @pulumi.getter(name="archiveBaseUrl")
    def archive_base_url(self) -> Optional[str]:
        """
        Video streaming base URL for the video archive. When present, archived video can be played through the Azure Video Analyzer player. Alternatively, this URL can be used with compatible DASH or HLS players by appending the following to the base URL:
        
          - HLSv4:     /manifest(format=m3u8-aapl).m3u8
          - HLS CMAF:  /manifest(format=m3u8-cmaf)
          - DASH CMAF: /manifest(format=mpd-time-cmaf)
        
        Moreover, an ongoing video recording can be played in "live mode" with latencies which are approximately double of the chosen video segment length.
        """
        return pulumi.get(self, "archive_base_url")


