# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AS2AcknowledgementConnectionSettingsResponse',
    'AS2AgreementContentResponse',
    'AS2EnvelopeSettingsResponse',
    'AS2ErrorSettingsResponse',
    'AS2MdnSettingsResponse',
    'AS2MessageConnectionSettingsResponse',
    'AS2OneWayAgreementResponse',
    'AS2ProtocolSettingsResponse',
    'AS2SecuritySettingsResponse',
    'AS2ValidationSettingsResponse',
    'AgreementContentResponse',
    'AssemblyPropertiesResponse',
    'AzureResourceErrorInfoResponse',
    'B2BPartnerContentResponse',
    'BatchConfigurationPropertiesResponse',
    'BatchReleaseCriteriaResponse',
    'BusinessIdentityResponse',
    'ContentHashResponse',
    'ContentLinkResponse',
    'EdifactAcknowledgementSettingsResponse',
    'EdifactAgreementContentResponse',
    'EdifactDelimiterOverrideResponse',
    'EdifactEnvelopeOverrideResponse',
    'EdifactEnvelopeSettingsResponse',
    'EdifactFramingSettingsResponse',
    'EdifactMessageFilterResponse',
    'EdifactMessageIdentifierResponse',
    'EdifactOneWayAgreementResponse',
    'EdifactProcessingSettingsResponse',
    'EdifactProtocolSettingsResponse',
    'EdifactSchemaReferenceResponse',
    'EdifactValidationOverrideResponse',
    'EdifactValidationSettingsResponse',
    'ExpressionResponse',
    'ExpressionRootResponse',
    'IntegrationAccountMapPropertiesResponseParametersSchema',
    'IntegrationAccountSkuResponse',
    'KeyVaultKeyReferenceResponse',
    'KeyVaultKeyReferenceResponseKeyVault',
    'KeyVaultKeyResponse',
    'KeyVaultKeyResponseAttributes',
    'PartnerContentResponse',
    'RecurrenceScheduleOccurrenceResponse',
    'RecurrenceScheduleResponse',
    'ResourceReferenceResponse',
    'RosettaNetPipAcknowledgmentOfReceiptSettingsResponse',
    'RosettaNetPipActivityBehaviorResponse',
    'RosettaNetPipActivitySettingsResponse',
    'RosettaNetPipBusinessDocumentResponse',
    'RosettaNetPipRoleSettingsResponse',
    'SkuResponse',
    'WorkflowParameterResponse',
    'WorkflowTriggerListCallbackUrlQueriesResponse',
    'WorkflowTriggerRecurrenceResponse',
    'X12AcknowledgementSettingsResponse',
    'X12AgreementContentResponse',
    'X12DelimiterOverridesResponse',
    'X12EnvelopeOverrideResponse',
    'X12EnvelopeSettingsResponse',
    'X12FramingSettingsResponse',
    'X12MessageFilterResponse',
    'X12MessageIdentifierResponse',
    'X12OneWayAgreementResponse',
    'X12ProcessingSettingsResponse',
    'X12ProtocolSettingsResponse',
    'X12SchemaReferenceResponse',
    'X12SecuritySettingsResponse',
    'X12ValidationOverrideResponse',
    'X12ValidationSettingsResponse',
]

@pulumi.output_type
class AS2AcknowledgementConnectionSettingsResponse(dict):
    """
    The AS2 agreement acknowledgement connection settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCertificateNameMismatch":
            suggest = "ignore_certificate_name_mismatch"
        elif key == "keepHttpConnectionAlive":
            suggest = "keep_http_connection_alive"
        elif key == "supportHttpStatusCodeContinue":
            suggest = "support_http_status_code_continue"
        elif key == "unfoldHttpHeaders":
            suggest = "unfold_http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2AcknowledgementConnectionSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2AcknowledgementConnectionSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2AcknowledgementConnectionSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_certificate_name_mismatch: bool,
                 keep_http_connection_alive: bool,
                 support_http_status_code_continue: bool,
                 unfold_http_headers: bool):
        """
        The AS2 agreement acknowledgement connection settings.
        :param bool ignore_certificate_name_mismatch: The value indicating whether to ignore mismatch in certificate name.
        :param bool keep_http_connection_alive: The value indicating whether to keep the connection alive.
        :param bool support_http_status_code_continue: The value indicating whether to support HTTP status code 'CONTINUE'.
        :param bool unfold_http_headers: The value indicating whether to unfold the HTTP headers.
        """
        pulumi.set(__self__, "ignore_certificate_name_mismatch", ignore_certificate_name_mismatch)
        pulumi.set(__self__, "keep_http_connection_alive", keep_http_connection_alive)
        pulumi.set(__self__, "support_http_status_code_continue", support_http_status_code_continue)
        pulumi.set(__self__, "unfold_http_headers", unfold_http_headers)

    @property
    @pulumi.getter(name="ignoreCertificateNameMismatch")
    def ignore_certificate_name_mismatch(self) -> bool:
        """
        The value indicating whether to ignore mismatch in certificate name.
        """
        return pulumi.get(self, "ignore_certificate_name_mismatch")

    @property
    @pulumi.getter(name="keepHttpConnectionAlive")
    def keep_http_connection_alive(self) -> bool:
        """
        The value indicating whether to keep the connection alive.
        """
        return pulumi.get(self, "keep_http_connection_alive")

    @property
    @pulumi.getter(name="supportHttpStatusCodeContinue")
    def support_http_status_code_continue(self) -> bool:
        """
        The value indicating whether to support HTTP status code 'CONTINUE'.
        """
        return pulumi.get(self, "support_http_status_code_continue")

    @property
    @pulumi.getter(name="unfoldHttpHeaders")
    def unfold_http_headers(self) -> bool:
        """
        The value indicating whether to unfold the HTTP headers.
        """
        return pulumi.get(self, "unfold_http_headers")


@pulumi.output_type
class AS2AgreementContentResponse(dict):
    """
    The integration account AS2 agreement content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "receiveAgreement":
            suggest = "receive_agreement"
        elif key == "sendAgreement":
            suggest = "send_agreement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2AgreementContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2AgreementContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2AgreementContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 receive_agreement: 'outputs.AS2OneWayAgreementResponse',
                 send_agreement: 'outputs.AS2OneWayAgreementResponse'):
        """
        The integration account AS2 agreement content.
        :param 'AS2OneWayAgreementResponse' receive_agreement: The AS2 one-way receive agreement.
        :param 'AS2OneWayAgreementResponse' send_agreement: The AS2 one-way send agreement.
        """
        pulumi.set(__self__, "receive_agreement", receive_agreement)
        pulumi.set(__self__, "send_agreement", send_agreement)

    @property
    @pulumi.getter(name="receiveAgreement")
    def receive_agreement(self) -> 'outputs.AS2OneWayAgreementResponse':
        """
        The AS2 one-way receive agreement.
        """
        return pulumi.get(self, "receive_agreement")

    @property
    @pulumi.getter(name="sendAgreement")
    def send_agreement(self) -> 'outputs.AS2OneWayAgreementResponse':
        """
        The AS2 one-way send agreement.
        """
        return pulumi.get(self, "send_agreement")


@pulumi.output_type
class AS2EnvelopeSettingsResponse(dict):
    """
    The AS2 agreement envelope settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autogenerateFileName":
            suggest = "autogenerate_file_name"
        elif key == "fileNameTemplate":
            suggest = "file_name_template"
        elif key == "messageContentType":
            suggest = "message_content_type"
        elif key == "suspendMessageOnFileNameGenerationError":
            suggest = "suspend_message_on_file_name_generation_error"
        elif key == "transmitFileNameInMimeHeader":
            suggest = "transmit_file_name_in_mime_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2EnvelopeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2EnvelopeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2EnvelopeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autogenerate_file_name: bool,
                 file_name_template: str,
                 message_content_type: str,
                 suspend_message_on_file_name_generation_error: bool,
                 transmit_file_name_in_mime_header: bool):
        """
        The AS2 agreement envelope settings.
        :param bool autogenerate_file_name: The value indicating whether to auto generate file name.
        :param str file_name_template: The template for file name.
        :param str message_content_type: The message content type.
        :param bool suspend_message_on_file_name_generation_error: The value indicating whether to suspend message on file name generation error.
        :param bool transmit_file_name_in_mime_header: The value indicating whether to transmit file name in mime header.
        """
        pulumi.set(__self__, "autogenerate_file_name", autogenerate_file_name)
        pulumi.set(__self__, "file_name_template", file_name_template)
        pulumi.set(__self__, "message_content_type", message_content_type)
        pulumi.set(__self__, "suspend_message_on_file_name_generation_error", suspend_message_on_file_name_generation_error)
        pulumi.set(__self__, "transmit_file_name_in_mime_header", transmit_file_name_in_mime_header)

    @property
    @pulumi.getter(name="autogenerateFileName")
    def autogenerate_file_name(self) -> bool:
        """
        The value indicating whether to auto generate file name.
        """
        return pulumi.get(self, "autogenerate_file_name")

    @property
    @pulumi.getter(name="fileNameTemplate")
    def file_name_template(self) -> str:
        """
        The template for file name.
        """
        return pulumi.get(self, "file_name_template")

    @property
    @pulumi.getter(name="messageContentType")
    def message_content_type(self) -> str:
        """
        The message content type.
        """
        return pulumi.get(self, "message_content_type")

    @property
    @pulumi.getter(name="suspendMessageOnFileNameGenerationError")
    def suspend_message_on_file_name_generation_error(self) -> bool:
        """
        The value indicating whether to suspend message on file name generation error.
        """
        return pulumi.get(self, "suspend_message_on_file_name_generation_error")

    @property
    @pulumi.getter(name="transmitFileNameInMimeHeader")
    def transmit_file_name_in_mime_header(self) -> bool:
        """
        The value indicating whether to transmit file name in mime header.
        """
        return pulumi.get(self, "transmit_file_name_in_mime_header")


@pulumi.output_type
class AS2ErrorSettingsResponse(dict):
    """
    The AS2 agreement error settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resendIfMdnNotReceived":
            suggest = "resend_if_mdn_not_received"
        elif key == "suspendDuplicateMessage":
            suggest = "suspend_duplicate_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2ErrorSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2ErrorSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2ErrorSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resend_if_mdn_not_received: bool,
                 suspend_duplicate_message: bool):
        """
        The AS2 agreement error settings.
        :param bool resend_if_mdn_not_received: The value indicating whether to resend message If MDN is not received.
        :param bool suspend_duplicate_message: The value indicating whether to suspend duplicate message.
        """
        pulumi.set(__self__, "resend_if_mdn_not_received", resend_if_mdn_not_received)
        pulumi.set(__self__, "suspend_duplicate_message", suspend_duplicate_message)

    @property
    @pulumi.getter(name="resendIfMdnNotReceived")
    def resend_if_mdn_not_received(self) -> bool:
        """
        The value indicating whether to resend message If MDN is not received.
        """
        return pulumi.get(self, "resend_if_mdn_not_received")

    @property
    @pulumi.getter(name="suspendDuplicateMessage")
    def suspend_duplicate_message(self) -> bool:
        """
        The value indicating whether to suspend duplicate message.
        """
        return pulumi.get(self, "suspend_duplicate_message")


@pulumi.output_type
class AS2MdnSettingsResponse(dict):
    """
    The AS2 agreement mdn settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "micHashingAlgorithm":
            suggest = "mic_hashing_algorithm"
        elif key == "needMdn":
            suggest = "need_mdn"
        elif key == "sendInboundMdnToMessageBox":
            suggest = "send_inbound_mdn_to_message_box"
        elif key == "sendMdnAsynchronously":
            suggest = "send_mdn_asynchronously"
        elif key == "signMdn":
            suggest = "sign_mdn"
        elif key == "signOutboundMdnIfOptional":
            suggest = "sign_outbound_mdn_if_optional"
        elif key == "dispositionNotificationTo":
            suggest = "disposition_notification_to"
        elif key == "mdnText":
            suggest = "mdn_text"
        elif key == "receiptDeliveryUrl":
            suggest = "receipt_delivery_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2MdnSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2MdnSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2MdnSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mic_hashing_algorithm: str,
                 need_mdn: bool,
                 send_inbound_mdn_to_message_box: bool,
                 send_mdn_asynchronously: bool,
                 sign_mdn: bool,
                 sign_outbound_mdn_if_optional: bool,
                 disposition_notification_to: Optional[str] = None,
                 mdn_text: Optional[str] = None,
                 receipt_delivery_url: Optional[str] = None):
        """
        The AS2 agreement mdn settings.
        :param str mic_hashing_algorithm: The signing or hashing algorithm.
        :param bool need_mdn: The value indicating whether to send or request a MDN.
        :param bool send_inbound_mdn_to_message_box: The value indicating whether to send inbound MDN to message box.
        :param bool send_mdn_asynchronously: The value indicating whether to send the asynchronous MDN.
        :param bool sign_mdn: The value indicating whether the MDN needs to be signed or not.
        :param bool sign_outbound_mdn_if_optional: The value indicating whether to sign the outbound MDN if optional.
        :param str disposition_notification_to: The disposition notification to header value.
        :param str mdn_text: The MDN text.
        :param str receipt_delivery_url: The receipt delivery URL.
        """
        pulumi.set(__self__, "mic_hashing_algorithm", mic_hashing_algorithm)
        pulumi.set(__self__, "need_mdn", need_mdn)
        pulumi.set(__self__, "send_inbound_mdn_to_message_box", send_inbound_mdn_to_message_box)
        pulumi.set(__self__, "send_mdn_asynchronously", send_mdn_asynchronously)
        pulumi.set(__self__, "sign_mdn", sign_mdn)
        pulumi.set(__self__, "sign_outbound_mdn_if_optional", sign_outbound_mdn_if_optional)
        if disposition_notification_to is not None:
            pulumi.set(__self__, "disposition_notification_to", disposition_notification_to)
        if mdn_text is not None:
            pulumi.set(__self__, "mdn_text", mdn_text)
        if receipt_delivery_url is not None:
            pulumi.set(__self__, "receipt_delivery_url", receipt_delivery_url)

    @property
    @pulumi.getter(name="micHashingAlgorithm")
    def mic_hashing_algorithm(self) -> str:
        """
        The signing or hashing algorithm.
        """
        return pulumi.get(self, "mic_hashing_algorithm")

    @property
    @pulumi.getter(name="needMdn")
    def need_mdn(self) -> bool:
        """
        The value indicating whether to send or request a MDN.
        """
        return pulumi.get(self, "need_mdn")

    @property
    @pulumi.getter(name="sendInboundMdnToMessageBox")
    def send_inbound_mdn_to_message_box(self) -> bool:
        """
        The value indicating whether to send inbound MDN to message box.
        """
        return pulumi.get(self, "send_inbound_mdn_to_message_box")

    @property
    @pulumi.getter(name="sendMdnAsynchronously")
    def send_mdn_asynchronously(self) -> bool:
        """
        The value indicating whether to send the asynchronous MDN.
        """
        return pulumi.get(self, "send_mdn_asynchronously")

    @property
    @pulumi.getter(name="signMdn")
    def sign_mdn(self) -> bool:
        """
        The value indicating whether the MDN needs to be signed or not.
        """
        return pulumi.get(self, "sign_mdn")

    @property
    @pulumi.getter(name="signOutboundMdnIfOptional")
    def sign_outbound_mdn_if_optional(self) -> bool:
        """
        The value indicating whether to sign the outbound MDN if optional.
        """
        return pulumi.get(self, "sign_outbound_mdn_if_optional")

    @property
    @pulumi.getter(name="dispositionNotificationTo")
    def disposition_notification_to(self) -> Optional[str]:
        """
        The disposition notification to header value.
        """
        return pulumi.get(self, "disposition_notification_to")

    @property
    @pulumi.getter(name="mdnText")
    def mdn_text(self) -> Optional[str]:
        """
        The MDN text.
        """
        return pulumi.get(self, "mdn_text")

    @property
    @pulumi.getter(name="receiptDeliveryUrl")
    def receipt_delivery_url(self) -> Optional[str]:
        """
        The receipt delivery URL.
        """
        return pulumi.get(self, "receipt_delivery_url")


@pulumi.output_type
class AS2MessageConnectionSettingsResponse(dict):
    """
    The AS2 agreement message connection settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCertificateNameMismatch":
            suggest = "ignore_certificate_name_mismatch"
        elif key == "keepHttpConnectionAlive":
            suggest = "keep_http_connection_alive"
        elif key == "supportHttpStatusCodeContinue":
            suggest = "support_http_status_code_continue"
        elif key == "unfoldHttpHeaders":
            suggest = "unfold_http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2MessageConnectionSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2MessageConnectionSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2MessageConnectionSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_certificate_name_mismatch: bool,
                 keep_http_connection_alive: bool,
                 support_http_status_code_continue: bool,
                 unfold_http_headers: bool):
        """
        The AS2 agreement message connection settings.
        :param bool ignore_certificate_name_mismatch: The value indicating whether to ignore mismatch in certificate name.
        :param bool keep_http_connection_alive: The value indicating whether to keep the connection alive.
        :param bool support_http_status_code_continue: The value indicating whether to support HTTP status code 'CONTINUE'.
        :param bool unfold_http_headers: The value indicating whether to unfold the HTTP headers.
        """
        pulumi.set(__self__, "ignore_certificate_name_mismatch", ignore_certificate_name_mismatch)
        pulumi.set(__self__, "keep_http_connection_alive", keep_http_connection_alive)
        pulumi.set(__self__, "support_http_status_code_continue", support_http_status_code_continue)
        pulumi.set(__self__, "unfold_http_headers", unfold_http_headers)

    @property
    @pulumi.getter(name="ignoreCertificateNameMismatch")
    def ignore_certificate_name_mismatch(self) -> bool:
        """
        The value indicating whether to ignore mismatch in certificate name.
        """
        return pulumi.get(self, "ignore_certificate_name_mismatch")

    @property
    @pulumi.getter(name="keepHttpConnectionAlive")
    def keep_http_connection_alive(self) -> bool:
        """
        The value indicating whether to keep the connection alive.
        """
        return pulumi.get(self, "keep_http_connection_alive")

    @property
    @pulumi.getter(name="supportHttpStatusCodeContinue")
    def support_http_status_code_continue(self) -> bool:
        """
        The value indicating whether to support HTTP status code 'CONTINUE'.
        """
        return pulumi.get(self, "support_http_status_code_continue")

    @property
    @pulumi.getter(name="unfoldHttpHeaders")
    def unfold_http_headers(self) -> bool:
        """
        The value indicating whether to unfold the HTTP headers.
        """
        return pulumi.get(self, "unfold_http_headers")


@pulumi.output_type
class AS2OneWayAgreementResponse(dict):
    """
    The integration account AS2 one-way agreement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolSettings":
            suggest = "protocol_settings"
        elif key == "receiverBusinessIdentity":
            suggest = "receiver_business_identity"
        elif key == "senderBusinessIdentity":
            suggest = "sender_business_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2OneWayAgreementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2OneWayAgreementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2OneWayAgreementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol_settings: 'outputs.AS2ProtocolSettingsResponse',
                 receiver_business_identity: 'outputs.BusinessIdentityResponse',
                 sender_business_identity: 'outputs.BusinessIdentityResponse'):
        """
        The integration account AS2 one-way agreement.
        :param 'AS2ProtocolSettingsResponse' protocol_settings: The AS2 protocol settings.
        :param 'BusinessIdentityResponse' receiver_business_identity: The receiver business identity
        :param 'BusinessIdentityResponse' sender_business_identity: The sender business identity
        """
        pulumi.set(__self__, "protocol_settings", protocol_settings)
        pulumi.set(__self__, "receiver_business_identity", receiver_business_identity)
        pulumi.set(__self__, "sender_business_identity", sender_business_identity)

    @property
    @pulumi.getter(name="protocolSettings")
    def protocol_settings(self) -> 'outputs.AS2ProtocolSettingsResponse':
        """
        The AS2 protocol settings.
        """
        return pulumi.get(self, "protocol_settings")

    @property
    @pulumi.getter(name="receiverBusinessIdentity")
    def receiver_business_identity(self) -> 'outputs.BusinessIdentityResponse':
        """
        The receiver business identity
        """
        return pulumi.get(self, "receiver_business_identity")

    @property
    @pulumi.getter(name="senderBusinessIdentity")
    def sender_business_identity(self) -> 'outputs.BusinessIdentityResponse':
        """
        The sender business identity
        """
        return pulumi.get(self, "sender_business_identity")


@pulumi.output_type
class AS2ProtocolSettingsResponse(dict):
    """
    The AS2 agreement protocol settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementConnectionSettings":
            suggest = "acknowledgement_connection_settings"
        elif key == "envelopeSettings":
            suggest = "envelope_settings"
        elif key == "errorSettings":
            suggest = "error_settings"
        elif key == "mdnSettings":
            suggest = "mdn_settings"
        elif key == "messageConnectionSettings":
            suggest = "message_connection_settings"
        elif key == "securitySettings":
            suggest = "security_settings"
        elif key == "validationSettings":
            suggest = "validation_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2ProtocolSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2ProtocolSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2ProtocolSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_connection_settings: 'outputs.AS2AcknowledgementConnectionSettingsResponse',
                 envelope_settings: 'outputs.AS2EnvelopeSettingsResponse',
                 error_settings: 'outputs.AS2ErrorSettingsResponse',
                 mdn_settings: 'outputs.AS2MdnSettingsResponse',
                 message_connection_settings: 'outputs.AS2MessageConnectionSettingsResponse',
                 security_settings: 'outputs.AS2SecuritySettingsResponse',
                 validation_settings: 'outputs.AS2ValidationSettingsResponse'):
        """
        The AS2 agreement protocol settings.
        :param 'AS2AcknowledgementConnectionSettingsResponse' acknowledgement_connection_settings: The acknowledgement connection settings.
        :param 'AS2EnvelopeSettingsResponse' envelope_settings: The envelope settings.
        :param 'AS2ErrorSettingsResponse' error_settings: The error settings.
        :param 'AS2MdnSettingsResponse' mdn_settings: The MDN settings.
        :param 'AS2MessageConnectionSettingsResponse' message_connection_settings: The message connection settings.
        :param 'AS2SecuritySettingsResponse' security_settings: The security settings.
        :param 'AS2ValidationSettingsResponse' validation_settings: The validation settings.
        """
        pulumi.set(__self__, "acknowledgement_connection_settings", acknowledgement_connection_settings)
        pulumi.set(__self__, "envelope_settings", envelope_settings)
        pulumi.set(__self__, "error_settings", error_settings)
        pulumi.set(__self__, "mdn_settings", mdn_settings)
        pulumi.set(__self__, "message_connection_settings", message_connection_settings)
        pulumi.set(__self__, "security_settings", security_settings)
        pulumi.set(__self__, "validation_settings", validation_settings)

    @property
    @pulumi.getter(name="acknowledgementConnectionSettings")
    def acknowledgement_connection_settings(self) -> 'outputs.AS2AcknowledgementConnectionSettingsResponse':
        """
        The acknowledgement connection settings.
        """
        return pulumi.get(self, "acknowledgement_connection_settings")

    @property
    @pulumi.getter(name="envelopeSettings")
    def envelope_settings(self) -> 'outputs.AS2EnvelopeSettingsResponse':
        """
        The envelope settings.
        """
        return pulumi.get(self, "envelope_settings")

    @property
    @pulumi.getter(name="errorSettings")
    def error_settings(self) -> 'outputs.AS2ErrorSettingsResponse':
        """
        The error settings.
        """
        return pulumi.get(self, "error_settings")

    @property
    @pulumi.getter(name="mdnSettings")
    def mdn_settings(self) -> 'outputs.AS2MdnSettingsResponse':
        """
        The MDN settings.
        """
        return pulumi.get(self, "mdn_settings")

    @property
    @pulumi.getter(name="messageConnectionSettings")
    def message_connection_settings(self) -> 'outputs.AS2MessageConnectionSettingsResponse':
        """
        The message connection settings.
        """
        return pulumi.get(self, "message_connection_settings")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> 'outputs.AS2SecuritySettingsResponse':
        """
        The security settings.
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> 'outputs.AS2ValidationSettingsResponse':
        """
        The validation settings.
        """
        return pulumi.get(self, "validation_settings")


@pulumi.output_type
class AS2SecuritySettingsResponse(dict):
    """
    The AS2 agreement security settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableNrrForInboundDecodedMessages":
            suggest = "enable_nrr_for_inbound_decoded_messages"
        elif key == "enableNrrForInboundEncodedMessages":
            suggest = "enable_nrr_for_inbound_encoded_messages"
        elif key == "enableNrrForInboundMdn":
            suggest = "enable_nrr_for_inbound_mdn"
        elif key == "enableNrrForOutboundDecodedMessages":
            suggest = "enable_nrr_for_outbound_decoded_messages"
        elif key == "enableNrrForOutboundEncodedMessages":
            suggest = "enable_nrr_for_outbound_encoded_messages"
        elif key == "enableNrrForOutboundMdn":
            suggest = "enable_nrr_for_outbound_mdn"
        elif key == "overrideGroupSigningCertificate":
            suggest = "override_group_signing_certificate"
        elif key == "encryptionCertificateName":
            suggest = "encryption_certificate_name"
        elif key == "sha2AlgorithmFormat":
            suggest = "sha2_algorithm_format"
        elif key == "signingCertificateName":
            suggest = "signing_certificate_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2SecuritySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2SecuritySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2SecuritySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_nrr_for_inbound_decoded_messages: bool,
                 enable_nrr_for_inbound_encoded_messages: bool,
                 enable_nrr_for_inbound_mdn: bool,
                 enable_nrr_for_outbound_decoded_messages: bool,
                 enable_nrr_for_outbound_encoded_messages: bool,
                 enable_nrr_for_outbound_mdn: bool,
                 override_group_signing_certificate: bool,
                 encryption_certificate_name: Optional[str] = None,
                 sha2_algorithm_format: Optional[str] = None,
                 signing_certificate_name: Optional[str] = None):
        """
        The AS2 agreement security settings.
        :param bool enable_nrr_for_inbound_decoded_messages: The value indicating whether to enable NRR for inbound decoded messages.
        :param bool enable_nrr_for_inbound_encoded_messages: The value indicating whether to enable NRR for inbound encoded messages.
        :param bool enable_nrr_for_inbound_mdn: The value indicating whether to enable NRR for inbound MDN.
        :param bool enable_nrr_for_outbound_decoded_messages: The value indicating whether to enable NRR for outbound decoded messages.
        :param bool enable_nrr_for_outbound_encoded_messages: The value indicating whether to enable NRR for outbound encoded messages.
        :param bool enable_nrr_for_outbound_mdn: The value indicating whether to enable NRR for outbound MDN.
        :param bool override_group_signing_certificate: The value indicating whether to send or request a MDN.
        :param str encryption_certificate_name: The name of the encryption certificate.
        :param str sha2_algorithm_format: The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
        :param str signing_certificate_name: The name of the signing certificate.
        """
        pulumi.set(__self__, "enable_nrr_for_inbound_decoded_messages", enable_nrr_for_inbound_decoded_messages)
        pulumi.set(__self__, "enable_nrr_for_inbound_encoded_messages", enable_nrr_for_inbound_encoded_messages)
        pulumi.set(__self__, "enable_nrr_for_inbound_mdn", enable_nrr_for_inbound_mdn)
        pulumi.set(__self__, "enable_nrr_for_outbound_decoded_messages", enable_nrr_for_outbound_decoded_messages)
        pulumi.set(__self__, "enable_nrr_for_outbound_encoded_messages", enable_nrr_for_outbound_encoded_messages)
        pulumi.set(__self__, "enable_nrr_for_outbound_mdn", enable_nrr_for_outbound_mdn)
        pulumi.set(__self__, "override_group_signing_certificate", override_group_signing_certificate)
        if encryption_certificate_name is not None:
            pulumi.set(__self__, "encryption_certificate_name", encryption_certificate_name)
        if sha2_algorithm_format is not None:
            pulumi.set(__self__, "sha2_algorithm_format", sha2_algorithm_format)
        if signing_certificate_name is not None:
            pulumi.set(__self__, "signing_certificate_name", signing_certificate_name)

    @property
    @pulumi.getter(name="enableNrrForInboundDecodedMessages")
    def enable_nrr_for_inbound_decoded_messages(self) -> bool:
        """
        The value indicating whether to enable NRR for inbound decoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_inbound_decoded_messages")

    @property
    @pulumi.getter(name="enableNrrForInboundEncodedMessages")
    def enable_nrr_for_inbound_encoded_messages(self) -> bool:
        """
        The value indicating whether to enable NRR for inbound encoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_inbound_encoded_messages")

    @property
    @pulumi.getter(name="enableNrrForInboundMdn")
    def enable_nrr_for_inbound_mdn(self) -> bool:
        """
        The value indicating whether to enable NRR for inbound MDN.
        """
        return pulumi.get(self, "enable_nrr_for_inbound_mdn")

    @property
    @pulumi.getter(name="enableNrrForOutboundDecodedMessages")
    def enable_nrr_for_outbound_decoded_messages(self) -> bool:
        """
        The value indicating whether to enable NRR for outbound decoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_outbound_decoded_messages")

    @property
    @pulumi.getter(name="enableNrrForOutboundEncodedMessages")
    def enable_nrr_for_outbound_encoded_messages(self) -> bool:
        """
        The value indicating whether to enable NRR for outbound encoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_outbound_encoded_messages")

    @property
    @pulumi.getter(name="enableNrrForOutboundMdn")
    def enable_nrr_for_outbound_mdn(self) -> bool:
        """
        The value indicating whether to enable NRR for outbound MDN.
        """
        return pulumi.get(self, "enable_nrr_for_outbound_mdn")

    @property
    @pulumi.getter(name="overrideGroupSigningCertificate")
    def override_group_signing_certificate(self) -> bool:
        """
        The value indicating whether to send or request a MDN.
        """
        return pulumi.get(self, "override_group_signing_certificate")

    @property
    @pulumi.getter(name="encryptionCertificateName")
    def encryption_certificate_name(self) -> Optional[str]:
        """
        The name of the encryption certificate.
        """
        return pulumi.get(self, "encryption_certificate_name")

    @property
    @pulumi.getter(name="sha2AlgorithmFormat")
    def sha2_algorithm_format(self) -> Optional[str]:
        """
        The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
        """
        return pulumi.get(self, "sha2_algorithm_format")

    @property
    @pulumi.getter(name="signingCertificateName")
    def signing_certificate_name(self) -> Optional[str]:
        """
        The name of the signing certificate.
        """
        return pulumi.get(self, "signing_certificate_name")


@pulumi.output_type
class AS2ValidationSettingsResponse(dict):
    """
    The AS2 agreement validation settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkCertificateRevocationListOnReceive":
            suggest = "check_certificate_revocation_list_on_receive"
        elif key == "checkCertificateRevocationListOnSend":
            suggest = "check_certificate_revocation_list_on_send"
        elif key == "checkDuplicateMessage":
            suggest = "check_duplicate_message"
        elif key == "compressMessage":
            suggest = "compress_message"
        elif key == "encryptMessage":
            suggest = "encrypt_message"
        elif key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"
        elif key == "interchangeDuplicatesValidityDays":
            suggest = "interchange_duplicates_validity_days"
        elif key == "overrideMessageProperties":
            suggest = "override_message_properties"
        elif key == "signMessage":
            suggest = "sign_message"
        elif key == "signingAlgorithm":
            suggest = "signing_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AS2ValidationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AS2ValidationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AS2ValidationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_certificate_revocation_list_on_receive: bool,
                 check_certificate_revocation_list_on_send: bool,
                 check_duplicate_message: bool,
                 compress_message: bool,
                 encrypt_message: bool,
                 encryption_algorithm: str,
                 interchange_duplicates_validity_days: int,
                 override_message_properties: bool,
                 sign_message: bool,
                 signing_algorithm: Optional[str] = None):
        """
        The AS2 agreement validation settings.
        :param bool check_certificate_revocation_list_on_receive: The value indicating whether to check for certificate revocation list on receive.
        :param bool check_certificate_revocation_list_on_send: The value indicating whether to check for certificate revocation list on send.
        :param bool check_duplicate_message: The value indicating whether to check for duplicate message.
        :param bool compress_message: The value indicating whether the message has to be compressed.
        :param bool encrypt_message: The value indicating whether the message has to be encrypted.
        :param str encryption_algorithm: The encryption algorithm.
        :param int interchange_duplicates_validity_days: The number of days to look back for duplicate interchange.
        :param bool override_message_properties: The value indicating whether to override incoming message properties with those in agreement.
        :param bool sign_message: The value indicating whether the message has to be signed.
        :param str signing_algorithm: The signing algorithm.
        """
        pulumi.set(__self__, "check_certificate_revocation_list_on_receive", check_certificate_revocation_list_on_receive)
        pulumi.set(__self__, "check_certificate_revocation_list_on_send", check_certificate_revocation_list_on_send)
        pulumi.set(__self__, "check_duplicate_message", check_duplicate_message)
        pulumi.set(__self__, "compress_message", compress_message)
        pulumi.set(__self__, "encrypt_message", encrypt_message)
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "interchange_duplicates_validity_days", interchange_duplicates_validity_days)
        pulumi.set(__self__, "override_message_properties", override_message_properties)
        pulumi.set(__self__, "sign_message", sign_message)
        if signing_algorithm is not None:
            pulumi.set(__self__, "signing_algorithm", signing_algorithm)

    @property
    @pulumi.getter(name="checkCertificateRevocationListOnReceive")
    def check_certificate_revocation_list_on_receive(self) -> bool:
        """
        The value indicating whether to check for certificate revocation list on receive.
        """
        return pulumi.get(self, "check_certificate_revocation_list_on_receive")

    @property
    @pulumi.getter(name="checkCertificateRevocationListOnSend")
    def check_certificate_revocation_list_on_send(self) -> bool:
        """
        The value indicating whether to check for certificate revocation list on send.
        """
        return pulumi.get(self, "check_certificate_revocation_list_on_send")

    @property
    @pulumi.getter(name="checkDuplicateMessage")
    def check_duplicate_message(self) -> bool:
        """
        The value indicating whether to check for duplicate message.
        """
        return pulumi.get(self, "check_duplicate_message")

    @property
    @pulumi.getter(name="compressMessage")
    def compress_message(self) -> bool:
        """
        The value indicating whether the message has to be compressed.
        """
        return pulumi.get(self, "compress_message")

    @property
    @pulumi.getter(name="encryptMessage")
    def encrypt_message(self) -> bool:
        """
        The value indicating whether the message has to be encrypted.
        """
        return pulumi.get(self, "encrypt_message")

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> str:
        """
        The encryption algorithm.
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="interchangeDuplicatesValidityDays")
    def interchange_duplicates_validity_days(self) -> int:
        """
        The number of days to look back for duplicate interchange.
        """
        return pulumi.get(self, "interchange_duplicates_validity_days")

    @property
    @pulumi.getter(name="overrideMessageProperties")
    def override_message_properties(self) -> bool:
        """
        The value indicating whether to override incoming message properties with those in agreement.
        """
        return pulumi.get(self, "override_message_properties")

    @property
    @pulumi.getter(name="signMessage")
    def sign_message(self) -> bool:
        """
        The value indicating whether the message has to be signed.
        """
        return pulumi.get(self, "sign_message")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional[str]:
        """
        The signing algorithm.
        """
        return pulumi.get(self, "signing_algorithm")


@pulumi.output_type
class AgreementContentResponse(dict):
    """
    The integration account agreement content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aS2":
            suggest = "a_s2"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgreementContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgreementContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgreementContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 a_s2: Optional['outputs.AS2AgreementContentResponse'] = None,
                 edifact: Optional['outputs.EdifactAgreementContentResponse'] = None,
                 x12: Optional['outputs.X12AgreementContentResponse'] = None):
        """
        The integration account agreement content.
        :param 'AS2AgreementContentResponse' a_s2: The AS2 agreement content.
        :param 'EdifactAgreementContentResponse' edifact: The EDIFACT agreement content.
        :param 'X12AgreementContentResponse' x12: The X12 agreement content.
        """
        if a_s2 is not None:
            pulumi.set(__self__, "a_s2", a_s2)
        if edifact is not None:
            pulumi.set(__self__, "edifact", edifact)
        if x12 is not None:
            pulumi.set(__self__, "x12", x12)

    @property
    @pulumi.getter(name="aS2")
    def a_s2(self) -> Optional['outputs.AS2AgreementContentResponse']:
        """
        The AS2 agreement content.
        """
        return pulumi.get(self, "a_s2")

    @property
    @pulumi.getter
    def edifact(self) -> Optional['outputs.EdifactAgreementContentResponse']:
        """
        The EDIFACT agreement content.
        """
        return pulumi.get(self, "edifact")

    @property
    @pulumi.getter
    def x12(self) -> Optional['outputs.X12AgreementContentResponse']:
        """
        The X12 agreement content.
        """
        return pulumi.get(self, "x12")


@pulumi.output_type
class AssemblyPropertiesResponse(dict):
    """
    The assembly properties definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assemblyName":
            suggest = "assembly_name"
        elif key == "assemblyCulture":
            suggest = "assembly_culture"
        elif key == "assemblyPublicKeyToken":
            suggest = "assembly_public_key_token"
        elif key == "assemblyVersion":
            suggest = "assembly_version"
        elif key == "changedTime":
            suggest = "changed_time"
        elif key == "contentLink":
            suggest = "content_link"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "createdTime":
            suggest = "created_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssemblyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssemblyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssemblyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assembly_name: str,
                 assembly_culture: Optional[str] = None,
                 assembly_public_key_token: Optional[str] = None,
                 assembly_version: Optional[str] = None,
                 changed_time: Optional[str] = None,
                 content: Optional[Any] = None,
                 content_link: Optional['outputs.ContentLinkResponse'] = None,
                 content_type: Optional[str] = None,
                 created_time: Optional[str] = None,
                 metadata: Optional[Any] = None):
        """
        The assembly properties definition.
        :param str assembly_name: The assembly name.
        :param str assembly_culture: The assembly culture.
        :param str assembly_public_key_token: The assembly public key token.
        :param str assembly_version: The assembly version.
        :param str changed_time: The artifact changed time.
        :param 'ContentLinkResponse' content_link: The content link.
        :param str content_type: The content type.
        :param str created_time: The artifact creation time.
        """
        pulumi.set(__self__, "assembly_name", assembly_name)
        if assembly_culture is not None:
            pulumi.set(__self__, "assembly_culture", assembly_culture)
        if assembly_public_key_token is not None:
            pulumi.set(__self__, "assembly_public_key_token", assembly_public_key_token)
        if assembly_version is not None:
            pulumi.set(__self__, "assembly_version", assembly_version)
        if changed_time is not None:
            pulumi.set(__self__, "changed_time", changed_time)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_link is not None:
            pulumi.set(__self__, "content_link", content_link)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter(name="assemblyName")
    def assembly_name(self) -> str:
        """
        The assembly name.
        """
        return pulumi.get(self, "assembly_name")

    @property
    @pulumi.getter(name="assemblyCulture")
    def assembly_culture(self) -> Optional[str]:
        """
        The assembly culture.
        """
        return pulumi.get(self, "assembly_culture")

    @property
    @pulumi.getter(name="assemblyPublicKeyToken")
    def assembly_public_key_token(self) -> Optional[str]:
        """
        The assembly public key token.
        """
        return pulumi.get(self, "assembly_public_key_token")

    @property
    @pulumi.getter(name="assemblyVersion")
    def assembly_version(self) -> Optional[str]:
        """
        The assembly version.
        """
        return pulumi.get(self, "assembly_version")

    @property
    @pulumi.getter(name="changedTime")
    def changed_time(self) -> Optional[str]:
        """
        The artifact changed time.
        """
        return pulumi.get(self, "changed_time")

    @property
    @pulumi.getter
    def content(self) -> Optional[Any]:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentLink")
    def content_link(self) -> Optional['outputs.ContentLinkResponse']:
        """
        The content link.
        """
        return pulumi.get(self, "content_link")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The content type.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        The artifact creation time.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        return pulumi.get(self, "metadata")


@pulumi.output_type
class AzureResourceErrorInfoResponse(dict):
    """
    The azure resource error info.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.AzureResourceErrorInfoResponse']] = None):
        """
        The azure resource error info.
        :param str code: The error code.
        :param str message: The error message.
        :param Sequence['AzureResourceErrorInfoResponse'] details: The error details.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.AzureResourceErrorInfoResponse']]:
        """
        The error details.
        """
        return pulumi.get(self, "details")


@pulumi.output_type
class B2BPartnerContentResponse(dict):
    """
    The B2B partner content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "businessIdentities":
            suggest = "business_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in B2BPartnerContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        B2BPartnerContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        B2BPartnerContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 business_identities: Optional[Sequence['outputs.BusinessIdentityResponse']] = None):
        """
        The B2B partner content.
        :param Sequence['BusinessIdentityResponse'] business_identities: The list of partner business identities.
        """
        if business_identities is not None:
            pulumi.set(__self__, "business_identities", business_identities)

    @property
    @pulumi.getter(name="businessIdentities")
    def business_identities(self) -> Optional[Sequence['outputs.BusinessIdentityResponse']]:
        """
        The list of partner business identities.
        """
        return pulumi.get(self, "business_identities")


@pulumi.output_type
class BatchConfigurationPropertiesResponse(dict):
    """
    The batch configuration properties definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchGroupName":
            suggest = "batch_group_name"
        elif key == "releaseCriteria":
            suggest = "release_criteria"
        elif key == "changedTime":
            suggest = "changed_time"
        elif key == "createdTime":
            suggest = "created_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchConfigurationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchConfigurationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchConfigurationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_group_name: str,
                 release_criteria: 'outputs.BatchReleaseCriteriaResponse',
                 changed_time: Optional[str] = None,
                 created_time: Optional[str] = None,
                 metadata: Optional[Any] = None):
        """
        The batch configuration properties definition.
        :param str batch_group_name: The name of the batch group.
        :param 'BatchReleaseCriteriaResponse' release_criteria: The batch release criteria.
        :param str changed_time: The artifact changed time.
        :param str created_time: The artifact creation time.
        """
        pulumi.set(__self__, "batch_group_name", batch_group_name)
        pulumi.set(__self__, "release_criteria", release_criteria)
        if changed_time is not None:
            pulumi.set(__self__, "changed_time", changed_time)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter(name="batchGroupName")
    def batch_group_name(self) -> str:
        """
        The name of the batch group.
        """
        return pulumi.get(self, "batch_group_name")

    @property
    @pulumi.getter(name="releaseCriteria")
    def release_criteria(self) -> 'outputs.BatchReleaseCriteriaResponse':
        """
        The batch release criteria.
        """
        return pulumi.get(self, "release_criteria")

    @property
    @pulumi.getter(name="changedTime")
    def changed_time(self) -> Optional[str]:
        """
        The artifact changed time.
        """
        return pulumi.get(self, "changed_time")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        The artifact creation time.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        return pulumi.get(self, "metadata")


@pulumi.output_type
class BatchReleaseCriteriaResponse(dict):
    """
    The batch release criteria.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSize":
            suggest = "batch_size"
        elif key == "messageCount":
            suggest = "message_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchReleaseCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchReleaseCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchReleaseCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size: Optional[int] = None,
                 message_count: Optional[int] = None,
                 recurrence: Optional['outputs.WorkflowTriggerRecurrenceResponse'] = None):
        """
        The batch release criteria.
        :param int batch_size: The batch size in bytes.
        :param int message_count: The message count.
        :param 'WorkflowTriggerRecurrenceResponse' recurrence: The recurrence.
        """
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if message_count is not None:
            pulumi.set(__self__, "message_count", message_count)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        """
        The batch size in bytes.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="messageCount")
    def message_count(self) -> Optional[int]:
        """
        The message count.
        """
        return pulumi.get(self, "message_count")

    @property
    @pulumi.getter
    def recurrence(self) -> Optional['outputs.WorkflowTriggerRecurrenceResponse']:
        """
        The recurrence.
        """
        return pulumi.get(self, "recurrence")


@pulumi.output_type
class BusinessIdentityResponse(dict):
    """
    The integration account partner's business identity.
    """
    def __init__(__self__, *,
                 qualifier: str,
                 value: str):
        """
        The integration account partner's business identity.
        :param str qualifier: The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
        :param str value: The user defined business identity value.
        """
        pulumi.set(__self__, "qualifier", qualifier)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def qualifier(self) -> str:
        """
        The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The user defined business identity value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContentHashResponse(dict):
    """
    The content hash.
    """
    def __init__(__self__, *,
                 algorithm: Optional[str] = None,
                 value: Optional[str] = None):
        """
        The content hash.
        :param str algorithm: The algorithm of the content hash.
        :param str value: The value of the content hash.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[str]:
        """
        The algorithm of the content hash.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the content hash.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContentLinkResponse(dict):
    """
    The content link.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentHash":
            suggest = "content_hash"
        elif key == "contentSize":
            suggest = "content_size"
        elif key == "contentVersion":
            suggest = "content_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_hash: Optional['outputs.ContentHashResponse'] = None,
                 content_size: Optional[float] = None,
                 content_version: Optional[str] = None,
                 metadata: Optional[Any] = None,
                 uri: Optional[str] = None):
        """
        The content link.
        :param 'ContentHashResponse' content_hash: The content hash.
        :param float content_size: The content size.
        :param str content_version: The content version.
        :param Any metadata: The metadata.
        :param str uri: The content link URI.
        """
        if content_hash is not None:
            pulumi.set(__self__, "content_hash", content_hash)
        if content_size is not None:
            pulumi.set(__self__, "content_size", content_size)
        if content_version is not None:
            pulumi.set(__self__, "content_version", content_version)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> Optional['outputs.ContentHashResponse']:
        """
        The content hash.
        """
        return pulumi.get(self, "content_hash")

    @property
    @pulumi.getter(name="contentSize")
    def content_size(self) -> Optional[float]:
        """
        The content size.
        """
        return pulumi.get(self, "content_size")

    @property
    @pulumi.getter(name="contentVersion")
    def content_version(self) -> Optional[str]:
        """
        The content version.
        """
        return pulumi.get(self, "content_version")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        """
        The metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The content link URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class EdifactAcknowledgementSettingsResponse(dict):
    """
    The Edifact agreement acknowledgement settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementControlNumberLowerBound":
            suggest = "acknowledgement_control_number_lower_bound"
        elif key == "acknowledgementControlNumberUpperBound":
            suggest = "acknowledgement_control_number_upper_bound"
        elif key == "batchFunctionalAcknowledgements":
            suggest = "batch_functional_acknowledgements"
        elif key == "batchTechnicalAcknowledgements":
            suggest = "batch_technical_acknowledgements"
        elif key == "needFunctionalAcknowledgement":
            suggest = "need_functional_acknowledgement"
        elif key == "needLoopForValidMessages":
            suggest = "need_loop_for_valid_messages"
        elif key == "needTechnicalAcknowledgement":
            suggest = "need_technical_acknowledgement"
        elif key == "rolloverAcknowledgementControlNumber":
            suggest = "rollover_acknowledgement_control_number"
        elif key == "sendSynchronousAcknowledgement":
            suggest = "send_synchronous_acknowledgement"
        elif key == "acknowledgementControlNumberPrefix":
            suggest = "acknowledgement_control_number_prefix"
        elif key == "acknowledgementControlNumberSuffix":
            suggest = "acknowledgement_control_number_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactAcknowledgementSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactAcknowledgementSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactAcknowledgementSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_control_number_lower_bound: int,
                 acknowledgement_control_number_upper_bound: int,
                 batch_functional_acknowledgements: bool,
                 batch_technical_acknowledgements: bool,
                 need_functional_acknowledgement: bool,
                 need_loop_for_valid_messages: bool,
                 need_technical_acknowledgement: bool,
                 rollover_acknowledgement_control_number: bool,
                 send_synchronous_acknowledgement: bool,
                 acknowledgement_control_number_prefix: Optional[str] = None,
                 acknowledgement_control_number_suffix: Optional[str] = None):
        """
        The Edifact agreement acknowledgement settings.
        :param int acknowledgement_control_number_lower_bound: The acknowledgement control number lower bound.
        :param int acknowledgement_control_number_upper_bound: The acknowledgement control number upper bound.
        :param bool batch_functional_acknowledgements: The value indicating whether to batch functional acknowledgements.
        :param bool batch_technical_acknowledgements: The value indicating whether to batch the technical acknowledgements.
        :param bool need_functional_acknowledgement: The value indicating whether functional acknowledgement is needed.
        :param bool need_loop_for_valid_messages: The value indicating whether a loop is needed for valid messages.
        :param bool need_technical_acknowledgement: The value indicating whether technical acknowledgement is needed.
        :param bool rollover_acknowledgement_control_number: The value indicating whether to rollover acknowledgement control number.
        :param bool send_synchronous_acknowledgement: The value indicating whether to send synchronous acknowledgement.
        :param str acknowledgement_control_number_prefix: The acknowledgement control number prefix.
        :param str acknowledgement_control_number_suffix: The acknowledgement control number suffix.
        """
        pulumi.set(__self__, "acknowledgement_control_number_lower_bound", acknowledgement_control_number_lower_bound)
        pulumi.set(__self__, "acknowledgement_control_number_upper_bound", acknowledgement_control_number_upper_bound)
        pulumi.set(__self__, "batch_functional_acknowledgements", batch_functional_acknowledgements)
        pulumi.set(__self__, "batch_technical_acknowledgements", batch_technical_acknowledgements)
        pulumi.set(__self__, "need_functional_acknowledgement", need_functional_acknowledgement)
        pulumi.set(__self__, "need_loop_for_valid_messages", need_loop_for_valid_messages)
        pulumi.set(__self__, "need_technical_acknowledgement", need_technical_acknowledgement)
        pulumi.set(__self__, "rollover_acknowledgement_control_number", rollover_acknowledgement_control_number)
        pulumi.set(__self__, "send_synchronous_acknowledgement", send_synchronous_acknowledgement)
        if acknowledgement_control_number_prefix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_prefix", acknowledgement_control_number_prefix)
        if acknowledgement_control_number_suffix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_suffix", acknowledgement_control_number_suffix)

    @property
    @pulumi.getter(name="acknowledgementControlNumberLowerBound")
    def acknowledgement_control_number_lower_bound(self) -> int:
        """
        The acknowledgement control number lower bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_lower_bound")

    @property
    @pulumi.getter(name="acknowledgementControlNumberUpperBound")
    def acknowledgement_control_number_upper_bound(self) -> int:
        """
        The acknowledgement control number upper bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_upper_bound")

    @property
    @pulumi.getter(name="batchFunctionalAcknowledgements")
    def batch_functional_acknowledgements(self) -> bool:
        """
        The value indicating whether to batch functional acknowledgements.
        """
        return pulumi.get(self, "batch_functional_acknowledgements")

    @property
    @pulumi.getter(name="batchTechnicalAcknowledgements")
    def batch_technical_acknowledgements(self) -> bool:
        """
        The value indicating whether to batch the technical acknowledgements.
        """
        return pulumi.get(self, "batch_technical_acknowledgements")

    @property
    @pulumi.getter(name="needFunctionalAcknowledgement")
    def need_functional_acknowledgement(self) -> bool:
        """
        The value indicating whether functional acknowledgement is needed.
        """
        return pulumi.get(self, "need_functional_acknowledgement")

    @property
    @pulumi.getter(name="needLoopForValidMessages")
    def need_loop_for_valid_messages(self) -> bool:
        """
        The value indicating whether a loop is needed for valid messages.
        """
        return pulumi.get(self, "need_loop_for_valid_messages")

    @property
    @pulumi.getter(name="needTechnicalAcknowledgement")
    def need_technical_acknowledgement(self) -> bool:
        """
        The value indicating whether technical acknowledgement is needed.
        """
        return pulumi.get(self, "need_technical_acknowledgement")

    @property
    @pulumi.getter(name="rolloverAcknowledgementControlNumber")
    def rollover_acknowledgement_control_number(self) -> bool:
        """
        The value indicating whether to rollover acknowledgement control number.
        """
        return pulumi.get(self, "rollover_acknowledgement_control_number")

    @property
    @pulumi.getter(name="sendSynchronousAcknowledgement")
    def send_synchronous_acknowledgement(self) -> bool:
        """
        The value indicating whether to send synchronous acknowledgement.
        """
        return pulumi.get(self, "send_synchronous_acknowledgement")

    @property
    @pulumi.getter(name="acknowledgementControlNumberPrefix")
    def acknowledgement_control_number_prefix(self) -> Optional[str]:
        """
        The acknowledgement control number prefix.
        """
        return pulumi.get(self, "acknowledgement_control_number_prefix")

    @property
    @pulumi.getter(name="acknowledgementControlNumberSuffix")
    def acknowledgement_control_number_suffix(self) -> Optional[str]:
        """
        The acknowledgement control number suffix.
        """
        return pulumi.get(self, "acknowledgement_control_number_suffix")


@pulumi.output_type
class EdifactAgreementContentResponse(dict):
    """
    The Edifact agreement content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "receiveAgreement":
            suggest = "receive_agreement"
        elif key == "sendAgreement":
            suggest = "send_agreement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactAgreementContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactAgreementContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactAgreementContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 receive_agreement: 'outputs.EdifactOneWayAgreementResponse',
                 send_agreement: 'outputs.EdifactOneWayAgreementResponse'):
        """
        The Edifact agreement content.
        :param 'EdifactOneWayAgreementResponse' receive_agreement: The EDIFACT one-way receive agreement.
        :param 'EdifactOneWayAgreementResponse' send_agreement: The EDIFACT one-way send agreement.
        """
        pulumi.set(__self__, "receive_agreement", receive_agreement)
        pulumi.set(__self__, "send_agreement", send_agreement)

    @property
    @pulumi.getter(name="receiveAgreement")
    def receive_agreement(self) -> 'outputs.EdifactOneWayAgreementResponse':
        """
        The EDIFACT one-way receive agreement.
        """
        return pulumi.get(self, "receive_agreement")

    @property
    @pulumi.getter(name="sendAgreement")
    def send_agreement(self) -> 'outputs.EdifactOneWayAgreementResponse':
        """
        The EDIFACT one-way send agreement.
        """
        return pulumi.get(self, "send_agreement")


@pulumi.output_type
class EdifactDelimiterOverrideResponse(dict):
    """
    The Edifact delimiter override settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentSeparator":
            suggest = "component_separator"
        elif key == "dataElementSeparator":
            suggest = "data_element_separator"
        elif key == "decimalPointIndicator":
            suggest = "decimal_point_indicator"
        elif key == "releaseIndicator":
            suggest = "release_indicator"
        elif key == "repetitionSeparator":
            suggest = "repetition_separator"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"
        elif key == "segmentTerminatorSuffix":
            suggest = "segment_terminator_suffix"
        elif key == "messageAssociationAssignedCode":
            suggest = "message_association_assigned_code"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "messageRelease":
            suggest = "message_release"
        elif key == "messageVersion":
            suggest = "message_version"
        elif key == "targetNamespace":
            suggest = "target_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactDelimiterOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactDelimiterOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactDelimiterOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_separator: int,
                 data_element_separator: int,
                 decimal_point_indicator: str,
                 release_indicator: int,
                 repetition_separator: int,
                 segment_terminator: int,
                 segment_terminator_suffix: str,
                 message_association_assigned_code: Optional[str] = None,
                 message_id: Optional[str] = None,
                 message_release: Optional[str] = None,
                 message_version: Optional[str] = None,
                 target_namespace: Optional[str] = None):
        """
        The Edifact delimiter override settings.
        :param int component_separator: The component separator.
        :param int data_element_separator: The data element separator.
        :param str decimal_point_indicator: The decimal point indicator.
        :param int release_indicator: The release indicator.
        :param int repetition_separator: The repetition separator.
        :param int segment_terminator: The segment terminator.
        :param str segment_terminator_suffix: The segment terminator suffix.
        :param str message_association_assigned_code: The message association assigned code.
        :param str message_id: The message id.
        :param str message_release: The message release.
        :param str message_version: The message version.
        :param str target_namespace: The target namespace on which this delimiter settings has to be applied.
        """
        pulumi.set(__self__, "component_separator", component_separator)
        pulumi.set(__self__, "data_element_separator", data_element_separator)
        pulumi.set(__self__, "decimal_point_indicator", decimal_point_indicator)
        pulumi.set(__self__, "release_indicator", release_indicator)
        pulumi.set(__self__, "repetition_separator", repetition_separator)
        pulumi.set(__self__, "segment_terminator", segment_terminator)
        pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)
        if message_association_assigned_code is not None:
            pulumi.set(__self__, "message_association_assigned_code", message_association_assigned_code)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if message_release is not None:
            pulumi.set(__self__, "message_release", message_release)
        if message_version is not None:
            pulumi.set(__self__, "message_version", message_version)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> int:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> int:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @property
    @pulumi.getter(name="decimalPointIndicator")
    def decimal_point_indicator(self) -> str:
        """
        The decimal point indicator.
        """
        return pulumi.get(self, "decimal_point_indicator")

    @property
    @pulumi.getter(name="releaseIndicator")
    def release_indicator(self) -> int:
        """
        The release indicator.
        """
        return pulumi.get(self, "release_indicator")

    @property
    @pulumi.getter(name="repetitionSeparator")
    def repetition_separator(self) -> int:
        """
        The repetition separator.
        """
        return pulumi.get(self, "repetition_separator")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> int:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> str:
        """
        The segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @property
    @pulumi.getter(name="messageAssociationAssignedCode")
    def message_association_assigned_code(self) -> Optional[str]:
        """
        The message association assigned code.
        """
        return pulumi.get(self, "message_association_assigned_code")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="messageRelease")
    def message_release(self) -> Optional[str]:
        """
        The message release.
        """
        return pulumi.get(self, "message_release")

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> Optional[str]:
        """
        The message version.
        """
        return pulumi.get(self, "message_version")

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[str]:
        """
        The target namespace on which this delimiter settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")


@pulumi.output_type
class EdifactEnvelopeOverrideResponse(dict):
    """
    The Edifact envelope override settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationPassword":
            suggest = "application_password"
        elif key == "associationAssignedCode":
            suggest = "association_assigned_code"
        elif key == "controllingAgencyCode":
            suggest = "controlling_agency_code"
        elif key == "functionalGroupId":
            suggest = "functional_group_id"
        elif key == "groupHeaderMessageRelease":
            suggest = "group_header_message_release"
        elif key == "groupHeaderMessageVersion":
            suggest = "group_header_message_version"
        elif key == "messageAssociationAssignedCode":
            suggest = "message_association_assigned_code"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "messageRelease":
            suggest = "message_release"
        elif key == "messageVersion":
            suggest = "message_version"
        elif key == "receiverApplicationId":
            suggest = "receiver_application_id"
        elif key == "receiverApplicationQualifier":
            suggest = "receiver_application_qualifier"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"
        elif key == "senderApplicationQualifier":
            suggest = "sender_application_qualifier"
        elif key == "targetNamespace":
            suggest = "target_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactEnvelopeOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactEnvelopeOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactEnvelopeOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_password: Optional[str] = None,
                 association_assigned_code: Optional[str] = None,
                 controlling_agency_code: Optional[str] = None,
                 functional_group_id: Optional[str] = None,
                 group_header_message_release: Optional[str] = None,
                 group_header_message_version: Optional[str] = None,
                 message_association_assigned_code: Optional[str] = None,
                 message_id: Optional[str] = None,
                 message_release: Optional[str] = None,
                 message_version: Optional[str] = None,
                 receiver_application_id: Optional[str] = None,
                 receiver_application_qualifier: Optional[str] = None,
                 sender_application_id: Optional[str] = None,
                 sender_application_qualifier: Optional[str] = None,
                 target_namespace: Optional[str] = None):
        """
        The Edifact envelope override settings.
        :param str application_password: The application password.
        :param str association_assigned_code: The association assigned code.
        :param str controlling_agency_code: The controlling agency code.
        :param str functional_group_id: The functional group id.
        :param str group_header_message_release: The group header message release.
        :param str group_header_message_version: The group header message version.
        :param str message_association_assigned_code: The message association assigned code.
        :param str message_id: The message id on which this envelope settings has to be applied.
        :param str message_release: The message release version on which this envelope settings has to be applied.
        :param str message_version: The message version on which this envelope settings has to be applied.
        :param str receiver_application_id: The receiver application id.
        :param str receiver_application_qualifier: The receiver application qualifier.
        :param str sender_application_id: The sender application id.
        :param str sender_application_qualifier: The sender application qualifier.
        :param str target_namespace: The target namespace on which this envelope settings has to be applied.
        """
        if application_password is not None:
            pulumi.set(__self__, "application_password", application_password)
        if association_assigned_code is not None:
            pulumi.set(__self__, "association_assigned_code", association_assigned_code)
        if controlling_agency_code is not None:
            pulumi.set(__self__, "controlling_agency_code", controlling_agency_code)
        if functional_group_id is not None:
            pulumi.set(__self__, "functional_group_id", functional_group_id)
        if group_header_message_release is not None:
            pulumi.set(__self__, "group_header_message_release", group_header_message_release)
        if group_header_message_version is not None:
            pulumi.set(__self__, "group_header_message_version", group_header_message_version)
        if message_association_assigned_code is not None:
            pulumi.set(__self__, "message_association_assigned_code", message_association_assigned_code)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if message_release is not None:
            pulumi.set(__self__, "message_release", message_release)
        if message_version is not None:
            pulumi.set(__self__, "message_version", message_version)
        if receiver_application_id is not None:
            pulumi.set(__self__, "receiver_application_id", receiver_application_id)
        if receiver_application_qualifier is not None:
            pulumi.set(__self__, "receiver_application_qualifier", receiver_application_qualifier)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)
        if sender_application_qualifier is not None:
            pulumi.set(__self__, "sender_application_qualifier", sender_application_qualifier)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="applicationPassword")
    def application_password(self) -> Optional[str]:
        """
        The application password.
        """
        return pulumi.get(self, "application_password")

    @property
    @pulumi.getter(name="associationAssignedCode")
    def association_assigned_code(self) -> Optional[str]:
        """
        The association assigned code.
        """
        return pulumi.get(self, "association_assigned_code")

    @property
    @pulumi.getter(name="controllingAgencyCode")
    def controlling_agency_code(self) -> Optional[str]:
        """
        The controlling agency code.
        """
        return pulumi.get(self, "controlling_agency_code")

    @property
    @pulumi.getter(name="functionalGroupId")
    def functional_group_id(self) -> Optional[str]:
        """
        The functional group id.
        """
        return pulumi.get(self, "functional_group_id")

    @property
    @pulumi.getter(name="groupHeaderMessageRelease")
    def group_header_message_release(self) -> Optional[str]:
        """
        The group header message release.
        """
        return pulumi.get(self, "group_header_message_release")

    @property
    @pulumi.getter(name="groupHeaderMessageVersion")
    def group_header_message_version(self) -> Optional[str]:
        """
        The group header message version.
        """
        return pulumi.get(self, "group_header_message_version")

    @property
    @pulumi.getter(name="messageAssociationAssignedCode")
    def message_association_assigned_code(self) -> Optional[str]:
        """
        The message association assigned code.
        """
        return pulumi.get(self, "message_association_assigned_code")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="messageRelease")
    def message_release(self) -> Optional[str]:
        """
        The message release version on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_release")

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> Optional[str]:
        """
        The message version on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_version")

    @property
    @pulumi.getter(name="receiverApplicationId")
    def receiver_application_id(self) -> Optional[str]:
        """
        The receiver application id.
        """
        return pulumi.get(self, "receiver_application_id")

    @property
    @pulumi.getter(name="receiverApplicationQualifier")
    def receiver_application_qualifier(self) -> Optional[str]:
        """
        The receiver application qualifier.
        """
        return pulumi.get(self, "receiver_application_qualifier")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @property
    @pulumi.getter(name="senderApplicationQualifier")
    def sender_application_qualifier(self) -> Optional[str]:
        """
        The sender application qualifier.
        """
        return pulumi.get(self, "sender_application_qualifier")

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[str]:
        """
        The target namespace on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")


@pulumi.output_type
class EdifactEnvelopeSettingsResponse(dict):
    """
    The Edifact agreement envelope settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyDelimiterStringAdvice":
            suggest = "apply_delimiter_string_advice"
        elif key == "createGroupingSegments":
            suggest = "create_grouping_segments"
        elif key == "enableDefaultGroupHeaders":
            suggest = "enable_default_group_headers"
        elif key == "groupControlNumberLowerBound":
            suggest = "group_control_number_lower_bound"
        elif key == "groupControlNumberUpperBound":
            suggest = "group_control_number_upper_bound"
        elif key == "interchangeControlNumberLowerBound":
            suggest = "interchange_control_number_lower_bound"
        elif key == "interchangeControlNumberUpperBound":
            suggest = "interchange_control_number_upper_bound"
        elif key == "isTestInterchange":
            suggest = "is_test_interchange"
        elif key == "overwriteExistingTransactionSetControlNumber":
            suggest = "overwrite_existing_transaction_set_control_number"
        elif key == "rolloverGroupControlNumber":
            suggest = "rollover_group_control_number"
        elif key == "rolloverInterchangeControlNumber":
            suggest = "rollover_interchange_control_number"
        elif key == "rolloverTransactionSetControlNumber":
            suggest = "rollover_transaction_set_control_number"
        elif key == "transactionSetControlNumberLowerBound":
            suggest = "transaction_set_control_number_lower_bound"
        elif key == "transactionSetControlNumberUpperBound":
            suggest = "transaction_set_control_number_upper_bound"
        elif key == "applicationReferenceId":
            suggest = "application_reference_id"
        elif key == "communicationAgreementId":
            suggest = "communication_agreement_id"
        elif key == "functionalGroupId":
            suggest = "functional_group_id"
        elif key == "groupApplicationPassword":
            suggest = "group_application_password"
        elif key == "groupApplicationReceiverId":
            suggest = "group_application_receiver_id"
        elif key == "groupApplicationReceiverQualifier":
            suggest = "group_application_receiver_qualifier"
        elif key == "groupApplicationSenderId":
            suggest = "group_application_sender_id"
        elif key == "groupApplicationSenderQualifier":
            suggest = "group_application_sender_qualifier"
        elif key == "groupAssociationAssignedCode":
            suggest = "group_association_assigned_code"
        elif key == "groupControlNumberPrefix":
            suggest = "group_control_number_prefix"
        elif key == "groupControlNumberSuffix":
            suggest = "group_control_number_suffix"
        elif key == "groupControllingAgencyCode":
            suggest = "group_controlling_agency_code"
        elif key == "groupMessageRelease":
            suggest = "group_message_release"
        elif key == "groupMessageVersion":
            suggest = "group_message_version"
        elif key == "interchangeControlNumberPrefix":
            suggest = "interchange_control_number_prefix"
        elif key == "interchangeControlNumberSuffix":
            suggest = "interchange_control_number_suffix"
        elif key == "processingPriorityCode":
            suggest = "processing_priority_code"
        elif key == "receiverInternalIdentification":
            suggest = "receiver_internal_identification"
        elif key == "receiverInternalSubIdentification":
            suggest = "receiver_internal_sub_identification"
        elif key == "receiverReverseRoutingAddress":
            suggest = "receiver_reverse_routing_address"
        elif key == "recipientReferencePasswordQualifier":
            suggest = "recipient_reference_password_qualifier"
        elif key == "recipientReferencePasswordValue":
            suggest = "recipient_reference_password_value"
        elif key == "senderInternalIdentification":
            suggest = "sender_internal_identification"
        elif key == "senderInternalSubIdentification":
            suggest = "sender_internal_sub_identification"
        elif key == "senderReverseRoutingAddress":
            suggest = "sender_reverse_routing_address"
        elif key == "transactionSetControlNumberPrefix":
            suggest = "transaction_set_control_number_prefix"
        elif key == "transactionSetControlNumberSuffix":
            suggest = "transaction_set_control_number_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactEnvelopeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactEnvelopeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactEnvelopeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_delimiter_string_advice: bool,
                 create_grouping_segments: bool,
                 enable_default_group_headers: bool,
                 group_control_number_lower_bound: float,
                 group_control_number_upper_bound: float,
                 interchange_control_number_lower_bound: float,
                 interchange_control_number_upper_bound: float,
                 is_test_interchange: bool,
                 overwrite_existing_transaction_set_control_number: bool,
                 rollover_group_control_number: bool,
                 rollover_interchange_control_number: bool,
                 rollover_transaction_set_control_number: bool,
                 transaction_set_control_number_lower_bound: float,
                 transaction_set_control_number_upper_bound: float,
                 application_reference_id: Optional[str] = None,
                 communication_agreement_id: Optional[str] = None,
                 functional_group_id: Optional[str] = None,
                 group_application_password: Optional[str] = None,
                 group_application_receiver_id: Optional[str] = None,
                 group_application_receiver_qualifier: Optional[str] = None,
                 group_application_sender_id: Optional[str] = None,
                 group_application_sender_qualifier: Optional[str] = None,
                 group_association_assigned_code: Optional[str] = None,
                 group_control_number_prefix: Optional[str] = None,
                 group_control_number_suffix: Optional[str] = None,
                 group_controlling_agency_code: Optional[str] = None,
                 group_message_release: Optional[str] = None,
                 group_message_version: Optional[str] = None,
                 interchange_control_number_prefix: Optional[str] = None,
                 interchange_control_number_suffix: Optional[str] = None,
                 processing_priority_code: Optional[str] = None,
                 receiver_internal_identification: Optional[str] = None,
                 receiver_internal_sub_identification: Optional[str] = None,
                 receiver_reverse_routing_address: Optional[str] = None,
                 recipient_reference_password_qualifier: Optional[str] = None,
                 recipient_reference_password_value: Optional[str] = None,
                 sender_internal_identification: Optional[str] = None,
                 sender_internal_sub_identification: Optional[str] = None,
                 sender_reverse_routing_address: Optional[str] = None,
                 transaction_set_control_number_prefix: Optional[str] = None,
                 transaction_set_control_number_suffix: Optional[str] = None):
        """
        The Edifact agreement envelope settings.
        :param bool apply_delimiter_string_advice: The value indicating whether to apply delimiter string advice.
        :param bool create_grouping_segments: The value indicating whether to create grouping segments.
        :param bool enable_default_group_headers: The value indicating whether to enable default group headers.
        :param float group_control_number_lower_bound: The group control number lower bound.
        :param float group_control_number_upper_bound: The group control number upper bound.
        :param float interchange_control_number_lower_bound: The interchange control number lower bound.
        :param float interchange_control_number_upper_bound: The interchange control number upper bound.
        :param bool is_test_interchange: The value indicating whether the message is a test interchange.
        :param bool overwrite_existing_transaction_set_control_number: The value indicating whether to overwrite existing transaction set control number.
        :param bool rollover_group_control_number: The value indicating whether to rollover group control number.
        :param bool rollover_interchange_control_number: The value indicating whether to rollover interchange control number.
        :param bool rollover_transaction_set_control_number: The value indicating whether to rollover transaction set control number.
        :param float transaction_set_control_number_lower_bound: The transaction set control number lower bound.
        :param float transaction_set_control_number_upper_bound: The transaction set control number upper bound.
        :param str application_reference_id: The application reference id.
        :param str communication_agreement_id: The communication agreement id.
        :param str functional_group_id: The functional group id.
        :param str group_application_password: The group application password.
        :param str group_application_receiver_id: The group application receiver id.
        :param str group_application_receiver_qualifier: The group application receiver qualifier.
        :param str group_application_sender_id: The group application sender id.
        :param str group_application_sender_qualifier: The group application sender qualifier.
        :param str group_association_assigned_code: The group association assigned code.
        :param str group_control_number_prefix: The group control number prefix.
        :param str group_control_number_suffix: The group control number suffix.
        :param str group_controlling_agency_code: The group controlling agency code.
        :param str group_message_release: The group message release.
        :param str group_message_version: The group message version.
        :param str interchange_control_number_prefix: The interchange control number prefix.
        :param str interchange_control_number_suffix: The interchange control number suffix.
        :param str processing_priority_code: The processing priority code.
        :param str receiver_internal_identification: The receiver internal identification.
        :param str receiver_internal_sub_identification: The receiver internal sub identification.
        :param str receiver_reverse_routing_address: The receiver reverse routing address.
        :param str recipient_reference_password_qualifier: The recipient reference password qualifier.
        :param str recipient_reference_password_value: The recipient reference password value.
        :param str sender_internal_identification: The sender internal identification.
        :param str sender_internal_sub_identification: The sender internal sub identification.
        :param str sender_reverse_routing_address: The sender reverse routing address.
        :param str transaction_set_control_number_prefix: The transaction set control number prefix.
        :param str transaction_set_control_number_suffix: The transaction set control number suffix.
        """
        pulumi.set(__self__, "apply_delimiter_string_advice", apply_delimiter_string_advice)
        pulumi.set(__self__, "create_grouping_segments", create_grouping_segments)
        pulumi.set(__self__, "enable_default_group_headers", enable_default_group_headers)
        pulumi.set(__self__, "group_control_number_lower_bound", group_control_number_lower_bound)
        pulumi.set(__self__, "group_control_number_upper_bound", group_control_number_upper_bound)
        pulumi.set(__self__, "interchange_control_number_lower_bound", interchange_control_number_lower_bound)
        pulumi.set(__self__, "interchange_control_number_upper_bound", interchange_control_number_upper_bound)
        pulumi.set(__self__, "is_test_interchange", is_test_interchange)
        pulumi.set(__self__, "overwrite_existing_transaction_set_control_number", overwrite_existing_transaction_set_control_number)
        pulumi.set(__self__, "rollover_group_control_number", rollover_group_control_number)
        pulumi.set(__self__, "rollover_interchange_control_number", rollover_interchange_control_number)
        pulumi.set(__self__, "rollover_transaction_set_control_number", rollover_transaction_set_control_number)
        pulumi.set(__self__, "transaction_set_control_number_lower_bound", transaction_set_control_number_lower_bound)
        pulumi.set(__self__, "transaction_set_control_number_upper_bound", transaction_set_control_number_upper_bound)
        if application_reference_id is not None:
            pulumi.set(__self__, "application_reference_id", application_reference_id)
        if communication_agreement_id is not None:
            pulumi.set(__self__, "communication_agreement_id", communication_agreement_id)
        if functional_group_id is not None:
            pulumi.set(__self__, "functional_group_id", functional_group_id)
        if group_application_password is not None:
            pulumi.set(__self__, "group_application_password", group_application_password)
        if group_application_receiver_id is not None:
            pulumi.set(__self__, "group_application_receiver_id", group_application_receiver_id)
        if group_application_receiver_qualifier is not None:
            pulumi.set(__self__, "group_application_receiver_qualifier", group_application_receiver_qualifier)
        if group_application_sender_id is not None:
            pulumi.set(__self__, "group_application_sender_id", group_application_sender_id)
        if group_application_sender_qualifier is not None:
            pulumi.set(__self__, "group_application_sender_qualifier", group_application_sender_qualifier)
        if group_association_assigned_code is not None:
            pulumi.set(__self__, "group_association_assigned_code", group_association_assigned_code)
        if group_control_number_prefix is not None:
            pulumi.set(__self__, "group_control_number_prefix", group_control_number_prefix)
        if group_control_number_suffix is not None:
            pulumi.set(__self__, "group_control_number_suffix", group_control_number_suffix)
        if group_controlling_agency_code is not None:
            pulumi.set(__self__, "group_controlling_agency_code", group_controlling_agency_code)
        if group_message_release is not None:
            pulumi.set(__self__, "group_message_release", group_message_release)
        if group_message_version is not None:
            pulumi.set(__self__, "group_message_version", group_message_version)
        if interchange_control_number_prefix is not None:
            pulumi.set(__self__, "interchange_control_number_prefix", interchange_control_number_prefix)
        if interchange_control_number_suffix is not None:
            pulumi.set(__self__, "interchange_control_number_suffix", interchange_control_number_suffix)
        if processing_priority_code is not None:
            pulumi.set(__self__, "processing_priority_code", processing_priority_code)
        if receiver_internal_identification is not None:
            pulumi.set(__self__, "receiver_internal_identification", receiver_internal_identification)
        if receiver_internal_sub_identification is not None:
            pulumi.set(__self__, "receiver_internal_sub_identification", receiver_internal_sub_identification)
        if receiver_reverse_routing_address is not None:
            pulumi.set(__self__, "receiver_reverse_routing_address", receiver_reverse_routing_address)
        if recipient_reference_password_qualifier is not None:
            pulumi.set(__self__, "recipient_reference_password_qualifier", recipient_reference_password_qualifier)
        if recipient_reference_password_value is not None:
            pulumi.set(__self__, "recipient_reference_password_value", recipient_reference_password_value)
        if sender_internal_identification is not None:
            pulumi.set(__self__, "sender_internal_identification", sender_internal_identification)
        if sender_internal_sub_identification is not None:
            pulumi.set(__self__, "sender_internal_sub_identification", sender_internal_sub_identification)
        if sender_reverse_routing_address is not None:
            pulumi.set(__self__, "sender_reverse_routing_address", sender_reverse_routing_address)
        if transaction_set_control_number_prefix is not None:
            pulumi.set(__self__, "transaction_set_control_number_prefix", transaction_set_control_number_prefix)
        if transaction_set_control_number_suffix is not None:
            pulumi.set(__self__, "transaction_set_control_number_suffix", transaction_set_control_number_suffix)

    @property
    @pulumi.getter(name="applyDelimiterStringAdvice")
    def apply_delimiter_string_advice(self) -> bool:
        """
        The value indicating whether to apply delimiter string advice.
        """
        return pulumi.get(self, "apply_delimiter_string_advice")

    @property
    @pulumi.getter(name="createGroupingSegments")
    def create_grouping_segments(self) -> bool:
        """
        The value indicating whether to create grouping segments.
        """
        return pulumi.get(self, "create_grouping_segments")

    @property
    @pulumi.getter(name="enableDefaultGroupHeaders")
    def enable_default_group_headers(self) -> bool:
        """
        The value indicating whether to enable default group headers.
        """
        return pulumi.get(self, "enable_default_group_headers")

    @property
    @pulumi.getter(name="groupControlNumberLowerBound")
    def group_control_number_lower_bound(self) -> float:
        """
        The group control number lower bound.
        """
        return pulumi.get(self, "group_control_number_lower_bound")

    @property
    @pulumi.getter(name="groupControlNumberUpperBound")
    def group_control_number_upper_bound(self) -> float:
        """
        The group control number upper bound.
        """
        return pulumi.get(self, "group_control_number_upper_bound")

    @property
    @pulumi.getter(name="interchangeControlNumberLowerBound")
    def interchange_control_number_lower_bound(self) -> float:
        """
        The interchange control number lower bound.
        """
        return pulumi.get(self, "interchange_control_number_lower_bound")

    @property
    @pulumi.getter(name="interchangeControlNumberUpperBound")
    def interchange_control_number_upper_bound(self) -> float:
        """
        The interchange control number upper bound.
        """
        return pulumi.get(self, "interchange_control_number_upper_bound")

    @property
    @pulumi.getter(name="isTestInterchange")
    def is_test_interchange(self) -> bool:
        """
        The value indicating whether the message is a test interchange.
        """
        return pulumi.get(self, "is_test_interchange")

    @property
    @pulumi.getter(name="overwriteExistingTransactionSetControlNumber")
    def overwrite_existing_transaction_set_control_number(self) -> bool:
        """
        The value indicating whether to overwrite existing transaction set control number.
        """
        return pulumi.get(self, "overwrite_existing_transaction_set_control_number")

    @property
    @pulumi.getter(name="rolloverGroupControlNumber")
    def rollover_group_control_number(self) -> bool:
        """
        The value indicating whether to rollover group control number.
        """
        return pulumi.get(self, "rollover_group_control_number")

    @property
    @pulumi.getter(name="rolloverInterchangeControlNumber")
    def rollover_interchange_control_number(self) -> bool:
        """
        The value indicating whether to rollover interchange control number.
        """
        return pulumi.get(self, "rollover_interchange_control_number")

    @property
    @pulumi.getter(name="rolloverTransactionSetControlNumber")
    def rollover_transaction_set_control_number(self) -> bool:
        """
        The value indicating whether to rollover transaction set control number.
        """
        return pulumi.get(self, "rollover_transaction_set_control_number")

    @property
    @pulumi.getter(name="transactionSetControlNumberLowerBound")
    def transaction_set_control_number_lower_bound(self) -> float:
        """
        The transaction set control number lower bound.
        """
        return pulumi.get(self, "transaction_set_control_number_lower_bound")

    @property
    @pulumi.getter(name="transactionSetControlNumberUpperBound")
    def transaction_set_control_number_upper_bound(self) -> float:
        """
        The transaction set control number upper bound.
        """
        return pulumi.get(self, "transaction_set_control_number_upper_bound")

    @property
    @pulumi.getter(name="applicationReferenceId")
    def application_reference_id(self) -> Optional[str]:
        """
        The application reference id.
        """
        return pulumi.get(self, "application_reference_id")

    @property
    @pulumi.getter(name="communicationAgreementId")
    def communication_agreement_id(self) -> Optional[str]:
        """
        The communication agreement id.
        """
        return pulumi.get(self, "communication_agreement_id")

    @property
    @pulumi.getter(name="functionalGroupId")
    def functional_group_id(self) -> Optional[str]:
        """
        The functional group id.
        """
        return pulumi.get(self, "functional_group_id")

    @property
    @pulumi.getter(name="groupApplicationPassword")
    def group_application_password(self) -> Optional[str]:
        """
        The group application password.
        """
        return pulumi.get(self, "group_application_password")

    @property
    @pulumi.getter(name="groupApplicationReceiverId")
    def group_application_receiver_id(self) -> Optional[str]:
        """
        The group application receiver id.
        """
        return pulumi.get(self, "group_application_receiver_id")

    @property
    @pulumi.getter(name="groupApplicationReceiverQualifier")
    def group_application_receiver_qualifier(self) -> Optional[str]:
        """
        The group application receiver qualifier.
        """
        return pulumi.get(self, "group_application_receiver_qualifier")

    @property
    @pulumi.getter(name="groupApplicationSenderId")
    def group_application_sender_id(self) -> Optional[str]:
        """
        The group application sender id.
        """
        return pulumi.get(self, "group_application_sender_id")

    @property
    @pulumi.getter(name="groupApplicationSenderQualifier")
    def group_application_sender_qualifier(self) -> Optional[str]:
        """
        The group application sender qualifier.
        """
        return pulumi.get(self, "group_application_sender_qualifier")

    @property
    @pulumi.getter(name="groupAssociationAssignedCode")
    def group_association_assigned_code(self) -> Optional[str]:
        """
        The group association assigned code.
        """
        return pulumi.get(self, "group_association_assigned_code")

    @property
    @pulumi.getter(name="groupControlNumberPrefix")
    def group_control_number_prefix(self) -> Optional[str]:
        """
        The group control number prefix.
        """
        return pulumi.get(self, "group_control_number_prefix")

    @property
    @pulumi.getter(name="groupControlNumberSuffix")
    def group_control_number_suffix(self) -> Optional[str]:
        """
        The group control number suffix.
        """
        return pulumi.get(self, "group_control_number_suffix")

    @property
    @pulumi.getter(name="groupControllingAgencyCode")
    def group_controlling_agency_code(self) -> Optional[str]:
        """
        The group controlling agency code.
        """
        return pulumi.get(self, "group_controlling_agency_code")

    @property
    @pulumi.getter(name="groupMessageRelease")
    def group_message_release(self) -> Optional[str]:
        """
        The group message release.
        """
        return pulumi.get(self, "group_message_release")

    @property
    @pulumi.getter(name="groupMessageVersion")
    def group_message_version(self) -> Optional[str]:
        """
        The group message version.
        """
        return pulumi.get(self, "group_message_version")

    @property
    @pulumi.getter(name="interchangeControlNumberPrefix")
    def interchange_control_number_prefix(self) -> Optional[str]:
        """
        The interchange control number prefix.
        """
        return pulumi.get(self, "interchange_control_number_prefix")

    @property
    @pulumi.getter(name="interchangeControlNumberSuffix")
    def interchange_control_number_suffix(self) -> Optional[str]:
        """
        The interchange control number suffix.
        """
        return pulumi.get(self, "interchange_control_number_suffix")

    @property
    @pulumi.getter(name="processingPriorityCode")
    def processing_priority_code(self) -> Optional[str]:
        """
        The processing priority code.
        """
        return pulumi.get(self, "processing_priority_code")

    @property
    @pulumi.getter(name="receiverInternalIdentification")
    def receiver_internal_identification(self) -> Optional[str]:
        """
        The receiver internal identification.
        """
        return pulumi.get(self, "receiver_internal_identification")

    @property
    @pulumi.getter(name="receiverInternalSubIdentification")
    def receiver_internal_sub_identification(self) -> Optional[str]:
        """
        The receiver internal sub identification.
        """
        return pulumi.get(self, "receiver_internal_sub_identification")

    @property
    @pulumi.getter(name="receiverReverseRoutingAddress")
    def receiver_reverse_routing_address(self) -> Optional[str]:
        """
        The receiver reverse routing address.
        """
        return pulumi.get(self, "receiver_reverse_routing_address")

    @property
    @pulumi.getter(name="recipientReferencePasswordQualifier")
    def recipient_reference_password_qualifier(self) -> Optional[str]:
        """
        The recipient reference password qualifier.
        """
        return pulumi.get(self, "recipient_reference_password_qualifier")

    @property
    @pulumi.getter(name="recipientReferencePasswordValue")
    def recipient_reference_password_value(self) -> Optional[str]:
        """
        The recipient reference password value.
        """
        return pulumi.get(self, "recipient_reference_password_value")

    @property
    @pulumi.getter(name="senderInternalIdentification")
    def sender_internal_identification(self) -> Optional[str]:
        """
        The sender internal identification.
        """
        return pulumi.get(self, "sender_internal_identification")

    @property
    @pulumi.getter(name="senderInternalSubIdentification")
    def sender_internal_sub_identification(self) -> Optional[str]:
        """
        The sender internal sub identification.
        """
        return pulumi.get(self, "sender_internal_sub_identification")

    @property
    @pulumi.getter(name="senderReverseRoutingAddress")
    def sender_reverse_routing_address(self) -> Optional[str]:
        """
        The sender reverse routing address.
        """
        return pulumi.get(self, "sender_reverse_routing_address")

    @property
    @pulumi.getter(name="transactionSetControlNumberPrefix")
    def transaction_set_control_number_prefix(self) -> Optional[str]:
        """
        The transaction set control number prefix.
        """
        return pulumi.get(self, "transaction_set_control_number_prefix")

    @property
    @pulumi.getter(name="transactionSetControlNumberSuffix")
    def transaction_set_control_number_suffix(self) -> Optional[str]:
        """
        The transaction set control number suffix.
        """
        return pulumi.get(self, "transaction_set_control_number_suffix")


@pulumi.output_type
class EdifactFramingSettingsResponse(dict):
    """
    The Edifact agreement framing settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "characterSet":
            suggest = "character_set"
        elif key == "componentSeparator":
            suggest = "component_separator"
        elif key == "dataElementSeparator":
            suggest = "data_element_separator"
        elif key == "decimalPointIndicator":
            suggest = "decimal_point_indicator"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "releaseIndicator":
            suggest = "release_indicator"
        elif key == "repetitionSeparator":
            suggest = "repetition_separator"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"
        elif key == "segmentTerminatorSuffix":
            suggest = "segment_terminator_suffix"
        elif key == "characterEncoding":
            suggest = "character_encoding"
        elif key == "serviceCodeListDirectoryVersion":
            suggest = "service_code_list_directory_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactFramingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactFramingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactFramingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 character_set: str,
                 component_separator: int,
                 data_element_separator: int,
                 decimal_point_indicator: str,
                 protocol_version: int,
                 release_indicator: int,
                 repetition_separator: int,
                 segment_terminator: int,
                 segment_terminator_suffix: str,
                 character_encoding: Optional[str] = None,
                 service_code_list_directory_version: Optional[str] = None):
        """
        The Edifact agreement framing settings.
        :param str character_set: The EDIFACT frame setting characterSet.
        :param int component_separator: The component separator.
        :param int data_element_separator: The data element separator.
        :param str decimal_point_indicator: The EDIFACT frame setting decimal indicator.
        :param int protocol_version: The protocol version.
        :param int release_indicator: The release indicator.
        :param int repetition_separator: The repetition separator.
        :param int segment_terminator: The segment terminator.
        :param str segment_terminator_suffix: The EDIFACT frame setting segment terminator suffix.
        :param str character_encoding: The character encoding.
        :param str service_code_list_directory_version: The service code list directory version.
        """
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "component_separator", component_separator)
        pulumi.set(__self__, "data_element_separator", data_element_separator)
        pulumi.set(__self__, "decimal_point_indicator", decimal_point_indicator)
        pulumi.set(__self__, "protocol_version", protocol_version)
        pulumi.set(__self__, "release_indicator", release_indicator)
        pulumi.set(__self__, "repetition_separator", repetition_separator)
        pulumi.set(__self__, "segment_terminator", segment_terminator)
        pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)
        if character_encoding is not None:
            pulumi.set(__self__, "character_encoding", character_encoding)
        if service_code_list_directory_version is not None:
            pulumi.set(__self__, "service_code_list_directory_version", service_code_list_directory_version)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> str:
        """
        The EDIFACT frame setting characterSet.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> int:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> int:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @property
    @pulumi.getter(name="decimalPointIndicator")
    def decimal_point_indicator(self) -> str:
        """
        The EDIFACT frame setting decimal indicator.
        """
        return pulumi.get(self, "decimal_point_indicator")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> int:
        """
        The protocol version.
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="releaseIndicator")
    def release_indicator(self) -> int:
        """
        The release indicator.
        """
        return pulumi.get(self, "release_indicator")

    @property
    @pulumi.getter(name="repetitionSeparator")
    def repetition_separator(self) -> int:
        """
        The repetition separator.
        """
        return pulumi.get(self, "repetition_separator")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> int:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> str:
        """
        The EDIFACT frame setting segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @property
    @pulumi.getter(name="characterEncoding")
    def character_encoding(self) -> Optional[str]:
        """
        The character encoding.
        """
        return pulumi.get(self, "character_encoding")

    @property
    @pulumi.getter(name="serviceCodeListDirectoryVersion")
    def service_code_list_directory_version(self) -> Optional[str]:
        """
        The service code list directory version.
        """
        return pulumi.get(self, "service_code_list_directory_version")


@pulumi.output_type
class EdifactMessageFilterResponse(dict):
    """
    The Edifact message filter for odata query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageFilterType":
            suggest = "message_filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactMessageFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactMessageFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactMessageFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_filter_type: str):
        """
        The Edifact message filter for odata query.
        :param str message_filter_type: The message filter type.
        """
        pulumi.set(__self__, "message_filter_type", message_filter_type)

    @property
    @pulumi.getter(name="messageFilterType")
    def message_filter_type(self) -> str:
        """
        The message filter type.
        """
        return pulumi.get(self, "message_filter_type")


@pulumi.output_type
class EdifactMessageIdentifierResponse(dict):
    """
    The Edifact message identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageId":
            suggest = "message_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactMessageIdentifierResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactMessageIdentifierResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactMessageIdentifierResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_id: str):
        """
        The Edifact message identifier.
        :param str message_id: The message id on which this envelope settings has to be applied.
        """
        pulumi.set(__self__, "message_id", message_id)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> str:
        """
        The message id on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_id")


@pulumi.output_type
class EdifactOneWayAgreementResponse(dict):
    """
    The Edifact one way agreement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolSettings":
            suggest = "protocol_settings"
        elif key == "receiverBusinessIdentity":
            suggest = "receiver_business_identity"
        elif key == "senderBusinessIdentity":
            suggest = "sender_business_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactOneWayAgreementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactOneWayAgreementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactOneWayAgreementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol_settings: 'outputs.EdifactProtocolSettingsResponse',
                 receiver_business_identity: 'outputs.BusinessIdentityResponse',
                 sender_business_identity: 'outputs.BusinessIdentityResponse'):
        """
        The Edifact one way agreement.
        :param 'EdifactProtocolSettingsResponse' protocol_settings: The EDIFACT protocol settings.
        :param 'BusinessIdentityResponse' receiver_business_identity: The receiver business identity
        :param 'BusinessIdentityResponse' sender_business_identity: The sender business identity
        """
        pulumi.set(__self__, "protocol_settings", protocol_settings)
        pulumi.set(__self__, "receiver_business_identity", receiver_business_identity)
        pulumi.set(__self__, "sender_business_identity", sender_business_identity)

    @property
    @pulumi.getter(name="protocolSettings")
    def protocol_settings(self) -> 'outputs.EdifactProtocolSettingsResponse':
        """
        The EDIFACT protocol settings.
        """
        return pulumi.get(self, "protocol_settings")

    @property
    @pulumi.getter(name="receiverBusinessIdentity")
    def receiver_business_identity(self) -> 'outputs.BusinessIdentityResponse':
        """
        The receiver business identity
        """
        return pulumi.get(self, "receiver_business_identity")

    @property
    @pulumi.getter(name="senderBusinessIdentity")
    def sender_business_identity(self) -> 'outputs.BusinessIdentityResponse':
        """
        The sender business identity
        """
        return pulumi.get(self, "sender_business_identity")


@pulumi.output_type
class EdifactProcessingSettingsResponse(dict):
    """
    The Edifact agreement protocol settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createEmptyXmlTagsForTrailingSeparators":
            suggest = "create_empty_xml_tags_for_trailing_separators"
        elif key == "maskSecurityInfo":
            suggest = "mask_security_info"
        elif key == "preserveInterchange":
            suggest = "preserve_interchange"
        elif key == "suspendInterchangeOnError":
            suggest = "suspend_interchange_on_error"
        elif key == "useDotAsDecimalSeparator":
            suggest = "use_dot_as_decimal_separator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactProcessingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactProcessingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactProcessingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_empty_xml_tags_for_trailing_separators: bool,
                 mask_security_info: bool,
                 preserve_interchange: bool,
                 suspend_interchange_on_error: bool,
                 use_dot_as_decimal_separator: bool):
        """
        The Edifact agreement protocol settings.
        :param bool create_empty_xml_tags_for_trailing_separators: The value indicating whether to create empty xml tags for trailing separators.
        :param bool mask_security_info: The value indicating whether to mask security information.
        :param bool preserve_interchange: The value indicating whether to preserve interchange.
        :param bool suspend_interchange_on_error: The value indicating whether to suspend interchange on error.
        :param bool use_dot_as_decimal_separator: The value indicating whether to use dot as decimal separator.
        """
        pulumi.set(__self__, "create_empty_xml_tags_for_trailing_separators", create_empty_xml_tags_for_trailing_separators)
        pulumi.set(__self__, "mask_security_info", mask_security_info)
        pulumi.set(__self__, "preserve_interchange", preserve_interchange)
        pulumi.set(__self__, "suspend_interchange_on_error", suspend_interchange_on_error)
        pulumi.set(__self__, "use_dot_as_decimal_separator", use_dot_as_decimal_separator)

    @property
    @pulumi.getter(name="createEmptyXmlTagsForTrailingSeparators")
    def create_empty_xml_tags_for_trailing_separators(self) -> bool:
        """
        The value indicating whether to create empty xml tags for trailing separators.
        """
        return pulumi.get(self, "create_empty_xml_tags_for_trailing_separators")

    @property
    @pulumi.getter(name="maskSecurityInfo")
    def mask_security_info(self) -> bool:
        """
        The value indicating whether to mask security information.
        """
        return pulumi.get(self, "mask_security_info")

    @property
    @pulumi.getter(name="preserveInterchange")
    def preserve_interchange(self) -> bool:
        """
        The value indicating whether to preserve interchange.
        """
        return pulumi.get(self, "preserve_interchange")

    @property
    @pulumi.getter(name="suspendInterchangeOnError")
    def suspend_interchange_on_error(self) -> bool:
        """
        The value indicating whether to suspend interchange on error.
        """
        return pulumi.get(self, "suspend_interchange_on_error")

    @property
    @pulumi.getter(name="useDotAsDecimalSeparator")
    def use_dot_as_decimal_separator(self) -> bool:
        """
        The value indicating whether to use dot as decimal separator.
        """
        return pulumi.get(self, "use_dot_as_decimal_separator")


@pulumi.output_type
class EdifactProtocolSettingsResponse(dict):
    """
    The Edifact agreement protocol settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementSettings":
            suggest = "acknowledgement_settings"
        elif key == "envelopeSettings":
            suggest = "envelope_settings"
        elif key == "framingSettings":
            suggest = "framing_settings"
        elif key == "messageFilter":
            suggest = "message_filter"
        elif key == "processingSettings":
            suggest = "processing_settings"
        elif key == "schemaReferences":
            suggest = "schema_references"
        elif key == "validationSettings":
            suggest = "validation_settings"
        elif key == "edifactDelimiterOverrides":
            suggest = "edifact_delimiter_overrides"
        elif key == "envelopeOverrides":
            suggest = "envelope_overrides"
        elif key == "messageFilterList":
            suggest = "message_filter_list"
        elif key == "validationOverrides":
            suggest = "validation_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactProtocolSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactProtocolSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactProtocolSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_settings: 'outputs.EdifactAcknowledgementSettingsResponse',
                 envelope_settings: 'outputs.EdifactEnvelopeSettingsResponse',
                 framing_settings: 'outputs.EdifactFramingSettingsResponse',
                 message_filter: 'outputs.EdifactMessageFilterResponse',
                 processing_settings: 'outputs.EdifactProcessingSettingsResponse',
                 schema_references: Sequence['outputs.EdifactSchemaReferenceResponse'],
                 validation_settings: 'outputs.EdifactValidationSettingsResponse',
                 edifact_delimiter_overrides: Optional[Sequence['outputs.EdifactDelimiterOverrideResponse']] = None,
                 envelope_overrides: Optional[Sequence['outputs.EdifactEnvelopeOverrideResponse']] = None,
                 message_filter_list: Optional[Sequence['outputs.EdifactMessageIdentifierResponse']] = None,
                 validation_overrides: Optional[Sequence['outputs.EdifactValidationOverrideResponse']] = None):
        """
        The Edifact agreement protocol settings.
        :param 'EdifactAcknowledgementSettingsResponse' acknowledgement_settings: The EDIFACT acknowledgement settings.
        :param 'EdifactEnvelopeSettingsResponse' envelope_settings: The EDIFACT envelope settings.
        :param 'EdifactFramingSettingsResponse' framing_settings: The EDIFACT framing settings.
        :param 'EdifactMessageFilterResponse' message_filter: The EDIFACT message filter.
        :param 'EdifactProcessingSettingsResponse' processing_settings: The EDIFACT processing Settings.
        :param Sequence['EdifactSchemaReferenceResponse'] schema_references: The EDIFACT schema references.
        :param 'EdifactValidationSettingsResponse' validation_settings: The EDIFACT validation settings.
        :param Sequence['EdifactDelimiterOverrideResponse'] edifact_delimiter_overrides: The EDIFACT delimiter override settings.
        :param Sequence['EdifactEnvelopeOverrideResponse'] envelope_overrides: The EDIFACT envelope override settings.
        :param Sequence['EdifactMessageIdentifierResponse'] message_filter_list: The EDIFACT message filter list.
        :param Sequence['EdifactValidationOverrideResponse'] validation_overrides: The EDIFACT validation override settings.
        """
        pulumi.set(__self__, "acknowledgement_settings", acknowledgement_settings)
        pulumi.set(__self__, "envelope_settings", envelope_settings)
        pulumi.set(__self__, "framing_settings", framing_settings)
        pulumi.set(__self__, "message_filter", message_filter)
        pulumi.set(__self__, "processing_settings", processing_settings)
        pulumi.set(__self__, "schema_references", schema_references)
        pulumi.set(__self__, "validation_settings", validation_settings)
        if edifact_delimiter_overrides is not None:
            pulumi.set(__self__, "edifact_delimiter_overrides", edifact_delimiter_overrides)
        if envelope_overrides is not None:
            pulumi.set(__self__, "envelope_overrides", envelope_overrides)
        if message_filter_list is not None:
            pulumi.set(__self__, "message_filter_list", message_filter_list)
        if validation_overrides is not None:
            pulumi.set(__self__, "validation_overrides", validation_overrides)

    @property
    @pulumi.getter(name="acknowledgementSettings")
    def acknowledgement_settings(self) -> 'outputs.EdifactAcknowledgementSettingsResponse':
        """
        The EDIFACT acknowledgement settings.
        """
        return pulumi.get(self, "acknowledgement_settings")

    @property
    @pulumi.getter(name="envelopeSettings")
    def envelope_settings(self) -> 'outputs.EdifactEnvelopeSettingsResponse':
        """
        The EDIFACT envelope settings.
        """
        return pulumi.get(self, "envelope_settings")

    @property
    @pulumi.getter(name="framingSettings")
    def framing_settings(self) -> 'outputs.EdifactFramingSettingsResponse':
        """
        The EDIFACT framing settings.
        """
        return pulumi.get(self, "framing_settings")

    @property
    @pulumi.getter(name="messageFilter")
    def message_filter(self) -> 'outputs.EdifactMessageFilterResponse':
        """
        The EDIFACT message filter.
        """
        return pulumi.get(self, "message_filter")

    @property
    @pulumi.getter(name="processingSettings")
    def processing_settings(self) -> 'outputs.EdifactProcessingSettingsResponse':
        """
        The EDIFACT processing Settings.
        """
        return pulumi.get(self, "processing_settings")

    @property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> Sequence['outputs.EdifactSchemaReferenceResponse']:
        """
        The EDIFACT schema references.
        """
        return pulumi.get(self, "schema_references")

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> 'outputs.EdifactValidationSettingsResponse':
        """
        The EDIFACT validation settings.
        """
        return pulumi.get(self, "validation_settings")

    @property
    @pulumi.getter(name="edifactDelimiterOverrides")
    def edifact_delimiter_overrides(self) -> Optional[Sequence['outputs.EdifactDelimiterOverrideResponse']]:
        """
        The EDIFACT delimiter override settings.
        """
        return pulumi.get(self, "edifact_delimiter_overrides")

    @property
    @pulumi.getter(name="envelopeOverrides")
    def envelope_overrides(self) -> Optional[Sequence['outputs.EdifactEnvelopeOverrideResponse']]:
        """
        The EDIFACT envelope override settings.
        """
        return pulumi.get(self, "envelope_overrides")

    @property
    @pulumi.getter(name="messageFilterList")
    def message_filter_list(self) -> Optional[Sequence['outputs.EdifactMessageIdentifierResponse']]:
        """
        The EDIFACT message filter list.
        """
        return pulumi.get(self, "message_filter_list")

    @property
    @pulumi.getter(name="validationOverrides")
    def validation_overrides(self) -> Optional[Sequence['outputs.EdifactValidationOverrideResponse']]:
        """
        The EDIFACT validation override settings.
        """
        return pulumi.get(self, "validation_overrides")


@pulumi.output_type
class EdifactSchemaReferenceResponse(dict):
    """
    The Edifact schema reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageId":
            suggest = "message_id"
        elif key == "messageRelease":
            suggest = "message_release"
        elif key == "messageVersion":
            suggest = "message_version"
        elif key == "schemaName":
            suggest = "schema_name"
        elif key == "associationAssignedCode":
            suggest = "association_assigned_code"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"
        elif key == "senderApplicationQualifier":
            suggest = "sender_application_qualifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactSchemaReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactSchemaReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactSchemaReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_id: str,
                 message_release: str,
                 message_version: str,
                 schema_name: str,
                 association_assigned_code: Optional[str] = None,
                 sender_application_id: Optional[str] = None,
                 sender_application_qualifier: Optional[str] = None):
        """
        The Edifact schema reference.
        :param str message_id: The message id.
        :param str message_release: The message release version.
        :param str message_version: The message version.
        :param str schema_name: The schema name.
        :param str association_assigned_code: The association assigned code.
        :param str sender_application_id: The sender application id.
        :param str sender_application_qualifier: The sender application qualifier.
        """
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "message_release", message_release)
        pulumi.set(__self__, "message_version", message_version)
        pulumi.set(__self__, "schema_name", schema_name)
        if association_assigned_code is not None:
            pulumi.set(__self__, "association_assigned_code", association_assigned_code)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)
        if sender_application_qualifier is not None:
            pulumi.set(__self__, "sender_application_qualifier", sender_application_qualifier)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> str:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="messageRelease")
    def message_release(self) -> str:
        """
        The message release version.
        """
        return pulumi.get(self, "message_release")

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> str:
        """
        The message version.
        """
        return pulumi.get(self, "message_version")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> str:
        """
        The schema name.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="associationAssignedCode")
    def association_assigned_code(self) -> Optional[str]:
        """
        The association assigned code.
        """
        return pulumi.get(self, "association_assigned_code")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @property
    @pulumi.getter(name="senderApplicationQualifier")
    def sender_application_qualifier(self) -> Optional[str]:
        """
        The sender application qualifier.
        """
        return pulumi.get(self, "sender_application_qualifier")


@pulumi.output_type
class EdifactValidationOverrideResponse(dict):
    """
    The Edifact validation override settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLeadingAndTrailingSpacesAndZeroes":
            suggest = "allow_leading_and_trailing_spaces_and_zeroes"
        elif key == "enforceCharacterSet":
            suggest = "enforce_character_set"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "trailingSeparatorPolicy":
            suggest = "trailing_separator_policy"
        elif key == "trimLeadingAndTrailingSpacesAndZeroes":
            suggest = "trim_leading_and_trailing_spaces_and_zeroes"
        elif key == "validateEdiTypes":
            suggest = "validate_edi_types"
        elif key == "validateXsdTypes":
            suggest = "validate_xsd_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactValidationOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactValidationOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactValidationOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: bool,
                 enforce_character_set: bool,
                 message_id: str,
                 trailing_separator_policy: str,
                 trim_leading_and_trailing_spaces_and_zeroes: bool,
                 validate_edi_types: bool,
                 validate_xsd_types: bool):
        """
        The Edifact validation override settings.
        :param bool allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param bool enforce_character_set: The value indicating whether to validate character Set.
        :param str message_id: The message id on which the validation settings has to be applied.
        :param str trailing_separator_policy: The trailing separator policy.
        :param bool trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param bool validate_edi_types: The value indicating whether to validate EDI types.
        :param bool validate_xsd_types: The value indicating whether to validate XSD types.
        """
        pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "enforce_character_set", enforce_character_set)
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> bool:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="enforceCharacterSet")
    def enforce_character_set(self) -> bool:
        """
        The value indicating whether to validate character Set.
        """
        return pulumi.get(self, "enforce_character_set")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> str:
        """
        The message id on which the validation settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> str:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> bool:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="validateEdiTypes")
    def validate_edi_types(self) -> bool:
        """
        The value indicating whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @property
    @pulumi.getter(name="validateXsdTypes")
    def validate_xsd_types(self) -> bool:
        """
        The value indicating whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")


@pulumi.output_type
class EdifactValidationSettingsResponse(dict):
    """
    The Edifact agreement validation settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLeadingAndTrailingSpacesAndZeroes":
            suggest = "allow_leading_and_trailing_spaces_and_zeroes"
        elif key == "checkDuplicateGroupControlNumber":
            suggest = "check_duplicate_group_control_number"
        elif key == "checkDuplicateInterchangeControlNumber":
            suggest = "check_duplicate_interchange_control_number"
        elif key == "checkDuplicateTransactionSetControlNumber":
            suggest = "check_duplicate_transaction_set_control_number"
        elif key == "interchangeControlNumberValidityDays":
            suggest = "interchange_control_number_validity_days"
        elif key == "trailingSeparatorPolicy":
            suggest = "trailing_separator_policy"
        elif key == "trimLeadingAndTrailingSpacesAndZeroes":
            suggest = "trim_leading_and_trailing_spaces_and_zeroes"
        elif key == "validateCharacterSet":
            suggest = "validate_character_set"
        elif key == "validateEdiTypes":
            suggest = "validate_edi_types"
        elif key == "validateXsdTypes":
            suggest = "validate_xsd_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdifactValidationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdifactValidationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdifactValidationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: bool,
                 check_duplicate_group_control_number: bool,
                 check_duplicate_interchange_control_number: bool,
                 check_duplicate_transaction_set_control_number: bool,
                 interchange_control_number_validity_days: int,
                 trailing_separator_policy: str,
                 trim_leading_and_trailing_spaces_and_zeroes: bool,
                 validate_character_set: bool,
                 validate_edi_types: bool,
                 validate_xsd_types: bool):
        """
        The Edifact agreement validation settings.
        :param bool allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param bool check_duplicate_group_control_number: The value indicating whether to check for duplicate group control number.
        :param bool check_duplicate_interchange_control_number: The value indicating whether to check for duplicate interchange control number.
        :param bool check_duplicate_transaction_set_control_number: The value indicating whether to check for duplicate transaction set control number.
        :param int interchange_control_number_validity_days: The validity period of interchange control number.
        :param str trailing_separator_policy: The trailing separator policy.
        :param bool trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param bool validate_character_set: The value indicating whether to validate character set in the message.
        :param bool validate_edi_types: The value indicating whether to Whether to validate EDI types.
        :param bool validate_xsd_types: The value indicating whether to Whether to validate XSD types.
        """
        pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "check_duplicate_group_control_number", check_duplicate_group_control_number)
        pulumi.set(__self__, "check_duplicate_interchange_control_number", check_duplicate_interchange_control_number)
        pulumi.set(__self__, "check_duplicate_transaction_set_control_number", check_duplicate_transaction_set_control_number)
        pulumi.set(__self__, "interchange_control_number_validity_days", interchange_control_number_validity_days)
        pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "validate_character_set", validate_character_set)
        pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> bool:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="checkDuplicateGroupControlNumber")
    def check_duplicate_group_control_number(self) -> bool:
        """
        The value indicating whether to check for duplicate group control number.
        """
        return pulumi.get(self, "check_duplicate_group_control_number")

    @property
    @pulumi.getter(name="checkDuplicateInterchangeControlNumber")
    def check_duplicate_interchange_control_number(self) -> bool:
        """
        The value indicating whether to check for duplicate interchange control number.
        """
        return pulumi.get(self, "check_duplicate_interchange_control_number")

    @property
    @pulumi.getter(name="checkDuplicateTransactionSetControlNumber")
    def check_duplicate_transaction_set_control_number(self) -> bool:
        """
        The value indicating whether to check for duplicate transaction set control number.
        """
        return pulumi.get(self, "check_duplicate_transaction_set_control_number")

    @property
    @pulumi.getter(name="interchangeControlNumberValidityDays")
    def interchange_control_number_validity_days(self) -> int:
        """
        The validity period of interchange control number.
        """
        return pulumi.get(self, "interchange_control_number_validity_days")

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> str:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> bool:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="validateCharacterSet")
    def validate_character_set(self) -> bool:
        """
        The value indicating whether to validate character set in the message.
        """
        return pulumi.get(self, "validate_character_set")

    @property
    @pulumi.getter(name="validateEdiTypes")
    def validate_edi_types(self) -> bool:
        """
        The value indicating whether to Whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @property
    @pulumi.getter(name="validateXsdTypes")
    def validate_xsd_types(self) -> bool:
        """
        The value indicating whether to Whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")


@pulumi.output_type
class ExpressionResponse(dict):
    def __init__(__self__, *,
                 error: Optional['outputs.AzureResourceErrorInfoResponse'] = None,
                 subexpressions: Optional[Sequence['outputs.ExpressionResponse']] = None,
                 text: Optional[str] = None,
                 value: Optional[Any] = None):
        """
        :param 'AzureResourceErrorInfoResponse' error: The azure resource error info.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if subexpressions is not None:
            pulumi.set(__self__, "subexpressions", subexpressions)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.AzureResourceErrorInfoResponse']:
        """
        The azure resource error info.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def subexpressions(self) -> Optional[Sequence['outputs.ExpressionResponse']]:
        return pulumi.get(self, "subexpressions")

    @property
    @pulumi.getter
    def text(self) -> Optional[str]:
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ExpressionRootResponse(dict):
    def __init__(__self__, *,
                 error: Optional['outputs.AzureResourceErrorInfoResponse'] = None,
                 path: Optional[str] = None,
                 subexpressions: Optional[Sequence['outputs.ExpressionResponse']] = None,
                 text: Optional[str] = None,
                 value: Optional[Any] = None):
        """
        :param 'AzureResourceErrorInfoResponse' error: The azure resource error info.
        :param str path: The path.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if subexpressions is not None:
            pulumi.set(__self__, "subexpressions", subexpressions)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.AzureResourceErrorInfoResponse']:
        """
        The azure resource error info.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def subexpressions(self) -> Optional[Sequence['outputs.ExpressionResponse']]:
        return pulumi.get(self, "subexpressions")

    @property
    @pulumi.getter
    def text(self) -> Optional[str]:
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        return pulumi.get(self, "value")


@pulumi.output_type
class IntegrationAccountMapPropertiesResponseParametersSchema(dict):
    """
    The parameters schema of integration account map.
    """
    def __init__(__self__, *,
                 ref: Optional[str] = None):
        """
        The parameters schema of integration account map.
        :param str ref: The reference name.
        """
        if ref is not None:
            pulumi.set(__self__, "ref", ref)

    @property
    @pulumi.getter
    def ref(self) -> Optional[str]:
        """
        The reference name.
        """
        return pulumi.get(self, "ref")


@pulumi.output_type
class IntegrationAccountSkuResponse(dict):
    """
    The integration account sku.
    """
    def __init__(__self__, *,
                 name: str):
        """
        The integration account sku.
        :param str name: The sku name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class KeyVaultKeyReferenceResponse(dict):
    """
    The reference to the key vault key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "keyVault":
            suggest = "key_vault"
        elif key == "keyVersion":
            suggest = "key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultKeyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: str,
                 key_vault: 'outputs.KeyVaultKeyReferenceResponseKeyVault',
                 key_version: Optional[str] = None):
        """
        The reference to the key vault key.
        :param str key_name: The private key name in key vault.
        :param 'KeyVaultKeyReferenceResponseKeyVault' key_vault: The key vault reference.
        :param str key_version: The private key version in key vault.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_vault", key_vault)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The private key name in key vault.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVault")
    def key_vault(self) -> 'outputs.KeyVaultKeyReferenceResponseKeyVault':
        """
        The key vault reference.
        """
        return pulumi.get(self, "key_vault")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        The private key version in key vault.
        """
        return pulumi.get(self, "key_version")


@pulumi.output_type
class KeyVaultKeyReferenceResponseKeyVault(dict):
    """
    The key vault reference.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 id: Optional[str] = None):
        """
        The key vault reference.
        :param str name: The resource name.
        :param str type: The resource type.
        :param str id: The resource id.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class KeyVaultKeyResponse(dict):
    """
    The key vault key.
    """
    def __init__(__self__, *,
                 attributes: Optional['outputs.KeyVaultKeyResponseAttributes'] = None,
                 kid: Optional[str] = None):
        """
        The key vault key.
        :param 'KeyVaultKeyResponseAttributes' attributes: The key attributes.
        :param str kid: The key id.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)

    @property
    @pulumi.getter
    def attributes(self) -> Optional['outputs.KeyVaultKeyResponseAttributes']:
        """
        The key attributes.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def kid(self) -> Optional[str]:
        """
        The key id.
        """
        return pulumi.get(self, "kid")


@pulumi.output_type
class KeyVaultKeyResponseAttributes(dict):
    """
    The key attributes.
    """
    def __init__(__self__, *,
                 created: Optional[float] = None,
                 enabled: Optional[bool] = None,
                 updated: Optional[float] = None):
        """
        The key attributes.
        :param float created: When the key was created.
        :param bool enabled: Whether the key is enabled or not.
        :param float updated: When the key was updated.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter
    def created(self) -> Optional[float]:
        """
        When the key was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether the key is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def updated(self) -> Optional[float]:
        """
        When the key was updated.
        """
        return pulumi.get(self, "updated")


@pulumi.output_type
class PartnerContentResponse(dict):
    """
    The integration account partner content.
    """
    def __init__(__self__, *,
                 b2b: Optional['outputs.B2BPartnerContentResponse'] = None):
        """
        The integration account partner content.
        :param 'B2BPartnerContentResponse' b2b: The B2B partner content.
        """
        if b2b is not None:
            pulumi.set(__self__, "b2b", b2b)

    @property
    @pulumi.getter
    def b2b(self) -> Optional['outputs.B2BPartnerContentResponse']:
        """
        The B2B partner content.
        """
        return pulumi.get(self, "b2b")


@pulumi.output_type
class RecurrenceScheduleOccurrenceResponse(dict):
    """
    The recurrence schedule occurrence.
    """
    def __init__(__self__, *,
                 day: Optional[str] = None,
                 occurrence: Optional[int] = None):
        """
        The recurrence schedule occurrence.
        :param str day: The day of the week.
        :param int occurrence: The occurrence.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if occurrence is not None:
            pulumi.set(__self__, "occurrence", occurrence)

    @property
    @pulumi.getter
    def day(self) -> Optional[str]:
        """
        The day of the week.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def occurrence(self) -> Optional[int]:
        """
        The occurrence.
        """
        return pulumi.get(self, "occurrence")


@pulumi.output_type
class RecurrenceScheduleResponse(dict):
    """
    The recurrence schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthDays":
            suggest = "month_days"
        elif key == "monthlyOccurrences":
            suggest = "monthly_occurrences"
        elif key == "weekDays":
            suggest = "week_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurrenceScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurrenceScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurrenceScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hours: Optional[Sequence[int]] = None,
                 minutes: Optional[Sequence[int]] = None,
                 month_days: Optional[Sequence[int]] = None,
                 monthly_occurrences: Optional[Sequence['outputs.RecurrenceScheduleOccurrenceResponse']] = None,
                 week_days: Optional[Sequence[str]] = None):
        """
        The recurrence schedule.
        :param Sequence[int] hours: The hours.
        :param Sequence[int] minutes: The minutes.
        :param Sequence[int] month_days: The month days.
        :param Sequence['RecurrenceScheduleOccurrenceResponse'] monthly_occurrences: The monthly occurrences.
        :param Sequence[str] week_days: The days of the week.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if monthly_occurrences is not None:
            pulumi.set(__self__, "monthly_occurrences", monthly_occurrences)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter
    def hours(self) -> Optional[Sequence[int]]:
        """
        The hours.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[Sequence[int]]:
        """
        The minutes.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[Sequence[int]]:
        """
        The month days.
        """
        return pulumi.get(self, "month_days")

    @property
    @pulumi.getter(name="monthlyOccurrences")
    def monthly_occurrences(self) -> Optional[Sequence['outputs.RecurrenceScheduleOccurrenceResponse']]:
        """
        The monthly occurrences.
        """
        return pulumi.get(self, "monthly_occurrences")

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[Sequence[str]]:
        """
        The days of the week.
        """
        return pulumi.get(self, "week_days")


@pulumi.output_type
class ResourceReferenceResponse(dict):
    """
    The resource reference.
    """
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str):
        """
        The resource reference.
        :param str id: The resource id.
        :param str name: Gets the resource name.
        :param str type: Gets the resource type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets the resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Gets the resource type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RosettaNetPipAcknowledgmentOfReceiptSettingsResponse(dict):
    """
    The integration account RosettaNet ProcessConfiguration Acknowledgement settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isNonRepudiationRequired":
            suggest = "is_non_repudiation_required"
        elif key == "timeToAcknowledgeInSeconds":
            suggest = "time_to_acknowledge_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RosettaNetPipAcknowledgmentOfReceiptSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RosettaNetPipAcknowledgmentOfReceiptSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RosettaNetPipAcknowledgmentOfReceiptSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_non_repudiation_required: bool,
                 time_to_acknowledge_in_seconds: int):
        """
        The integration account RosettaNet ProcessConfiguration Acknowledgement settings.
        :param bool is_non_repudiation_required: The non-repudiation is required or not.
        :param int time_to_acknowledge_in_seconds: The time to acknowledge in seconds.
        """
        pulumi.set(__self__, "is_non_repudiation_required", is_non_repudiation_required)
        pulumi.set(__self__, "time_to_acknowledge_in_seconds", time_to_acknowledge_in_seconds)

    @property
    @pulumi.getter(name="isNonRepudiationRequired")
    def is_non_repudiation_required(self) -> bool:
        """
        The non-repudiation is required or not.
        """
        return pulumi.get(self, "is_non_repudiation_required")

    @property
    @pulumi.getter(name="timeToAcknowledgeInSeconds")
    def time_to_acknowledge_in_seconds(self) -> int:
        """
        The time to acknowledge in seconds.
        """
        return pulumi.get(self, "time_to_acknowledge_in_seconds")


@pulumi.output_type
class RosettaNetPipActivityBehaviorResponse(dict):
    """
    The integration account RosettaNet ProcessConfiguration activity behavior.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "isAuthorizationRequired":
            suggest = "is_authorization_required"
        elif key == "isSecuredTransportRequired":
            suggest = "is_secured_transport_required"
        elif key == "nonRepudiationOfOriginAndContent":
            suggest = "non_repudiation_of_origin_and_content"
        elif key == "persistentConfidentialityScope":
            suggest = "persistent_confidentiality_scope"
        elif key == "responseType":
            suggest = "response_type"
        elif key == "retryCount":
            suggest = "retry_count"
        elif key == "timeToPerformInSeconds":
            suggest = "time_to_perform_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RosettaNetPipActivityBehaviorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RosettaNetPipActivityBehaviorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RosettaNetPipActivityBehaviorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 is_authorization_required: bool,
                 is_secured_transport_required: bool,
                 non_repudiation_of_origin_and_content: bool,
                 persistent_confidentiality_scope: str,
                 response_type: str,
                 retry_count: int,
                 time_to_perform_in_seconds: int):
        """
        The integration account RosettaNet ProcessConfiguration activity behavior.
        :param str action_type: The value indicating whether the RosettaNet PIP is used for a single action.
        :param bool is_authorization_required: The value indicating whether authorization is required.
        :param bool is_secured_transport_required: The value indicating whether secured transport is required.
        :param bool non_repudiation_of_origin_and_content: The value indicating whether non-repudiation is for origin and content.
        :param str persistent_confidentiality_scope: The persistent confidentiality encryption scope.
        :param str response_type: The value indicating whether the RosettaNet PIP communication is synchronous.
        :param int retry_count: The value indicating retry count.
        :param int time_to_perform_in_seconds: The time to perform in seconds.
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "is_authorization_required", is_authorization_required)
        pulumi.set(__self__, "is_secured_transport_required", is_secured_transport_required)
        pulumi.set(__self__, "non_repudiation_of_origin_and_content", non_repudiation_of_origin_and_content)
        pulumi.set(__self__, "persistent_confidentiality_scope", persistent_confidentiality_scope)
        pulumi.set(__self__, "response_type", response_type)
        pulumi.set(__self__, "retry_count", retry_count)
        pulumi.set(__self__, "time_to_perform_in_seconds", time_to_perform_in_seconds)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The value indicating whether the RosettaNet PIP is used for a single action.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="isAuthorizationRequired")
    def is_authorization_required(self) -> bool:
        """
        The value indicating whether authorization is required.
        """
        return pulumi.get(self, "is_authorization_required")

    @property
    @pulumi.getter(name="isSecuredTransportRequired")
    def is_secured_transport_required(self) -> bool:
        """
        The value indicating whether secured transport is required.
        """
        return pulumi.get(self, "is_secured_transport_required")

    @property
    @pulumi.getter(name="nonRepudiationOfOriginAndContent")
    def non_repudiation_of_origin_and_content(self) -> bool:
        """
        The value indicating whether non-repudiation is for origin and content.
        """
        return pulumi.get(self, "non_repudiation_of_origin_and_content")

    @property
    @pulumi.getter(name="persistentConfidentialityScope")
    def persistent_confidentiality_scope(self) -> str:
        """
        The persistent confidentiality encryption scope.
        """
        return pulumi.get(self, "persistent_confidentiality_scope")

    @property
    @pulumi.getter(name="responseType")
    def response_type(self) -> str:
        """
        The value indicating whether the RosettaNet PIP communication is synchronous.
        """
        return pulumi.get(self, "response_type")

    @property
    @pulumi.getter(name="retryCount")
    def retry_count(self) -> int:
        """
        The value indicating retry count.
        """
        return pulumi.get(self, "retry_count")

    @property
    @pulumi.getter(name="timeToPerformInSeconds")
    def time_to_perform_in_seconds(self) -> int:
        """
        The time to perform in seconds.
        """
        return pulumi.get(self, "time_to_perform_in_seconds")


@pulumi.output_type
class RosettaNetPipActivitySettingsResponse(dict):
    """
    The integration account RosettaNet ProcessConfiguration activity settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgmentOfReceiptSettings":
            suggest = "acknowledgment_of_receipt_settings"
        elif key == "activityBehavior":
            suggest = "activity_behavior"
        elif key == "activityType":
            suggest = "activity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RosettaNetPipActivitySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RosettaNetPipActivitySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RosettaNetPipActivitySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgment_of_receipt_settings: 'outputs.RosettaNetPipAcknowledgmentOfReceiptSettingsResponse',
                 activity_behavior: 'outputs.RosettaNetPipActivityBehaviorResponse',
                 activity_type: str):
        """
        The integration account RosettaNet ProcessConfiguration activity settings.
        :param 'RosettaNetPipAcknowledgmentOfReceiptSettingsResponse' acknowledgment_of_receipt_settings: The RosettaNet ProcessConfiguration acknowledgement settings.
        :param 'RosettaNetPipActivityBehaviorResponse' activity_behavior: The RosettaNet ProcessConfiguration activity behavior.
        :param str activity_type: The RosettaNet ProcessConfiguration activity type.
        """
        pulumi.set(__self__, "acknowledgment_of_receipt_settings", acknowledgment_of_receipt_settings)
        pulumi.set(__self__, "activity_behavior", activity_behavior)
        pulumi.set(__self__, "activity_type", activity_type)

    @property
    @pulumi.getter(name="acknowledgmentOfReceiptSettings")
    def acknowledgment_of_receipt_settings(self) -> 'outputs.RosettaNetPipAcknowledgmentOfReceiptSettingsResponse':
        """
        The RosettaNet ProcessConfiguration acknowledgement settings.
        """
        return pulumi.get(self, "acknowledgment_of_receipt_settings")

    @property
    @pulumi.getter(name="activityBehavior")
    def activity_behavior(self) -> 'outputs.RosettaNetPipActivityBehaviorResponse':
        """
        The RosettaNet ProcessConfiguration activity behavior.
        """
        return pulumi.get(self, "activity_behavior")

    @property
    @pulumi.getter(name="activityType")
    def activity_type(self) -> str:
        """
        The RosettaNet ProcessConfiguration activity type.
        """
        return pulumi.get(self, "activity_type")


@pulumi.output_type
class RosettaNetPipBusinessDocumentResponse(dict):
    """
    The RosettaNet ProcessConfiguration business document settings.
    """
    def __init__(__self__, *,
                 name: str,
                 version: str,
                 description: Optional[str] = None):
        """
        The RosettaNet ProcessConfiguration business document settings.
        :param str name: The business document name.
        :param str version: The business document version.
        :param str description: The business document description.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The business document name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The business document version.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The business document description.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class RosettaNetPipRoleSettingsResponse(dict):
    """
    The integration account RosettaNet ProcessConfiguration role settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "businessDocument":
            suggest = "business_document"
        elif key == "roleType":
            suggest = "role_type"
        elif key == "serviceClassification":
            suggest = "service_classification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RosettaNetPipRoleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RosettaNetPipRoleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RosettaNetPipRoleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 business_document: 'outputs.RosettaNetPipBusinessDocumentResponse',
                 role: str,
                 role_type: str,
                 service: str,
                 service_classification: str,
                 description: Optional[str] = None):
        """
        The integration account RosettaNet ProcessConfiguration role settings.
        :param str action: The action name.
        :param 'RosettaNetPipBusinessDocumentResponse' business_document: The RosettaNet ProcessConfiguration business document.
        :param str role: The role name.
        :param str role_type: The RosettaNet ProcessConfiguration role type.
        :param str service: The service name.
        :param str service_classification: The service classification name.
        :param str description: The description.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "business_document", business_document)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "role_type", role_type)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "service_classification", service_classification)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action name.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="businessDocument")
    def business_document(self) -> 'outputs.RosettaNetPipBusinessDocumentResponse':
        """
        The RosettaNet ProcessConfiguration business document.
        """
        return pulumi.get(self, "business_document")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role name.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> str:
        """
        The RosettaNet ProcessConfiguration role type.
        """
        return pulumi.get(self, "role_type")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The service name.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceClassification")
    def service_classification(self) -> str:
        """
        The service classification name.
        """
        return pulumi.get(self, "service_classification")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class SkuResponse(dict):
    """
    The sku type.
    """
    def __init__(__self__, *,
                 name: str,
                 plan: Optional['outputs.ResourceReferenceResponse'] = None):
        """
        The sku type.
        :param str name: The name.
        :param 'ResourceReferenceResponse' plan: The reference to plan.
        """
        pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> Optional['outputs.ResourceReferenceResponse']:
        """
        The reference to plan.
        """
        return pulumi.get(self, "plan")


@pulumi.output_type
class WorkflowParameterResponse(dict):
    """
    The workflow parameters.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 metadata: Optional[Any] = None,
                 type: Optional[str] = None,
                 value: Optional[Any] = None):
        """
        The workflow parameters.
        :param str description: The description.
        :param Any metadata: The metadata.
        :param str type: The type.
        :param Any value: The value.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        """
        The metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WorkflowTriggerListCallbackUrlQueriesResponse(dict):
    """
    Gets the workflow trigger callback URL query parameters.
    """
    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 se: Optional[str] = None,
                 sig: Optional[str] = None,
                 sp: Optional[str] = None,
                 sv: Optional[str] = None):
        """
        Gets the workflow trigger callback URL query parameters.
        :param str api_version: The api version.
        :param str se: The SAS timestamp.
        :param str sig: The SAS signature.
        :param str sp: The SAS permissions.
        :param str sv: The SAS version.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if se is not None:
            pulumi.set(__self__, "se", se)
        if sig is not None:
            pulumi.set(__self__, "sig", sig)
        if sp is not None:
            pulumi.set(__self__, "sp", sp)
        if sv is not None:
            pulumi.set(__self__, "sv", sv)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        The api version.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def se(self) -> Optional[str]:
        """
        The SAS timestamp.
        """
        return pulumi.get(self, "se")

    @property
    @pulumi.getter
    def sig(self) -> Optional[str]:
        """
        The SAS signature.
        """
        return pulumi.get(self, "sig")

    @property
    @pulumi.getter
    def sp(self) -> Optional[str]:
        """
        The SAS permissions.
        """
        return pulumi.get(self, "sp")

    @property
    @pulumi.getter
    def sv(self) -> Optional[str]:
        """
        The SAS version.
        """
        return pulumi.get(self, "sv")


@pulumi.output_type
class WorkflowTriggerRecurrenceResponse(dict):
    """
    The workflow trigger recurrence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTriggerRecurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTriggerRecurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTriggerRecurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[str] = None,
                 frequency: Optional[str] = None,
                 interval: Optional[int] = None,
                 schedule: Optional['outputs.RecurrenceScheduleResponse'] = None,
                 start_time: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        The workflow trigger recurrence.
        :param str end_time: The end time.
        :param str frequency: The frequency.
        :param int interval: The interval.
        :param 'RecurrenceScheduleResponse' schedule: The recurrence schedule.
        :param str start_time: The start time.
        :param str time_zone: The time zone.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        """
        The frequency.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The interval.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.RecurrenceScheduleResponse']:
        """
        The recurrence schedule.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        The time zone.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class X12AcknowledgementSettingsResponse(dict):
    """
    The X12 agreement acknowledgement settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementControlNumberLowerBound":
            suggest = "acknowledgement_control_number_lower_bound"
        elif key == "acknowledgementControlNumberUpperBound":
            suggest = "acknowledgement_control_number_upper_bound"
        elif key == "batchFunctionalAcknowledgements":
            suggest = "batch_functional_acknowledgements"
        elif key == "batchImplementationAcknowledgements":
            suggest = "batch_implementation_acknowledgements"
        elif key == "batchTechnicalAcknowledgements":
            suggest = "batch_technical_acknowledgements"
        elif key == "needFunctionalAcknowledgement":
            suggest = "need_functional_acknowledgement"
        elif key == "needImplementationAcknowledgement":
            suggest = "need_implementation_acknowledgement"
        elif key == "needLoopForValidMessages":
            suggest = "need_loop_for_valid_messages"
        elif key == "needTechnicalAcknowledgement":
            suggest = "need_technical_acknowledgement"
        elif key == "rolloverAcknowledgementControlNumber":
            suggest = "rollover_acknowledgement_control_number"
        elif key == "sendSynchronousAcknowledgement":
            suggest = "send_synchronous_acknowledgement"
        elif key == "acknowledgementControlNumberPrefix":
            suggest = "acknowledgement_control_number_prefix"
        elif key == "acknowledgementControlNumberSuffix":
            suggest = "acknowledgement_control_number_suffix"
        elif key == "functionalAcknowledgementVersion":
            suggest = "functional_acknowledgement_version"
        elif key == "implementationAcknowledgementVersion":
            suggest = "implementation_acknowledgement_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12AcknowledgementSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12AcknowledgementSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12AcknowledgementSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_control_number_lower_bound: int,
                 acknowledgement_control_number_upper_bound: int,
                 batch_functional_acknowledgements: bool,
                 batch_implementation_acknowledgements: bool,
                 batch_technical_acknowledgements: bool,
                 need_functional_acknowledgement: bool,
                 need_implementation_acknowledgement: bool,
                 need_loop_for_valid_messages: bool,
                 need_technical_acknowledgement: bool,
                 rollover_acknowledgement_control_number: bool,
                 send_synchronous_acknowledgement: bool,
                 acknowledgement_control_number_prefix: Optional[str] = None,
                 acknowledgement_control_number_suffix: Optional[str] = None,
                 functional_acknowledgement_version: Optional[str] = None,
                 implementation_acknowledgement_version: Optional[str] = None):
        """
        The X12 agreement acknowledgement settings.
        :param int acknowledgement_control_number_lower_bound: The acknowledgement control number lower bound.
        :param int acknowledgement_control_number_upper_bound: The acknowledgement control number upper bound.
        :param bool batch_functional_acknowledgements: The value indicating whether to batch functional acknowledgements.
        :param bool batch_implementation_acknowledgements: The value indicating whether to batch implementation acknowledgements.
        :param bool batch_technical_acknowledgements: The value indicating whether to batch the technical acknowledgements.
        :param bool need_functional_acknowledgement: The value indicating whether functional acknowledgement is needed.
        :param bool need_implementation_acknowledgement: The value indicating whether implementation acknowledgement is needed.
        :param bool need_loop_for_valid_messages: The value indicating whether a loop is needed for valid messages.
        :param bool need_technical_acknowledgement: The value indicating whether technical acknowledgement is needed.
        :param bool rollover_acknowledgement_control_number: The value indicating whether to rollover acknowledgement control number.
        :param bool send_synchronous_acknowledgement: The value indicating whether to send synchronous acknowledgement.
        :param str acknowledgement_control_number_prefix: The acknowledgement control number prefix.
        :param str acknowledgement_control_number_suffix: The acknowledgement control number suffix.
        :param str functional_acknowledgement_version: The functional acknowledgement version.
        :param str implementation_acknowledgement_version: The implementation acknowledgement version.
        """
        pulumi.set(__self__, "acknowledgement_control_number_lower_bound", acknowledgement_control_number_lower_bound)
        pulumi.set(__self__, "acknowledgement_control_number_upper_bound", acknowledgement_control_number_upper_bound)
        pulumi.set(__self__, "batch_functional_acknowledgements", batch_functional_acknowledgements)
        pulumi.set(__self__, "batch_implementation_acknowledgements", batch_implementation_acknowledgements)
        pulumi.set(__self__, "batch_technical_acknowledgements", batch_technical_acknowledgements)
        pulumi.set(__self__, "need_functional_acknowledgement", need_functional_acknowledgement)
        pulumi.set(__self__, "need_implementation_acknowledgement", need_implementation_acknowledgement)
        pulumi.set(__self__, "need_loop_for_valid_messages", need_loop_for_valid_messages)
        pulumi.set(__self__, "need_technical_acknowledgement", need_technical_acknowledgement)
        pulumi.set(__self__, "rollover_acknowledgement_control_number", rollover_acknowledgement_control_number)
        pulumi.set(__self__, "send_synchronous_acknowledgement", send_synchronous_acknowledgement)
        if acknowledgement_control_number_prefix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_prefix", acknowledgement_control_number_prefix)
        if acknowledgement_control_number_suffix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_suffix", acknowledgement_control_number_suffix)
        if functional_acknowledgement_version is not None:
            pulumi.set(__self__, "functional_acknowledgement_version", functional_acknowledgement_version)
        if implementation_acknowledgement_version is not None:
            pulumi.set(__self__, "implementation_acknowledgement_version", implementation_acknowledgement_version)

    @property
    @pulumi.getter(name="acknowledgementControlNumberLowerBound")
    def acknowledgement_control_number_lower_bound(self) -> int:
        """
        The acknowledgement control number lower bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_lower_bound")

    @property
    @pulumi.getter(name="acknowledgementControlNumberUpperBound")
    def acknowledgement_control_number_upper_bound(self) -> int:
        """
        The acknowledgement control number upper bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_upper_bound")

    @property
    @pulumi.getter(name="batchFunctionalAcknowledgements")
    def batch_functional_acknowledgements(self) -> bool:
        """
        The value indicating whether to batch functional acknowledgements.
        """
        return pulumi.get(self, "batch_functional_acknowledgements")

    @property
    @pulumi.getter(name="batchImplementationAcknowledgements")
    def batch_implementation_acknowledgements(self) -> bool:
        """
        The value indicating whether to batch implementation acknowledgements.
        """
        return pulumi.get(self, "batch_implementation_acknowledgements")

    @property
    @pulumi.getter(name="batchTechnicalAcknowledgements")
    def batch_technical_acknowledgements(self) -> bool:
        """
        The value indicating whether to batch the technical acknowledgements.
        """
        return pulumi.get(self, "batch_technical_acknowledgements")

    @property
    @pulumi.getter(name="needFunctionalAcknowledgement")
    def need_functional_acknowledgement(self) -> bool:
        """
        The value indicating whether functional acknowledgement is needed.
        """
        return pulumi.get(self, "need_functional_acknowledgement")

    @property
    @pulumi.getter(name="needImplementationAcknowledgement")
    def need_implementation_acknowledgement(self) -> bool:
        """
        The value indicating whether implementation acknowledgement is needed.
        """
        return pulumi.get(self, "need_implementation_acknowledgement")

    @property
    @pulumi.getter(name="needLoopForValidMessages")
    def need_loop_for_valid_messages(self) -> bool:
        """
        The value indicating whether a loop is needed for valid messages.
        """
        return pulumi.get(self, "need_loop_for_valid_messages")

    @property
    @pulumi.getter(name="needTechnicalAcknowledgement")
    def need_technical_acknowledgement(self) -> bool:
        """
        The value indicating whether technical acknowledgement is needed.
        """
        return pulumi.get(self, "need_technical_acknowledgement")

    @property
    @pulumi.getter(name="rolloverAcknowledgementControlNumber")
    def rollover_acknowledgement_control_number(self) -> bool:
        """
        The value indicating whether to rollover acknowledgement control number.
        """
        return pulumi.get(self, "rollover_acknowledgement_control_number")

    @property
    @pulumi.getter(name="sendSynchronousAcknowledgement")
    def send_synchronous_acknowledgement(self) -> bool:
        """
        The value indicating whether to send synchronous acknowledgement.
        """
        return pulumi.get(self, "send_synchronous_acknowledgement")

    @property
    @pulumi.getter(name="acknowledgementControlNumberPrefix")
    def acknowledgement_control_number_prefix(self) -> Optional[str]:
        """
        The acknowledgement control number prefix.
        """
        return pulumi.get(self, "acknowledgement_control_number_prefix")

    @property
    @pulumi.getter(name="acknowledgementControlNumberSuffix")
    def acknowledgement_control_number_suffix(self) -> Optional[str]:
        """
        The acknowledgement control number suffix.
        """
        return pulumi.get(self, "acknowledgement_control_number_suffix")

    @property
    @pulumi.getter(name="functionalAcknowledgementVersion")
    def functional_acknowledgement_version(self) -> Optional[str]:
        """
        The functional acknowledgement version.
        """
        return pulumi.get(self, "functional_acknowledgement_version")

    @property
    @pulumi.getter(name="implementationAcknowledgementVersion")
    def implementation_acknowledgement_version(self) -> Optional[str]:
        """
        The implementation acknowledgement version.
        """
        return pulumi.get(self, "implementation_acknowledgement_version")


@pulumi.output_type
class X12AgreementContentResponse(dict):
    """
    The X12 agreement content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "receiveAgreement":
            suggest = "receive_agreement"
        elif key == "sendAgreement":
            suggest = "send_agreement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12AgreementContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12AgreementContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12AgreementContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 receive_agreement: 'outputs.X12OneWayAgreementResponse',
                 send_agreement: 'outputs.X12OneWayAgreementResponse'):
        """
        The X12 agreement content.
        :param 'X12OneWayAgreementResponse' receive_agreement: The X12 one-way receive agreement.
        :param 'X12OneWayAgreementResponse' send_agreement: The X12 one-way send agreement.
        """
        pulumi.set(__self__, "receive_agreement", receive_agreement)
        pulumi.set(__self__, "send_agreement", send_agreement)

    @property
    @pulumi.getter(name="receiveAgreement")
    def receive_agreement(self) -> 'outputs.X12OneWayAgreementResponse':
        """
        The X12 one-way receive agreement.
        """
        return pulumi.get(self, "receive_agreement")

    @property
    @pulumi.getter(name="sendAgreement")
    def send_agreement(self) -> 'outputs.X12OneWayAgreementResponse':
        """
        The X12 one-way send agreement.
        """
        return pulumi.get(self, "send_agreement")


@pulumi.output_type
class X12DelimiterOverridesResponse(dict):
    """
    The X12 delimiter override settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentSeparator":
            suggest = "component_separator"
        elif key == "dataElementSeparator":
            suggest = "data_element_separator"
        elif key == "replaceCharacter":
            suggest = "replace_character"
        elif key == "replaceSeparatorsInPayload":
            suggest = "replace_separators_in_payload"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"
        elif key == "segmentTerminatorSuffix":
            suggest = "segment_terminator_suffix"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "targetNamespace":
            suggest = "target_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12DelimiterOverridesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12DelimiterOverridesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12DelimiterOverridesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_separator: int,
                 data_element_separator: int,
                 replace_character: int,
                 replace_separators_in_payload: bool,
                 segment_terminator: int,
                 segment_terminator_suffix: str,
                 message_id: Optional[str] = None,
                 protocol_version: Optional[str] = None,
                 target_namespace: Optional[str] = None):
        """
        The X12 delimiter override settings.
        :param int component_separator: The component separator.
        :param int data_element_separator: The data element separator.
        :param int replace_character: The replacement character.
        :param bool replace_separators_in_payload: The value indicating whether to replace separators in payload.
        :param int segment_terminator: The segment terminator.
        :param str segment_terminator_suffix: The segment terminator suffix.
        :param str message_id: The message id.
        :param str protocol_version: The protocol version.
        :param str target_namespace: The target namespace on which this delimiter settings has to be applied.
        """
        pulumi.set(__self__, "component_separator", component_separator)
        pulumi.set(__self__, "data_element_separator", data_element_separator)
        pulumi.set(__self__, "replace_character", replace_character)
        pulumi.set(__self__, "replace_separators_in_payload", replace_separators_in_payload)
        pulumi.set(__self__, "segment_terminator", segment_terminator)
        pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> int:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> int:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @property
    @pulumi.getter(name="replaceCharacter")
    def replace_character(self) -> int:
        """
        The replacement character.
        """
        return pulumi.get(self, "replace_character")

    @property
    @pulumi.getter(name="replaceSeparatorsInPayload")
    def replace_separators_in_payload(self) -> bool:
        """
        The value indicating whether to replace separators in payload.
        """
        return pulumi.get(self, "replace_separators_in_payload")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> int:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> str:
        """
        The segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[str]:
        """
        The protocol version.
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[str]:
        """
        The target namespace on which this delimiter settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")


@pulumi.output_type
class X12EnvelopeOverrideResponse(dict):
    """
    The X12 envelope override settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateFormat":
            suggest = "date_format"
        elif key == "headerVersion":
            suggest = "header_version"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "receiverApplicationId":
            suggest = "receiver_application_id"
        elif key == "responsibleAgencyCode":
            suggest = "responsible_agency_code"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"
        elif key == "targetNamespace":
            suggest = "target_namespace"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "functionalIdentifierCode":
            suggest = "functional_identifier_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12EnvelopeOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12EnvelopeOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12EnvelopeOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_format: str,
                 header_version: str,
                 message_id: str,
                 protocol_version: str,
                 receiver_application_id: str,
                 responsible_agency_code: str,
                 sender_application_id: str,
                 target_namespace: str,
                 time_format: str,
                 functional_identifier_code: Optional[str] = None):
        """
        The X12 envelope override settings.
        :param str date_format: The date format.
        :param str header_version: The header version.
        :param str message_id: The message id on which this envelope settings has to be applied.
        :param str protocol_version: The protocol version on which this envelope settings has to be applied.
        :param str receiver_application_id: The receiver application id.
        :param str responsible_agency_code: The responsible agency code.
        :param str sender_application_id: The sender application id.
        :param str target_namespace: The target namespace on which this envelope settings has to be applied.
        :param str time_format: The time format.
        :param str functional_identifier_code: The functional identifier code.
        """
        pulumi.set(__self__, "date_format", date_format)
        pulumi.set(__self__, "header_version", header_version)
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "protocol_version", protocol_version)
        pulumi.set(__self__, "receiver_application_id", receiver_application_id)
        pulumi.set(__self__, "responsible_agency_code", responsible_agency_code)
        pulumi.set(__self__, "sender_application_id", sender_application_id)
        pulumi.set(__self__, "target_namespace", target_namespace)
        pulumi.set(__self__, "time_format", time_format)
        if functional_identifier_code is not None:
            pulumi.set(__self__, "functional_identifier_code", functional_identifier_code)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> str:
        """
        The date format.
        """
        return pulumi.get(self, "date_format")

    @property
    @pulumi.getter(name="headerVersion")
    def header_version(self) -> str:
        """
        The header version.
        """
        return pulumi.get(self, "header_version")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> str:
        """
        The message id on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> str:
        """
        The protocol version on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="receiverApplicationId")
    def receiver_application_id(self) -> str:
        """
        The receiver application id.
        """
        return pulumi.get(self, "receiver_application_id")

    @property
    @pulumi.getter(name="responsibleAgencyCode")
    def responsible_agency_code(self) -> str:
        """
        The responsible agency code.
        """
        return pulumi.get(self, "responsible_agency_code")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> str:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> str:
        """
        The target namespace on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        The time format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="functionalIdentifierCode")
    def functional_identifier_code(self) -> Optional[str]:
        """
        The functional identifier code.
        """
        return pulumi.get(self, "functional_identifier_code")


@pulumi.output_type
class X12EnvelopeSettingsResponse(dict):
    """
    The X12 agreement envelope settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controlStandardsId":
            suggest = "control_standards_id"
        elif key == "controlVersionNumber":
            suggest = "control_version_number"
        elif key == "enableDefaultGroupHeaders":
            suggest = "enable_default_group_headers"
        elif key == "groupControlNumberLowerBound":
            suggest = "group_control_number_lower_bound"
        elif key == "groupControlNumberUpperBound":
            suggest = "group_control_number_upper_bound"
        elif key == "groupHeaderAgencyCode":
            suggest = "group_header_agency_code"
        elif key == "groupHeaderDateFormat":
            suggest = "group_header_date_format"
        elif key == "groupHeaderTimeFormat":
            suggest = "group_header_time_format"
        elif key == "groupHeaderVersion":
            suggest = "group_header_version"
        elif key == "interchangeControlNumberLowerBound":
            suggest = "interchange_control_number_lower_bound"
        elif key == "interchangeControlNumberUpperBound":
            suggest = "interchange_control_number_upper_bound"
        elif key == "overwriteExistingTransactionSetControlNumber":
            suggest = "overwrite_existing_transaction_set_control_number"
        elif key == "receiverApplicationId":
            suggest = "receiver_application_id"
        elif key == "rolloverGroupControlNumber":
            suggest = "rollover_group_control_number"
        elif key == "rolloverInterchangeControlNumber":
            suggest = "rollover_interchange_control_number"
        elif key == "rolloverTransactionSetControlNumber":
            suggest = "rollover_transaction_set_control_number"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"
        elif key == "transactionSetControlNumberLowerBound":
            suggest = "transaction_set_control_number_lower_bound"
        elif key == "transactionSetControlNumberUpperBound":
            suggest = "transaction_set_control_number_upper_bound"
        elif key == "usageIndicator":
            suggest = "usage_indicator"
        elif key == "useControlStandardsIdAsRepetitionCharacter":
            suggest = "use_control_standards_id_as_repetition_character"
        elif key == "functionalGroupId":
            suggest = "functional_group_id"
        elif key == "transactionSetControlNumberPrefix":
            suggest = "transaction_set_control_number_prefix"
        elif key == "transactionSetControlNumberSuffix":
            suggest = "transaction_set_control_number_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12EnvelopeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12EnvelopeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12EnvelopeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 control_standards_id: int,
                 control_version_number: str,
                 enable_default_group_headers: bool,
                 group_control_number_lower_bound: int,
                 group_control_number_upper_bound: int,
                 group_header_agency_code: str,
                 group_header_date_format: str,
                 group_header_time_format: str,
                 group_header_version: str,
                 interchange_control_number_lower_bound: int,
                 interchange_control_number_upper_bound: int,
                 overwrite_existing_transaction_set_control_number: bool,
                 receiver_application_id: str,
                 rollover_group_control_number: bool,
                 rollover_interchange_control_number: bool,
                 rollover_transaction_set_control_number: bool,
                 sender_application_id: str,
                 transaction_set_control_number_lower_bound: int,
                 transaction_set_control_number_upper_bound: int,
                 usage_indicator: str,
                 use_control_standards_id_as_repetition_character: bool,
                 functional_group_id: Optional[str] = None,
                 transaction_set_control_number_prefix: Optional[str] = None,
                 transaction_set_control_number_suffix: Optional[str] = None):
        """
        The X12 agreement envelope settings.
        :param int control_standards_id: The controls standards id.
        :param str control_version_number: The control version number.
        :param bool enable_default_group_headers: The value indicating whether to enable default group headers.
        :param int group_control_number_lower_bound: The group control number lower bound.
        :param int group_control_number_upper_bound: The group control number upper bound.
        :param str group_header_agency_code: The group header agency code.
        :param str group_header_date_format: The group header date format.
        :param str group_header_time_format: The group header time format.
        :param str group_header_version: The group header version.
        :param int interchange_control_number_lower_bound: The interchange  control number lower bound.
        :param int interchange_control_number_upper_bound: The interchange  control number upper bound.
        :param bool overwrite_existing_transaction_set_control_number: The value indicating whether to overwrite existing transaction set control number.
        :param str receiver_application_id: The receiver application id.
        :param bool rollover_group_control_number: The value indicating whether to rollover group control number.
        :param bool rollover_interchange_control_number: The value indicating whether to rollover interchange control number.
        :param bool rollover_transaction_set_control_number: The value indicating whether to rollover transaction set control number.
        :param str sender_application_id: The sender application id.
        :param int transaction_set_control_number_lower_bound: The transaction set control number lower bound.
        :param int transaction_set_control_number_upper_bound: The transaction set control number upper bound.
        :param str usage_indicator: The usage indicator.
        :param bool use_control_standards_id_as_repetition_character: The value indicating whether to use control standards id as repetition character.
        :param str functional_group_id: The functional group id.
        :param str transaction_set_control_number_prefix: The transaction set control number prefix.
        :param str transaction_set_control_number_suffix: The transaction set control number suffix.
        """
        pulumi.set(__self__, "control_standards_id", control_standards_id)
        pulumi.set(__self__, "control_version_number", control_version_number)
        pulumi.set(__self__, "enable_default_group_headers", enable_default_group_headers)
        pulumi.set(__self__, "group_control_number_lower_bound", group_control_number_lower_bound)
        pulumi.set(__self__, "group_control_number_upper_bound", group_control_number_upper_bound)
        pulumi.set(__self__, "group_header_agency_code", group_header_agency_code)
        pulumi.set(__self__, "group_header_date_format", group_header_date_format)
        pulumi.set(__self__, "group_header_time_format", group_header_time_format)
        pulumi.set(__self__, "group_header_version", group_header_version)
        pulumi.set(__self__, "interchange_control_number_lower_bound", interchange_control_number_lower_bound)
        pulumi.set(__self__, "interchange_control_number_upper_bound", interchange_control_number_upper_bound)
        pulumi.set(__self__, "overwrite_existing_transaction_set_control_number", overwrite_existing_transaction_set_control_number)
        pulumi.set(__self__, "receiver_application_id", receiver_application_id)
        pulumi.set(__self__, "rollover_group_control_number", rollover_group_control_number)
        pulumi.set(__self__, "rollover_interchange_control_number", rollover_interchange_control_number)
        pulumi.set(__self__, "rollover_transaction_set_control_number", rollover_transaction_set_control_number)
        pulumi.set(__self__, "sender_application_id", sender_application_id)
        pulumi.set(__self__, "transaction_set_control_number_lower_bound", transaction_set_control_number_lower_bound)
        pulumi.set(__self__, "transaction_set_control_number_upper_bound", transaction_set_control_number_upper_bound)
        pulumi.set(__self__, "usage_indicator", usage_indicator)
        pulumi.set(__self__, "use_control_standards_id_as_repetition_character", use_control_standards_id_as_repetition_character)
        if functional_group_id is not None:
            pulumi.set(__self__, "functional_group_id", functional_group_id)
        if transaction_set_control_number_prefix is not None:
            pulumi.set(__self__, "transaction_set_control_number_prefix", transaction_set_control_number_prefix)
        if transaction_set_control_number_suffix is not None:
            pulumi.set(__self__, "transaction_set_control_number_suffix", transaction_set_control_number_suffix)

    @property
    @pulumi.getter(name="controlStandardsId")
    def control_standards_id(self) -> int:
        """
        The controls standards id.
        """
        return pulumi.get(self, "control_standards_id")

    @property
    @pulumi.getter(name="controlVersionNumber")
    def control_version_number(self) -> str:
        """
        The control version number.
        """
        return pulumi.get(self, "control_version_number")

    @property
    @pulumi.getter(name="enableDefaultGroupHeaders")
    def enable_default_group_headers(self) -> bool:
        """
        The value indicating whether to enable default group headers.
        """
        return pulumi.get(self, "enable_default_group_headers")

    @property
    @pulumi.getter(name="groupControlNumberLowerBound")
    def group_control_number_lower_bound(self) -> int:
        """
        The group control number lower bound.
        """
        return pulumi.get(self, "group_control_number_lower_bound")

    @property
    @pulumi.getter(name="groupControlNumberUpperBound")
    def group_control_number_upper_bound(self) -> int:
        """
        The group control number upper bound.
        """
        return pulumi.get(self, "group_control_number_upper_bound")

    @property
    @pulumi.getter(name="groupHeaderAgencyCode")
    def group_header_agency_code(self) -> str:
        """
        The group header agency code.
        """
        return pulumi.get(self, "group_header_agency_code")

    @property
    @pulumi.getter(name="groupHeaderDateFormat")
    def group_header_date_format(self) -> str:
        """
        The group header date format.
        """
        return pulumi.get(self, "group_header_date_format")

    @property
    @pulumi.getter(name="groupHeaderTimeFormat")
    def group_header_time_format(self) -> str:
        """
        The group header time format.
        """
        return pulumi.get(self, "group_header_time_format")

    @property
    @pulumi.getter(name="groupHeaderVersion")
    def group_header_version(self) -> str:
        """
        The group header version.
        """
        return pulumi.get(self, "group_header_version")

    @property
    @pulumi.getter(name="interchangeControlNumberLowerBound")
    def interchange_control_number_lower_bound(self) -> int:
        """
        The interchange  control number lower bound.
        """
        return pulumi.get(self, "interchange_control_number_lower_bound")

    @property
    @pulumi.getter(name="interchangeControlNumberUpperBound")
    def interchange_control_number_upper_bound(self) -> int:
        """
        The interchange  control number upper bound.
        """
        return pulumi.get(self, "interchange_control_number_upper_bound")

    @property
    @pulumi.getter(name="overwriteExistingTransactionSetControlNumber")
    def overwrite_existing_transaction_set_control_number(self) -> bool:
        """
        The value indicating whether to overwrite existing transaction set control number.
        """
        return pulumi.get(self, "overwrite_existing_transaction_set_control_number")

    @property
    @pulumi.getter(name="receiverApplicationId")
    def receiver_application_id(self) -> str:
        """
        The receiver application id.
        """
        return pulumi.get(self, "receiver_application_id")

    @property
    @pulumi.getter(name="rolloverGroupControlNumber")
    def rollover_group_control_number(self) -> bool:
        """
        The value indicating whether to rollover group control number.
        """
        return pulumi.get(self, "rollover_group_control_number")

    @property
    @pulumi.getter(name="rolloverInterchangeControlNumber")
    def rollover_interchange_control_number(self) -> bool:
        """
        The value indicating whether to rollover interchange control number.
        """
        return pulumi.get(self, "rollover_interchange_control_number")

    @property
    @pulumi.getter(name="rolloverTransactionSetControlNumber")
    def rollover_transaction_set_control_number(self) -> bool:
        """
        The value indicating whether to rollover transaction set control number.
        """
        return pulumi.get(self, "rollover_transaction_set_control_number")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> str:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @property
    @pulumi.getter(name="transactionSetControlNumberLowerBound")
    def transaction_set_control_number_lower_bound(self) -> int:
        """
        The transaction set control number lower bound.
        """
        return pulumi.get(self, "transaction_set_control_number_lower_bound")

    @property
    @pulumi.getter(name="transactionSetControlNumberUpperBound")
    def transaction_set_control_number_upper_bound(self) -> int:
        """
        The transaction set control number upper bound.
        """
        return pulumi.get(self, "transaction_set_control_number_upper_bound")

    @property
    @pulumi.getter(name="usageIndicator")
    def usage_indicator(self) -> str:
        """
        The usage indicator.
        """
        return pulumi.get(self, "usage_indicator")

    @property
    @pulumi.getter(name="useControlStandardsIdAsRepetitionCharacter")
    def use_control_standards_id_as_repetition_character(self) -> bool:
        """
        The value indicating whether to use control standards id as repetition character.
        """
        return pulumi.get(self, "use_control_standards_id_as_repetition_character")

    @property
    @pulumi.getter(name="functionalGroupId")
    def functional_group_id(self) -> Optional[str]:
        """
        The functional group id.
        """
        return pulumi.get(self, "functional_group_id")

    @property
    @pulumi.getter(name="transactionSetControlNumberPrefix")
    def transaction_set_control_number_prefix(self) -> Optional[str]:
        """
        The transaction set control number prefix.
        """
        return pulumi.get(self, "transaction_set_control_number_prefix")

    @property
    @pulumi.getter(name="transactionSetControlNumberSuffix")
    def transaction_set_control_number_suffix(self) -> Optional[str]:
        """
        The transaction set control number suffix.
        """
        return pulumi.get(self, "transaction_set_control_number_suffix")


@pulumi.output_type
class X12FramingSettingsResponse(dict):
    """
    The X12 agreement framing settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "characterSet":
            suggest = "character_set"
        elif key == "componentSeparator":
            suggest = "component_separator"
        elif key == "dataElementSeparator":
            suggest = "data_element_separator"
        elif key == "replaceCharacter":
            suggest = "replace_character"
        elif key == "replaceSeparatorsInPayload":
            suggest = "replace_separators_in_payload"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"
        elif key == "segmentTerminatorSuffix":
            suggest = "segment_terminator_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12FramingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12FramingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12FramingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 character_set: str,
                 component_separator: int,
                 data_element_separator: int,
                 replace_character: int,
                 replace_separators_in_payload: bool,
                 segment_terminator: int,
                 segment_terminator_suffix: str):
        """
        The X12 agreement framing settings.
        :param str character_set: The X12 character set.
        :param int component_separator: The component separator.
        :param int data_element_separator: The data element separator.
        :param int replace_character: The replacement character.
        :param bool replace_separators_in_payload: The value indicating whether to replace separators in payload.
        :param int segment_terminator: The segment terminator.
        :param str segment_terminator_suffix: The segment terminator suffix.
        """
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "component_separator", component_separator)
        pulumi.set(__self__, "data_element_separator", data_element_separator)
        pulumi.set(__self__, "replace_character", replace_character)
        pulumi.set(__self__, "replace_separators_in_payload", replace_separators_in_payload)
        pulumi.set(__self__, "segment_terminator", segment_terminator)
        pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> str:
        """
        The X12 character set.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> int:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> int:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @property
    @pulumi.getter(name="replaceCharacter")
    def replace_character(self) -> int:
        """
        The replacement character.
        """
        return pulumi.get(self, "replace_character")

    @property
    @pulumi.getter(name="replaceSeparatorsInPayload")
    def replace_separators_in_payload(self) -> bool:
        """
        The value indicating whether to replace separators in payload.
        """
        return pulumi.get(self, "replace_separators_in_payload")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> int:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> str:
        """
        The segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")


@pulumi.output_type
class X12MessageFilterResponse(dict):
    """
    The X12 message filter for odata query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageFilterType":
            suggest = "message_filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12MessageFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12MessageFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12MessageFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_filter_type: str):
        """
        The X12 message filter for odata query.
        :param str message_filter_type: The message filter type.
        """
        pulumi.set(__self__, "message_filter_type", message_filter_type)

    @property
    @pulumi.getter(name="messageFilterType")
    def message_filter_type(self) -> str:
        """
        The message filter type.
        """
        return pulumi.get(self, "message_filter_type")


@pulumi.output_type
class X12MessageIdentifierResponse(dict):
    """
    The X12 message identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageId":
            suggest = "message_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12MessageIdentifierResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12MessageIdentifierResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12MessageIdentifierResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_id: str):
        """
        The X12 message identifier.
        :param str message_id: The message id.
        """
        pulumi.set(__self__, "message_id", message_id)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> str:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")


@pulumi.output_type
class X12OneWayAgreementResponse(dict):
    """
    The X12 one-way agreement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolSettings":
            suggest = "protocol_settings"
        elif key == "receiverBusinessIdentity":
            suggest = "receiver_business_identity"
        elif key == "senderBusinessIdentity":
            suggest = "sender_business_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12OneWayAgreementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12OneWayAgreementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12OneWayAgreementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol_settings: 'outputs.X12ProtocolSettingsResponse',
                 receiver_business_identity: 'outputs.BusinessIdentityResponse',
                 sender_business_identity: 'outputs.BusinessIdentityResponse'):
        """
        The X12 one-way agreement.
        :param 'X12ProtocolSettingsResponse' protocol_settings: The X12 protocol settings.
        :param 'BusinessIdentityResponse' receiver_business_identity: The receiver business identity
        :param 'BusinessIdentityResponse' sender_business_identity: The sender business identity
        """
        pulumi.set(__self__, "protocol_settings", protocol_settings)
        pulumi.set(__self__, "receiver_business_identity", receiver_business_identity)
        pulumi.set(__self__, "sender_business_identity", sender_business_identity)

    @property
    @pulumi.getter(name="protocolSettings")
    def protocol_settings(self) -> 'outputs.X12ProtocolSettingsResponse':
        """
        The X12 protocol settings.
        """
        return pulumi.get(self, "protocol_settings")

    @property
    @pulumi.getter(name="receiverBusinessIdentity")
    def receiver_business_identity(self) -> 'outputs.BusinessIdentityResponse':
        """
        The receiver business identity
        """
        return pulumi.get(self, "receiver_business_identity")

    @property
    @pulumi.getter(name="senderBusinessIdentity")
    def sender_business_identity(self) -> 'outputs.BusinessIdentityResponse':
        """
        The sender business identity
        """
        return pulumi.get(self, "sender_business_identity")


@pulumi.output_type
class X12ProcessingSettingsResponse(dict):
    """
    The X12 processing settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "convertImpliedDecimal":
            suggest = "convert_implied_decimal"
        elif key == "createEmptyXmlTagsForTrailingSeparators":
            suggest = "create_empty_xml_tags_for_trailing_separators"
        elif key == "maskSecurityInfo":
            suggest = "mask_security_info"
        elif key == "preserveInterchange":
            suggest = "preserve_interchange"
        elif key == "suspendInterchangeOnError":
            suggest = "suspend_interchange_on_error"
        elif key == "useDotAsDecimalSeparator":
            suggest = "use_dot_as_decimal_separator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12ProcessingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12ProcessingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12ProcessingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 convert_implied_decimal: bool,
                 create_empty_xml_tags_for_trailing_separators: bool,
                 mask_security_info: bool,
                 preserve_interchange: bool,
                 suspend_interchange_on_error: bool,
                 use_dot_as_decimal_separator: bool):
        """
        The X12 processing settings.
        :param bool convert_implied_decimal: The value indicating whether to convert numerical type to implied decimal.
        :param bool create_empty_xml_tags_for_trailing_separators: The value indicating whether to create empty xml tags for trailing separators.
        :param bool mask_security_info: The value indicating whether to mask security information.
        :param bool preserve_interchange: The value indicating whether to preserve interchange.
        :param bool suspend_interchange_on_error: The value indicating whether to suspend interchange on error.
        :param bool use_dot_as_decimal_separator: The value indicating whether to use dot as decimal separator.
        """
        pulumi.set(__self__, "convert_implied_decimal", convert_implied_decimal)
        pulumi.set(__self__, "create_empty_xml_tags_for_trailing_separators", create_empty_xml_tags_for_trailing_separators)
        pulumi.set(__self__, "mask_security_info", mask_security_info)
        pulumi.set(__self__, "preserve_interchange", preserve_interchange)
        pulumi.set(__self__, "suspend_interchange_on_error", suspend_interchange_on_error)
        pulumi.set(__self__, "use_dot_as_decimal_separator", use_dot_as_decimal_separator)

    @property
    @pulumi.getter(name="convertImpliedDecimal")
    def convert_implied_decimal(self) -> bool:
        """
        The value indicating whether to convert numerical type to implied decimal.
        """
        return pulumi.get(self, "convert_implied_decimal")

    @property
    @pulumi.getter(name="createEmptyXmlTagsForTrailingSeparators")
    def create_empty_xml_tags_for_trailing_separators(self) -> bool:
        """
        The value indicating whether to create empty xml tags for trailing separators.
        """
        return pulumi.get(self, "create_empty_xml_tags_for_trailing_separators")

    @property
    @pulumi.getter(name="maskSecurityInfo")
    def mask_security_info(self) -> bool:
        """
        The value indicating whether to mask security information.
        """
        return pulumi.get(self, "mask_security_info")

    @property
    @pulumi.getter(name="preserveInterchange")
    def preserve_interchange(self) -> bool:
        """
        The value indicating whether to preserve interchange.
        """
        return pulumi.get(self, "preserve_interchange")

    @property
    @pulumi.getter(name="suspendInterchangeOnError")
    def suspend_interchange_on_error(self) -> bool:
        """
        The value indicating whether to suspend interchange on error.
        """
        return pulumi.get(self, "suspend_interchange_on_error")

    @property
    @pulumi.getter(name="useDotAsDecimalSeparator")
    def use_dot_as_decimal_separator(self) -> bool:
        """
        The value indicating whether to use dot as decimal separator.
        """
        return pulumi.get(self, "use_dot_as_decimal_separator")


@pulumi.output_type
class X12ProtocolSettingsResponse(dict):
    """
    The X12 agreement protocol settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgementSettings":
            suggest = "acknowledgement_settings"
        elif key == "envelopeSettings":
            suggest = "envelope_settings"
        elif key == "framingSettings":
            suggest = "framing_settings"
        elif key == "messageFilter":
            suggest = "message_filter"
        elif key == "processingSettings":
            suggest = "processing_settings"
        elif key == "schemaReferences":
            suggest = "schema_references"
        elif key == "securitySettings":
            suggest = "security_settings"
        elif key == "validationSettings":
            suggest = "validation_settings"
        elif key == "envelopeOverrides":
            suggest = "envelope_overrides"
        elif key == "messageFilterList":
            suggest = "message_filter_list"
        elif key == "validationOverrides":
            suggest = "validation_overrides"
        elif key == "x12DelimiterOverrides":
            suggest = "x12_delimiter_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12ProtocolSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12ProtocolSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12ProtocolSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledgement_settings: 'outputs.X12AcknowledgementSettingsResponse',
                 envelope_settings: 'outputs.X12EnvelopeSettingsResponse',
                 framing_settings: 'outputs.X12FramingSettingsResponse',
                 message_filter: 'outputs.X12MessageFilterResponse',
                 processing_settings: 'outputs.X12ProcessingSettingsResponse',
                 schema_references: Sequence['outputs.X12SchemaReferenceResponse'],
                 security_settings: 'outputs.X12SecuritySettingsResponse',
                 validation_settings: 'outputs.X12ValidationSettingsResponse',
                 envelope_overrides: Optional[Sequence['outputs.X12EnvelopeOverrideResponse']] = None,
                 message_filter_list: Optional[Sequence['outputs.X12MessageIdentifierResponse']] = None,
                 validation_overrides: Optional[Sequence['outputs.X12ValidationOverrideResponse']] = None,
                 x12_delimiter_overrides: Optional[Sequence['outputs.X12DelimiterOverridesResponse']] = None):
        """
        The X12 agreement protocol settings.
        :param 'X12AcknowledgementSettingsResponse' acknowledgement_settings: The X12 acknowledgment settings.
        :param 'X12EnvelopeSettingsResponse' envelope_settings: The X12 envelope settings.
        :param 'X12FramingSettingsResponse' framing_settings: The X12 framing settings.
        :param 'X12MessageFilterResponse' message_filter: The X12 message filter.
        :param 'X12ProcessingSettingsResponse' processing_settings: The X12 processing settings.
        :param Sequence['X12SchemaReferenceResponse'] schema_references: The X12 schema references.
        :param 'X12SecuritySettingsResponse' security_settings: The X12 security settings.
        :param 'X12ValidationSettingsResponse' validation_settings: The X12 validation settings.
        :param Sequence['X12EnvelopeOverrideResponse'] envelope_overrides: The X12 envelope override settings.
        :param Sequence['X12MessageIdentifierResponse'] message_filter_list: The X12 message filter list.
        :param Sequence['X12ValidationOverrideResponse'] validation_overrides: The X12 validation override settings.
        :param Sequence['X12DelimiterOverridesResponse'] x12_delimiter_overrides: The X12 delimiter override settings.
        """
        pulumi.set(__self__, "acknowledgement_settings", acknowledgement_settings)
        pulumi.set(__self__, "envelope_settings", envelope_settings)
        pulumi.set(__self__, "framing_settings", framing_settings)
        pulumi.set(__self__, "message_filter", message_filter)
        pulumi.set(__self__, "processing_settings", processing_settings)
        pulumi.set(__self__, "schema_references", schema_references)
        pulumi.set(__self__, "security_settings", security_settings)
        pulumi.set(__self__, "validation_settings", validation_settings)
        if envelope_overrides is not None:
            pulumi.set(__self__, "envelope_overrides", envelope_overrides)
        if message_filter_list is not None:
            pulumi.set(__self__, "message_filter_list", message_filter_list)
        if validation_overrides is not None:
            pulumi.set(__self__, "validation_overrides", validation_overrides)
        if x12_delimiter_overrides is not None:
            pulumi.set(__self__, "x12_delimiter_overrides", x12_delimiter_overrides)

    @property
    @pulumi.getter(name="acknowledgementSettings")
    def acknowledgement_settings(self) -> 'outputs.X12AcknowledgementSettingsResponse':
        """
        The X12 acknowledgment settings.
        """
        return pulumi.get(self, "acknowledgement_settings")

    @property
    @pulumi.getter(name="envelopeSettings")
    def envelope_settings(self) -> 'outputs.X12EnvelopeSettingsResponse':
        """
        The X12 envelope settings.
        """
        return pulumi.get(self, "envelope_settings")

    @property
    @pulumi.getter(name="framingSettings")
    def framing_settings(self) -> 'outputs.X12FramingSettingsResponse':
        """
        The X12 framing settings.
        """
        return pulumi.get(self, "framing_settings")

    @property
    @pulumi.getter(name="messageFilter")
    def message_filter(self) -> 'outputs.X12MessageFilterResponse':
        """
        The X12 message filter.
        """
        return pulumi.get(self, "message_filter")

    @property
    @pulumi.getter(name="processingSettings")
    def processing_settings(self) -> 'outputs.X12ProcessingSettingsResponse':
        """
        The X12 processing settings.
        """
        return pulumi.get(self, "processing_settings")

    @property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> Sequence['outputs.X12SchemaReferenceResponse']:
        """
        The X12 schema references.
        """
        return pulumi.get(self, "schema_references")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> 'outputs.X12SecuritySettingsResponse':
        """
        The X12 security settings.
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> 'outputs.X12ValidationSettingsResponse':
        """
        The X12 validation settings.
        """
        return pulumi.get(self, "validation_settings")

    @property
    @pulumi.getter(name="envelopeOverrides")
    def envelope_overrides(self) -> Optional[Sequence['outputs.X12EnvelopeOverrideResponse']]:
        """
        The X12 envelope override settings.
        """
        return pulumi.get(self, "envelope_overrides")

    @property
    @pulumi.getter(name="messageFilterList")
    def message_filter_list(self) -> Optional[Sequence['outputs.X12MessageIdentifierResponse']]:
        """
        The X12 message filter list.
        """
        return pulumi.get(self, "message_filter_list")

    @property
    @pulumi.getter(name="validationOverrides")
    def validation_overrides(self) -> Optional[Sequence['outputs.X12ValidationOverrideResponse']]:
        """
        The X12 validation override settings.
        """
        return pulumi.get(self, "validation_overrides")

    @property
    @pulumi.getter(name="x12DelimiterOverrides")
    def x12_delimiter_overrides(self) -> Optional[Sequence['outputs.X12DelimiterOverridesResponse']]:
        """
        The X12 delimiter override settings.
        """
        return pulumi.get(self, "x12_delimiter_overrides")


@pulumi.output_type
class X12SchemaReferenceResponse(dict):
    """
    The X12 schema reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageId":
            suggest = "message_id"
        elif key == "schemaName":
            suggest = "schema_name"
        elif key == "schemaVersion":
            suggest = "schema_version"
        elif key == "senderApplicationId":
            suggest = "sender_application_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12SchemaReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12SchemaReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12SchemaReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_id: str,
                 schema_name: str,
                 schema_version: str,
                 sender_application_id: Optional[str] = None):
        """
        The X12 schema reference.
        :param str message_id: The message id.
        :param str schema_name: The schema name.
        :param str schema_version: The schema version.
        :param str sender_application_id: The sender application id.
        """
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "schema_name", schema_name)
        pulumi.set(__self__, "schema_version", schema_version)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> str:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> str:
        """
        The schema name.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="schemaVersion")
    def schema_version(self) -> str:
        """
        The schema version.
        """
        return pulumi.get(self, "schema_version")

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")


@pulumi.output_type
class X12SecuritySettingsResponse(dict):
    """
    The X12 agreement security settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationQualifier":
            suggest = "authorization_qualifier"
        elif key == "securityQualifier":
            suggest = "security_qualifier"
        elif key == "authorizationValue":
            suggest = "authorization_value"
        elif key == "passwordValue":
            suggest = "password_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12SecuritySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12SecuritySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12SecuritySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_qualifier: str,
                 security_qualifier: str,
                 authorization_value: Optional[str] = None,
                 password_value: Optional[str] = None):
        """
        The X12 agreement security settings.
        :param str authorization_qualifier: The authorization qualifier.
        :param str security_qualifier: The security qualifier.
        :param str authorization_value: The authorization value.
        :param str password_value: The password value.
        """
        pulumi.set(__self__, "authorization_qualifier", authorization_qualifier)
        pulumi.set(__self__, "security_qualifier", security_qualifier)
        if authorization_value is not None:
            pulumi.set(__self__, "authorization_value", authorization_value)
        if password_value is not None:
            pulumi.set(__self__, "password_value", password_value)

    @property
    @pulumi.getter(name="authorizationQualifier")
    def authorization_qualifier(self) -> str:
        """
        The authorization qualifier.
        """
        return pulumi.get(self, "authorization_qualifier")

    @property
    @pulumi.getter(name="securityQualifier")
    def security_qualifier(self) -> str:
        """
        The security qualifier.
        """
        return pulumi.get(self, "security_qualifier")

    @property
    @pulumi.getter(name="authorizationValue")
    def authorization_value(self) -> Optional[str]:
        """
        The authorization value.
        """
        return pulumi.get(self, "authorization_value")

    @property
    @pulumi.getter(name="passwordValue")
    def password_value(self) -> Optional[str]:
        """
        The password value.
        """
        return pulumi.get(self, "password_value")


@pulumi.output_type
class X12ValidationOverrideResponse(dict):
    """
    The X12 validation override settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLeadingAndTrailingSpacesAndZeroes":
            suggest = "allow_leading_and_trailing_spaces_and_zeroes"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "trailingSeparatorPolicy":
            suggest = "trailing_separator_policy"
        elif key == "trimLeadingAndTrailingSpacesAndZeroes":
            suggest = "trim_leading_and_trailing_spaces_and_zeroes"
        elif key == "validateCharacterSet":
            suggest = "validate_character_set"
        elif key == "validateEdiTypes":
            suggest = "validate_edi_types"
        elif key == "validateXsdTypes":
            suggest = "validate_xsd_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12ValidationOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12ValidationOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12ValidationOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: bool,
                 message_id: str,
                 trailing_separator_policy: str,
                 trim_leading_and_trailing_spaces_and_zeroes: bool,
                 validate_character_set: bool,
                 validate_edi_types: bool,
                 validate_xsd_types: bool):
        """
        The X12 validation override settings.
        :param bool allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param str message_id: The message id on which the validation settings has to be applied.
        :param str trailing_separator_policy: The trailing separator policy.
        :param bool trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param bool validate_character_set: The value indicating whether to validate character Set.
        :param bool validate_edi_types: The value indicating whether to validate EDI types.
        :param bool validate_xsd_types: The value indicating whether to validate XSD types.
        """
        pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "validate_character_set", validate_character_set)
        pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> bool:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> str:
        """
        The message id on which the validation settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> str:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> bool:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="validateCharacterSet")
    def validate_character_set(self) -> bool:
        """
        The value indicating whether to validate character Set.
        """
        return pulumi.get(self, "validate_character_set")

    @property
    @pulumi.getter(name="validateEdiTypes")
    def validate_edi_types(self) -> bool:
        """
        The value indicating whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @property
    @pulumi.getter(name="validateXsdTypes")
    def validate_xsd_types(self) -> bool:
        """
        The value indicating whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")


@pulumi.output_type
class X12ValidationSettingsResponse(dict):
    """
    The X12 agreement validation settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLeadingAndTrailingSpacesAndZeroes":
            suggest = "allow_leading_and_trailing_spaces_and_zeroes"
        elif key == "checkDuplicateGroupControlNumber":
            suggest = "check_duplicate_group_control_number"
        elif key == "checkDuplicateInterchangeControlNumber":
            suggest = "check_duplicate_interchange_control_number"
        elif key == "checkDuplicateTransactionSetControlNumber":
            suggest = "check_duplicate_transaction_set_control_number"
        elif key == "interchangeControlNumberValidityDays":
            suggest = "interchange_control_number_validity_days"
        elif key == "trailingSeparatorPolicy":
            suggest = "trailing_separator_policy"
        elif key == "trimLeadingAndTrailingSpacesAndZeroes":
            suggest = "trim_leading_and_trailing_spaces_and_zeroes"
        elif key == "validateCharacterSet":
            suggest = "validate_character_set"
        elif key == "validateEdiTypes":
            suggest = "validate_edi_types"
        elif key == "validateXsdTypes":
            suggest = "validate_xsd_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X12ValidationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X12ValidationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X12ValidationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: bool,
                 check_duplicate_group_control_number: bool,
                 check_duplicate_interchange_control_number: bool,
                 check_duplicate_transaction_set_control_number: bool,
                 interchange_control_number_validity_days: int,
                 trailing_separator_policy: str,
                 trim_leading_and_trailing_spaces_and_zeroes: bool,
                 validate_character_set: bool,
                 validate_edi_types: bool,
                 validate_xsd_types: bool):
        """
        The X12 agreement validation settings.
        :param bool allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param bool check_duplicate_group_control_number: The value indicating whether to check for duplicate group control number.
        :param bool check_duplicate_interchange_control_number: The value indicating whether to check for duplicate interchange control number.
        :param bool check_duplicate_transaction_set_control_number: The value indicating whether to check for duplicate transaction set control number.
        :param int interchange_control_number_validity_days: The validity period of interchange control number.
        :param str trailing_separator_policy: The trailing separator policy.
        :param bool trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param bool validate_character_set: The value indicating whether to validate character set in the message.
        :param bool validate_edi_types: The value indicating whether to Whether to validate EDI types.
        :param bool validate_xsd_types: The value indicating whether to Whether to validate XSD types.
        """
        pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "check_duplicate_group_control_number", check_duplicate_group_control_number)
        pulumi.set(__self__, "check_duplicate_interchange_control_number", check_duplicate_interchange_control_number)
        pulumi.set(__self__, "check_duplicate_transaction_set_control_number", check_duplicate_transaction_set_control_number)
        pulumi.set(__self__, "interchange_control_number_validity_days", interchange_control_number_validity_days)
        pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "validate_character_set", validate_character_set)
        pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> bool:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="checkDuplicateGroupControlNumber")
    def check_duplicate_group_control_number(self) -> bool:
        """
        The value indicating whether to check for duplicate group control number.
        """
        return pulumi.get(self, "check_duplicate_group_control_number")

    @property
    @pulumi.getter(name="checkDuplicateInterchangeControlNumber")
    def check_duplicate_interchange_control_number(self) -> bool:
        """
        The value indicating whether to check for duplicate interchange control number.
        """
        return pulumi.get(self, "check_duplicate_interchange_control_number")

    @property
    @pulumi.getter(name="checkDuplicateTransactionSetControlNumber")
    def check_duplicate_transaction_set_control_number(self) -> bool:
        """
        The value indicating whether to check for duplicate transaction set control number.
        """
        return pulumi.get(self, "check_duplicate_transaction_set_control_number")

    @property
    @pulumi.getter(name="interchangeControlNumberValidityDays")
    def interchange_control_number_validity_days(self) -> int:
        """
        The validity period of interchange control number.
        """
        return pulumi.get(self, "interchange_control_number_validity_days")

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> str:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> bool:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @property
    @pulumi.getter(name="validateCharacterSet")
    def validate_character_set(self) -> bool:
        """
        The value indicating whether to validate character set in the message.
        """
        return pulumi.get(self, "validate_character_set")

    @property
    @pulumi.getter(name="validateEdiTypes")
    def validate_edi_types(self) -> bool:
        """
        The value indicating whether to Whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @property
    @pulumi.getter(name="validateXsdTypes")
    def validate_xsd_types(self) -> bool:
        """
        The value indicating whether to Whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")


