# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['SecurityContactArgs', 'SecurityContact']

@pulumi.input_type
class SecurityContactArgs:
    def __init__(__self__, *,
                 alert_notifications: pulumi.Input[Union[str, 'AlertNotifications']],
                 alerts_to_admins: pulumi.Input[Union[str, 'AlertsToAdmins']],
                 email: pulumi.Input[str],
                 phone: Optional[pulumi.Input[str]] = None,
                 security_contact_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecurityContact resource.
        :param pulumi.Input[Union[str, 'AlertNotifications']] alert_notifications: Whether to send security alerts notifications to the security contact
        :param pulumi.Input[Union[str, 'AlertsToAdmins']] alerts_to_admins: Whether to send security alerts notifications to subscription admins
        :param pulumi.Input[str] email: The email of this security contact
        :param pulumi.Input[str] phone: The phone number of this security contact
        :param pulumi.Input[str] security_contact_name: Name of the security contact object
        """
        pulumi.set(__self__, "alert_notifications", alert_notifications)
        pulumi.set(__self__, "alerts_to_admins", alerts_to_admins)
        pulumi.set(__self__, "email", email)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if security_contact_name is not None:
            pulumi.set(__self__, "security_contact_name", security_contact_name)

    @property
    @pulumi.getter(name="alertNotifications")
    def alert_notifications(self) -> pulumi.Input[Union[str, 'AlertNotifications']]:
        """
        Whether to send security alerts notifications to the security contact
        """
        return pulumi.get(self, "alert_notifications")

    @alert_notifications.setter
    def alert_notifications(self, value: pulumi.Input[Union[str, 'AlertNotifications']]):
        pulumi.set(self, "alert_notifications", value)

    @property
    @pulumi.getter(name="alertsToAdmins")
    def alerts_to_admins(self) -> pulumi.Input[Union[str, 'AlertsToAdmins']]:
        """
        Whether to send security alerts notifications to subscription admins
        """
        return pulumi.get(self, "alerts_to_admins")

    @alerts_to_admins.setter
    def alerts_to_admins(self, value: pulumi.Input[Union[str, 'AlertsToAdmins']]):
        pulumi.set(self, "alerts_to_admins", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The email of this security contact
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[str]]:
        """
        The phone number of this security contact
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter(name="securityContactName")
    def security_contact_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the security contact object
        """
        return pulumi.get(self, "security_contact_name")

    @security_contact_name.setter
    def security_contact_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_contact_name", value)


class SecurityContact(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_notifications: Optional[pulumi.Input[Union[str, 'AlertNotifications']]] = None,
                 alerts_to_admins: Optional[pulumi.Input[Union[str, 'AlertsToAdmins']]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 security_contact_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Contact details for security issues

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'AlertNotifications']] alert_notifications: Whether to send security alerts notifications to the security contact
        :param pulumi.Input[Union[str, 'AlertsToAdmins']] alerts_to_admins: Whether to send security alerts notifications to subscription admins
        :param pulumi.Input[str] email: The email of this security contact
        :param pulumi.Input[str] phone: The phone number of this security contact
        :param pulumi.Input[str] security_contact_name: Name of the security contact object
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityContactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Contact details for security issues

        :param str resource_name: The name of the resource.
        :param SecurityContactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityContactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_notifications: Optional[pulumi.Input[Union[str, 'AlertNotifications']]] = None,
                 alerts_to_admins: Optional[pulumi.Input[Union[str, 'AlertsToAdmins']]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 security_contact_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityContactArgs.__new__(SecurityContactArgs)

            if alert_notifications is None and not opts.urn:
                raise TypeError("Missing required property 'alert_notifications'")
            __props__.__dict__["alert_notifications"] = alert_notifications
            if alerts_to_admins is None and not opts.urn:
                raise TypeError("Missing required property 'alerts_to_admins'")
            __props__.__dict__["alerts_to_admins"] = alerts_to_admins
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["phone"] = phone
            __props__.__dict__["security_contact_name"] = security_contact_name
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:security/v20170801preview:SecurityContact"), pulumi.Alias(type_="azure-native:security:SecurityContact"), pulumi.Alias(type_="azure-nextgen:security:SecurityContact"), pulumi.Alias(type_="azure-native:security/v20200101preview:SecurityContact"), pulumi.Alias(type_="azure-nextgen:security/v20200101preview:SecurityContact")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SecurityContact, __self__).__init__(
            'azure-native:security/v20170801preview:SecurityContact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SecurityContact':
        """
        Get an existing SecurityContact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SecurityContactArgs.__new__(SecurityContactArgs)

        __props__.__dict__["alert_notifications"] = None
        __props__.__dict__["alerts_to_admins"] = None
        __props__.__dict__["email"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["phone"] = None
        __props__.__dict__["type"] = None
        return SecurityContact(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertNotifications")
    def alert_notifications(self) -> pulumi.Output[str]:
        """
        Whether to send security alerts notifications to the security contact
        """
        return pulumi.get(self, "alert_notifications")

    @property
    @pulumi.getter(name="alertsToAdmins")
    def alerts_to_admins(self) -> pulumi.Output[str]:
        """
        Whether to send security alerts notifications to subscription admins
        """
        return pulumi.get(self, "alerts_to_admins")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The email of this security contact
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Output[Optional[str]]:
        """
        The phone number of this security contact
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

