# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['CapacityDetailsArgs', 'CapacityDetails']

@pulumi.input_type
class CapacityDetailsArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 sku: pulumi.Input['CapacitySkuArgs'],
                 administration: Optional[pulumi.Input['DedicatedCapacityAdministratorsArgs']] = None,
                 dedicated_capacity_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'Mode']]] = None,
                 system_data: Optional[pulumi.Input['SystemDataArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CapacityDetails resource.
        :param pulumi.Input[str] resource_group_name: The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
        :param pulumi.Input['CapacitySkuArgs'] sku: The SKU of the PowerBI Dedicated capacity resource.
        :param pulumi.Input['DedicatedCapacityAdministratorsArgs'] administration: A collection of Dedicated capacity administrators
        :param pulumi.Input[str] dedicated_capacity_name: The name of the Dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
        :param pulumi.Input[str] location: Location of the PowerBI Dedicated resource.
        :param pulumi.Input[Union[str, 'Mode']] mode: Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
        :param pulumi.Input['SystemDataArgs'] system_data: Metadata pertaining to creation and last modification of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value pairs of additional resource provisioning properties.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if administration is not None:
            pulumi.set(__self__, "administration", administration)
        if dedicated_capacity_name is not None:
            pulumi.set(__self__, "dedicated_capacity_name", dedicated_capacity_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if system_data is not None:
            pulumi.set(__self__, "system_data", system_data)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input['CapacitySkuArgs']:
        """
        The SKU of the PowerBI Dedicated capacity resource.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['CapacitySkuArgs']):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def administration(self) -> Optional[pulumi.Input['DedicatedCapacityAdministratorsArgs']]:
        """
        A collection of Dedicated capacity administrators
        """
        return pulumi.get(self, "administration")

    @administration.setter
    def administration(self, value: Optional[pulumi.Input['DedicatedCapacityAdministratorsArgs']]):
        pulumi.set(self, "administration", value)

    @property
    @pulumi.getter(name="dedicatedCapacityName")
    def dedicated_capacity_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
        """
        return pulumi.get(self, "dedicated_capacity_name")

    @dedicated_capacity_name.setter
    def dedicated_capacity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_capacity_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the PowerBI Dedicated resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'Mode']]]:
        """
        Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'Mode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> Optional[pulumi.Input['SystemDataArgs']]:
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @system_data.setter
    def system_data(self, value: Optional[pulumi.Input['SystemDataArgs']]):
        pulumi.set(self, "system_data", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value pairs of additional resource provisioning properties.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class CapacityDetails(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administration: Optional[pulumi.Input[pulumi.InputType['DedicatedCapacityAdministratorsArgs']]] = None,
                 dedicated_capacity_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'Mode']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[pulumi.InputType['CapacitySkuArgs']]] = None,
                 system_data: Optional[pulumi.Input[pulumi.InputType['SystemDataArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Represents an instance of a Dedicated Capacity resource.
        API Version: 2021-01-01.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DedicatedCapacityAdministratorsArgs']] administration: A collection of Dedicated capacity administrators
        :param pulumi.Input[str] dedicated_capacity_name: The name of the Dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
        :param pulumi.Input[str] location: Location of the PowerBI Dedicated resource.
        :param pulumi.Input[Union[str, 'Mode']] mode: Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
        :param pulumi.Input[str] resource_group_name: The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
        :param pulumi.Input[pulumi.InputType['CapacitySkuArgs']] sku: The SKU of the PowerBI Dedicated capacity resource.
        :param pulumi.Input[pulumi.InputType['SystemDataArgs']] system_data: Metadata pertaining to creation and last modification of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value pairs of additional resource provisioning properties.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CapacityDetailsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an instance of a Dedicated Capacity resource.
        API Version: 2021-01-01.

        :param str resource_name: The name of the resource.
        :param CapacityDetailsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CapacityDetailsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administration: Optional[pulumi.Input[pulumi.InputType['DedicatedCapacityAdministratorsArgs']]] = None,
                 dedicated_capacity_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'Mode']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[pulumi.InputType['CapacitySkuArgs']]] = None,
                 system_data: Optional[pulumi.Input[pulumi.InputType['SystemDataArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CapacityDetailsArgs.__new__(CapacityDetailsArgs)

            __props__.__dict__["administration"] = administration
            __props__.__dict__["dedicated_capacity_name"] = dedicated_capacity_name
            __props__.__dict__["location"] = location
            __props__.__dict__["mode"] = mode
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["system_data"] = system_data
            __props__.__dict__["tags"] = tags
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:powerbidedicated:CapacityDetails"), pulumi.Alias(type_="azure-native:powerbidedicated/v20171001:CapacityDetails"), pulumi.Alias(type_="azure-nextgen:powerbidedicated/v20171001:CapacityDetails"), pulumi.Alias(type_="azure-native:powerbidedicated/v20210101:CapacityDetails"), pulumi.Alias(type_="azure-nextgen:powerbidedicated/v20210101:CapacityDetails")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(CapacityDetails, __self__).__init__(
            'azure-native:powerbidedicated:CapacityDetails',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CapacityDetails':
        """
        Get an existing CapacityDetails resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CapacityDetailsArgs.__new__(CapacityDetailsArgs)

        __props__.__dict__["administration"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["mode"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["sku"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return CapacityDetails(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def administration(self) -> pulumi.Output[Optional['outputs.DedicatedCapacityAdministratorsResponse']]:
        """
        A collection of Dedicated capacity administrators
        """
        return pulumi.get(self, "administration")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Location of the PowerBI Dedicated resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2)
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the PowerBI Dedicated resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The current deployment state of PowerBI Dedicated resource. The provisioningState is to indicate states for resource provisioning.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.CapacitySkuResponse']:
        """
        The SKU of the PowerBI Dedicated capacity resource.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of PowerBI Dedicated resource. The state is to indicate more states outside of resource provisioning.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output[Optional['outputs.SystemDataResponse']]:
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value pairs of additional resource provisioning properties.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the PowerBI Dedicated resource.
        """
        return pulumi.get(self, "type")

