# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConnectorCollectionErrorInfoResponse',
    'ConnectorCollectionInfoResponse',
    'ReportAggregationResponse',
    'ReportComparisonExpressionResponse',
    'ReportDatasetConfigurationResponse',
    'ReportDatasetResponse',
    'ReportDefinitionResponse',
    'ReportDeliveryDestinationResponse',
    'ReportDeliveryInfoResponse',
    'ReportFilterResponse',
    'ReportGroupingResponse',
    'ReportRecurrencePeriodResponse',
    'ReportScheduleResponse',
    'ReportTimePeriodResponse',
]

@pulumi.output_type
class ConnectorCollectionErrorInfoResponse(dict):
    """
    Details of any error encountered on last collection attempt
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "errorStartTime":
            suggest = "error_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorCollectionErrorInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorCollectionErrorInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorCollectionErrorInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: str,
                 error_message: str,
                 error_start_time: str):
        """
        Details of any error encountered on last collection attempt
        :param str error_code: Short error message
        :param str error_message: Detailed error message
        :param str error_start_time: Time the error started occurring (Last time error occurred in lastRun)
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "error_start_time", error_start_time)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        Short error message
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        Detailed error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="errorStartTime")
    def error_start_time(self) -> str:
        """
        Time the error started occurring (Last time error occurred in lastRun)
        """
        return pulumi.get(self, "error_start_time")


@pulumi.output_type
class ConnectorCollectionInfoResponse(dict):
    """
    Collection and ingestion information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRun":
            suggest = "last_run"
        elif key == "lastUpdated":
            suggest = "last_updated"
        elif key == "sourceLastUpdated":
            suggest = "source_last_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorCollectionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorCollectionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorCollectionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_run: str,
                 last_updated: str,
                 source_last_updated: str,
                 error: Optional['outputs.ConnectorCollectionErrorInfoResponse'] = None):
        """
        Collection and ingestion information
        :param str last_run: Last time the data acquisition process completed (even if no new data was found)
        :param str last_updated: Last time the external data was updated into Azure
        :param str source_last_updated: Source timestamp of external data currently available in Azure (eg AWS last processed CUR file timestamp)
        :param 'ConnectorCollectionErrorInfoResponse' error: Error information of last collection
        """
        pulumi.set(__self__, "last_run", last_run)
        pulumi.set(__self__, "last_updated", last_updated)
        pulumi.set(__self__, "source_last_updated", source_last_updated)
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter(name="lastRun")
    def last_run(self) -> str:
        """
        Last time the data acquisition process completed (even if no new data was found)
        """
        return pulumi.get(self, "last_run")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> str:
        """
        Last time the external data was updated into Azure
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter(name="sourceLastUpdated")
    def source_last_updated(self) -> str:
        """
        Source timestamp of external data currently available in Azure (eg AWS last processed CUR file timestamp)
        """
        return pulumi.get(self, "source_last_updated")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ConnectorCollectionErrorInfoResponse']:
        """
        Error information of last collection
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class ReportAggregationResponse(dict):
    """
    The aggregation expression to be used in the report.
    """
    def __init__(__self__, *,
                 function: str,
                 name: str):
        """
        The aggregation expression to be used in the report.
        :param str function: The name of the aggregation function to use.
        :param str name: The name of the column to aggregate.
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def function(self) -> str:
        """
        The name of the aggregation function to use.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to aggregate.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ReportComparisonExpressionResponse(dict):
    """
    The comparison expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        The comparison expression to be used in the report.
        :param str name: The name of the column to use in comparison.
        :param str operator: The operator to use for comparison.
        :param Sequence[str] values: Array of values to use for comparison
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to use in comparison.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use for comparison.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Array of values to use for comparison
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ReportDatasetConfigurationResponse(dict):
    """
    The configuration of dataset in the report.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence[str]] = None):
        """
        The configuration of dataset in the report.
        :param Sequence[str] columns: Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence[str]]:
        """
        Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class ReportDatasetResponse(dict):
    """
    The definition of data present in the report.
    """
    def __init__(__self__, *,
                 aggregation: Optional[Mapping[str, 'outputs.ReportAggregationResponse']] = None,
                 configuration: Optional['outputs.ReportDatasetConfigurationResponse'] = None,
                 filter: Optional['outputs.ReportFilterResponse'] = None,
                 granularity: Optional[str] = None,
                 grouping: Optional[Sequence['outputs.ReportGroupingResponse']] = None):
        """
        The definition of data present in the report.
        :param Mapping[str, 'ReportAggregationResponse'] aggregation: Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        :param 'ReportDatasetConfigurationResponse' configuration: Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        :param 'ReportFilterResponse' filter: Has filter expression to use in the report.
        :param str granularity: The granularity of rows in the report.
        :param Sequence['ReportGroupingResponse'] grouping: Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        """
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if grouping is not None:
            pulumi.set(__self__, "grouping", grouping)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[Mapping[str, 'outputs.ReportAggregationResponse']]:
        """
        Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.ReportDatasetConfigurationResponse']:
        """
        Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.ReportFilterResponse']:
        """
        Has filter expression to use in the report.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def granularity(self) -> Optional[str]:
        """
        The granularity of rows in the report.
        """
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def grouping(self) -> Optional[Sequence['outputs.ReportGroupingResponse']]:
        """
        Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        """
        return pulumi.get(self, "grouping")


@pulumi.output_type
class ReportDefinitionResponse(dict):
    """
    The definition of a report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timePeriod":
            suggest = "time_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeframe: str,
                 type: str,
                 dataset: Optional['outputs.ReportDatasetResponse'] = None,
                 time_period: Optional['outputs.ReportTimePeriodResponse'] = None):
        """
        The definition of a report.
        :param str timeframe: The time frame for pulling data for the report. If custom, then a specific time period must be provided.
        :param str type: The type of the report.
        :param 'ReportDatasetResponse' dataset: Has definition for data in this report.
        :param 'ReportTimePeriodResponse' time_period: Has time period for pulling data for the report.
        """
        pulumi.set(__self__, "timeframe", timeframe)
        pulumi.set(__self__, "type", type)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if time_period is not None:
            pulumi.set(__self__, "time_period", time_period)

    @property
    @pulumi.getter
    def timeframe(self) -> str:
        """
        The time frame for pulling data for the report. If custom, then a specific time period must be provided.
        """
        return pulumi.get(self, "timeframe")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the report.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def dataset(self) -> Optional['outputs.ReportDatasetResponse']:
        """
        Has definition for data in this report.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> Optional['outputs.ReportTimePeriodResponse']:
        """
        Has time period for pulling data for the report.
        """
        return pulumi.get(self, "time_period")


@pulumi.output_type
class ReportDeliveryDestinationResponse(dict):
    """
    The destination information for the delivery of the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "rootFolderPath":
            suggest = "root_folder_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportDeliveryDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportDeliveryDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportDeliveryDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: str,
                 resource_id: str,
                 root_folder_path: Optional[str] = None):
        """
        The destination information for the delivery of the report.
        :param str container: The name of the container where reports will be uploaded.
        :param str resource_id: The resource id of the storage account where reports will be delivered.
        :param str root_folder_path: The name of the directory where reports will be uploaded.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "resource_id", resource_id)
        if root_folder_path is not None:
            pulumi.set(__self__, "root_folder_path", root_folder_path)

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the container where reports will be uploaded.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource id of the storage account where reports will be delivered.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> Optional[str]:
        """
        The name of the directory where reports will be uploaded.
        """
        return pulumi.get(self, "root_folder_path")


@pulumi.output_type
class ReportDeliveryInfoResponse(dict):
    """
    The delivery information associated with a report.
    """
    def __init__(__self__, *,
                 destination: 'outputs.ReportDeliveryDestinationResponse'):
        """
        The delivery information associated with a report.
        :param 'ReportDeliveryDestinationResponse' destination: Has destination for the report being delivered.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.ReportDeliveryDestinationResponse':
        """
        Has destination for the report being delivered.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class ReportFilterResponse(dict):
    """
    The filter expression to be used in the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"
        elif key == "not":
            suggest = "not_"
        elif key == "or":
            suggest = "or_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional[Sequence['outputs.ReportFilterResponse']] = None,
                 dimension: Optional['outputs.ReportComparisonExpressionResponse'] = None,
                 not_: Optional['outputs.ReportFilterResponse'] = None,
                 or_: Optional[Sequence['outputs.ReportFilterResponse']] = None,
                 tag: Optional['outputs.ReportComparisonExpressionResponse'] = None):
        """
        The filter expression to be used in the report.
        :param Sequence['ReportFilterResponse'] and_: The logical "AND" expression. Must have at least 2 items.
        :param 'ReportComparisonExpressionResponse' dimension: Has comparison expression for a dimension
        :param 'ReportFilterResponse' not_: The logical "NOT" expression.
        :param Sequence['ReportFilterResponse'] or_: The logical "OR" expression. Must have at least 2 items.
        :param 'ReportComparisonExpressionResponse' tag: Has comparison expression for a tag
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if dimension is not None:
            pulumi.set(__self__, "dimension", dimension)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if or_ is not None:
            pulumi.set(__self__, "or_", or_)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional[Sequence['outputs.ReportFilterResponse']]:
        """
        The logical "AND" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter
    def dimension(self) -> Optional['outputs.ReportComparisonExpressionResponse']:
        """
        Has comparison expression for a dimension
        """
        return pulumi.get(self, "dimension")

    @property
    @pulumi.getter(name="not")
    def not_(self) -> Optional['outputs.ReportFilterResponse']:
        """
        The logical "NOT" expression.
        """
        return pulumi.get(self, "not_")

    @property
    @pulumi.getter(name="or")
    def or_(self) -> Optional[Sequence['outputs.ReportFilterResponse']]:
        """
        The logical "OR" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "or_")

    @property
    @pulumi.getter
    def tag(self) -> Optional['outputs.ReportComparisonExpressionResponse']:
        """
        Has comparison expression for a tag
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class ReportGroupingResponse(dict):
    """
    The group by expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        The group by expression to be used in the report.
        :param str name: The name of the column to group.
        :param str type: Has type of the column to group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Has type of the column to group.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReportRecurrencePeriodResponse(dict):
    """
    The start and end date for recurrence schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportRecurrencePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportRecurrencePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportRecurrencePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: Optional[str] = None):
        """
        The start and end date for recurrence schedule.
        :param str from_: The start date of recurrence.
        :param str to: The end date of recurrence.
        """
        pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date of recurrence.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> Optional[str]:
        """
        The end date of recurrence.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class ReportScheduleResponse(dict):
    """
    The schedule associated with a report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurrencePeriod":
            suggest = "recurrence_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurrence: str,
                 recurrence_period: Optional['outputs.ReportRecurrencePeriodResponse'] = None,
                 status: Optional[str] = None):
        """
        The schedule associated with a report.
        :param str recurrence: The schedule recurrence.
        :param 'ReportRecurrencePeriodResponse' recurrence_period: Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        :param str status: The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
        """
        pulumi.set(__self__, "recurrence", recurrence)
        if recurrence_period is not None:
            pulumi.set(__self__, "recurrence_period", recurrence_period)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def recurrence(self) -> str:
        """
        The schedule recurrence.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="recurrencePeriod")
    def recurrence_period(self) -> Optional['outputs.ReportRecurrencePeriodResponse']:
        """
        Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        """
        return pulumi.get(self, "recurrence_period")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ReportTimePeriodResponse(dict):
    """
    The start and end date for pulling data for the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportTimePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportTimePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportTimePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: str):
        """
        The start and end date for pulling data for the report.
        :param str from_: The start date to pull data from.
        :param str to: The end date to pull data to.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date to pull data from.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> str:
        """
        The end date to pull data to.
        """
        return pulumi.get(self, "to")


