# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ControllerConnectionDetailsResponse',
    'KubernetesConnectionDetailsResponse',
    'SkuResponse',
]

@pulumi.output_type
class ControllerConnectionDetailsResponse(dict):
    def __init__(__self__, *,
                 orchestrator_specific_connection_details: Optional['outputs.KubernetesConnectionDetailsResponse'] = None):
        """
        :param 'KubernetesConnectionDetailsResponse' orchestrator_specific_connection_details: Base class for types that supply values used to connect to container orchestrators
        """
        if orchestrator_specific_connection_details is not None:
            pulumi.set(__self__, "orchestrator_specific_connection_details", orchestrator_specific_connection_details)

    @property
    @pulumi.getter(name="orchestratorSpecificConnectionDetails")
    def orchestrator_specific_connection_details(self) -> Optional['outputs.KubernetesConnectionDetailsResponse']:
        """
        Base class for types that supply values used to connect to container orchestrators
        """
        return pulumi.get(self, "orchestrator_specific_connection_details")


@pulumi.output_type
class KubernetesConnectionDetailsResponse(dict):
    """
    Contains information used to connect to a Kubernetes cluster
    """
    def __init__(__self__, *,
                 instance_type: str,
                 kube_config: Optional[str] = None):
        """
        Contains information used to connect to a Kubernetes cluster
        :param str instance_type: Gets the Instance type.
               Expected value is 'Kubernetes'.
        :param str kube_config: Gets the kubeconfig for the cluster.
        """
        pulumi.set(__self__, "instance_type", 'Kubernetes')
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets the Instance type.
        Expected value is 'Kubernetes'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> Optional[str]:
        """
        Gets the kubeconfig for the cluster.
        """
        return pulumi.get(self, "kube_config")


@pulumi.output_type
class SkuResponse(dict):
    """
    Model representing SKU for Azure Dev Spaces Controller.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: Optional[str] = None):
        """
        Model representing SKU for Azure Dev Spaces Controller.
        :param str name: The name of the SKU for Azure Dev Spaces Controller.
        :param str tier: The tier of the SKU for Azure Dev Spaces Controller.
        """
        pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU for Azure Dev Spaces Controller.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier of the SKU for Azure Dev Spaces Controller.
        """
        return pulumi.get(self, "tier")


