# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BasicLoginInformationResponse',
    'DataControllerPropertiesResponse',
    'ExtendedLocationResponse',
    'K8sResourceRequirementsResponse',
    'K8sSchedulingOptionsResponse',
    'K8sSchedulingResponse',
    'LogAnalyticsWorkspaceConfigResponse',
    'OnPremisePropertyResponse',
    'SqlManagedInstanceK8sRawResponse',
    'SqlManagedInstanceK8sSpecResponse',
    'SqlManagedInstancePropertiesResponse',
    'SqlManagedInstanceSkuResponse',
    'SqlServerInstancePropertiesResponse',
    'SystemDataResponse',
    'UploadServicePrincipalResponse',
    'UploadWatermarkResponse',
]

@pulumi.output_type
class BasicLoginInformationResponse(dict):
    """
    Username and password for basic login authentication.
    """
    def __init__(__self__, *,
                 username: Optional[str] = None):
        """
        Username and password for basic login authentication.
        :param str username: Login username.
        """
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Login username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class DataControllerPropertiesResponse(dict):
    """
    The data controller properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "basicLoginInformation":
            suggest = "basic_login_information"
        elif key == "clusterId":
            suggest = "cluster_id"
        elif key == "extensionId":
            suggest = "extension_id"
        elif key == "k8sRaw":
            suggest = "k8s_raw"
        elif key == "lastUploadedDate":
            suggest = "last_uploaded_date"
        elif key == "logAnalyticsWorkspaceConfig":
            suggest = "log_analytics_workspace_config"
        elif key == "logsDashboardCredential":
            suggest = "logs_dashboard_credential"
        elif key == "metricsDashboardCredential":
            suggest = "metrics_dashboard_credential"
        elif key == "onPremiseProperty":
            suggest = "on_premise_property"
        elif key == "uploadServicePrincipal":
            suggest = "upload_service_principal"
        elif key == "uploadWatermark":
            suggest = "upload_watermark"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataControllerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataControllerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataControllerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 basic_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 cluster_id: Optional[str] = None,
                 extension_id: Optional[str] = None,
                 infrastructure: Optional[str] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[str] = None,
                 log_analytics_workspace_config: Optional['outputs.LogAnalyticsWorkspaceConfigResponse'] = None,
                 logs_dashboard_credential: Optional['outputs.BasicLoginInformationResponse'] = None,
                 metrics_dashboard_credential: Optional['outputs.BasicLoginInformationResponse'] = None,
                 on_premise_property: Optional['outputs.OnPremisePropertyResponse'] = None,
                 upload_service_principal: Optional['outputs.UploadServicePrincipalResponse'] = None,
                 upload_watermark: Optional['outputs.UploadWatermarkResponse'] = None):
        """
        The data controller properties.
        :param 'BasicLoginInformationResponse' basic_login_information: Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
        :param str cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        :param str extension_id: If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        :param str infrastructure: The infrastructure the data controller is running on.
        :param Any k8s_raw: The raw kubernetes information
        :param str last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param 'LogAnalyticsWorkspaceConfigResponse' log_analytics_workspace_config: Log analytics workspace id and primary key
        :param 'BasicLoginInformationResponse' logs_dashboard_credential: Login credential for logs dashboard on the Kubernetes cluster.
        :param 'BasicLoginInformationResponse' metrics_dashboard_credential: Login credential for metrics dashboard on the Kubernetes cluster.
        :param 'OnPremisePropertyResponse' on_premise_property: Properties from the Kubernetes data controller
        :param 'UploadServicePrincipalResponse' upload_service_principal: Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
        :param 'UploadWatermarkResponse' upload_watermark: Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if extension_id is not None:
            pulumi.set(__self__, "extension_id", extension_id)
        if infrastructure is None:
            infrastructure = 'other'
        if infrastructure is not None:
            pulumi.set(__self__, "infrastructure", infrastructure)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if log_analytics_workspace_config is not None:
            pulumi.set(__self__, "log_analytics_workspace_config", log_analytics_workspace_config)
        if logs_dashboard_credential is not None:
            pulumi.set(__self__, "logs_dashboard_credential", logs_dashboard_credential)
        if metrics_dashboard_credential is not None:
            pulumi.set(__self__, "metrics_dashboard_credential", metrics_dashboard_credential)
        if on_premise_property is not None:
            pulumi.set(__self__, "on_premise_property", on_premise_property)
        if upload_service_principal is not None:
            pulumi.set(__self__, "upload_service_principal", upload_service_principal)
        if upload_watermark is not None:
            pulumi.set(__self__, "upload_watermark", upload_watermark)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
        """
        return pulumi.get(self, "basic_login_information")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="extensionId")
    def extension_id(self) -> Optional[str]:
        """
        If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        """
        return pulumi.get(self, "extension_id")

    @property
    @pulumi.getter
    def infrastructure(self) -> Optional[str]:
        """
        The infrastructure the data controller is running on.
        """
        return pulumi.get(self, "infrastructure")

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[str]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceConfig")
    def log_analytics_workspace_config(self) -> Optional['outputs.LogAnalyticsWorkspaceConfigResponse']:
        """
        Log analytics workspace id and primary key
        """
        return pulumi.get(self, "log_analytics_workspace_config")

    @property
    @pulumi.getter(name="logsDashboardCredential")
    def logs_dashboard_credential(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Login credential for logs dashboard on the Kubernetes cluster.
        """
        return pulumi.get(self, "logs_dashboard_credential")

    @property
    @pulumi.getter(name="metricsDashboardCredential")
    def metrics_dashboard_credential(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Login credential for metrics dashboard on the Kubernetes cluster.
        """
        return pulumi.get(self, "metrics_dashboard_credential")

    @property
    @pulumi.getter(name="onPremiseProperty")
    def on_premise_property(self) -> Optional['outputs.OnPremisePropertyResponse']:
        """
        Properties from the Kubernetes data controller
        """
        return pulumi.get(self, "on_premise_property")

    @property
    @pulumi.getter(name="uploadServicePrincipal")
    def upload_service_principal(self) -> Optional['outputs.UploadServicePrincipalResponse']:
        """
        Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
        """
        return pulumi.get(self, "upload_service_principal")

    @property
    @pulumi.getter(name="uploadWatermark")
    def upload_watermark(self) -> Optional['outputs.UploadWatermarkResponse']:
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        return pulumi.get(self, "upload_watermark")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    The complex type of the extended location.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The complex type of the extended location.
        :param str name: The name of the extended location.
        :param str type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class K8sResourceRequirementsResponse(dict):
    """
    The kubernetes resource limits and requests used to restrict or reserve resource usage.
    """
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, str]] = None,
                 requests: Optional[Mapping[str, str]] = None):
        """
        The kubernetes resource limits and requests used to restrict or reserve resource usage.
        :param Mapping[str, str] limits: Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        :param Mapping[str, str] requests: Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        """
        Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Mapping[str, str]]:
        """
        Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class K8sSchedulingOptionsResponse(dict):
    """
    The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
    """
    def __init__(__self__, *,
                 resources: Optional['outputs.K8sResourceRequirementsResponse'] = None):
        """
        The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
        :param 'K8sResourceRequirementsResponse' resources: The kubernetes resource limits and requests used to restrict or reserve resource usage.
        """
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.K8sResourceRequirementsResponse']:
        """
        The kubernetes resource limits and requests used to restrict or reserve resource usage.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class K8sSchedulingResponse(dict):
    """
    The kubernetes scheduling information.
    """
    def __init__(__self__, *,
                 default: Optional['outputs.K8sSchedulingOptionsResponse'] = None):
        """
        The kubernetes scheduling information.
        :param 'K8sSchedulingOptionsResponse' default: The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
        """
        if default is not None:
            pulumi.set(__self__, "default", default)

    @property
    @pulumi.getter
    def default(self) -> Optional['outputs.K8sSchedulingOptionsResponse']:
        """
        The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
        """
        return pulumi.get(self, "default")


@pulumi.output_type
class LogAnalyticsWorkspaceConfigResponse(dict):
    """
    Log analytics workspace id and primary key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogAnalyticsWorkspaceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogAnalyticsWorkspaceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogAnalyticsWorkspaceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workspace_id: Optional[str] = None):
        """
        Log analytics workspace id and primary key
        :param str workspace_id: Azure Log Analytics workspace ID
        """
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[str]:
        """
        Azure Log Analytics workspace ID
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class OnPremisePropertyResponse(dict):
    """
    Properties from the Kubernetes data controller
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicSigningKey":
            suggest = "public_signing_key"
        elif key == "signingCertificateThumbprint":
            suggest = "signing_certificate_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnPremisePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnPremisePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnPremisePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 public_signing_key: str,
                 signing_certificate_thumbprint: Optional[str] = None):
        """
        Properties from the Kubernetes data controller
        :param str id: A globally unique ID identifying the associated Kubernetes cluster
        :param str public_signing_key: Certificate that contains the Kubernetes cluster public key used to verify signing
        :param str signing_certificate_thumbprint: Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "public_signing_key", public_signing_key)
        if signing_certificate_thumbprint is not None:
            pulumi.set(__self__, "signing_certificate_thumbprint", signing_certificate_thumbprint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A globally unique ID identifying the associated Kubernetes cluster
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="publicSigningKey")
    def public_signing_key(self) -> str:
        """
        Certificate that contains the Kubernetes cluster public key used to verify signing
        """
        return pulumi.get(self, "public_signing_key")

    @property
    @pulumi.getter(name="signingCertificateThumbprint")
    def signing_certificate_thumbprint(self) -> Optional[str]:
        """
        Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        return pulumi.get(self, "signing_certificate_thumbprint")


@pulumi.output_type
class SqlManagedInstanceK8sRawResponse(dict):
    """
    The raw kubernetes information.
    """
    def __init__(__self__, *,
                 spec: Optional['outputs.SqlManagedInstanceK8sSpecResponse'] = None):
        """
        The raw kubernetes information.
        :param 'SqlManagedInstanceK8sSpecResponse' spec: The kubernetes spec information.
        """
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.SqlManagedInstanceK8sSpecResponse']:
        """
        The kubernetes spec information.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class SqlManagedInstanceK8sSpecResponse(dict):
    """
    The kubernetes spec information.
    """
    def __init__(__self__, *,
                 replicas: Optional[int] = None,
                 scheduling: Optional['outputs.K8sSchedulingResponse'] = None):
        """
        The kubernetes spec information.
        :param int replicas: This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
        :param 'K8sSchedulingResponse' scheduling: The kubernetes scheduling information.
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[int]:
        """
        This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter
    def scheduling(self) -> Optional['outputs.K8sSchedulingResponse']:
        """
        The kubernetes scheduling information.
        """
        return pulumi.get(self, "scheduling")


@pulumi.output_type
class SqlManagedInstancePropertiesResponse(dict):
    """
    Properties of sqlManagedInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "basicLoginInformation":
            suggest = "basic_login_information"
        elif key == "clusterId":
            suggest = "cluster_id"
        elif key == "dataControllerId":
            suggest = "data_controller_id"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "extensionId":
            suggest = "extension_id"
        elif key == "k8sRaw":
            suggest = "k8s_raw"
        elif key == "lastUploadedDate":
            suggest = "last_uploaded_date"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlManagedInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlManagedInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlManagedInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 admin: Optional[str] = None,
                 basic_login_information: Optional['outputs.BasicLoginInformationResponse'] = None,
                 cluster_id: Optional[str] = None,
                 data_controller_id: Optional[str] = None,
                 end_time: Optional[str] = None,
                 extension_id: Optional[str] = None,
                 k8s_raw: Optional['outputs.SqlManagedInstanceK8sRawResponse'] = None,
                 last_uploaded_date: Optional[str] = None,
                 license_type: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        Properties of sqlManagedInstance.
        :param str admin: The instance admin user
        :param 'BasicLoginInformationResponse' basic_login_information: Username and password for basic authentication.
        :param str cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        :param str data_controller_id: null
        :param str end_time: The instance end time
        :param str extension_id: If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        :param 'SqlManagedInstanceK8sRawResponse' k8s_raw: The raw kubernetes information
        :param str last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param str license_type: The license type to apply for this managed instance.
        :param str start_time: The instance start time
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data_controller_id is not None:
            pulumi.set(__self__, "data_controller_id", data_controller_id)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if extension_id is not None:
            pulumi.set(__self__, "extension_id", extension_id)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if license_type is None:
            license_type = 'BasePrice'
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def admin(self) -> Optional[str]:
        """
        The instance admin user
        """
        return pulumi.get(self, "admin")

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional['outputs.BasicLoginInformationResponse']:
        """
        Username and password for basic authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="dataControllerId")
    def data_controller_id(self) -> Optional[str]:
        """
        null
        """
        return pulumi.get(self, "data_controller_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        The instance end time
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="extensionId")
    def extension_id(self) -> Optional[str]:
        """
        If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
        """
        return pulumi.get(self, "extension_id")

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional['outputs.SqlManagedInstanceK8sRawResponse']:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[str]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        The license type to apply for this managed instance.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The instance start time
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class SqlManagedInstanceSkuResponse(dict):
    """
    The resource model definition representing SKU for Azure Managed Instance - Azure Arc
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 dev: Optional[bool] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The resource model definition representing SKU for Azure Managed Instance - Azure Arc
        :param str name: The name of the SKU.
        :param bool dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        :param str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param str tier: The pricing tier for the instance.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dev is None:
            dev = True
        if dev is not None:
            pulumi.set(__self__, "dev", dev)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is None:
            tier = 'GeneralPurpose'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def dev(self) -> Optional[bool]:
        """
        Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        """
        return pulumi.get(self, "dev")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The pricing tier for the instance.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SqlServerInstancePropertiesResponse(dict):
    """
    Properties of SqlServerInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResourceId":
            suggest = "container_resource_id"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "azureDefenderStatus":
            suggest = "azure_defender_status"
        elif key == "azureDefenderStatusLastUpdated":
            suggest = "azure_defender_status_last_updated"
        elif key == "currentVersion":
            suggest = "current_version"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "patchLevel":
            suggest = "patch_level"
        elif key == "productId":
            suggest = "product_id"
        elif key == "tcpDynamicPorts":
            suggest = "tcp_dynamic_ports"
        elif key == "tcpStaticPorts":
            suggest = "tcp_static_ports"
        elif key == "vCore":
            suggest = "v_core"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_resource_id: str,
                 create_time: str,
                 provisioning_state: str,
                 status: str,
                 azure_defender_status: Optional[str] = None,
                 azure_defender_status_last_updated: Optional[str] = None,
                 collation: Optional[str] = None,
                 current_version: Optional[str] = None,
                 edition: Optional[str] = None,
                 instance_name: Optional[str] = None,
                 license_type: Optional[str] = None,
                 patch_level: Optional[str] = None,
                 product_id: Optional[str] = None,
                 tcp_dynamic_ports: Optional[str] = None,
                 tcp_static_ports: Optional[str] = None,
                 v_core: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Properties of SqlServerInstance.
        :param str container_resource_id: ARM Resource id of the container resource (Azure Arc for Servers).
        :param str create_time: The time when the resource was created.
        :param str status: The cloud connectivity status.
        :param str azure_defender_status: Status of Azure Defender.
        :param str azure_defender_status_last_updated: Timestamp of last Azure Defender status update.
        :param str collation: SQL Server collation.
        :param str current_version: SQL Server current version.
        :param str edition: SQL Server edition.
        :param str instance_name: SQL Server instance name.
        :param str license_type: SQL Server license type.
        :param str patch_level: SQL Server update level.
        :param str product_id: SQL Server product ID.
        :param str tcp_dynamic_ports: Dynamic TCP ports used by SQL Server.
        :param str tcp_static_ports: Static TCP ports used by SQL Server.
        :param str v_core: The number of logical processors used by the SQL Server instance.
        :param str version: SQL Server version.
        """
        pulumi.set(__self__, "container_resource_id", container_resource_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        if azure_defender_status is not None:
            pulumi.set(__self__, "azure_defender_status", azure_defender_status)
        if azure_defender_status_last_updated is not None:
            pulumi.set(__self__, "azure_defender_status_last_updated", azure_defender_status_last_updated)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if patch_level is not None:
            pulumi.set(__self__, "patch_level", patch_level)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if tcp_dynamic_ports is not None:
            pulumi.set(__self__, "tcp_dynamic_ports", tcp_dynamic_ports)
        if tcp_static_ports is not None:
            pulumi.set(__self__, "tcp_static_ports", tcp_static_ports)
        if v_core is not None:
            pulumi.set(__self__, "v_core", v_core)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="containerResourceId")
    def container_resource_id(self) -> str:
        """
        ARM Resource id of the container resource (Azure Arc for Servers).
        """
        return pulumi.get(self, "container_resource_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The cloud connectivity status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="azureDefenderStatus")
    def azure_defender_status(self) -> Optional[str]:
        """
        Status of Azure Defender.
        """
        return pulumi.get(self, "azure_defender_status")

    @property
    @pulumi.getter(name="azureDefenderStatusLastUpdated")
    def azure_defender_status_last_updated(self) -> Optional[str]:
        """
        Timestamp of last Azure Defender status update.
        """
        return pulumi.get(self, "azure_defender_status_last_updated")

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        SQL Server collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[str]:
        """
        SQL Server current version.
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter
    def edition(self) -> Optional[str]:
        """
        SQL Server edition.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[str]:
        """
        SQL Server instance name.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        SQL Server license type.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="patchLevel")
    def patch_level(self) -> Optional[str]:
        """
        SQL Server update level.
        """
        return pulumi.get(self, "patch_level")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[str]:
        """
        SQL Server product ID.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="tcpDynamicPorts")
    def tcp_dynamic_ports(self) -> Optional[str]:
        """
        Dynamic TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_dynamic_ports")

    @property
    @pulumi.getter(name="tcpStaticPorts")
    def tcp_static_ports(self) -> Optional[str]:
        """
        Static TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_static_ports")

    @property
    @pulumi.getter(name="vCore")
    def v_core(self) -> Optional[str]:
        """
        The number of logical processors used by the SQL Server instance.
        """
        return pulumi.get(self, "v_core")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        SQL Server version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Read only system data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Read only system data
        :param str created_at: The timestamp of resource creation (UTC)
        :param str created_by: An identifier for the identity that created the resource
        :param str created_by_type: The type of identity that created the resource
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: An identifier for the identity that last modified the resource
        :param str last_modified_by_type: The type of identity that last modified the resource
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC)
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        An identifier for the identity that created the resource
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        An identifier for the identity that last modified the resource
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UploadServicePrincipalResponse(dict):
    """
    Service principal for uploading billing, metrics and logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UploadServicePrincipalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UploadServicePrincipalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UploadServicePrincipalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority: Optional[str] = None,
                 client_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Service principal for uploading billing, metrics and logs.
        :param str authority: Authority for the service principal. Example: https://login.microsoftonline.com/
        :param str client_id: Client ID of the service principal for uploading data.
        :param str tenant_id: Tenant ID of the service principal.
        """
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def authority(self) -> Optional[str]:
        """
        Authority for the service principal. Example: https://login.microsoftonline.com/
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Client ID of the service principal for uploading data.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant ID of the service principal.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class UploadWatermarkResponse(dict):
    """
    Properties on upload watermark.  Mostly timestamp for each upload data type
    """
    def __init__(__self__, *,
                 logs: Optional[str] = None,
                 metrics: Optional[str] = None,
                 usages: Optional[str] = None):
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        :param str logs: Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        :param str metrics: Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        :param str usages: Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)

    @property
    @pulumi.getter
    def logs(self) -> Optional[str]:
        """
        Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[str]:
        """
        Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def usages(self) -> Optional[str]:
        """
        Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "usages")


