# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'ListGatewayKeysResult',
    'AwaitableListGatewayKeysResult',
    'list_gateway_keys',
    'list_gateway_keys_output',
]

@pulumi.output_type
class ListGatewayKeysResult:
    """
    Gateway authentication keys.
    """
    def __init__(__self__, primary=None, secondary=None):
        if primary and not isinstance(primary, str):
            raise TypeError("Expected argument 'primary' to be a str")
        pulumi.set(__self__, "primary", primary)
        if secondary and not isinstance(secondary, str):
            raise TypeError("Expected argument 'secondary' to be a str")
        pulumi.set(__self__, "secondary", secondary)

    @property
    @pulumi.getter
    def primary(self) -> Optional[str]:
        """
        Primary gateway key.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def secondary(self) -> Optional[str]:
        """
        Secondary gateway key.
        """
        return pulumi.get(self, "secondary")


class AwaitableListGatewayKeysResult(ListGatewayKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListGatewayKeysResult(
            primary=self.primary,
            secondary=self.secondary)


def list_gateway_keys(gateway_id: Optional[str] = None,
                      resource_group_name: Optional[str] = None,
                      service_name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListGatewayKeysResult:
    """
    Gateway authentication keys.


    :param str gateway_id: Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
    :param str resource_group_name: The name of the resource group.
    :param str service_name: The name of the API Management service.
    """
    __args__ = dict()
    __args__['gatewayId'] = gateway_id
    __args__['resourceGroupName'] = resource_group_name
    __args__['serviceName'] = service_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:apimanagement/v20201201:listGatewayKeys', __args__, opts=opts, typ=ListGatewayKeysResult).value

    return AwaitableListGatewayKeysResult(
        primary=__ret__.primary,
        secondary=__ret__.secondary)


@_utilities.lift_output_func(list_gateway_keys)
def list_gateway_keys_output(gateway_id: Optional[pulumi.Input[str]] = None,
                             resource_group_name: Optional[pulumi.Input[str]] = None,
                             service_name: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListGatewayKeysResult]:
    """
    Gateway authentication keys.


    :param str gateway_id: Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
    :param str resource_group_name: The name of the resource group.
    :param str service_name: The name of the API Management service.
    """
    ...
