# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ChapSettingArgs', 'ChapSetting']

@pulumi.input_type
class ChapSettingArgs:
    def __init__(__self__, *,
                 device_name: pulumi.Input[str],
                 manager_name: pulumi.Input[str],
                 password: pulumi.Input['AsymmetricEncryptedSecretArgs'],
                 resource_group_name: pulumi.Input[str],
                 chap_user_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ChapSetting resource.
        :param pulumi.Input[str] device_name: The device name.
        :param pulumi.Input[str] manager_name: The manager name
        :param pulumi.Input['AsymmetricEncryptedSecretArgs'] password: The chap password.
        :param pulumi.Input[str] resource_group_name: The resource group name
        :param pulumi.Input[str] chap_user_name: The chap user name.
        """
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "manager_name", manager_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if chap_user_name is not None:
            pulumi.set(__self__, "chap_user_name", chap_user_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Input[str]:
        """
        The device name.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="managerName")
    def manager_name(self) -> pulumi.Input[str]:
        """
        The manager name
        """
        return pulumi.get(self, "manager_name")

    @manager_name.setter
    def manager_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "manager_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input['AsymmetricEncryptedSecretArgs']:
        """
        The chap password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input['AsymmetricEncryptedSecretArgs']):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The resource group name
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="chapUserName")
    def chap_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The chap user name.
        """
        return pulumi.get(self, "chap_user_name")

    @chap_user_name.setter
    def chap_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chap_user_name", value)


class ChapSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chap_user_name: Optional[pulumi.Input[str]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 manager_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[pulumi.InputType['AsymmetricEncryptedSecretArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Challenge-Handshake Authentication Protocol (CHAP) setting

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] chap_user_name: The chap user name.
        :param pulumi.Input[str] device_name: The device name.
        :param pulumi.Input[str] manager_name: The manager name
        :param pulumi.Input[pulumi.InputType['AsymmetricEncryptedSecretArgs']] password: The chap password.
        :param pulumi.Input[str] resource_group_name: The resource group name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChapSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Challenge-Handshake Authentication Protocol (CHAP) setting

        :param str resource_name: The name of the resource.
        :param ChapSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChapSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chap_user_name: Optional[pulumi.Input[str]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 manager_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[pulumi.InputType['AsymmetricEncryptedSecretArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChapSettingArgs.__new__(ChapSettingArgs)

            __props__.__dict__["chap_user_name"] = chap_user_name
            if device_name is None and not opts.urn:
                raise TypeError("Missing required property 'device_name'")
            __props__.__dict__["device_name"] = device_name
            if manager_name is None and not opts.urn:
                raise TypeError("Missing required property 'manager_name'")
            __props__.__dict__["manager_name"] = manager_name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:storsimple/v20161001:ChapSetting")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ChapSetting, __self__).__init__(
            'azure-native:storsimple/v20161001:ChapSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ChapSetting':
        """
        Get an existing ChapSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ChapSettingArgs.__new__(ChapSettingArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["password"] = None
        __props__.__dict__["type"] = None
        return ChapSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output['outputs.AsymmetricEncryptedSecretResponse']:
        """
        The chap password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type.
        """
        return pulumi.get(self, "type")

