# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DiagnosticStoragePropertiesArgs',
    'IotHubSettingsArgs',
    'ManagedServiceIdentityArgs',
    'PrivateLinkServiceConnectionStateArgs',
]

@pulumi.input_type
class DiagnosticStoragePropertiesArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[Union[str, 'AuthenticationType']],
                 resource_id: pulumi.Input[str],
                 connection_string: Optional[pulumi.Input[str]] = None):
        """
        Customer-initiated diagnostic log collection storage properties
        :param pulumi.Input[Union[str, 'AuthenticationType']] authentication_type: Authentication Type
        :param pulumi.Input[str] resource_id: ResourceId of the diagnostic storage account
        :param pulumi.Input[str] connection_string: ConnectionString of the diagnostic storage account
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "resource_id", resource_id)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[Union[str, 'AuthenticationType']]:
        """
        Authentication Type
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[Union[str, 'AuthenticationType']]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        ResourceId of the diagnostic storage account
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        ConnectionString of the diagnostic storage account
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)


@pulumi.input_type
class IotHubSettingsArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 event_hub_connection_string: Optional[pulumi.Input[str]] = None,
                 io_t_hub_connection_string: Optional[pulumi.Input[str]] = None):
        """
        Device Update account integration with IoT Hub settings.
        :param pulumi.Input[str] resource_id: IoTHub resource ID
        :param pulumi.Input[str] event_hub_connection_string: EventHub connection string.
        :param pulumi.Input[str] io_t_hub_connection_string: IoTHub connection string.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if event_hub_connection_string is not None:
            pulumi.set(__self__, "event_hub_connection_string", event_hub_connection_string)
        if io_t_hub_connection_string is not None:
            pulumi.set(__self__, "io_t_hub_connection_string", io_t_hub_connection_string)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        IoTHub resource ID
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="eventHubConnectionString")
    def event_hub_connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        EventHub connection string.
        """
        return pulumi.get(self, "event_hub_connection_string")

    @event_hub_connection_string.setter
    def event_hub_connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_hub_connection_string", value)

    @property
    @pulumi.getter(name="ioTHubConnectionString")
    def io_t_hub_connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        IoTHub connection string.
        """
        return pulumi.get(self, "io_t_hub_connection_string")

    @io_t_hub_connection_string.setter
    def io_t_hub_connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "io_t_hub_connection_string", value)


@pulumi.input_type
class ManagedServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ManagedServiceIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Managed service identity (system assigned and/or user assigned identities)
        :param pulumi.Input[Union[str, 'ManagedServiceIdentityType']] type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ManagedServiceIdentityType']]:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


