# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = ['PolicyPricingArgs', 'PolicyPricing']

@pulumi.input_type
class PolicyPricingArgs:
    def __init__(__self__, *,
                 pricing_tier: pulumi.Input[Union[str, 'PricingTier']],
                 scope: pulumi.Input[str],
                 policy_pricing_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PolicyPricing resource.
        :param pulumi.Input[Union[str, 'PricingTier']] pricing_tier: The policy pricing tier. Possible values are Advanced and Defender.
        :param pulumi.Input[str] scope: The scope of the policy pricing. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}') or subscription (format: '/subscriptions/{subscriptionId}')
        :param pulumi.Input[str] policy_pricing_name: The name of the policy pricing.
        """
        pulumi.set(__self__, "pricing_tier", pricing_tier)
        pulumi.set(__self__, "scope", scope)
        if policy_pricing_name is not None:
            pulumi.set(__self__, "policy_pricing_name", policy_pricing_name)

    @property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> pulumi.Input[Union[str, 'PricingTier']]:
        """
        The policy pricing tier. Possible values are Advanced and Defender.
        """
        return pulumi.get(self, "pricing_tier")

    @pricing_tier.setter
    def pricing_tier(self, value: pulumi.Input[Union[str, 'PricingTier']]):
        pulumi.set(self, "pricing_tier", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[str]:
        """
        The scope of the policy pricing. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}') or subscription (format: '/subscriptions/{subscriptionId}')
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="policyPricingName")
    def policy_pricing_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy pricing.
        """
        return pulumi.get(self, "policy_pricing_name")

    @policy_pricing_name.setter
    def policy_pricing_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_pricing_name", value)


class PolicyPricing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_pricing_name: Optional[pulumi.Input[str]] = None,
                 pricing_tier: Optional[pulumi.Input[Union[str, 'PricingTier']]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The policy pricing.
        API Version: 2021-07-01.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] policy_pricing_name: The name of the policy pricing.
        :param pulumi.Input[Union[str, 'PricingTier']] pricing_tier: The policy pricing tier. Possible values are Advanced and Defender.
        :param pulumi.Input[str] scope: The scope of the policy pricing. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}') or subscription (format: '/subscriptions/{subscriptionId}')
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyPricingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The policy pricing.
        API Version: 2021-07-01.

        :param str resource_name: The name of the resource.
        :param PolicyPricingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyPricingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_pricing_name: Optional[pulumi.Input[str]] = None,
                 pricing_tier: Optional[pulumi.Input[Union[str, 'PricingTier']]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyPricingArgs.__new__(PolicyPricingArgs)

            __props__.__dict__["policy_pricing_name"] = policy_pricing_name
            if pricing_tier is None and not opts.urn:
                raise TypeError("Missing required property 'pricing_tier'")
            __props__.__dict__["pricing_tier"] = pricing_tier
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:authorization:PolicyPricing"), pulumi.Alias(type_="azure-native:authorization/v20210701:PolicyPricing"), pulumi.Alias(type_="azure-nextgen:authorization/v20210701:PolicyPricing")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(PolicyPricing, __self__).__init__(
            'azure-native:authorization:PolicyPricing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PolicyPricing':
        """
        Get an existing PolicyPricing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PolicyPricingArgs.__new__(PolicyPricingArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["pricing_tier"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return PolicyPricing(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy pricing.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> pulumi.Output[str]:
        """
        The policy pricing tier. Possible values are Advanced and Defender.
        """
        return pulumi.get(self, "pricing_tier")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning state of the policy pricing resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource (Microsoft.Authorization/policyPricings).
        """
        return pulumi.get(self, "type")

