# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPolicyPricingResult',
    'AwaitableGetPolicyPricingResult',
    'get_policy_pricing',
    'get_policy_pricing_output',
]

@pulumi.output_type
class GetPolicyPricingResult:
    """
    The policy pricing.
    """
    def __init__(__self__, id=None, name=None, pricing_tier=None, provisioning_state=None, system_data=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pricing_tier and not isinstance(pricing_tier, str):
            raise TypeError("Expected argument 'pricing_tier' to be a str")
        pulumi.set(__self__, "pricing_tier", pricing_tier)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the policy pricing.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the policy pricing.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> str:
        """
        The policy pricing tier. Possible values are Advanced and Defender.
        """
        return pulumi.get(self, "pricing_tier")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the policy pricing resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource (Microsoft.Authorization/policyPricings).
        """
        return pulumi.get(self, "type")


class AwaitableGetPolicyPricingResult(GetPolicyPricingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyPricingResult(
            id=self.id,
            name=self.name,
            pricing_tier=self.pricing_tier,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            type=self.type)


def get_policy_pricing(policy_pricing_name: Optional[str] = None,
                       scope: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyPricingResult:
    """
    The policy pricing.
    API Version: 2021-07-01.


    :param str policy_pricing_name: The name of the policy pricing.
    :param str scope: The scope of the policy pricing. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}') or subscription (format: '/subscriptions/{subscriptionId}')
    """
    __args__ = dict()
    __args__['policyPricingName'] = policy_pricing_name
    __args__['scope'] = scope
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:authorization:getPolicyPricing', __args__, opts=opts, typ=GetPolicyPricingResult).value

    return AwaitableGetPolicyPricingResult(
        id=__ret__.id,
        name=__ret__.name,
        pricing_tier=__ret__.pricing_tier,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        type=__ret__.type)


@_utilities.lift_output_func(get_policy_pricing)
def get_policy_pricing_output(policy_pricing_name: Optional[pulumi.Input[str]] = None,
                              scope: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPolicyPricingResult]:
    """
    The policy pricing.
    API Version: 2021-07-01.


    :param str policy_pricing_name: The name of the policy pricing.
    :param str scope: The scope of the policy pricing. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}') or subscription (format: '/subscriptions/{subscriptionId}')
    """
    ...
