# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'AzureActiveDirectoryArgs',
    'CertificateDescriptionArgs',
    'ClientCertificateCommonNameArgs',
    'ClientCertificateThumbprintArgs',
    'ClusterHealthPolicyArgs',
    'ClusterUpgradeDeltaHealthPolicyArgs',
    'ClusterUpgradePolicyArgs',
    'DiagnosticsStorageAccountConfigArgs',
    'EndpointRangeDescriptionArgs',
    'NodeTypeDescriptionArgs',
    'SettingsParameterDescriptionArgs',
    'SettingsSectionDescriptionArgs',
]

@pulumi.input_type
class AzureActiveDirectoryArgs:
    def __init__(__self__, *,
                 client_application: Optional[pulumi.Input[str]] = None,
                 cluster_application: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        The settings to enable AAD authentication on the cluster
        :param pulumi.Input[str] client_application: Azure active directory client application id
        :param pulumi.Input[str] cluster_application: Azure active directory cluster application id
        :param pulumi.Input[str] tenant_id: Azure active directory tenant id
        """
        if client_application is not None:
            pulumi.set(__self__, "client_application", client_application)
        if cluster_application is not None:
            pulumi.set(__self__, "cluster_application", cluster_application)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplication")
    def client_application(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory client application id
        """
        return pulumi.get(self, "client_application")

    @client_application.setter
    def client_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_application", value)

    @property
    @pulumi.getter(name="clusterApplication")
    def cluster_application(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory cluster application id
        """
        return pulumi.get(self, "cluster_application")

    @cluster_application.setter
    def cluster_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_application", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure active directory tenant id
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class CertificateDescriptionArgs:
    def __init__(__self__, *,
                 thumbprint: pulumi.Input[str],
                 thumbprint_secondary: Optional[pulumi.Input[str]] = None,
                 x509_store_name: Optional[pulumi.Input[str]] = None):
        """
        Certificate details
        :param pulumi.Input[str] thumbprint: Thumbprint of the primary certificate
        :param pulumi.Input[str] thumbprint_secondary: Thumbprint of the secondary certificate
        :param pulumi.Input[str] x509_store_name: The local certificate store location
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[str]:
        """
        Thumbprint of the primary certificate
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[pulumi.Input[str]]:
        """
        Thumbprint of the secondary certificate
        """
        return pulumi.get(self, "thumbprint_secondary")

    @thumbprint_secondary.setter
    def thumbprint_secondary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint_secondary", value)

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[pulumi.Input[str]]:
        """
        The local certificate store location
        """
        return pulumi.get(self, "x509_store_name")

    @x509_store_name.setter
    def x509_store_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_store_name", value)


@pulumi.input_type
class ClientCertificateCommonNameArgs:
    def __init__(__self__, *,
                 certificate_common_name: pulumi.Input[str],
                 certificate_issuer_thumbprint: pulumi.Input[str],
                 is_admin: pulumi.Input[bool]):
        """
        Client certificate details using common name
        :param pulumi.Input[str] certificate_common_name: Certificate common name to be granted access; be careful using wild card common names
        :param pulumi.Input[str] certificate_issuer_thumbprint: Certificate issuer thumbprint
        :param pulumi.Input[bool] is_admin: Is this certificate used for admin access from the client, if false , it is used or query only access
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> pulumi.Input[str]:
        """
        Certificate common name to be granted access; be careful using wild card common names
        """
        return pulumi.get(self, "certificate_common_name")

    @certificate_common_name.setter
    def certificate_common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_common_name", value)

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> pulumi.Input[str]:
        """
        Certificate issuer thumbprint
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @certificate_issuer_thumbprint.setter
    def certificate_issuer_thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_issuer_thumbprint", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[bool]:
        """
        Is this certificate used for admin access from the client, if false , it is used or query only access
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_admin", value)


@pulumi.input_type
class ClientCertificateThumbprintArgs:
    def __init__(__self__, *,
                 certificate_thumbprint: pulumi.Input[str],
                 is_admin: pulumi.Input[bool]):
        """
        Client certificate details using thumbprint
        :param pulumi.Input[str] certificate_thumbprint: Certificate thumbprint
        :param pulumi.Input[bool] is_admin: Is this certificate used for admin access from the client, if false, it is used or query only access
        """
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> pulumi.Input[str]:
        """
        Certificate thumbprint
        """
        return pulumi.get(self, "certificate_thumbprint")

    @certificate_thumbprint.setter
    def certificate_thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_thumbprint", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Input[bool]:
        """
        Is this certificate used for admin access from the client, if false, it is used or query only access
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_admin", value)


@pulumi.input_type
class ClusterHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_unhealthy_applications: Optional[pulumi.Input[int]] = None,
                 max_percent_unhealthy_nodes: Optional[pulumi.Input[int]] = None):
        """
        Defines a health policy used to evaluate the health of the cluster or of a cluster node.
        :param pulumi.Input[int] max_percent_unhealthy_applications: The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10. 
        :param pulumi.Input[int] max_percent_unhealthy_nodes: The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10. 
        """
        if max_percent_unhealthy_applications is not None:
            pulumi.set(__self__, "max_percent_unhealthy_applications", max_percent_unhealthy_applications)
        if max_percent_unhealthy_nodes is not None:
            pulumi.set(__self__, "max_percent_unhealthy_nodes", max_percent_unhealthy_nodes)

    @property
    @pulumi.getter(name="maxPercentUnhealthyApplications")
    def max_percent_unhealthy_applications(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10. 
        """
        return pulumi.get(self, "max_percent_unhealthy_applications")

    @max_percent_unhealthy_applications.setter
    def max_percent_unhealthy_applications(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_applications", value)

    @property
    @pulumi.getter(name="maxPercentUnhealthyNodes")
    def max_percent_unhealthy_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10. 
        """
        return pulumi.get(self, "max_percent_unhealthy_nodes")

    @max_percent_unhealthy_nodes.setter
    def max_percent_unhealthy_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_percent_unhealthy_nodes", value)


@pulumi.input_type
class ClusterUpgradeDeltaHealthPolicyArgs:
    def __init__(__self__, *,
                 max_percent_delta_unhealthy_applications: pulumi.Input[int],
                 max_percent_delta_unhealthy_nodes: pulumi.Input[int],
                 max_percent_upgrade_domain_delta_unhealthy_nodes: pulumi.Input[int]):
        """
        Delta health policy for the cluster
        :param pulumi.Input[int] max_percent_delta_unhealthy_applications: Additional unhealthy applications percentage
        :param pulumi.Input[int] max_percent_delta_unhealthy_nodes: Additional unhealthy nodes percentage
        :param pulumi.Input[int] max_percent_upgrade_domain_delta_unhealthy_nodes: Additional unhealthy nodes percentage per upgrade domain 
        """
        pulumi.set(__self__, "max_percent_delta_unhealthy_applications", max_percent_delta_unhealthy_applications)
        pulumi.set(__self__, "max_percent_delta_unhealthy_nodes", max_percent_delta_unhealthy_nodes)
        pulumi.set(__self__, "max_percent_upgrade_domain_delta_unhealthy_nodes", max_percent_upgrade_domain_delta_unhealthy_nodes)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyApplications")
    def max_percent_delta_unhealthy_applications(self) -> pulumi.Input[int]:
        """
        Additional unhealthy applications percentage
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_applications")

    @max_percent_delta_unhealthy_applications.setter
    def max_percent_delta_unhealthy_applications(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_delta_unhealthy_applications", value)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyNodes")
    def max_percent_delta_unhealthy_nodes(self) -> pulumi.Input[int]:
        """
        Additional unhealthy nodes percentage
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_nodes")

    @max_percent_delta_unhealthy_nodes.setter
    def max_percent_delta_unhealthy_nodes(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_delta_unhealthy_nodes", value)

    @property
    @pulumi.getter(name="maxPercentUpgradeDomainDeltaUnhealthyNodes")
    def max_percent_upgrade_domain_delta_unhealthy_nodes(self) -> pulumi.Input[int]:
        """
        Additional unhealthy nodes percentage per upgrade domain 
        """
        return pulumi.get(self, "max_percent_upgrade_domain_delta_unhealthy_nodes")

    @max_percent_upgrade_domain_delta_unhealthy_nodes.setter
    def max_percent_upgrade_domain_delta_unhealthy_nodes(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_percent_upgrade_domain_delta_unhealthy_nodes", value)


@pulumi.input_type
class ClusterUpgradePolicyArgs:
    def __init__(__self__, *,
                 health_check_retry_timeout: pulumi.Input[str],
                 health_check_stable_duration: pulumi.Input[str],
                 health_check_wait_duration: pulumi.Input[str],
                 health_policy: pulumi.Input['ClusterHealthPolicyArgs'],
                 upgrade_domain_timeout: pulumi.Input[str],
                 upgrade_replica_set_check_timeout: pulumi.Input[str],
                 upgrade_timeout: pulumi.Input[str],
                 delta_health_policy: Optional[pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs']] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 override_user_upgrade_policy: Optional[pulumi.Input[bool]] = None):
        """
        Cluster upgrade policy
        :param pulumi.Input[str] health_check_retry_timeout: The length of time that health checks can fail continuously,it represents .Net TimeSpan
        :param pulumi.Input[str] health_check_stable_duration: The length of time that health checks must pass continuously,it represents .Net TimeSpan
        :param pulumi.Input[str] health_check_wait_duration: The length of time to wait after completing an upgrade domain before performing health checks, it represents .Net TimeSpan
        :param pulumi.Input['ClusterHealthPolicyArgs'] health_policy: Cluster health Policy
        :param pulumi.Input[str] upgrade_domain_timeout: The timeout for any upgrade domain,it represents .Net TimeSpan
        :param pulumi.Input[str] upgrade_replica_set_check_timeout: Timeout for replica set upgrade to complete,it represents .Net TimeSpan
        :param pulumi.Input[str] upgrade_timeout: The upgrade timeout,it represents .Net TimeSpan
        :param pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs'] delta_health_policy: Delta health policy
        :param pulumi.Input[bool] force_restart: Force node to restart or not
        :param pulumi.Input[bool] override_user_upgrade_policy: Use the user defined upgrade policy or not
        """
        pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        pulumi.set(__self__, "health_policy", health_policy)
        pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)
        pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)
        if delta_health_policy is not None:
            pulumi.set(__self__, "delta_health_policy", delta_health_policy)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if override_user_upgrade_policy is not None:
            pulumi.set(__self__, "override_user_upgrade_policy", override_user_upgrade_policy)

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> pulumi.Input[str]:
        """
        The length of time that health checks can fail continuously,it represents .Net TimeSpan
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @health_check_retry_timeout.setter
    def health_check_retry_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_retry_timeout", value)

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> pulumi.Input[str]:
        """
        The length of time that health checks must pass continuously,it represents .Net TimeSpan
        """
        return pulumi.get(self, "health_check_stable_duration")

    @health_check_stable_duration.setter
    def health_check_stable_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_stable_duration", value)

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> pulumi.Input[str]:
        """
        The length of time to wait after completing an upgrade domain before performing health checks, it represents .Net TimeSpan
        """
        return pulumi.get(self, "health_check_wait_duration")

    @health_check_wait_duration.setter
    def health_check_wait_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_wait_duration", value)

    @property
    @pulumi.getter(name="healthPolicy")
    def health_policy(self) -> pulumi.Input['ClusterHealthPolicyArgs']:
        """
        Cluster health Policy
        """
        return pulumi.get(self, "health_policy")

    @health_policy.setter
    def health_policy(self, value: pulumi.Input['ClusterHealthPolicyArgs']):
        pulumi.set(self, "health_policy", value)

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> pulumi.Input[str]:
        """
        The timeout for any upgrade domain,it represents .Net TimeSpan
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @upgrade_domain_timeout.setter
    def upgrade_domain_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_domain_timeout", value)

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> pulumi.Input[str]:
        """
        Timeout for replica set upgrade to complete,it represents .Net TimeSpan
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @upgrade_replica_set_check_timeout.setter
    def upgrade_replica_set_check_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_replica_set_check_timeout", value)

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> pulumi.Input[str]:
        """
        The upgrade timeout,it represents .Net TimeSpan
        """
        return pulumi.get(self, "upgrade_timeout")

    @upgrade_timeout.setter
    def upgrade_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "upgrade_timeout", value)

    @property
    @pulumi.getter(name="deltaHealthPolicy")
    def delta_health_policy(self) -> Optional[pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs']]:
        """
        Delta health policy
        """
        return pulumi.get(self, "delta_health_policy")

    @delta_health_policy.setter
    def delta_health_policy(self, value: Optional[pulumi.Input['ClusterUpgradeDeltaHealthPolicyArgs']]):
        pulumi.set(self, "delta_health_policy", value)

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        Force node to restart or not
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_restart", value)

    @property
    @pulumi.getter(name="overrideUserUpgradePolicy")
    def override_user_upgrade_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the user defined upgrade policy or not
        """
        return pulumi.get(self, "override_user_upgrade_policy")

    @override_user_upgrade_policy.setter
    def override_user_upgrade_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "override_user_upgrade_policy", value)


@pulumi.input_type
class DiagnosticsStorageAccountConfigArgs:
    def __init__(__self__, *,
                 blob_endpoint: pulumi.Input[str],
                 protected_account_key_name: pulumi.Input[str],
                 queue_endpoint: pulumi.Input[str],
                 storage_account_name: pulumi.Input[str],
                 table_endpoint: pulumi.Input[str]):
        """
        Diagnostics storage account config
        :param pulumi.Input[str] blob_endpoint: Diagnostics storage account blob endpoint
        :param pulumi.Input[str] protected_account_key_name: Protected Diagnostics storage key name
        :param pulumi.Input[str] queue_endpoint: Diagnostics storage account queue endpoint
        :param pulumi.Input[str] storage_account_name: Diagnostics storage account name
        :param pulumi.Input[str] table_endpoint: Diagnostics storage account table endpoint
        """
        pulumi.set(__self__, "blob_endpoint", blob_endpoint)
        pulumi.set(__self__, "protected_account_key_name", protected_account_key_name)
        pulumi.set(__self__, "queue_endpoint", queue_endpoint)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "table_endpoint", table_endpoint)

    @property
    @pulumi.getter(name="blobEndpoint")
    def blob_endpoint(self) -> pulumi.Input[str]:
        """
        Diagnostics storage account blob endpoint
        """
        return pulumi.get(self, "blob_endpoint")

    @blob_endpoint.setter
    def blob_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "blob_endpoint", value)

    @property
    @pulumi.getter(name="protectedAccountKeyName")
    def protected_account_key_name(self) -> pulumi.Input[str]:
        """
        Protected Diagnostics storage key name
        """
        return pulumi.get(self, "protected_account_key_name")

    @protected_account_key_name.setter
    def protected_account_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_account_key_name", value)

    @property
    @pulumi.getter(name="queueEndpoint")
    def queue_endpoint(self) -> pulumi.Input[str]:
        """
        Diagnostics storage account queue endpoint
        """
        return pulumi.get(self, "queue_endpoint")

    @queue_endpoint.setter
    def queue_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_endpoint", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[str]:
        """
        Diagnostics storage account name
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account_name", value)

    @property
    @pulumi.getter(name="tableEndpoint")
    def table_endpoint(self) -> pulumi.Input[str]:
        """
        Diagnostics storage account table endpoint
        """
        return pulumi.get(self, "table_endpoint")

    @table_endpoint.setter
    def table_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_endpoint", value)


@pulumi.input_type
class EndpointRangeDescriptionArgs:
    def __init__(__self__, *,
                 end_port: pulumi.Input[int],
                 start_port: pulumi.Input[int]):
        """
        Port range details
        :param pulumi.Input[int] end_port: End port of a range of ports
        :param pulumi.Input[int] start_port: Starting port of a range of ports
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> pulumi.Input[int]:
        """
        End port of a range of ports
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> pulumi.Input[int]:
        """
        Starting port of a range of ports
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "start_port", value)


@pulumi.input_type
class NodeTypeDescriptionArgs:
    def __init__(__self__, *,
                 client_connection_endpoint_port: pulumi.Input[int],
                 http_gateway_endpoint_port: pulumi.Input[int],
                 is_primary: pulumi.Input[bool],
                 name: pulumi.Input[str],
                 vm_instance_count: pulumi.Input[int],
                 application_ports: Optional[pulumi.Input['EndpointRangeDescriptionArgs']] = None,
                 capacities: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 durability_level: Optional[pulumi.Input[str]] = None,
                 ephemeral_ports: Optional[pulumi.Input['EndpointRangeDescriptionArgs']] = None,
                 placement_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 reverse_proxy_endpoint_port: Optional[pulumi.Input[int]] = None):
        """
        Describes a node type in the cluster, each node type represents sub set of nodes in the cluster
        :param pulumi.Input[int] client_connection_endpoint_port: The TCP cluster management endpoint port
        :param pulumi.Input[int] http_gateway_endpoint_port: The HTTP cluster management endpoint port
        :param pulumi.Input[bool] is_primary: Mark this as the primary node type
        :param pulumi.Input[str] name: Name of the node type
        :param pulumi.Input[int] vm_instance_count: The number of node instances in the node type
        :param pulumi.Input['EndpointRangeDescriptionArgs'] application_ports: Ports used by applications
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] capacities: The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much of a resource a node has
        :param pulumi.Input[str] durability_level: Node type durability Level
        :param pulumi.Input['EndpointRangeDescriptionArgs'] ephemeral_ports: System assigned application ports
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] placement_properties: The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run
        :param pulumi.Input[int] reverse_proxy_endpoint_port: Endpoint used by reverse proxy
        """
        pulumi.set(__self__, "client_connection_endpoint_port", client_connection_endpoint_port)
        pulumi.set(__self__, "http_gateway_endpoint_port", http_gateway_endpoint_port)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vm_instance_count", vm_instance_count)
        if application_ports is not None:
            pulumi.set(__self__, "application_ports", application_ports)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if durability_level is not None:
            pulumi.set(__self__, "durability_level", durability_level)
        if ephemeral_ports is not None:
            pulumi.set(__self__, "ephemeral_ports", ephemeral_ports)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if reverse_proxy_endpoint_port is not None:
            pulumi.set(__self__, "reverse_proxy_endpoint_port", reverse_proxy_endpoint_port)

    @property
    @pulumi.getter(name="clientConnectionEndpointPort")
    def client_connection_endpoint_port(self) -> pulumi.Input[int]:
        """
        The TCP cluster management endpoint port
        """
        return pulumi.get(self, "client_connection_endpoint_port")

    @client_connection_endpoint_port.setter
    def client_connection_endpoint_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "client_connection_endpoint_port", value)

    @property
    @pulumi.getter(name="httpGatewayEndpointPort")
    def http_gateway_endpoint_port(self) -> pulumi.Input[int]:
        """
        The HTTP cluster management endpoint port
        """
        return pulumi.get(self, "http_gateway_endpoint_port")

    @http_gateway_endpoint_port.setter
    def http_gateway_endpoint_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "http_gateway_endpoint_port", value)

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> pulumi.Input[bool]:
        """
        Mark this as the primary node type
        """
        return pulumi.get(self, "is_primary")

    @is_primary.setter
    def is_primary(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_primary", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the node type
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="vmInstanceCount")
    def vm_instance_count(self) -> pulumi.Input[int]:
        """
        The number of node instances in the node type
        """
        return pulumi.get(self, "vm_instance_count")

    @vm_instance_count.setter
    def vm_instance_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "vm_instance_count", value)

    @property
    @pulumi.getter(name="applicationPorts")
    def application_ports(self) -> Optional[pulumi.Input['EndpointRangeDescriptionArgs']]:
        """
        Ports used by applications
        """
        return pulumi.get(self, "application_ports")

    @application_ports.setter
    def application_ports(self, value: Optional[pulumi.Input['EndpointRangeDescriptionArgs']]):
        pulumi.set(self, "application_ports", value)

    @property
    @pulumi.getter
    def capacities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much of a resource a node has
        """
        return pulumi.get(self, "capacities")

    @capacities.setter
    def capacities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "capacities", value)

    @property
    @pulumi.getter(name="durabilityLevel")
    def durability_level(self) -> Optional[pulumi.Input[str]]:
        """
        Node type durability Level
        """
        return pulumi.get(self, "durability_level")

    @durability_level.setter
    def durability_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "durability_level", value)

    @property
    @pulumi.getter(name="ephemeralPorts")
    def ephemeral_ports(self) -> Optional[pulumi.Input['EndpointRangeDescriptionArgs']]:
        """
        System assigned application ports
        """
        return pulumi.get(self, "ephemeral_ports")

    @ephemeral_ports.setter
    def ephemeral_ports(self, value: Optional[pulumi.Input['EndpointRangeDescriptionArgs']]):
        pulumi.set(self, "ephemeral_ports", value)

    @property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run
        """
        return pulumi.get(self, "placement_properties")

    @placement_properties.setter
    def placement_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "placement_properties", value)

    @property
    @pulumi.getter(name="reverseProxyEndpointPort")
    def reverse_proxy_endpoint_port(self) -> Optional[pulumi.Input[int]]:
        """
        Endpoint used by reverse proxy
        """
        return pulumi.get(self, "reverse_proxy_endpoint_port")

    @reverse_proxy_endpoint_port.setter
    def reverse_proxy_endpoint_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reverse_proxy_endpoint_port", value)


@pulumi.input_type
class SettingsParameterDescriptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        ServiceFabric settings under sections
        :param pulumi.Input[str] name: The name of settings property
        :param pulumi.Input[str] value: The value of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of settings property
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the property
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SettingsSectionDescriptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]):
        """
        ServiceFabric section settings
        :param pulumi.Input[str] name: The name of settings section
        :param pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]] parameters: Collection of settings in the section, each setting is a tuple consisting of setting name and value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of settings section
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]:
        """
        Collection of settings in the section, each setting is a tuple consisting of setting name and value
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[Sequence[pulumi.Input['SettingsParameterDescriptionArgs']]]):
        pulumi.set(self, "parameters", value)


