# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetServerVulnerabilityAssessmentResult',
    'AwaitableGetServerVulnerabilityAssessmentResult',
    'get_server_vulnerability_assessment',
    'get_server_vulnerability_assessment_output',
]

@pulumi.output_type
class GetServerVulnerabilityAssessmentResult:
    """
    Describes the server vulnerability assessment details on a resource
    """
    def __init__(__self__, id=None, name=None, provisioning_state=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioningState of the vulnerability assessment capability on the VM
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")


class AwaitableGetServerVulnerabilityAssessmentResult(GetServerVulnerabilityAssessmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerVulnerabilityAssessmentResult(
            id=self.id,
            name=self.name,
            provisioning_state=self.provisioning_state,
            type=self.type)


def get_server_vulnerability_assessment(resource_group_name: Optional[str] = None,
                                        resource_name: Optional[str] = None,
                                        resource_namespace: Optional[str] = None,
                                        resource_type: Optional[str] = None,
                                        server_vulnerability_assessment: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerVulnerabilityAssessmentResult:
    """
    Describes the server vulnerability assessment details on a resource
    API Version: 2020-01-01.


    :param str resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
    :param str resource_name: Name of the resource.
    :param str resource_namespace: The Namespace of the resource.
    :param str resource_type: The type of the resource.
    :param str server_vulnerability_assessment: ServerVulnerabilityAssessment status. only a 'default' value is supported.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['resourceName'] = resource_name
    __args__['resourceNamespace'] = resource_namespace
    __args__['resourceType'] = resource_type
    __args__['serverVulnerabilityAssessment'] = server_vulnerability_assessment
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:security:getServerVulnerabilityAssessment', __args__, opts=opts, typ=GetServerVulnerabilityAssessmentResult).value

    return AwaitableGetServerVulnerabilityAssessmentResult(
        id=__ret__.id,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        type=__ret__.type)


@_utilities.lift_output_func(get_server_vulnerability_assessment)
def get_server_vulnerability_assessment_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                                               resource_name: Optional[pulumi.Input[str]] = None,
                                               resource_namespace: Optional[pulumi.Input[str]] = None,
                                               resource_type: Optional[pulumi.Input[str]] = None,
                                               server_vulnerability_assessment: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerVulnerabilityAssessmentResult]:
    """
    Describes the server vulnerability assessment details on a resource
    API Version: 2020-01-01.


    :param str resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
    :param str resource_name: Name of the resource.
    :param str resource_namespace: The Namespace of the resource.
    :param str resource_type: The type of the resource.
    :param str server_vulnerability_assessment: ServerVulnerabilityAssessment status. only a 'default' value is supported.
    """
    ...
