# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'DnsConfigArgs',
    'EndpointArgs',
    'MonitorConfigArgs',
]

@pulumi.input_type
class DnsConfigArgs:
    def __init__(__self__, *,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 relative_name: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[float]] = None):
        """
        Class containing DNS settings in a Traffic Manager profile.
        :param pulumi.Input[str] fqdn: Gets or sets the fully-qualified domain name (FQDN) of the Traffic Manager profile.  This is formed from the concatenation of the RelativeName with the DNS domain used by Azure Traffic Manager.
        :param pulumi.Input[str] relative_name: Gets or sets the relative DNS name provided by this Traffic Manager profile.  This value is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the profile.
        :param pulumi.Input[float] ttl: Gets or sets the DNS Time-To-Live (TTL), in seconds.  This informs the local DNS resolvers and DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if relative_name is not None:
            pulumi.set(__self__, "relative_name", relative_name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the fully-qualified domain name (FQDN) of the Traffic Manager profile.  This is formed from the concatenation of the RelativeName with the DNS domain used by Azure Traffic Manager.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="relativeName")
    def relative_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the relative DNS name provided by this Traffic Manager profile.  This value is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the profile.
        """
        return pulumi.get(self, "relative_name")

    @relative_name.setter
    def relative_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_name", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the DNS Time-To-Live (TTL), in seconds.  This informs the local DNS resolvers and DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 endpoint_location: Optional[pulumi.Input[str]] = None,
                 endpoint_monitor_status: Optional[pulumi.Input[str]] = None,
                 endpoint_status: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 min_child_endpoints: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[float]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 target_resource_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[float]] = None):
        """
        Class representing a Traffic Manager endpoint.
        :param pulumi.Input[str] endpoint_location: Specifies the location of the external or nested endpoints when using the ‘Performance’ traffic routing method.
        :param pulumi.Input[str] endpoint_monitor_status: Gets or sets the monitoring status of the endpoint.
        :param pulumi.Input[str] endpoint_status: Gets or sets the status of the endpoint..  If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.  Possible values are 'Enabled' and 'Disabled'.
        :param pulumi.Input[str] id: Gets or sets the ID of the Traffic Manager endpoint.
        :param pulumi.Input[float] min_child_endpoints: Gets or sets the minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
        :param pulumi.Input[str] name: Gets or sets the name of the Traffic Manager endpoint.
        :param pulumi.Input[float] priority: Gets or sets the priority of this endpoint when using the ‘Priority’ traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
        :param pulumi.Input[str] target: Gets or sets the fully-qualified DNS name of the endpoint.  Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
        :param pulumi.Input[str] target_resource_id: Gets or sets the Azure Resource URI of the of the endpoint.  Not applicable to endpoints of type 'ExternalEndpoints'.
        :param pulumi.Input[str] type: Gets or sets the endpoint type of the Traffic Manager endpoint.
        :param pulumi.Input[float] weight: Gets or sets the weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
        """
        if endpoint_location is not None:
            pulumi.set(__self__, "endpoint_location", endpoint_location)
        if endpoint_monitor_status is not None:
            pulumi.set(__self__, "endpoint_monitor_status", endpoint_monitor_status)
        if endpoint_status is not None:
            pulumi.set(__self__, "endpoint_status", endpoint_status)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if min_child_endpoints is not None:
            pulumi.set(__self__, "min_child_endpoints", min_child_endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="endpointLocation")
    def endpoint_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the external or nested endpoints when using the ‘Performance’ traffic routing method.
        """
        return pulumi.get(self, "endpoint_location")

    @endpoint_location.setter
    def endpoint_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_location", value)

    @property
    @pulumi.getter(name="endpointMonitorStatus")
    def endpoint_monitor_status(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the monitoring status of the endpoint.
        """
        return pulumi.get(self, "endpoint_monitor_status")

    @endpoint_monitor_status.setter
    def endpoint_monitor_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_monitor_status", value)

    @property
    @pulumi.getter(name="endpointStatus")
    def endpoint_status(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the status of the endpoint..  If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.  Possible values are 'Enabled' and 'Disabled'.
        """
        return pulumi.get(self, "endpoint_status")

    @endpoint_status.setter
    def endpoint_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_status", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the ID of the Traffic Manager endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="minChildEndpoints")
    def min_child_endpoints(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
        """
        return pulumi.get(self, "min_child_endpoints")

    @min_child_endpoints.setter
    def min_child_endpoints(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_child_endpoints", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the Traffic Manager endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the priority of this endpoint when using the ‘Priority’ traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the fully-qualified DNS name of the endpoint.  Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Azure Resource URI of the of the endpoint.  Not applicable to endpoints of type 'ExternalEndpoints'.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the endpoint type of the Traffic Manager endpoint.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class MonitorConfigArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[float]] = None,
                 profile_monitor_status: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        Class containing endpoint monitoring settings in a Traffic Manager profile.
        :param pulumi.Input[str] path: Gets or sets the path relative to the endpoint domain name used to probe for endpoint health.
        :param pulumi.Input[float] port: Gets or sets the TCP port used to probe for endpoint health.
        :param pulumi.Input[str] profile_monitor_status: Gets or sets the profile-level monitoring status of the Traffic Manager profile.
        :param pulumi.Input[str] protocol: Gets or sets the protocol (HTTP or HTTPS) used to probe for endpoint health.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if profile_monitor_status is not None:
            pulumi.set(__self__, "profile_monitor_status", profile_monitor_status)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the path relative to the endpoint domain name used to probe for endpoint health.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the TCP port used to probe for endpoint health.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="profileMonitorStatus")
    def profile_monitor_status(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the profile-level monitoring status of the Traffic Manager profile.
        """
        return pulumi.get(self, "profile_monitor_status")

    @profile_monitor_status.setter
    def profile_monitor_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_monitor_status", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the protocol (HTTP or HTTPS) used to probe for endpoint health.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


