# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccountEncryptionResponse',
    'AudioEncoderAacResponse',
    'EccTokenKeyResponse',
    'EncoderCustomPresetResponse',
    'EncoderProcessorResponse',
    'EncoderSystemPresetResponse',
    'EndpointResponse',
    'GroupLevelAccessControlResponse',
    'IotHubResponse',
    'JwtAuthenticationResponse',
    'KeyVaultPropertiesResponse',
    'NetworkAccessControlResponse',
    'NodeInputResponse',
    'ParameterDeclarationResponse',
    'ParameterDefinitionResponse',
    'PemCertificateListResponse',
    'PipelineJobErrorResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ResourceIdentityResponse',
    'RsaTokenKeyResponse',
    'RtspSourceResponse',
    'SecureIotDeviceRemoteTunnelResponse',
    'SkuResponse',
    'StorageAccountResponse',
    'SystemDataResponse',
    'TlsEndpointResponse',
    'TlsValidationOptionsResponse',
    'TokenClaimResponse',
    'UnsecuredEndpointResponse',
    'UserAssignedManagedIdentityResponse',
    'UsernamePasswordCredentialsResponse',
    'VideoAnalyzerIdentityResponse',
    'VideoArchivalResponse',
    'VideoContentUrlsResponse',
    'VideoCreationPropertiesResponse',
    'VideoEncoderH264Response',
    'VideoFlagsResponse',
    'VideoMediaInfoResponse',
    'VideoPreviewImageUrlsResponse',
    'VideoPublishingOptionsResponse',
    'VideoScaleResponse',
    'VideoSequenceAbsoluteTimeMarkersResponse',
    'VideoSinkResponse',
    'VideoSourceResponse',
]

@pulumi.output_type
class AccountEncryptionResponse(dict):
    """
    Defines how the Video Analyzer account is (optionally) encrypted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 type: str,
                 identity: Optional['outputs.ResourceIdentityResponse'] = None,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None):
        """
        Defines how the Video Analyzer account is (optionally) encrypted.
        :param str status: The current status of the Key Vault mapping.
        :param str type: The type of key used to encrypt the Account Key.
        :param 'ResourceIdentityResponse' identity: The Key Vault identity.
        :param 'KeyVaultPropertiesResponse' key_vault_properties: The properties of the key used to encrypt the account.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the Key Vault mapping.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of key used to encrypt the Account Key.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ResourceIdentityResponse']:
        """
        The Key Vault identity.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        The properties of the key used to encrypt the account.
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class AudioEncoderAacResponse(dict):
    """
    A custom preset for encoding audio with the AAC codec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitrateKbps":
            suggest = "bitrate_kbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioEncoderAacResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioEncoderAacResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioEncoderAacResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 bitrate_kbps: Optional[str] = None):
        """
        A custom preset for encoding audio with the AAC codec.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.AudioEncoderAac'.
        :param str bitrate_kbps: Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.AudioEncoderAac')
        if bitrate_kbps is not None:
            pulumi.set(__self__, "bitrate_kbps", bitrate_kbps)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.AudioEncoderAac'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="bitrateKbps")
    def bitrate_kbps(self) -> Optional[str]:
        """
        Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
        """
        return pulumi.get(self, "bitrate_kbps")


@pulumi.output_type
class EccTokenKeyResponse(dict):
    """
    Required validation properties for tokens generated with Elliptical Curve algorithm.
    """
    def __init__(__self__, *,
                 alg: str,
                 kid: str,
                 type: str,
                 x: str,
                 y: str):
        """
        Required validation properties for tokens generated with Elliptical Curve algorithm.
        :param str alg: Elliptical curve algorithm to be used: ES256, ES384 or ES512.
        :param str kid: JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
        :param str x: X coordinate.
        :param str y: Y coordinate.
        """
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EccTokenKey')
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def alg(self) -> str:
        """
        Elliptical curve algorithm to be used: ES256, ES384 or ES512.
        """
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter
    def kid(self) -> str:
        """
        JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def x(self) -> str:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> str:
        """
        Y coordinate.
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class EncoderCustomPresetResponse(dict):
    """
    Describes a custom preset for encoding the input content using the encoder processor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioEncoder":
            suggest = "audio_encoder"
        elif key == "videoEncoder":
            suggest = "video_encoder"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncoderCustomPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncoderCustomPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncoderCustomPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 audio_encoder: Optional['outputs.AudioEncoderAacResponse'] = None,
                 video_encoder: Optional['outputs.VideoEncoderH264Response'] = None):
        """
        Describes a custom preset for encoding the input content using the encoder processor.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EncoderCustomPreset'.
        :param 'AudioEncoderAacResponse' audio_encoder: Describes a custom preset for encoding audio.
        :param 'VideoEncoderH264Response' video_encoder: Describes a custom preset for encoding video.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EncoderCustomPreset')
        if audio_encoder is not None:
            pulumi.set(__self__, "audio_encoder", audio_encoder)
        if video_encoder is not None:
            pulumi.set(__self__, "video_encoder", video_encoder)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EncoderCustomPreset'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="audioEncoder")
    def audio_encoder(self) -> Optional['outputs.AudioEncoderAacResponse']:
        """
        Describes a custom preset for encoding audio.
        """
        return pulumi.get(self, "audio_encoder")

    @property
    @pulumi.getter(name="videoEncoder")
    def video_encoder(self) -> Optional['outputs.VideoEncoderH264Response']:
        """
        Describes a custom preset for encoding video.
        """
        return pulumi.get(self, "video_encoder")


@pulumi.output_type
class EncoderProcessorResponse(dict):
    """
    Encoder processor allows for encoding of the input content. For example, it can used to change the resolution from 4K to 1280x720.
    """
    def __init__(__self__, *,
                 inputs: Sequence['outputs.NodeInputResponse'],
                 name: str,
                 preset: Any,
                 type: str):
        """
        Encoder processor allows for encoding of the input content. For example, it can used to change the resolution from 4K to 1280x720.
        :param Sequence['NodeInputResponse'] inputs: An array of upstream node references within the topology to be used as inputs for this node.
        :param str name: Node name. Must be unique within the topology.
        :param Union['EncoderCustomPresetResponse', 'EncoderSystemPresetResponse'] preset: The encoder preset, which defines the recipe or instructions on how the input content should be processed.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EncoderProcessor'.
        """
        pulumi.set(__self__, "inputs", inputs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "preset", preset)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EncoderProcessor')

    @property
    @pulumi.getter
    def inputs(self) -> Sequence['outputs.NodeInputResponse']:
        """
        An array of upstream node references within the topology to be used as inputs for this node.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name. Must be unique within the topology.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def preset(self) -> Any:
        """
        The encoder preset, which defines the recipe or instructions on how the input content should be processed.
        """
        return pulumi.get(self, "preset")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EncoderProcessor'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EncoderSystemPresetResponse(dict):
    """
    Describes a built-in preset for encoding the input content using the encoder processor.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        Describes a built-in preset for encoding the input content using the encoder processor.
        :param str name: Name of the built-in encoding preset.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EncoderSystemPreset'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EncoderSystemPreset')

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the built-in encoding preset.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EncoderSystemPreset'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EndpointResponse(dict):
    """
    The endpoint details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointUrl":
            suggest = "endpoint_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 endpoint_url: Optional[str] = None):
        """
        The endpoint details.
        :param str type: The type of the endpoint.
        :param str endpoint_url: The URL of the endpoint.
        """
        pulumi.set(__self__, "type", type)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the endpoint.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[str]:
        """
        The URL of the endpoint.
        """
        return pulumi.get(self, "endpoint_url")


@pulumi.output_type
class GroupLevelAccessControlResponse(dict):
    """
    Group level network access control.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicNetworkAccess":
            suggest = "public_network_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupLevelAccessControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupLevelAccessControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupLevelAccessControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_network_access: Optional[str] = None):
        """
        Group level network access control.
        :param str public_network_access: Whether or not public network access is allowed for specified resources under the Video Analyzer account.
        """
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Whether or not public network access is allowed for specified resources under the Video Analyzer account.
        """
        return pulumi.get(self, "public_network_access")


@pulumi.output_type
class IotHubResponse(dict):
    """
    The IoT Hub details.
    """
    def __init__(__self__, *,
                 id: str,
                 identity: 'outputs.ResourceIdentityResponse',
                 status: str):
        """
        The IoT Hub details.
        :param str id: The IoT Hub resource identifier.
        :param 'ResourceIdentityResponse' identity: The IoT Hub identity.
        :param str status: The current status of the Iot Hub mapping.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The IoT Hub resource identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> 'outputs.ResourceIdentityResponse':
        """
        The IoT Hub identity.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the Iot Hub mapping.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class JwtAuthenticationResponse(dict):
    """
    Properties for access validation based on JSON Web Tokens (JWT).
    """
    def __init__(__self__, *,
                 type: str,
                 audiences: Optional[Sequence[str]] = None,
                 claims: Optional[Sequence['outputs.TokenClaimResponse']] = None,
                 issuers: Optional[Sequence[str]] = None,
                 keys: Optional[Sequence[Any]] = None):
        """
        Properties for access validation based on JSON Web Tokens (JWT).
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
        :param Sequence[str] audiences: List of expected token audiences. Token audience is valid if it matches at least one of the given values.
        :param Sequence['TokenClaimResponse'] claims: List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
        :param Sequence[str] issuers: List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
        :param Sequence[Union['EccTokenKeyResponse', 'RsaTokenKeyResponse']] keys: List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.JwtAuthentication')
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if claims is not None:
            pulumi.set(__self__, "claims", claims)
        if issuers is not None:
            pulumi.set(__self__, "issuers", issuers)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def audiences(self) -> Optional[Sequence[str]]:
        """
        List of expected token audiences. Token audience is valid if it matches at least one of the given values.
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter
    def claims(self) -> Optional[Sequence['outputs.TokenClaimResponse']]:
        """
        List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
        """
        return pulumi.get(self, "claims")

    @property
    @pulumi.getter
    def issuers(self) -> Optional[Sequence[str]]:
        """
        List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
        """
        return pulumi.get(self, "issuers")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[Any]]:
        """
        List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
        """
        return pulumi.get(self, "keys")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    """
    The details for accessing the encryption keys in Key Vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentKeyIdentifier":
            suggest = "current_key_identifier"
        elif key == "keyIdentifier":
            suggest = "key_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_key_identifier: str,
                 key_identifier: str):
        """
        The details for accessing the encryption keys in Key Vault.
        :param str current_key_identifier: The current key used to encrypt Video Analyzer account, including the key version.
        :param str key_identifier: The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        pulumi.set(__self__, "current_key_identifier", current_key_identifier)
        pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="currentKeyIdentifier")
    def current_key_identifier(self) -> str:
        """
        The current key used to encrypt Video Analyzer account, including the key version.
        """
        return pulumi.get(self, "current_key_identifier")

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> str:
        """
        The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        return pulumi.get(self, "key_identifier")


@pulumi.output_type
class NetworkAccessControlResponse(dict):
    """
    Network access control for video analyzer account.
    """
    def __init__(__self__, *,
                 consumption: Optional['outputs.GroupLevelAccessControlResponse'] = None,
                 ingestion: Optional['outputs.GroupLevelAccessControlResponse'] = None,
                 integration: Optional['outputs.GroupLevelAccessControlResponse'] = None):
        """
        Network access control for video analyzer account.
        :param 'GroupLevelAccessControlResponse' consumption: Public network access for consumption group.
        :param 'GroupLevelAccessControlResponse' ingestion: Public network access for ingestion group.
        :param 'GroupLevelAccessControlResponse' integration: Public network access for integration group.
        """
        if consumption is not None:
            pulumi.set(__self__, "consumption", consumption)
        if ingestion is not None:
            pulumi.set(__self__, "ingestion", ingestion)
        if integration is not None:
            pulumi.set(__self__, "integration", integration)

    @property
    @pulumi.getter
    def consumption(self) -> Optional['outputs.GroupLevelAccessControlResponse']:
        """
        Public network access for consumption group.
        """
        return pulumi.get(self, "consumption")

    @property
    @pulumi.getter
    def ingestion(self) -> Optional['outputs.GroupLevelAccessControlResponse']:
        """
        Public network access for ingestion group.
        """
        return pulumi.get(self, "ingestion")

    @property
    @pulumi.getter
    def integration(self) -> Optional['outputs.GroupLevelAccessControlResponse']:
        """
        Public network access for integration group.
        """
        return pulumi.get(self, "integration")


@pulumi.output_type
class NodeInputResponse(dict):
    """
    Describes an input signal to be used on a pipeline node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_name: str):
        """
        Describes an input signal to be used on a pipeline node.
        :param str node_name: The name of the upstream node in the pipeline which output is used as input of the current node.
        """
        pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        The name of the upstream node in the pipeline which output is used as input of the current node.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class ParameterDeclarationResponse(dict):
    """
    Single topology parameter declaration. Declared parameters can and must be referenced throughout the topology and can optionally have default values to be used when they are not defined in the pipelines.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 default: Optional[str] = None,
                 description: Optional[str] = None):
        """
        Single topology parameter declaration. Declared parameters can and must be referenced throughout the topology and can optionally have default values to be used when they are not defined in the pipelines.
        :param str name: Name of the parameter.
        :param str type: Type of the parameter.
        :param str default: The default value for the parameter to be used if the pipeline does not specify a value.
        :param str description: Description of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def default(self) -> Optional[str]:
        """
        The default value for the parameter to be used if the pipeline does not specify a value.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the parameter.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ParameterDefinitionResponse(dict):
    """
    Defines the parameter value of an specific pipeline topology parameter. See pipeline topology parameters for more information.
    """
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        Defines the parameter value of an specific pipeline topology parameter. See pipeline topology parameters for more information.
        :param str name: Name of the parameter declared in the pipeline topology.
        :param str value: Parameter value to be applied on this specific pipeline.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the parameter declared in the pipeline topology.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Parameter value to be applied on this specific pipeline.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PemCertificateListResponse(dict):
    """
    A list of PEM formatted certificates.
    """
    def __init__(__self__, *,
                 certificates: Sequence[str],
                 type: str):
        """
        A list of PEM formatted certificates.
        :param Sequence[str] certificates: PEM formatted public certificates. One certificate per entry.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.PemCertificateList'.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.PemCertificateList')

    @property
    @pulumi.getter
    def certificates(self) -> Sequence[str]:
        """
        PEM formatted public certificates. One certificate per entry.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.PemCertificateList'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipelineJobErrorResponse(dict):
    """
    Details about the error for a failed pipeline job.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None):
        """
        Details about the error for a failed pipeline job.
        :param str code: The error code.
        :param str message: The error message.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param 'SystemDataResponse' system_data: Azure Resource Manager metadata containing createdBy and modifiedBy information.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    """
    The user assigned managed identity to use when accessing a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_assigned_identity: str):
        """
        The user assigned managed identity to use when accessing a resource.
        :param str user_assigned_identity: The user assigned managed identity's resource identifier to use when accessing a resource.
        """
        pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> str:
        """
        The user assigned managed identity's resource identifier to use when accessing a resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class RsaTokenKeyResponse(dict):
    """
    Required validation properties for tokens generated with RSA algorithm.
    """
    def __init__(__self__, *,
                 alg: str,
                 e: str,
                 kid: str,
                 n: str,
                 type: str):
        """
        Required validation properties for tokens generated with RSA algorithm.
        :param str alg: RSA algorithm to be used: RS256, RS384 or RS512.
        :param str e: RSA public key exponent.
        :param str kid: JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        :param str n: RSA public key modulus.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
        """
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "e", e)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "n", n)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.RsaTokenKey')

    @property
    @pulumi.getter
    def alg(self) -> str:
        """
        RSA algorithm to be used: RS256, RS384 or RS512.
        """
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter
    def e(self) -> str:
        """
        RSA public key exponent.
        """
        return pulumi.get(self, "e")

    @property
    @pulumi.getter
    def kid(self) -> str:
        """
        JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def n(self) -> str:
        """
        RSA public key modulus.
        """
        return pulumi.get(self, "n")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RtspSourceResponse(dict):
    """
    RTSP source allows for media from an RTSP camera or generic RTSP server to be ingested into a pipeline.
    """
    def __init__(__self__, *,
                 endpoint: Any,
                 name: str,
                 type: str,
                 transport: Optional[str] = None):
        """
        RTSP source allows for media from an RTSP camera or generic RTSP server to be ingested into a pipeline.
        :param Union['TlsEndpointResponse', 'UnsecuredEndpointResponse'] endpoint: RTSP endpoint information for Video Analyzer to connect to. This contains the required information for Video Analyzer to connect to RTSP cameras and/or generic RTSP servers.
        :param str name: Node name. Must be unique within the topology.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.RtspSource'.
        :param str transport: Network transport utilized by the RTSP and RTP exchange: TCP or HTTP. When using TCP, the RTP packets are interleaved on the TCP RTSP connection. When using HTTP, the RTSP messages are exchanged through long lived HTTP connections, and the RTP packages are interleaved in the HTTP connections alongside the RTSP messages.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.RtspSource')
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @property
    @pulumi.getter
    def endpoint(self) -> Any:
        """
        RTSP endpoint information for Video Analyzer to connect to. This contains the required information for Video Analyzer to connect to RTSP cameras and/or generic RTSP servers.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name. Must be unique within the topology.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.RtspSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def transport(self) -> Optional[str]:
        """
        Network transport utilized by the RTSP and RTP exchange: TCP or HTTP. When using TCP, the RTP packets are interleaved on the TCP RTSP connection. When using HTTP, the RTSP messages are exchanged through long lived HTTP connections, and the RTP packages are interleaved in the HTTP connections alongside the RTSP messages.
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class SecureIotDeviceRemoteTunnelResponse(dict):
    """
    A remote tunnel securely established using IoT Hub device information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceId":
            suggest = "device_id"
        elif key == "iotHubName":
            suggest = "iot_hub_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecureIotDeviceRemoteTunnelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecureIotDeviceRemoteTunnelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecureIotDeviceRemoteTunnelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_id: str,
                 iot_hub_name: str,
                 type: str):
        """
        A remote tunnel securely established using IoT Hub device information.
        :param str device_id: The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
        :param str iot_hub_name: Name of the IoT Hub.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel'.
        """
        pulumi.set(__self__, "device_id", device_id)
        pulumi.set(__self__, "iot_hub_name", iot_hub_name)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel')

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> str:
        """
        The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="iotHubName")
    def iot_hub_name(self) -> str:
        """
        Name of the IoT Hub.
        """
        return pulumi.get(self, "iot_hub_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SkuResponse(dict):
    """
    The SKU details.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str):
        """
        The SKU details.
        :param str name: The SKU name.
        :param str tier: The SKU tier.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The SKU name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The SKU tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class StorageAccountResponse(dict):
    """
    The details about the associated storage account.
    """
    def __init__(__self__, *,
                 id: str,
                 status: str,
                 identity: Optional['outputs.ResourceIdentityResponse'] = None):
        """
        The details about the associated storage account.
        :param str id: The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
        :param str status: The current status of the storage account mapping.
        :param 'ResourceIdentityResponse' identity: A managed identity that Video Analyzer will use to access the storage account.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the storage account mapping.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ResourceIdentityResponse']:
        """
        A managed identity that Video Analyzer will use to access the storage account.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TlsEndpointResponse(dict):
    """
    TLS endpoint describes an endpoint that the pipeline can connect to over TLS transport (data is encrypted in transit).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustedCertificates":
            suggest = "trusted_certificates"
        elif key == "validationOptions":
            suggest = "validation_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 url: str,
                 credentials: Optional['outputs.UsernamePasswordCredentialsResponse'] = None,
                 trusted_certificates: Optional['outputs.PemCertificateListResponse'] = None,
                 tunnel: Optional['outputs.SecureIotDeviceRemoteTunnelResponse'] = None,
                 validation_options: Optional['outputs.TlsValidationOptionsResponse'] = None):
        """
        TLS endpoint describes an endpoint that the pipeline can connect to over TLS transport (data is encrypted in transit).
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.TlsEndpoint'.
        :param str url: The endpoint URL for Video Analyzer to connect to.
        :param 'UsernamePasswordCredentialsResponse' credentials: Credentials to be presented to the endpoint.
        :param 'PemCertificateListResponse' trusted_certificates: List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
        :param 'SecureIotDeviceRemoteTunnelResponse' tunnel: Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
        :param 'TlsValidationOptionsResponse' validation_options: Validation options to use when authenticating a TLS connection. By default, strict validation is used.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.TlsEndpoint')
        pulumi.set(__self__, "url", url)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if trusted_certificates is not None:
            pulumi.set(__self__, "trusted_certificates", trusted_certificates)
        if tunnel is not None:
            pulumi.set(__self__, "tunnel", tunnel)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.TlsEndpoint'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The endpoint URL for Video Analyzer to connect to.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.UsernamePasswordCredentialsResponse']:
        """
        Credentials to be presented to the endpoint.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="trustedCertificates")
    def trusted_certificates(self) -> Optional['outputs.PemCertificateListResponse']:
        """
        List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
        """
        return pulumi.get(self, "trusted_certificates")

    @property
    @pulumi.getter
    def tunnel(self) -> Optional['outputs.SecureIotDeviceRemoteTunnelResponse']:
        """
        Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
        """
        return pulumi.get(self, "tunnel")

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional['outputs.TlsValidationOptionsResponse']:
        """
        Validation options to use when authenticating a TLS connection. By default, strict validation is used.
        """
        return pulumi.get(self, "validation_options")


@pulumi.output_type
class TlsValidationOptionsResponse(dict):
    """
    Options for controlling the validation of TLS endpoints.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreHostname":
            suggest = "ignore_hostname"
        elif key == "ignoreSignature":
            suggest = "ignore_signature"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsValidationOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsValidationOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsValidationOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_hostname: Optional[str] = None,
                 ignore_signature: Optional[str] = None):
        """
        Options for controlling the validation of TLS endpoints.
        :param str ignore_hostname: When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
        :param str ignore_signature: When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
        """
        if ignore_hostname is not None:
            pulumi.set(__self__, "ignore_hostname", ignore_hostname)
        if ignore_signature is not None:
            pulumi.set(__self__, "ignore_signature", ignore_signature)

    @property
    @pulumi.getter(name="ignoreHostname")
    def ignore_hostname(self) -> Optional[str]:
        """
        When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
        """
        return pulumi.get(self, "ignore_hostname")

    @property
    @pulumi.getter(name="ignoreSignature")
    def ignore_signature(self) -> Optional[str]:
        """
        When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
        """
        return pulumi.get(self, "ignore_signature")


@pulumi.output_type
class TokenClaimResponse(dict):
    """
    Properties for expected token claims.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Properties for expected token claims.
        :param str name: Name of the claim which must be present on the token.
        :param str value: Expected value of the claim to be present on the token.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the claim which must be present on the token.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Expected value of the claim to be present on the token.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UnsecuredEndpointResponse(dict):
    """
    Unsecured endpoint describes an endpoint that the pipeline can connect to over clear transport (no encryption in transit).
    """
    def __init__(__self__, *,
                 type: str,
                 url: str,
                 credentials: Optional['outputs.UsernamePasswordCredentialsResponse'] = None,
                 tunnel: Optional['outputs.SecureIotDeviceRemoteTunnelResponse'] = None):
        """
        Unsecured endpoint describes an endpoint that the pipeline can connect to over clear transport (no encryption in transit).
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.UnsecuredEndpoint'.
        :param str url: The endpoint URL for Video Analyzer to connect to.
        :param 'UsernamePasswordCredentialsResponse' credentials: Credentials to be presented to the endpoint.
        :param 'SecureIotDeviceRemoteTunnelResponse' tunnel: Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.UnsecuredEndpoint')
        pulumi.set(__self__, "url", url)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if tunnel is not None:
            pulumi.set(__self__, "tunnel", tunnel)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.UnsecuredEndpoint'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The endpoint URL for Video Analyzer to connect to.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.UsernamePasswordCredentialsResponse']:
        """
        Credentials to be presented to the endpoint.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def tunnel(self) -> Optional['outputs.SecureIotDeviceRemoteTunnelResponse']:
        """
        Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
        """
        return pulumi.get(self, "tunnel")


@pulumi.output_type
class UserAssignedManagedIdentityResponse(dict):
    """
    The details of the user assigned managed identity used by the Video Analyzer resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        The details of the user assigned managed identity used by the Video Analyzer resource.
        :param str client_id: The client ID.
        :param str principal_id: The principal ID.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class UsernamePasswordCredentialsResponse(dict):
    """
    Username and password credentials.
    """
    def __init__(__self__, *,
                 password: str,
                 type: str,
                 username: str):
        """
        Username and password credentials.
        :param str password: Password to be presented as part of the credentials. It is recommended that this value is parameterized as a secret string in order to prevent this value to be returned as part of the resource on API requests.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials'.
        :param str username: Username to be presented as part of the credentials.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials')
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password to be presented as part of the credentials. It is recommended that this value is parameterized as a secret string in order to prevent this value to be returned as part of the resource on API requests.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username to be presented as part of the credentials.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class VideoAnalyzerIdentityResponse(dict):
    """
    The managed identity for the Video Analyzer resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoAnalyzerIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoAnalyzerIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoAnalyzerIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedManagedIdentityResponse']] = None):
        """
        The managed identity for the Video Analyzer resource.
        :param str type: The identity type.
        :param Mapping[str, 'UserAssignedManagedIdentityResponse'] user_assigned_identities: The User Assigned Managed Identities.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedManagedIdentityResponse']]:
        """
        The User Assigned Managed Identities.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class VideoArchivalResponse(dict):
    """
    Video archival properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoArchivalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoArchivalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoArchivalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_period: Optional[str] = None):
        """
        Video archival properties.
        :param str retention_period: Video retention period indicates the maximum age of the video archive segments which are intended to be kept in storage. It must be provided in the ISO8601 duration format in the granularity of days, up to a maximum of 10 years. For example, if this is set to P30D (30 days), content older than 30 days will be periodically deleted. This value can be updated at any time and the new desired retention period will be effective within 24 hours.
        """
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[str]:
        """
        Video retention period indicates the maximum age of the video archive segments which are intended to be kept in storage. It must be provided in the ISO8601 duration format in the granularity of days, up to a maximum of 10 years. For example, if this is set to P30D (30 days), content older than 30 days will be periodically deleted. This value can be updated at any time and the new desired retention period will be effective within 24 hours.
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class VideoContentUrlsResponse(dict):
    """
    Set of URLs to the video content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveBaseUrl":
            suggest = "archive_base_url"
        elif key == "downloadUrl":
            suggest = "download_url"
        elif key == "previewImageUrls":
            suggest = "preview_image_urls"
        elif key == "rtspTunnelUrl":
            suggest = "rtsp_tunnel_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoContentUrlsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoContentUrlsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoContentUrlsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_base_url: Optional[str] = None,
                 download_url: Optional[str] = None,
                 preview_image_urls: Optional['outputs.VideoPreviewImageUrlsResponse'] = None,
                 rtsp_tunnel_url: Optional[str] = None):
        """
        Set of URLs to the video content.
        :param str archive_base_url: Video archive streaming base URL. The archived content can be automatically played by the Azure Video Analyzer player widget. Alternatively, this URL can be used in conjunction with the video content authorization token on any compatible DASH or HLS players by appending the following to the base URL:
               
                   - HLSv4:     /manifest(format=m3u8-aapl).m3u8
                   - HLS CMAF:  /manifest(format=m3u8-cmaf)
                   - DASH CMAF: /manifest(format=mpd-time-cmaf)
               
                   Moreover, an ongoing video recording can be played in "live mode" with latencies which are approximately double of the chosen video segment length. It is available when the video type is 'archive' and video archiving is enabled.
        :param str download_url: Video file download URL. This URL can be used in conjunction with the video content authorization token to download the video MP4 file. The resulting MP4 file can be played on any standard media player. It is available when the video type is 'file' and video file is available for consumption.
        :param 'VideoPreviewImageUrlsResponse' preview_image_urls: Video preview image URLs. These URLs can be used in conjunction with the video content authorization token to download the most recent still image from the video archive in different resolutions. They are available when the video type is 'archive' and preview images are enabled.
        :param str rtsp_tunnel_url: Video low-latency streaming URL. The live content can be automatically played by the Azure Video Analyzer player widget. Alternatively, this URL can be used in conjunction with the video content authorization token to expose a WebSocket tunneled RTSP stream. It is available when the video type is 'archive' and a live, low-latency feed is available from the source.
        """
        if archive_base_url is not None:
            pulumi.set(__self__, "archive_base_url", archive_base_url)
        if download_url is not None:
            pulumi.set(__self__, "download_url", download_url)
        if preview_image_urls is not None:
            pulumi.set(__self__, "preview_image_urls", preview_image_urls)
        if rtsp_tunnel_url is not None:
            pulumi.set(__self__, "rtsp_tunnel_url", rtsp_tunnel_url)

    @property
    @pulumi.getter(name="archiveBaseUrl")
    def archive_base_url(self) -> Optional[str]:
        """
        Video archive streaming base URL. The archived content can be automatically played by the Azure Video Analyzer player widget. Alternatively, this URL can be used in conjunction with the video content authorization token on any compatible DASH or HLS players by appending the following to the base URL:
        
            - HLSv4:     /manifest(format=m3u8-aapl).m3u8
            - HLS CMAF:  /manifest(format=m3u8-cmaf)
            - DASH CMAF: /manifest(format=mpd-time-cmaf)
        
            Moreover, an ongoing video recording can be played in "live mode" with latencies which are approximately double of the chosen video segment length. It is available when the video type is 'archive' and video archiving is enabled.
        """
        return pulumi.get(self, "archive_base_url")

    @property
    @pulumi.getter(name="downloadUrl")
    def download_url(self) -> Optional[str]:
        """
        Video file download URL. This URL can be used in conjunction with the video content authorization token to download the video MP4 file. The resulting MP4 file can be played on any standard media player. It is available when the video type is 'file' and video file is available for consumption.
        """
        return pulumi.get(self, "download_url")

    @property
    @pulumi.getter(name="previewImageUrls")
    def preview_image_urls(self) -> Optional['outputs.VideoPreviewImageUrlsResponse']:
        """
        Video preview image URLs. These URLs can be used in conjunction with the video content authorization token to download the most recent still image from the video archive in different resolutions. They are available when the video type is 'archive' and preview images are enabled.
        """
        return pulumi.get(self, "preview_image_urls")

    @property
    @pulumi.getter(name="rtspTunnelUrl")
    def rtsp_tunnel_url(self) -> Optional[str]:
        """
        Video low-latency streaming URL. The live content can be automatically played by the Azure Video Analyzer player widget. Alternatively, this URL can be used in conjunction with the video content authorization token to expose a WebSocket tunneled RTSP stream. It is available when the video type is 'archive' and a live, low-latency feed is available from the source.
        """
        return pulumi.get(self, "rtsp_tunnel_url")


@pulumi.output_type
class VideoCreationPropertiesResponse(dict):
    """
    Optional properties to be used in case a new video resource needs to be created on the service. These will not take effect if the video already exists.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"
        elif key == "segmentLength":
            suggest = "segment_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoCreationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoCreationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoCreationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 retention_period: Optional[str] = None,
                 segment_length: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Optional properties to be used in case a new video resource needs to be created on the service. These will not take effect if the video already exists.
        :param str description: Optional description provided by the user. Value can be up to 2048 characters long.
        :param str retention_period: Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format (i.e. "PT1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies where "kind" is set to "live".
        :param str segment_length: Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial call to create the video resource can lead to errors when uploading content to the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
        :param str title: Optional title provided by the user. Value can be up to 256 characters long.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if segment_length is not None:
            pulumi.set(__self__, "segment_length", segment_length)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Optional description provided by the user. Value can be up to 2048 characters long.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[str]:
        """
        Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format (i.e. "PT1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies where "kind" is set to "live".
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="segmentLength")
    def segment_length(self) -> Optional[str]:
        """
        Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial call to create the video resource can lead to errors when uploading content to the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
        """
        return pulumi.get(self, "segment_length")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Optional title provided by the user. Value can be up to 256 characters long.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class VideoEncoderH264Response(dict):
    """
    A custom preset for encoding video with the H.264 (AVC) codec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitrateKbps":
            suggest = "bitrate_kbps"
        elif key == "frameRate":
            suggest = "frame_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoEncoderH264Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoEncoderH264Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoEncoderH264Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 bitrate_kbps: Optional[str] = None,
                 frame_rate: Optional[str] = None,
                 scale: Optional['outputs.VideoScaleResponse'] = None):
        """
        A custom preset for encoding video with the H.264 (AVC) codec.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.VideoEncoderH264'.
        :param str bitrate_kbps: The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
        :param str frame_rate: The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
        :param 'VideoScaleResponse' scale: Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.VideoEncoderH264')
        if bitrate_kbps is not None:
            pulumi.set(__self__, "bitrate_kbps", bitrate_kbps)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.VideoEncoderH264'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="bitrateKbps")
    def bitrate_kbps(self) -> Optional[str]:
        """
        The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
        """
        return pulumi.get(self, "bitrate_kbps")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[str]:
        """
        The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
        """
        return pulumi.get(self, "frame_rate")

    @property
    @pulumi.getter
    def scale(self) -> Optional['outputs.VideoScaleResponse']:
        """
        Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class VideoFlagsResponse(dict):
    """
    Video flags contain information about the available video actions and its dynamic properties based on the current video state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canStream":
            suggest = "can_stream"
        elif key == "hasData":
            suggest = "has_data"
        elif key == "isInUse":
            suggest = "is_in_use"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoFlagsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoFlagsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoFlagsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_stream: bool,
                 has_data: bool,
                 is_in_use: bool):
        """
        Video flags contain information about the available video actions and its dynamic properties based on the current video state.
        :param bool can_stream: Value indicating whether or not the video can be streamed. Only "archive" type videos can be streamed.
        :param bool has_data: Value indicating whether or not there has ever been data recorded or uploaded into the video. Newly created videos have this value set to false.
        :param bool is_in_use: Value indicating whether or not the video is currently being referenced be an active pipeline. The fact that is being referenced, doesn't necessarily indicate that data is being received. For example, video recording may be gated on events or camera may not be accessible at the time.
        """
        pulumi.set(__self__, "can_stream", can_stream)
        pulumi.set(__self__, "has_data", has_data)
        pulumi.set(__self__, "is_in_use", is_in_use)

    @property
    @pulumi.getter(name="canStream")
    def can_stream(self) -> bool:
        """
        Value indicating whether or not the video can be streamed. Only "archive" type videos can be streamed.
        """
        return pulumi.get(self, "can_stream")

    @property
    @pulumi.getter(name="hasData")
    def has_data(self) -> bool:
        """
        Value indicating whether or not there has ever been data recorded or uploaded into the video. Newly created videos have this value set to false.
        """
        return pulumi.get(self, "has_data")

    @property
    @pulumi.getter(name="isInUse")
    def is_in_use(self) -> bool:
        """
        Value indicating whether or not the video is currently being referenced be an active pipeline. The fact that is being referenced, doesn't necessarily indicate that data is being received. For example, video recording may be gated on events or camera may not be accessible at the time.
        """
        return pulumi.get(self, "is_in_use")


@pulumi.output_type
class VideoMediaInfoResponse(dict):
    """
    Contains information about the video and audio content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "segmentLength":
            suggest = "segment_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoMediaInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoMediaInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoMediaInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 segment_length: str):
        """
        Contains information about the video and audio content.
        :param str segment_length: Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
        """
        pulumi.set(__self__, "segment_length", segment_length)

    @property
    @pulumi.getter(name="segmentLength")
    def segment_length(self) -> str:
        """
        Video segment length indicates the length of individual video files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments.
        """
        return pulumi.get(self, "segment_length")


@pulumi.output_type
class VideoPreviewImageUrlsResponse(dict):
    """
    Video preview image URLs. These URLs can be used in conjunction with the video content authorization token to download the most recent still image from the video archive in different resolutions. They are available when the video type is 'archive' and preview images are enabled.
    """
    def __init__(__self__, *,
                 large: Optional[str] = None,
                 medium: Optional[str] = None,
                 small: Optional[str] = None):
        """
        Video preview image URLs. These URLs can be used in conjunction with the video content authorization token to download the most recent still image from the video archive in different resolutions. They are available when the video type is 'archive' and preview images are enabled.
        :param str large: High resolution preview image URL.
        :param str medium: Medium resolution preview image URL.
        :param str small: Low resolution preview image URL.
        """
        if large is not None:
            pulumi.set(__self__, "large", large)
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if small is not None:
            pulumi.set(__self__, "small", small)

    @property
    @pulumi.getter
    def large(self) -> Optional[str]:
        """
        High resolution preview image URL.
        """
        return pulumi.get(self, "large")

    @property
    @pulumi.getter
    def medium(self) -> Optional[str]:
        """
        Medium resolution preview image URL.
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter
    def small(self) -> Optional[str]:
        """
        Low resolution preview image URL.
        """
        return pulumi.get(self, "small")


@pulumi.output_type
class VideoPublishingOptionsResponse(dict):
    """
    Optional flags used to change how video is published. These are only allowed for topologies where "kind" is set to "live".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableArchive":
            suggest = "disable_archive"
        elif key == "disableRtspPublishing":
            suggest = "disable_rtsp_publishing"
        elif key == "disableVideoPreviewImage":
            suggest = "disable_video_preview_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoPublishingOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoPublishingOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoPublishingOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_archive: Optional[str] = None,
                 disable_rtsp_publishing: Optional[str] = None,
                 disable_video_preview_image: Optional[str] = None):
        """
        Optional flags used to change how video is published. These are only allowed for topologies where "kind" is set to "live".
        :param str disable_archive: When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
        :param str disable_rtsp_publishing: When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example, when the topology is used only for archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to 'false'.
        :param str disable_video_preview_image: When set to 'true' preview images will not be generated. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'false', then "disableArchive" must be set to 'false'.
        """
        if disable_archive is not None:
            pulumi.set(__self__, "disable_archive", disable_archive)
        if disable_rtsp_publishing is not None:
            pulumi.set(__self__, "disable_rtsp_publishing", disable_rtsp_publishing)
        if disable_video_preview_image is not None:
            pulumi.set(__self__, "disable_video_preview_image", disable_video_preview_image)

    @property
    @pulumi.getter(name="disableArchive")
    def disable_archive(self) -> Optional[str]:
        """
        When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
        """
        return pulumi.get(self, "disable_archive")

    @property
    @pulumi.getter(name="disableRtspPublishing")
    def disable_rtsp_publishing(self) -> Optional[str]:
        """
        When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example, when the topology is used only for archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to 'false'.
        """
        return pulumi.get(self, "disable_rtsp_publishing")

    @property
    @pulumi.getter(name="disableVideoPreviewImage")
    def disable_video_preview_image(self) -> Optional[str]:
        """
        When set to 'true' preview images will not be generated. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'false', then "disableArchive" must be set to 'false'.
        """
        return pulumi.get(self, "disable_video_preview_image")


@pulumi.output_type
class VideoScaleResponse(dict):
    """
    The video scaling information.
    """
    def __init__(__self__, *,
                 height: Optional[str] = None,
                 mode: Optional[str] = None,
                 width: Optional[str] = None):
        """
        The video scaling information.
        :param str height: The desired output video height.
        :param str mode: Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
        :param str width: The desired output video width.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The desired output video height.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The desired output video width.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class VideoSequenceAbsoluteTimeMarkersResponse(dict):
    """
    A sequence of absolute datetime ranges as a string. The datetime values should follow IS08601, and the sum of the ranges should add up to 24 hours or less. Currently, there can be only one range specified in the sequence.
    """
    def __init__(__self__, *,
                 ranges: str,
                 type: str):
        """
        A sequence of absolute datetime ranges as a string. The datetime values should follow IS08601, and the sum of the ranges should add up to 24 hours or less. Currently, there can be only one range specified in the sequence.
        :param str ranges: The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers'.
        """
        pulumi.set(__self__, "ranges", ranges)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers')

    @property
    @pulumi.getter
    def ranges(self) -> str:
        """
        The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
        """
        return pulumi.get(self, "ranges")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VideoSinkResponse(dict):
    """
    Video sink in a live topology allows for video and audio to be captured, optionally archived, and published via a video resource. If archiving is enabled, this results in a video of type 'archive'. If used in a batch topology, this allows for video and audio to be stored as a file, and published via a video resource of type 'file'
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "videoName":
            suggest = "video_name"
        elif key == "videoCreationProperties":
            suggest = "video_creation_properties"
        elif key == "videoPublishingOptions":
            suggest = "video_publishing_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoSinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoSinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoSinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inputs: Sequence['outputs.NodeInputResponse'],
                 name: str,
                 type: str,
                 video_name: str,
                 video_creation_properties: Optional['outputs.VideoCreationPropertiesResponse'] = None,
                 video_publishing_options: Optional['outputs.VideoPublishingOptionsResponse'] = None):
        """
        Video sink in a live topology allows for video and audio to be captured, optionally archived, and published via a video resource. If archiving is enabled, this results in a video of type 'archive'. If used in a batch topology, this allows for video and audio to be stored as a file, and published via a video resource of type 'file'
        :param Sequence['NodeInputResponse'] inputs: An array of upstream node references within the topology to be used as inputs for this node.
        :param str name: Node name. Must be unique within the topology.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.VideoSink'.
        :param str video_name: Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then no content is archived.
        :param 'VideoCreationPropertiesResponse' video_creation_properties: Optional video properties to be used in case a new video resource needs to be created on the service.
        :param 'VideoPublishingOptionsResponse' video_publishing_options: Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
        """
        pulumi.set(__self__, "inputs", inputs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.VideoSink')
        pulumi.set(__self__, "video_name", video_name)
        if video_creation_properties is not None:
            pulumi.set(__self__, "video_creation_properties", video_creation_properties)
        if video_publishing_options is not None:
            pulumi.set(__self__, "video_publishing_options", video_publishing_options)

    @property
    @pulumi.getter
    def inputs(self) -> Sequence['outputs.NodeInputResponse']:
        """
        An array of upstream node references within the topology to be used as inputs for this node.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name. Must be unique within the topology.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.VideoSink'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="videoName")
    def video_name(self) -> str:
        """
        Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then no content is archived.
        """
        return pulumi.get(self, "video_name")

    @property
    @pulumi.getter(name="videoCreationProperties")
    def video_creation_properties(self) -> Optional['outputs.VideoCreationPropertiesResponse']:
        """
        Optional video properties to be used in case a new video resource needs to be created on the service.
        """
        return pulumi.get(self, "video_creation_properties")

    @property
    @pulumi.getter(name="videoPublishingOptions")
    def video_publishing_options(self) -> Optional['outputs.VideoPublishingOptionsResponse']:
        """
        Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
        """
        return pulumi.get(self, "video_publishing_options")


@pulumi.output_type
class VideoSourceResponse(dict):
    """
    Video source allows for content from a Video Analyzer video resource to be ingested into a pipeline. Currently supported only with batch pipelines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeSequences":
            suggest = "time_sequences"
        elif key == "videoName":
            suggest = "video_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 time_sequences: 'outputs.VideoSequenceAbsoluteTimeMarkersResponse',
                 type: str,
                 video_name: str):
        """
        Video source allows for content from a Video Analyzer video resource to be ingested into a pipeline. Currently supported only with batch pipelines.
        :param str name: Node name. Must be unique within the topology.
        :param 'VideoSequenceAbsoluteTimeMarkersResponse' time_sequences: Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
        :param str type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.VideoSource'.
        :param str video_name: Name of the Video Analyzer video resource to be used as the source.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "time_sequences", time_sequences)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.VideoSource')
        pulumi.set(__self__, "video_name", video_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Node name. Must be unique within the topology.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="timeSequences")
    def time_sequences(self) -> 'outputs.VideoSequenceAbsoluteTimeMarkersResponse':
        """
        Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
        """
        return pulumi.get(self, "time_sequences")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.VideoSource'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="videoName")
    def video_name(self) -> str:
        """
        Name of the Video Analyzer video resource to be used as the source.
        """
        return pulumi.get(self, "video_name")


