# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AccountEncryptionArgs',
    'AudioEncoderAacArgs',
    'EccTokenKeyArgs',
    'EncoderCustomPresetArgs',
    'EncoderProcessorArgs',
    'EncoderSystemPresetArgs',
    'JwtAuthenticationArgs',
    'KeyVaultPropertiesArgs',
    'NodeInputArgs',
    'ParameterDeclarationArgs',
    'ParameterDefinitionArgs',
    'PemCertificateListArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'ResourceIdentityArgs',
    'RsaTokenKeyArgs',
    'RtspSourceArgs',
    'SecureIotDeviceRemoteTunnelArgs',
    'SkuArgs',
    'StorageAccountArgs',
    'TlsEndpointArgs',
    'TlsValidationOptionsArgs',
    'TokenClaimArgs',
    'UnsecuredEndpointArgs',
    'UsernamePasswordCredentialsArgs',
    'VideoAnalyzerIdentityArgs',
    'VideoCreationPropertiesArgs',
    'VideoEncoderH264Args',
    'VideoPublishingOptionsArgs',
    'VideoScaleArgs',
    'VideoSequenceAbsoluteTimeMarkersArgs',
    'VideoSinkArgs',
    'VideoSourceArgs',
]

@pulumi.input_type
class AccountEncryptionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'AccountEncryptionKeyType']],
                 identity: Optional[pulumi.Input['ResourceIdentityArgs']] = None,
                 key_vault_properties: Optional[pulumi.Input['KeyVaultPropertiesArgs']] = None):
        """
        Defines how the Video Analyzer account is (optionally) encrypted.
        :param pulumi.Input[Union[str, 'AccountEncryptionKeyType']] type: The type of key used to encrypt the Account Key.
        :param pulumi.Input['ResourceIdentityArgs'] identity: The Key Vault identity.
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: The properties of the key used to encrypt the account.
        """
        pulumi.set(__self__, "type", type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'AccountEncryptionKeyType']]:
        """
        The type of key used to encrypt the Account Key.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'AccountEncryptionKeyType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceIdentityArgs']]:
        """
        The Key Vault identity.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input['KeyVaultPropertiesArgs']]:
        """
        The properties of the key used to encrypt the account.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input['KeyVaultPropertiesArgs']]):
        pulumi.set(self, "key_vault_properties", value)


@pulumi.input_type
class AudioEncoderAacArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 bitrate_kbps: Optional[pulumi.Input[str]] = None):
        """
        A custom preset for encoding audio with the AAC codec.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.AudioEncoderAac'.
        :param pulumi.Input[str] bitrate_kbps: Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.AudioEncoderAac')
        if bitrate_kbps is not None:
            pulumi.set(__self__, "bitrate_kbps", bitrate_kbps)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.AudioEncoderAac'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="bitrateKbps")
    def bitrate_kbps(self) -> Optional[pulumi.Input[str]]:
        """
        Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
        """
        return pulumi.get(self, "bitrate_kbps")

    @bitrate_kbps.setter
    def bitrate_kbps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bitrate_kbps", value)


@pulumi.input_type
class EccTokenKeyArgs:
    def __init__(__self__, *,
                 alg: pulumi.Input[Union[str, 'AccessPolicyEccAlgo']],
                 kid: pulumi.Input[str],
                 type: pulumi.Input[str],
                 x: pulumi.Input[str],
                 y: pulumi.Input[str]):
        """
        Required validation properties for tokens generated with Elliptical Curve algorithm.
        :param pulumi.Input[Union[str, 'AccessPolicyEccAlgo']] alg: Elliptical curve algorithm to be used: ES256, ES384 or ES512.
        :param pulumi.Input[str] kid: JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
        :param pulumi.Input[str] x: X coordinate.
        :param pulumi.Input[str] y: Y coordinate.
        """
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EccTokenKey')
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def alg(self) -> pulumi.Input[Union[str, 'AccessPolicyEccAlgo']]:
        """
        Elliptical curve algorithm to be used: ES256, ES384 or ES512.
        """
        return pulumi.get(self, "alg")

    @alg.setter
    def alg(self, value: pulumi.Input[Union[str, 'AccessPolicyEccAlgo']]):
        pulumi.set(self, "alg", value)

    @property
    @pulumi.getter
    def kid(self) -> pulumi.Input[str]:
        """
        JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: pulumi.Input[str]):
        pulumi.set(self, "kid", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def x(self) -> pulumi.Input[str]:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @x.setter
    def x(self, value: pulumi.Input[str]):
        pulumi.set(self, "x", value)

    @property
    @pulumi.getter
    def y(self) -> pulumi.Input[str]:
        """
        Y coordinate.
        """
        return pulumi.get(self, "y")

    @y.setter
    def y(self, value: pulumi.Input[str]):
        pulumi.set(self, "y", value)


@pulumi.input_type
class EncoderCustomPresetArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 audio_encoder: Optional[pulumi.Input['AudioEncoderAacArgs']] = None,
                 video_encoder: Optional[pulumi.Input['VideoEncoderH264Args']] = None):
        """
        Describes a custom preset for encoding the input content using the encoder processor.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EncoderCustomPreset'.
        :param pulumi.Input['AudioEncoderAacArgs'] audio_encoder: Describes a custom preset for encoding audio.
        :param pulumi.Input['VideoEncoderH264Args'] video_encoder: Describes a custom preset for encoding video.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EncoderCustomPreset')
        if audio_encoder is not None:
            pulumi.set(__self__, "audio_encoder", audio_encoder)
        if video_encoder is not None:
            pulumi.set(__self__, "video_encoder", video_encoder)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EncoderCustomPreset'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="audioEncoder")
    def audio_encoder(self) -> Optional[pulumi.Input['AudioEncoderAacArgs']]:
        """
        Describes a custom preset for encoding audio.
        """
        return pulumi.get(self, "audio_encoder")

    @audio_encoder.setter
    def audio_encoder(self, value: Optional[pulumi.Input['AudioEncoderAacArgs']]):
        pulumi.set(self, "audio_encoder", value)

    @property
    @pulumi.getter(name="videoEncoder")
    def video_encoder(self) -> Optional[pulumi.Input['VideoEncoderH264Args']]:
        """
        Describes a custom preset for encoding video.
        """
        return pulumi.get(self, "video_encoder")

    @video_encoder.setter
    def video_encoder(self, value: Optional[pulumi.Input['VideoEncoderH264Args']]):
        pulumi.set(self, "video_encoder", value)


@pulumi.input_type
class EncoderProcessorArgs:
    def __init__(__self__, *,
                 inputs: pulumi.Input[Sequence[pulumi.Input['NodeInputArgs']]],
                 name: pulumi.Input[str],
                 preset: pulumi.Input[Union['EncoderCustomPresetArgs', 'EncoderSystemPresetArgs']],
                 type: pulumi.Input[str]):
        """
        Encoder processor allows for encoding of the input content. For example, it can used to change the resolution from 4K to 1280x720.
        :param pulumi.Input[Sequence[pulumi.Input['NodeInputArgs']]] inputs: An array of upstream node references within the topology to be used as inputs for this node.
        :param pulumi.Input[str] name: Node name. Must be unique within the topology.
        :param pulumi.Input[Union['EncoderCustomPresetArgs', 'EncoderSystemPresetArgs']] preset: The encoder preset, which defines the recipe or instructions on how the input content should be processed.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EncoderProcessor'.
        """
        pulumi.set(__self__, "inputs", inputs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "preset", preset)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EncoderProcessor')

    @property
    @pulumi.getter
    def inputs(self) -> pulumi.Input[Sequence[pulumi.Input['NodeInputArgs']]]:
        """
        An array of upstream node references within the topology to be used as inputs for this node.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: pulumi.Input[Sequence[pulumi.Input['NodeInputArgs']]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Node name. Must be unique within the topology.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def preset(self) -> pulumi.Input[Union['EncoderCustomPresetArgs', 'EncoderSystemPresetArgs']]:
        """
        The encoder preset, which defines the recipe or instructions on how the input content should be processed.
        """
        return pulumi.get(self, "preset")

    @preset.setter
    def preset(self, value: pulumi.Input[Union['EncoderCustomPresetArgs', 'EncoderSystemPresetArgs']]):
        pulumi.set(self, "preset", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EncoderProcessor'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EncoderSystemPresetArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'EncoderSystemPresetType']],
                 type: pulumi.Input[str]):
        """
        Describes a built-in preset for encoding the input content using the encoder processor.
        :param pulumi.Input[Union[str, 'EncoderSystemPresetType']] name: Name of the built-in encoding preset.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EncoderSystemPreset'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EncoderSystemPreset')

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'EncoderSystemPresetType']]:
        """
        Name of the built-in encoding preset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'EncoderSystemPresetType']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EncoderSystemPreset'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JwtAuthenticationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 claims: Optional[pulumi.Input[Sequence[pulumi.Input['TokenClaimArgs']]]] = None,
                 issuers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EccTokenKeyArgs', 'RsaTokenKeyArgs']]]]] = None):
        """
        Properties for access validation based on JSON Web Tokens (JWT).
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audiences: List of expected token audiences. Token audience is valid if it matches at least one of the given values.
        :param pulumi.Input[Sequence[pulumi.Input['TokenClaimArgs']]] claims: List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] issuers: List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EccTokenKeyArgs', 'RsaTokenKeyArgs']]]] keys: List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.JwtAuthentication')
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if claims is not None:
            pulumi.set(__self__, "claims", claims)
        if issuers is not None:
            pulumi.set(__self__, "issuers", issuers)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of expected token audiences. Token audience is valid if it matches at least one of the given values.
        """
        return pulumi.get(self, "audiences")

    @audiences.setter
    def audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "audiences", value)

    @property
    @pulumi.getter
    def claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TokenClaimArgs']]]]:
        """
        List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
        """
        return pulumi.get(self, "claims")

    @claims.setter
    def claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TokenClaimArgs']]]]):
        pulumi.set(self, "claims", value)

    @property
    @pulumi.getter
    def issuers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
        """
        return pulumi.get(self, "issuers")

    @issuers.setter
    def issuers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "issuers", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['EccTokenKeyArgs', 'RsaTokenKeyArgs']]]]]:
        """
        List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EccTokenKeyArgs', 'RsaTokenKeyArgs']]]]]):
        pulumi.set(self, "keys", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_identifier: pulumi.Input[str]):
        """
        The details for accessing the encryption keys in Key Vault.
        :param pulumi.Input[str] key_identifier: The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> pulumi.Input[str]:
        """
        The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_identifier", value)


@pulumi.input_type
class NodeInputArgs:
    def __init__(__self__, *,
                 node_name: pulumi.Input[str]):
        """
        Describes an input signal to be used on a pipeline node.
        :param pulumi.Input[str] node_name: The name of the upstream node in the pipeline which output is used as input of the current node.
        """
        pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> pulumi.Input[str]:
        """
        The name of the upstream node in the pipeline which output is used as input of the current node.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_name", value)


@pulumi.input_type
class ParameterDeclarationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[Union[str, 'ParameterType']],
                 default: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        Single topology parameter declaration. Declared parameters can and must be referenced throughout the topology and can optionally have default values to be used when they are not defined in the pipelines.
        :param pulumi.Input[str] name: Name of the parameter.
        :param pulumi.Input[Union[str, 'ParameterType']] type: Type of the parameter.
        :param pulumi.Input[str] default: The default value for the parameter to be used if the pipeline does not specify a value.
        :param pulumi.Input[str] description: Description of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ParameterType']]:
        """
        Type of the parameter.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ParameterType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[str]]:
        """
        The default value for the parameter to be used if the pipeline does not specify a value.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the parameter.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ParameterDefinitionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        Defines the parameter value of an specific pipeline topology parameter. See pipeline topology parameters for more information.
        :param pulumi.Input[str] name: Name of the parameter declared in the pipeline topology.
        :param pulumi.Input[str] value: Parameter value to be applied on this specific pipeline.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the parameter declared in the pipeline topology.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter value to be applied on this specific pipeline.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PemCertificateListArgs:
    def __init__(__self__, *,
                 certificates: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str]):
        """
        A list of PEM formatted certificates.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificates: PEM formatted public certificates. One certificate per entry.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.PemCertificateList'.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.PemCertificateList')

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        PEM formatted public certificates. One certificate per entry.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.PemCertificateList'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ResourceIdentityArgs:
    def __init__(__self__, *,
                 user_assigned_identity: pulumi.Input[str]):
        """
        The user assigned managed identity to use when accessing a resource.
        :param pulumi.Input[str] user_assigned_identity: The user assigned managed identity's resource identifier to use when accessing a resource.
        """
        pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> pulumi.Input[str]:
        """
        The user assigned managed identity's resource identifier to use when accessing a resource.
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_assigned_identity", value)


@pulumi.input_type
class RsaTokenKeyArgs:
    def __init__(__self__, *,
                 alg: pulumi.Input[Union[str, 'AccessPolicyRsaAlgo']],
                 e: pulumi.Input[str],
                 kid: pulumi.Input[str],
                 n: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Required validation properties for tokens generated with RSA algorithm.
        :param pulumi.Input[Union[str, 'AccessPolicyRsaAlgo']] alg: RSA algorithm to be used: RS256, RS384 or RS512.
        :param pulumi.Input[str] e: RSA public key exponent.
        :param pulumi.Input[str] kid: JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        :param pulumi.Input[str] n: RSA public key modulus.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
        """
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "e", e)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "n", n)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.RsaTokenKey')

    @property
    @pulumi.getter
    def alg(self) -> pulumi.Input[Union[str, 'AccessPolicyRsaAlgo']]:
        """
        RSA algorithm to be used: RS256, RS384 or RS512.
        """
        return pulumi.get(self, "alg")

    @alg.setter
    def alg(self, value: pulumi.Input[Union[str, 'AccessPolicyRsaAlgo']]):
        pulumi.set(self, "alg", value)

    @property
    @pulumi.getter
    def e(self) -> pulumi.Input[str]:
        """
        RSA public key exponent.
        """
        return pulumi.get(self, "e")

    @e.setter
    def e(self, value: pulumi.Input[str]):
        pulumi.set(self, "e", value)

    @property
    @pulumi.getter
    def kid(self) -> pulumi.Input[str]:
        """
        JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: pulumi.Input[str]):
        pulumi.set(self, "kid", value)

    @property
    @pulumi.getter
    def n(self) -> pulumi.Input[str]:
        """
        RSA public key modulus.
        """
        return pulumi.get(self, "n")

    @n.setter
    def n(self, value: pulumi.Input[str]):
        pulumi.set(self, "n", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RtspSourceArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[Union['TlsEndpointArgs', 'UnsecuredEndpointArgs']],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 transport: Optional[pulumi.Input[Union[str, 'RtspTransport']]] = None):
        """
        RTSP source allows for media from an RTSP camera or generic RTSP server to be ingested into a pipeline.
        :param pulumi.Input[Union['TlsEndpointArgs', 'UnsecuredEndpointArgs']] endpoint: RTSP endpoint information for Video Analyzer to connect to. This contains the required information for Video Analyzer to connect to RTSP cameras and/or generic RTSP servers.
        :param pulumi.Input[str] name: Node name. Must be unique within the topology.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.RtspSource'.
        :param pulumi.Input[Union[str, 'RtspTransport']] transport: Network transport utilized by the RTSP and RTP exchange: TCP or HTTP. When using TCP, the RTP packets are interleaved on the TCP RTSP connection. When using HTTP, the RTSP messages are exchanged through long lived HTTP connections, and the RTP packages are interleaved in the HTTP connections alongside the RTSP messages.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.RtspSource')
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[Union['TlsEndpointArgs', 'UnsecuredEndpointArgs']]:
        """
        RTSP endpoint information for Video Analyzer to connect to. This contains the required information for Video Analyzer to connect to RTSP cameras and/or generic RTSP servers.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[Union['TlsEndpointArgs', 'UnsecuredEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Node name. Must be unique within the topology.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.RtspSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def transport(self) -> Optional[pulumi.Input[Union[str, 'RtspTransport']]]:
        """
        Network transport utilized by the RTSP and RTP exchange: TCP or HTTP. When using TCP, the RTP packets are interleaved on the TCP RTSP connection. When using HTTP, the RTSP messages are exchanged through long lived HTTP connections, and the RTP packages are interleaved in the HTTP connections alongside the RTSP messages.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: Optional[pulumi.Input[Union[str, 'RtspTransport']]]):
        pulumi.set(self, "transport", value)


@pulumi.input_type
class SecureIotDeviceRemoteTunnelArgs:
    def __init__(__self__, *,
                 device_id: pulumi.Input[str],
                 iot_hub_name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        A remote tunnel securely established using IoT Hub device information.
        :param pulumi.Input[str] device_id: The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
        :param pulumi.Input[str] iot_hub_name: Name of the IoT Hub.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel'.
        """
        pulumi.set(__self__, "device_id", device_id)
        pulumi.set(__self__, "iot_hub_name", iot_hub_name)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel')

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> pulumi.Input[str]:
        """
        The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="iotHubName")
    def iot_hub_name(self) -> pulumi.Input[str]:
        """
        Name of the IoT Hub.
        """
        return pulumi.get(self, "iot_hub_name")

    @iot_hub_name.setter
    def iot_hub_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "iot_hub_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']]):
        """
        The SKU details.
        :param pulumi.Input[Union[str, 'SkuName']] name: The SKU name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        The SKU name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class StorageAccountArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input['ResourceIdentityArgs']] = None):
        """
        The details about the associated storage account.
        :param pulumi.Input[str] id: The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
        :param pulumi.Input['ResourceIdentityArgs'] identity: A managed identity that Video Analyzer will use to access the storage account.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceIdentityArgs']]:
        """
        A managed identity that Video Analyzer will use to access the storage account.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceIdentityArgs']]):
        pulumi.set(self, "identity", value)


@pulumi.input_type
class TlsEndpointArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 url: pulumi.Input[str],
                 credentials: Optional[pulumi.Input['UsernamePasswordCredentialsArgs']] = None,
                 trusted_certificates: Optional[pulumi.Input['PemCertificateListArgs']] = None,
                 tunnel: Optional[pulumi.Input['SecureIotDeviceRemoteTunnelArgs']] = None,
                 validation_options: Optional[pulumi.Input['TlsValidationOptionsArgs']] = None):
        """
        TLS endpoint describes an endpoint that the pipeline can connect to over TLS transport (data is encrypted in transit).
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.TlsEndpoint'.
        :param pulumi.Input[str] url: The endpoint URL for Video Analyzer to connect to.
        :param pulumi.Input['UsernamePasswordCredentialsArgs'] credentials: Credentials to be presented to the endpoint.
        :param pulumi.Input['PemCertificateListArgs'] trusted_certificates: List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
        :param pulumi.Input['SecureIotDeviceRemoteTunnelArgs'] tunnel: Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
        :param pulumi.Input['TlsValidationOptionsArgs'] validation_options: Validation options to use when authenticating a TLS connection. By default, strict validation is used.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.TlsEndpoint')
        pulumi.set(__self__, "url", url)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if trusted_certificates is not None:
            pulumi.set(__self__, "trusted_certificates", trusted_certificates)
        if tunnel is not None:
            pulumi.set(__self__, "tunnel", tunnel)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.TlsEndpoint'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The endpoint URL for Video Analyzer to connect to.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['UsernamePasswordCredentialsArgs']]:
        """
        Credentials to be presented to the endpoint.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['UsernamePasswordCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="trustedCertificates")
    def trusted_certificates(self) -> Optional[pulumi.Input['PemCertificateListArgs']]:
        """
        List of trusted certificate authorities when authenticating a TLS connection. A null list designates that Azure Video Analyzer's list of trusted authorities should be used.
        """
        return pulumi.get(self, "trusted_certificates")

    @trusted_certificates.setter
    def trusted_certificates(self, value: Optional[pulumi.Input['PemCertificateListArgs']]):
        pulumi.set(self, "trusted_certificates", value)

    @property
    @pulumi.getter
    def tunnel(self) -> Optional[pulumi.Input['SecureIotDeviceRemoteTunnelArgs']]:
        """
        Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
        """
        return pulumi.get(self, "tunnel")

    @tunnel.setter
    def tunnel(self, value: Optional[pulumi.Input['SecureIotDeviceRemoteTunnelArgs']]):
        pulumi.set(self, "tunnel", value)

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional[pulumi.Input['TlsValidationOptionsArgs']]:
        """
        Validation options to use when authenticating a TLS connection. By default, strict validation is used.
        """
        return pulumi.get(self, "validation_options")

    @validation_options.setter
    def validation_options(self, value: Optional[pulumi.Input['TlsValidationOptionsArgs']]):
        pulumi.set(self, "validation_options", value)


@pulumi.input_type
class TlsValidationOptionsArgs:
    def __init__(__self__, *,
                 ignore_hostname: Optional[pulumi.Input[str]] = None,
                 ignore_signature: Optional[pulumi.Input[str]] = None):
        """
        Options for controlling the validation of TLS endpoints.
        :param pulumi.Input[str] ignore_hostname: When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
        :param pulumi.Input[str] ignore_signature: When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
        """
        if ignore_hostname is not None:
            pulumi.set(__self__, "ignore_hostname", ignore_hostname)
        if ignore_signature is not None:
            pulumi.set(__self__, "ignore_signature", ignore_signature)

    @property
    @pulumi.getter(name="ignoreHostname")
    def ignore_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        When set to 'true' causes the certificate subject name validation to be skipped. Default is 'false'.
        """
        return pulumi.get(self, "ignore_hostname")

    @ignore_hostname.setter
    def ignore_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ignore_hostname", value)

    @property
    @pulumi.getter(name="ignoreSignature")
    def ignore_signature(self) -> Optional[pulumi.Input[str]]:
        """
        When set to 'true' causes the certificate chain trust validation to be skipped. Default is 'false'.
        """
        return pulumi.get(self, "ignore_signature")

    @ignore_signature.setter
    def ignore_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ignore_signature", value)


@pulumi.input_type
class TokenClaimArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Properties for expected token claims.
        :param pulumi.Input[str] name: Name of the claim which must be present on the token.
        :param pulumi.Input[str] value: Expected value of the claim to be present on the token.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the claim which must be present on the token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Expected value of the claim to be present on the token.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class UnsecuredEndpointArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 url: pulumi.Input[str],
                 credentials: Optional[pulumi.Input['UsernamePasswordCredentialsArgs']] = None,
                 tunnel: Optional[pulumi.Input['SecureIotDeviceRemoteTunnelArgs']] = None):
        """
        Unsecured endpoint describes an endpoint that the pipeline can connect to over clear transport (no encryption in transit).
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.UnsecuredEndpoint'.
        :param pulumi.Input[str] url: The endpoint URL for Video Analyzer to connect to.
        :param pulumi.Input['UsernamePasswordCredentialsArgs'] credentials: Credentials to be presented to the endpoint.
        :param pulumi.Input['SecureIotDeviceRemoteTunnelArgs'] tunnel: Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.UnsecuredEndpoint')
        pulumi.set(__self__, "url", url)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if tunnel is not None:
            pulumi.set(__self__, "tunnel", tunnel)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.UnsecuredEndpoint'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The endpoint URL for Video Analyzer to connect to.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['UsernamePasswordCredentialsArgs']]:
        """
        Credentials to be presented to the endpoint.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['UsernamePasswordCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def tunnel(self) -> Optional[pulumi.Input['SecureIotDeviceRemoteTunnelArgs']]:
        """
        Describes the tunnel through which Video Analyzer can connect to the endpoint URL. This is an optional property, typically used when the endpoint is behind a firewall.
        """
        return pulumi.get(self, "tunnel")

    @tunnel.setter
    def tunnel(self, value: Optional[pulumi.Input['SecureIotDeviceRemoteTunnelArgs']]):
        pulumi.set(self, "tunnel", value)


@pulumi.input_type
class UsernamePasswordCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 type: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        Username and password credentials.
        :param pulumi.Input[str] password: Password to be presented as part of the credentials. It is recommended that this value is parameterized as a secret string in order to prevent this value to be returned as part of the resource on API requests.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials'.
        :param pulumi.Input[str] username: Username to be presented as part of the credentials.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials')
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password to be presented as part of the credentials. It is recommended that this value is parameterized as a secret string in order to prevent this value to be returned as part of the resource on API requests.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username to be presented as part of the credentials.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VideoAnalyzerIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The managed identity for the Video Analyzer resource.
        :param pulumi.Input[str] type: The identity type.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The User Assigned Managed Identities.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The User Assigned Managed Identities.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class VideoCreationPropertiesArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[str]] = None,
                 segment_length: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Optional properties to be used in case a new video resource needs to be created on the service. These will not take effect if the video already exists.
        :param pulumi.Input[str] description: Optional description provided by the user. Value can be up to 2048 characters long.
        :param pulumi.Input[str] retention_period: Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format (i.e. "PT1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies where "kind" is set to "live".
        :param pulumi.Input[str] segment_length: Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial call to create the video resource can lead to errors when uploading content to the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
        :param pulumi.Input[str] title: Optional title provided by the user. Value can be up to 256 characters long.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if segment_length is not None:
            pulumi.set(__self__, "segment_length", segment_length)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional description provided by the user. Value can be up to 2048 characters long.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[str]]:
        """
        Video retention period indicates how long the video is kept in storage. Value must be specified in ISO8601 duration format (i.e. "PT1D" equals 1 day) and can vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is retained indefinitely. This property is only allowed for topologies where "kind" is set to "live".
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="segmentLength")
    def segment_length(self) -> Optional[pulumi.Input[str]]:
        """
        Segment length indicates the length of individual content files (segments) which are persisted to storage. Smaller segments provide lower archive playback latency but generate larger volume of storage transactions. Larger segments reduce the amount of storage transactions while increasing the archive playback latency. Value must be specified in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to 5 minutes, in 30 seconds increments. Changing this value after the initial call to create the video resource can lead to errors when uploading content to the archive. Default value is 30 seconds. This property is only allowed for topologies where "kind" is set to "live".
        """
        return pulumi.get(self, "segment_length")

    @segment_length.setter
    def segment_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_length", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional title provided by the user. Value can be up to 256 characters long.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class VideoEncoderH264Args:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 bitrate_kbps: Optional[pulumi.Input[str]] = None,
                 frame_rate: Optional[pulumi.Input[str]] = None,
                 scale: Optional[pulumi.Input['VideoScaleArgs']] = None):
        """
        A custom preset for encoding video with the H.264 (AVC) codec.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.VideoEncoderH264'.
        :param pulumi.Input[str] bitrate_kbps: The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
        :param pulumi.Input[str] frame_rate: The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
        :param pulumi.Input['VideoScaleArgs'] scale: Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.VideoEncoderH264')
        if bitrate_kbps is not None:
            pulumi.set(__self__, "bitrate_kbps", bitrate_kbps)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.VideoEncoderH264'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="bitrateKbps")
    def bitrate_kbps(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum bitrate, in kilobits per second or Kbps, at which video should be encoded. If omitted, encoder sets it automatically to try and match the quality of the input video.
        """
        return pulumi.get(self, "bitrate_kbps")

    @bitrate_kbps.setter
    def bitrate_kbps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bitrate_kbps", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[pulumi.Input[str]]:
        """
        The frame rate (in frames per second) of the encoded video. The value must be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average frame rate of the input video.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frame_rate", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input['VideoScaleArgs']]:
        """
        Describes the resolution of the encoded video. If omitted, the encoder uses the resolution of the input video.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input['VideoScaleArgs']]):
        pulumi.set(self, "scale", value)


@pulumi.input_type
class VideoPublishingOptionsArgs:
    def __init__(__self__, *,
                 disable_archive: Optional[pulumi.Input[str]] = None,
                 disable_rtsp_publishing: Optional[pulumi.Input[str]] = None,
                 disable_video_preview_image: Optional[pulumi.Input[str]] = None):
        """
        Optional flags used to change how video is published. These are only allowed for topologies where "kind" is set to "live".
        :param pulumi.Input[str] disable_archive: When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
        :param pulumi.Input[str] disable_rtsp_publishing: When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example, when the topology is used only for archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to 'false'.
        :param pulumi.Input[str] disable_video_preview_image: When set to 'true' preview images will not be generated. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'false', then "disableArchive" must be set to 'false'.
        """
        if disable_archive is not None:
            pulumi.set(__self__, "disable_archive", disable_archive)
        if disable_rtsp_publishing is not None:
            pulumi.set(__self__, "disable_rtsp_publishing", disable_rtsp_publishing)
        if disable_video_preview_image is not None:
            pulumi.set(__self__, "disable_video_preview_image", disable_video_preview_image)

    @property
    @pulumi.getter(name="disableArchive")
    def disable_archive(self) -> Optional[pulumi.Input[str]]:
        """
        When set to 'true' content will not be archived or recorded. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
        """
        return pulumi.get(self, "disable_archive")

    @disable_archive.setter
    def disable_archive(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disable_archive", value)

    @property
    @pulumi.getter(name="disableRtspPublishing")
    def disable_rtsp_publishing(self) -> Optional[pulumi.Input[str]]:
        """
        When set to 'true' the RTSP playback URL will not be published, disabling low latency streaming. This is used, for example, when the topology is used only for archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to 'false'.
        """
        return pulumi.get(self, "disable_rtsp_publishing")

    @disable_rtsp_publishing.setter
    def disable_rtsp_publishing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disable_rtsp_publishing", value)

    @property
    @pulumi.getter(name="disableVideoPreviewImage")
    def disable_video_preview_image(self) -> Optional[pulumi.Input[str]]:
        """
        When set to 'true' preview images will not be generated. This is used, for example, when the topology is used only for low latency video streaming. Default is 'false'.  If set to 'false', then "disableArchive" must be set to 'false'.
        """
        return pulumi.get(self, "disable_video_preview_image")

    @disable_video_preview_image.setter
    def disable_video_preview_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disable_video_preview_image", value)


@pulumi.input_type
class VideoScaleArgs:
    def __init__(__self__, *,
                 height: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'VideoScaleMode']]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        The video scaling information.
        :param pulumi.Input[str] height: The desired output video height.
        :param pulumi.Input[Union[str, 'VideoScaleMode']] mode: Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
        :param pulumi.Input[str] width: The desired output video width.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The desired output video height.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'VideoScaleMode']]]:
        """
        Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is 'PreserveAspectRatio' then only one of width or height need be provided.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'VideoScaleMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The desired output video width.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class VideoSequenceAbsoluteTimeMarkersArgs:
    def __init__(__self__, *,
                 ranges: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        A sequence of absolute datetime ranges as a string. The datetime values should follow IS08601, and the sum of the ranges should add up to 24 hours or less. Currently, there can be only one range specified in the sequence.
        :param pulumi.Input[str] ranges: The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers'.
        """
        pulumi.set(__self__, "ranges", ranges)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers')

    @property
    @pulumi.getter
    def ranges(self) -> pulumi.Input[str]:
        """
        The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z", "2021-10-05T03:40:00Z"]]'.
        """
        return pulumi.get(self, "ranges")

    @ranges.setter
    def ranges(self, value: pulumi.Input[str]):
        pulumi.set(self, "ranges", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class VideoSinkArgs:
    def __init__(__self__, *,
                 inputs: pulumi.Input[Sequence[pulumi.Input['NodeInputArgs']]],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 video_name: pulumi.Input[str],
                 video_creation_properties: Optional[pulumi.Input['VideoCreationPropertiesArgs']] = None,
                 video_publishing_options: Optional[pulumi.Input['VideoPublishingOptionsArgs']] = None):
        """
        Video sink in a live topology allows for video and audio to be captured, optionally archived, and published via a video resource. If archiving is enabled, this results in a video of type 'archive'. If used in a batch topology, this allows for video and audio to be stored as a file, and published via a video resource of type 'file'
        :param pulumi.Input[Sequence[pulumi.Input['NodeInputArgs']]] inputs: An array of upstream node references within the topology to be used as inputs for this node.
        :param pulumi.Input[str] name: Node name. Must be unique within the topology.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.VideoSink'.
        :param pulumi.Input[str] video_name: Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then no content is archived.
        :param pulumi.Input['VideoCreationPropertiesArgs'] video_creation_properties: Optional video properties to be used in case a new video resource needs to be created on the service.
        :param pulumi.Input['VideoPublishingOptionsArgs'] video_publishing_options: Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
        """
        pulumi.set(__self__, "inputs", inputs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.VideoSink')
        pulumi.set(__self__, "video_name", video_name)
        if video_creation_properties is not None:
            pulumi.set(__self__, "video_creation_properties", video_creation_properties)
        if video_publishing_options is not None:
            pulumi.set(__self__, "video_publishing_options", video_publishing_options)

    @property
    @pulumi.getter
    def inputs(self) -> pulumi.Input[Sequence[pulumi.Input['NodeInputArgs']]]:
        """
        An array of upstream node references within the topology to be used as inputs for this node.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: pulumi.Input[Sequence[pulumi.Input['NodeInputArgs']]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Node name. Must be unique within the topology.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.VideoSink'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="videoName")
    def video_name(self) -> pulumi.Input[str]:
        """
        Name of a new or existing video resource used to capture and publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then no content is archived.
        """
        return pulumi.get(self, "video_name")

    @video_name.setter
    def video_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "video_name", value)

    @property
    @pulumi.getter(name="videoCreationProperties")
    def video_creation_properties(self) -> Optional[pulumi.Input['VideoCreationPropertiesArgs']]:
        """
        Optional video properties to be used in case a new video resource needs to be created on the service.
        """
        return pulumi.get(self, "video_creation_properties")

    @video_creation_properties.setter
    def video_creation_properties(self, value: Optional[pulumi.Input['VideoCreationPropertiesArgs']]):
        pulumi.set(self, "video_creation_properties", value)

    @property
    @pulumi.getter(name="videoPublishingOptions")
    def video_publishing_options(self) -> Optional[pulumi.Input['VideoPublishingOptionsArgs']]:
        """
        Options to change how the video sink publishes content via the video resource. This property is only allowed for topologies where "kind" is set to "live".
        """
        return pulumi.get(self, "video_publishing_options")

    @video_publishing_options.setter
    def video_publishing_options(self, value: Optional[pulumi.Input['VideoPublishingOptionsArgs']]):
        pulumi.set(self, "video_publishing_options", value)


@pulumi.input_type
class VideoSourceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 time_sequences: pulumi.Input['VideoSequenceAbsoluteTimeMarkersArgs'],
                 type: pulumi.Input[str],
                 video_name: pulumi.Input[str]):
        """
        Video source allows for content from a Video Analyzer video resource to be ingested into a pipeline. Currently supported only with batch pipelines.
        :param pulumi.Input[str] name: Node name. Must be unique within the topology.
        :param pulumi.Input['VideoSequenceAbsoluteTimeMarkersArgs'] time_sequences: Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.VideoSource'.
        :param pulumi.Input[str] video_name: Name of the Video Analyzer video resource to be used as the source.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "time_sequences", time_sequences)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.VideoSource')
        pulumi.set(__self__, "video_name", video_name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Node name. Must be unique within the topology.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="timeSequences")
    def time_sequences(self) -> pulumi.Input['VideoSequenceAbsoluteTimeMarkersArgs']:
        """
        Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
        """
        return pulumi.get(self, "time_sequences")

    @time_sequences.setter
    def time_sequences(self, value: pulumi.Input['VideoSequenceAbsoluteTimeMarkersArgs']):
        pulumi.set(self, "time_sequences", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.VideoSource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="videoName")
    def video_name(self) -> pulumi.Input[str]:
        """
        Name of the Video Analyzer video resource to be used as the source.
        """
        return pulumi.get(self, "video_name")

    @video_name.setter
    def video_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "video_name", value)


