# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['ManagementLockAtResourceGroupLevelArgs', 'ManagementLockAtResourceGroupLevel']

@pulumi.input_type
class ManagementLockAtResourceGroupLevelArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 level: Optional[pulumi.Input[Union[str, 'LockLevel']]] = None,
                 lock_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ManagementLockAtResourceGroupLevel resource.
        :param pulumi.Input[str] resource_group_name: The resource group name.
        :param pulumi.Input[Union[str, 'LockLevel']] level: The lock level of the management lock.
        :param pulumi.Input[str] lock_name: The lock name.
        :param pulumi.Input[str] name: The name of the lock.
        :param pulumi.Input[str] notes: The notes of the management lock.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if lock_name is not None:
            pulumi.set(__self__, "lock_name", lock_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The resource group name.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[Union[str, 'LockLevel']]]:
        """
        The lock level of the management lock.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[Union[str, 'LockLevel']]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="lockName")
    def lock_name(self) -> Optional[pulumi.Input[str]]:
        """
        The lock name.
        """
        return pulumi.get(self, "lock_name")

    @lock_name.setter
    def lock_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the lock.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        The notes of the management lock.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)


class ManagementLockAtResourceGroupLevel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 level: Optional[pulumi.Input[Union[str, 'LockLevel']]] = None,
                 lock_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Management lock information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'LockLevel']] level: The lock level of the management lock.
        :param pulumi.Input[str] lock_name: The lock name.
        :param pulumi.Input[str] name: The name of the lock.
        :param pulumi.Input[str] notes: The notes of the management lock.
        :param pulumi.Input[str] resource_group_name: The resource group name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementLockAtResourceGroupLevelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Management lock information.

        :param str resource_name: The name of the resource.
        :param ManagementLockAtResourceGroupLevelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementLockAtResourceGroupLevelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 level: Optional[pulumi.Input[Union[str, 'LockLevel']]] = None,
                 lock_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementLockAtResourceGroupLevelArgs.__new__(ManagementLockAtResourceGroupLevelArgs)

            __props__.__dict__["level"] = level
            __props__.__dict__["lock_name"] = lock_name
            __props__.__dict__["name"] = name
            __props__.__dict__["notes"] = notes
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:authorization/v20150101:ManagementLockAtResourceGroupLevel"), pulumi.Alias(type_="azure-native:authorization:ManagementLockAtResourceGroupLevel"), pulumi.Alias(type_="azure-nextgen:authorization:ManagementLockAtResourceGroupLevel"), pulumi.Alias(type_="azure-native:authorization/v20160901:ManagementLockAtResourceGroupLevel"), pulumi.Alias(type_="azure-nextgen:authorization/v20160901:ManagementLockAtResourceGroupLevel"), pulumi.Alias(type_="azure-native:authorization/v20170401:ManagementLockAtResourceGroupLevel"), pulumi.Alias(type_="azure-nextgen:authorization/v20170401:ManagementLockAtResourceGroupLevel"), pulumi.Alias(type_="azure-native:authorization/v20200501:ManagementLockAtResourceGroupLevel"), pulumi.Alias(type_="azure-nextgen:authorization/v20200501:ManagementLockAtResourceGroupLevel")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ManagementLockAtResourceGroupLevel, __self__).__init__(
            'azure-native:authorization/v20150101:ManagementLockAtResourceGroupLevel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ManagementLockAtResourceGroupLevel':
        """
        Get an existing ManagementLockAtResourceGroupLevel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ManagementLockAtResourceGroupLevelArgs.__new__(ManagementLockAtResourceGroupLevelArgs)

        __props__.__dict__["level"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["notes"] = None
        __props__.__dict__["type"] = None
        return ManagementLockAtResourceGroupLevel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def level(self) -> pulumi.Output[Optional[str]]:
        """
        The lock level of the management lock.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the lock.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[str]]:
        """
        The notes of the management lock.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the lock.
        """
        return pulumi.get(self, "type")

