# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'ImageTemplateIsoSourceResponse',
    'ImageTemplateLastRunStatusResponse',
    'ImageTemplateManagedImageDistributorResponse',
    'ImageTemplateManagedImageSourceResponse',
    'ImageTemplatePlatformImageSourceResponse',
    'ImageTemplatePowerShellCustomizerResponse',
    'ImageTemplateRestartCustomizerResponse',
    'ImageTemplateSharedImageDistributorResponse',
    'ImageTemplateShellCustomizerResponse',
    'ImageTemplateVhdDistributorResponse',
    'ProvisioningErrorResponse',
]

@pulumi.output_type
class ImageTemplateIsoSourceResponse(dict):
    """
    Describes an image source that is an installation ISO. Currently only supports Red Hat Enterprise Linux 7.2-7.5 ISO's.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Checksum":
            suggest = "sha256_checksum"
        elif key == "sourceURI":
            suggest = "source_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTemplateIsoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTemplateIsoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTemplateIsoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sha256_checksum: str,
                 source_uri: str,
                 type: str):
        """
        Describes an image source that is an installation ISO. Currently only supports Red Hat Enterprise Linux 7.2-7.5 ISO's.
        :param str sha256_checksum: SHA256 Checksum of the ISO image.
        :param str source_uri: URI to get the ISO image. This URI has to be accessible to the resource provider at the time of the image template creation.
        :param str type: Specifies the type of source image you want to start with.
               Expected value is 'ISO'.
        """
        pulumi.set(__self__, "sha256_checksum", sha256_checksum)
        pulumi.set(__self__, "source_uri", source_uri)
        pulumi.set(__self__, "type", 'ISO')

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> str:
        """
        SHA256 Checksum of the ISO image.
        """
        return pulumi.get(self, "sha256_checksum")

    @property
    @pulumi.getter(name="sourceURI")
    def source_uri(self) -> str:
        """
        URI to get the ISO image. This URI has to be accessible to the resource provider at the time of the image template creation.
        """
        return pulumi.get(self, "source_uri")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of source image you want to start with.
        Expected value is 'ISO'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ImageTemplateLastRunStatusResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "runState":
            suggest = "run_state"
        elif key == "runSubState":
            suggest = "run_sub_state"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTemplateLastRunStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTemplateLastRunStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTemplateLastRunStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[str] = None,
                 message: Optional[str] = None,
                 run_state: Optional[str] = None,
                 run_sub_state: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        :param str end_time: End time of the last run (UTC)
        :param str message: Verbose information about the last run state
        :param str run_state: State of the last run
        :param str run_sub_state: Sub-state of the last run
        :param str start_time: Start time of the last run (UTC)
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if run_state is not None:
            pulumi.set(__self__, "run_state", run_state)
        if run_sub_state is not None:
            pulumi.set(__self__, "run_sub_state", run_sub_state)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        End time of the last run (UTC)
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Verbose information about the last run state
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="runState")
    def run_state(self) -> Optional[str]:
        """
        State of the last run
        """
        return pulumi.get(self, "run_state")

    @property
    @pulumi.getter(name="runSubState")
    def run_sub_state(self) -> Optional[str]:
        """
        Sub-state of the last run
        """
        return pulumi.get(self, "run_sub_state")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Start time of the last run (UTC)
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ImageTemplateManagedImageDistributorResponse(dict):
    """
    Distribute as a Managed Disk Image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"
        elif key == "runOutputName":
            suggest = "run_output_name"
        elif key == "artifactTags":
            suggest = "artifact_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTemplateManagedImageDistributorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTemplateManagedImageDistributorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTemplateManagedImageDistributorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: str,
                 location: str,
                 run_output_name: str,
                 type: str,
                 artifact_tags: Optional[Mapping[str, str]] = None):
        """
        Distribute as a Managed Disk Image.
        :param str image_id: Resource Id of the Managed Disk Image
        :param str location: Azure location for the image, should match if image already exists
        :param str run_output_name: The name to be used for the associated RunOutput.
        :param str type: Type of distribution.
               Expected value is 'ManagedImage'.
        :param Mapping[str, str] artifact_tags: Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "run_output_name", run_output_name)
        pulumi.set(__self__, "type", 'ManagedImage')
        if artifact_tags is not None:
            pulumi.set(__self__, "artifact_tags", artifact_tags)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        Resource Id of the Managed Disk Image
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Azure location for the image, should match if image already exists
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="runOutputName")
    def run_output_name(self) -> str:
        """
        The name to be used for the associated RunOutput.
        """
        return pulumi.get(self, "run_output_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of distribution.
        Expected value is 'ManagedImage'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="artifactTags")
    def artifact_tags(self) -> Optional[Mapping[str, str]]:
        """
        Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        return pulumi.get(self, "artifact_tags")


@pulumi.output_type
class ImageTemplateManagedImageSourceResponse(dict):
    """
    Describes an image source that is a managed image in customer subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTemplateManagedImageSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTemplateManagedImageSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTemplateManagedImageSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: str,
                 type: str):
        """
        Describes an image source that is a managed image in customer subscription.
        :param str image_id: ARM resource id of the managed image in customer subscription
        :param str type: Specifies the type of source image you want to start with.
               Expected value is 'ManagedImage'.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "type", 'ManagedImage')

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        ARM resource id of the managed image in customer subscription
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of source image you want to start with.
        Expected value is 'ManagedImage'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ImageTemplatePlatformImageSourceResponse(dict):
    """
    Describes an image source from [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
    """
    def __init__(__self__, *,
                 type: str,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Describes an image source from [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        :param str type: Specifies the type of source image you want to start with.
               Expected value is 'PlatformImage'.
        :param str offer: Image offer from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        :param str publisher: Image Publisher in [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        :param str sku: Image sku from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        :param str version: Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        """
        pulumi.set(__self__, "type", 'PlatformImage')
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of source image you want to start with.
        Expected value is 'PlatformImage'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        Image offer from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        Image Publisher in [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        Image sku from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ImageTemplatePowerShellCustomizerResponse(dict):
    """
    Runs the specified PowerShell on the VM (Windows). Corresponds to Packer powershell provisioner. Exactly one of 'script' or 'inline' can be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validExitCodes":
            suggest = "valid_exit_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTemplatePowerShellCustomizerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTemplatePowerShellCustomizerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTemplatePowerShellCustomizerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 inline: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 script: Optional[str] = None,
                 valid_exit_codes: Optional[Sequence[int]] = None):
        """
        Runs the specified PowerShell on the VM (Windows). Corresponds to Packer powershell provisioner. Exactly one of 'script' or 'inline' can be specified.
        :param str type: The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
               Expected value is 'PowerShell'.
        :param Sequence[str] inline: Array of PowerShell commands to execute
        :param str name: Friendly Name to provide context on what this customization step does
        :param str script: The PowerShell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
        :param Sequence[int] valid_exit_codes: Valid exit codes for the PowerShell script. [Default: 0]
        """
        pulumi.set(__self__, "type", 'PowerShell')
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if valid_exit_codes is not None:
            pulumi.set(__self__, "valid_exit_codes", valid_exit_codes)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
        Expected value is 'PowerShell'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def inline(self) -> Optional[Sequence[str]]:
        """
        Array of PowerShell commands to execute
        """
        return pulumi.get(self, "inline")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Friendly Name to provide context on what this customization step does
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        The PowerShell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="validExitCodes")
    def valid_exit_codes(self) -> Optional[Sequence[int]]:
        """
        Valid exit codes for the PowerShell script. [Default: 0]
        """
        return pulumi.get(self, "valid_exit_codes")


@pulumi.output_type
class ImageTemplateRestartCustomizerResponse(dict):
    """
    Reboots a VM and waits for it to come back online (Windows). Corresponds to Packer windows-restart provisioner
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restartCheckCommand":
            suggest = "restart_check_command"
        elif key == "restartCommand":
            suggest = "restart_command"
        elif key == "restartTimeout":
            suggest = "restart_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTemplateRestartCustomizerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTemplateRestartCustomizerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTemplateRestartCustomizerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 name: Optional[str] = None,
                 restart_check_command: Optional[str] = None,
                 restart_command: Optional[str] = None,
                 restart_timeout: Optional[str] = None):
        """
        Reboots a VM and waits for it to come back online (Windows). Corresponds to Packer windows-restart provisioner
        :param str type: The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
               Expected value is 'WindowsRestart'.
        :param str name: Friendly Name to provide context on what this customization step does
        :param str restart_check_command: Command to check if restart succeeded [Default: '']
        :param str restart_command: Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
        :param str restart_timeout: Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
        """
        pulumi.set(__self__, "type", 'WindowsRestart')
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restart_check_command is not None:
            pulumi.set(__self__, "restart_check_command", restart_check_command)
        if restart_command is not None:
            pulumi.set(__self__, "restart_command", restart_command)
        if restart_timeout is not None:
            pulumi.set(__self__, "restart_timeout", restart_timeout)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
        Expected value is 'WindowsRestart'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Friendly Name to provide context on what this customization step does
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restartCheckCommand")
    def restart_check_command(self) -> Optional[str]:
        """
        Command to check if restart succeeded [Default: '']
        """
        return pulumi.get(self, "restart_check_command")

    @property
    @pulumi.getter(name="restartCommand")
    def restart_command(self) -> Optional[str]:
        """
        Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
        """
        return pulumi.get(self, "restart_command")

    @property
    @pulumi.getter(name="restartTimeout")
    def restart_timeout(self) -> Optional[str]:
        """
        Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
        """
        return pulumi.get(self, "restart_timeout")


@pulumi.output_type
class ImageTemplateSharedImageDistributorResponse(dict):
    """
    Distribute via Shared Image Gallery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "galleryImageId":
            suggest = "gallery_image_id"
        elif key == "replicationRegions":
            suggest = "replication_regions"
        elif key == "runOutputName":
            suggest = "run_output_name"
        elif key == "artifactTags":
            suggest = "artifact_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTemplateSharedImageDistributorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTemplateSharedImageDistributorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTemplateSharedImageDistributorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gallery_image_id: str,
                 replication_regions: Sequence[str],
                 run_output_name: str,
                 type: str,
                 artifact_tags: Optional[Mapping[str, str]] = None):
        """
        Distribute via Shared Image Gallery.
        :param str gallery_image_id: Resource Id of the Shared Image Gallery image
        :param str run_output_name: The name to be used for the associated RunOutput.
        :param str type: Type of distribution.
               Expected value is 'SharedImage'.
        :param Mapping[str, str] artifact_tags: Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        pulumi.set(__self__, "gallery_image_id", gallery_image_id)
        pulumi.set(__self__, "replication_regions", replication_regions)
        pulumi.set(__self__, "run_output_name", run_output_name)
        pulumi.set(__self__, "type", 'SharedImage')
        if artifact_tags is not None:
            pulumi.set(__self__, "artifact_tags", artifact_tags)

    @property
    @pulumi.getter(name="galleryImageId")
    def gallery_image_id(self) -> str:
        """
        Resource Id of the Shared Image Gallery image
        """
        return pulumi.get(self, "gallery_image_id")

    @property
    @pulumi.getter(name="replicationRegions")
    def replication_regions(self) -> Sequence[str]:
        return pulumi.get(self, "replication_regions")

    @property
    @pulumi.getter(name="runOutputName")
    def run_output_name(self) -> str:
        """
        The name to be used for the associated RunOutput.
        """
        return pulumi.get(self, "run_output_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of distribution.
        Expected value is 'SharedImage'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="artifactTags")
    def artifact_tags(self) -> Optional[Mapping[str, str]]:
        """
        Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        return pulumi.get(self, "artifact_tags")


@pulumi.output_type
class ImageTemplateShellCustomizerResponse(dict):
    """
    Runs a shell script during the customization phase (Linux). Corresponds to Packer shell provisioner. Exactly one of 'script' or 'inline' can be specified.
    """
    def __init__(__self__, *,
                 type: str,
                 inline: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 script: Optional[str] = None):
        """
        Runs a shell script during the customization phase (Linux). Corresponds to Packer shell provisioner. Exactly one of 'script' or 'inline' can be specified.
        :param str type: The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
               Expected value is 'Shell'.
        :param Sequence[str] inline: Array of shell commands to execute
        :param str name: Friendly Name to provide context on what this customization step does
        :param str script: The shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
        """
        pulumi.set(__self__, "type", 'Shell')
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
        Expected value is 'Shell'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def inline(self) -> Optional[Sequence[str]]:
        """
        Array of shell commands to execute
        """
        return pulumi.get(self, "inline")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Friendly Name to provide context on what this customization step does
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        The shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class ImageTemplateVhdDistributorResponse(dict):
    """
    Distribute via VHD in a storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runOutputName":
            suggest = "run_output_name"
        elif key == "artifactTags":
            suggest = "artifact_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageTemplateVhdDistributorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageTemplateVhdDistributorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageTemplateVhdDistributorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 run_output_name: str,
                 type: str,
                 artifact_tags: Optional[Mapping[str, str]] = None):
        """
        Distribute via VHD in a storage account.
        :param str run_output_name: The name to be used for the associated RunOutput.
        :param str type: Type of distribution.
               Expected value is 'VHD'.
        :param Mapping[str, str] artifact_tags: Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        pulumi.set(__self__, "run_output_name", run_output_name)
        pulumi.set(__self__, "type", 'VHD')
        if artifact_tags is not None:
            pulumi.set(__self__, "artifact_tags", artifact_tags)

    @property
    @pulumi.getter(name="runOutputName")
    def run_output_name(self) -> str:
        """
        The name to be used for the associated RunOutput.
        """
        return pulumi.get(self, "run_output_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of distribution.
        Expected value is 'VHD'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="artifactTags")
    def artifact_tags(self) -> Optional[Mapping[str, str]]:
        """
        Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        return pulumi.get(self, "artifact_tags")


@pulumi.output_type
class ProvisioningErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningErrorCode":
            suggest = "provisioning_error_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProvisioningErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProvisioningErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProvisioningErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: Optional[str] = None,
                 provisioning_error_code: Optional[str] = None):
        """
        :param str message: Verbose error message about the provisioning failure
        :param str provisioning_error_code: Error code of the provisioning failure
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if provisioning_error_code is not None:
            pulumi.set(__self__, "provisioning_error_code", provisioning_error_code)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Verbose error message about the provisioning failure
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="provisioningErrorCode")
    def provisioning_error_code(self) -> Optional[str]:
        """
        Error code of the provisioning failure
        """
        return pulumi.get(self, "provisioning_error_code")


