# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCapacityDetailsResult',
    'AwaitableGetCapacityDetailsResult',
    'get_capacity_details',
]

@pulumi.output_type
class GetCapacityDetailsResult:
    """
    Represents an instance of a Dedicated Capacity resource.
    """
    def __init__(__self__, administration=None, id=None, location=None, mode=None, name=None, provisioning_state=None, sku=None, state=None, system_data=None, tags=None, type=None):
        if administration and not isinstance(administration, dict):
            raise TypeError("Expected argument 'administration' to be a dict")
        pulumi.set(__self__, "administration", administration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if sku and not isinstance(sku, dict):
            raise TypeError("Expected argument 'sku' to be a dict")
        pulumi.set(__self__, "sku", sku)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def administration(self) -> Optional['outputs.DedicatedCapacityAdministratorsResponse']:
        """
        A collection of Dedicated capacity administrators
        """
        return pulumi.get(self, "administration")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        An identifier that represents the PowerBI Dedicated resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Location of the PowerBI Dedicated resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The capacity mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the PowerBI Dedicated resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The current deployment state of PowerBI Dedicated resource. The provisioningState is to indicate states for resource provisioning.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def sku(self) -> 'outputs.CapacitySkuResponse':
        """
        The SKU of the PowerBI Dedicated capacity resource.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of PowerBI Dedicated resource. The state is to indicate more states outside of resource provisioning.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> Optional['outputs.SystemDataResponse']:
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Key-value pairs of additional resource provisioning properties.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the PowerBI Dedicated resource.
        """
        return pulumi.get(self, "type")


class AwaitableGetCapacityDetailsResult(GetCapacityDetailsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCapacityDetailsResult(
            administration=self.administration,
            id=self.id,
            location=self.location,
            mode=self.mode,
            name=self.name,
            provisioning_state=self.provisioning_state,
            sku=self.sku,
            state=self.state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_capacity_details(dedicated_capacity_name: Optional[str] = None,
                         resource_group_name: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCapacityDetailsResult:
    """
    Represents an instance of a Dedicated Capacity resource.


    :param str dedicated_capacity_name: The name of the dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
    :param str resource_group_name: The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
    """
    __args__ = dict()
    __args__['dedicatedCapacityName'] = dedicated_capacity_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:powerbidedicated/v20210101:getCapacityDetails', __args__, opts=opts, typ=GetCapacityDetailsResult).value

    return AwaitableGetCapacityDetailsResult(
        administration=__ret__.administration,
        id=__ret__.id,
        location=__ret__.location,
        mode=__ret__.mode,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        sku=__ret__.sku,
        state=__ret__.state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)
