# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AddRemove',
    'ConfigurationState',
    'ConnectionType',
    'EnableState',
    'LabUserAccessMode',
    'ManagedLabVmSize',
    'RecurrenceFrequency',
    'ShutdownOnIdleMode',
    'WeekDay',
]


class AddRemove(str, Enum):
    """
    Enum indicating if user is adding or removing a favorite lab
    """
    ADD = "Add"
    """Indicates that a user is adding a favorite lab"""
    REMOVE = "Remove"
    """Indicates that a user is removing a favorite lab"""


class ConfigurationState(str, Enum):
    """
    Describes the user's progress in configuring their environment setting
    """
    NOT_APPLICABLE = "NotApplicable"
    """User either hasn't started configuring their template
or they haven't started the configuration process."""
    COMPLETED = "Completed"
    """User is finished modifying the template."""


class ConnectionType(str, Enum):
    """
    The enabled access level for Web Access over SSH.
    """
    PUBLIC = "Public"
    PRIVATE = "Private"
    NONE = "None"


class EnableState(str, Enum):
    """
    Whether a VM will get shutdown when it hasn't been connected to after a period of time.
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class LabUserAccessMode(str, Enum):
    """
    Lab user access mode (open to all vs. restricted to those listed on the lab).
    """
    RESTRICTED = "Restricted"
    """Only users registered with the lab can access VMs."""
    OPEN = "Open"
    """Any user can register with the lab and access its VMs."""


class ManagedLabVmSize(str, Enum):
    """
    The size of the virtual machine
    """
    BASIC = "Basic"
    """The base VM size"""
    STANDARD = "Standard"
    """The standard or default VM size"""
    PERFORMANCE = "Performance"
    """The most performant VM size"""


class RecurrenceFrequency(str, Enum):
    """
    The frequency of the recurrence.
    """
    DAILY = "Daily"
    """Schedule will run every days."""
    WEEKLY = "Weekly"
    """Schedule will run every week on days specified in weekDays."""


class ShutdownOnIdleMode(str, Enum):
    """
    Whether a VM will get shutdown when it has idled for a period of time.
    """
    NONE = "None"
    """The VM won't be shut down when it is idle."""
    USER_ABSENCE = "UserAbsence"
    """The VM will be considered as idle when there is no keyboard or mouse input."""
    LOW_USAGE = "LowUsage"
    """The VM will be considered as idle when user is absent and the resource (CPU and disk) consumption is low."""


class WeekDay(str, Enum):
    """
    Days of the week.
    """
    SUNDAY = "Sunday"
    """Schedule will run on Sunday"""
    MONDAY = "Monday"
    """Schedule will run on Monday"""
    TUESDAY = "Tuesday"
    """Schedule will run on Tuesday"""
    WEDNESDAY = "Wednesday"
    """Schedule will run on Wednesday"""
    THURSDAY = "Thursday"
    """Schedule will run on Thursday"""
    FRIDAY = "Friday"
    """Schedule will run on Friday"""
    SATURDAY = "Saturday"
    """Schedule will run on Saturday"""
