# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'ArmServicePackageActivationMode',
    'ArmUpgradeFailureAction',
    'ManagedIdentityType',
    'MoveCost',
    'PartitionScheme',
    'ProbeProtocol',
    'Protocol',
    'RollingUpgradeMode',
    'ServiceCorrelationScheme',
    'ServiceKind',
    'ServiceLoadMetricWeight',
    'ServicePlacementPolicyType',
]


class ArmServicePackageActivationMode(str, Enum):
    """
    The activation Mode of the service package
    """
    SHARED_PROCESS = "SharedProcess"
    """Indicates the application package activation mode will use shared process."""
    EXCLUSIVE_PROCESS = "ExclusiveProcess"
    """Indicates the application package activation mode will use exclusive process."""


class ArmUpgradeFailureAction(str, Enum):
    """
    The activation Mode of the service package
    """
    ROLLBACK = "Rollback"
    """Indicates that a rollback of the upgrade will be performed by Service Fabric if the upgrade fails."""
    MANUAL = "Manual"
    """Indicates that a manual repair will need to be performed by the administrator if the upgrade fails. Service Fabric will not proceed to the next upgrade domain automatically."""


class ManagedIdentityType(str, Enum):
    """
    The type of managed identity for the resource.
    """
    SYSTEM_ASSIGNED = "SystemAssigned"
    """Indicates that system assigned identity is associated with the resource."""
    USER_ASSIGNED = "UserAssigned"
    """Indicates that user assigned identity is associated with the resource."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    """Indicates that both system assigned and user assigned identity are associated with the resource."""
    NONE = "None"
    """Indicates that no identity is associated with the resource."""


class MoveCost(str, Enum):
    """
    Specifies the move cost for the service.
    """
    ZERO = "Zero"
    """Zero move cost. This value is zero."""
    LOW = "Low"
    """Specifies the move cost of the service as Low. The value is 1."""
    MEDIUM = "Medium"
    """Specifies the move cost of the service as Medium. The value is 2."""
    HIGH = "High"
    """Specifies the move cost of the service as High. The value is 3."""


class PartitionScheme(str, Enum):
    """
    Specifies how the service is partitioned.
    """
    INVALID = "Invalid"
    """Indicates the partition kind is invalid. All Service Fabric enumerations have the invalid type. The value is zero."""
    SINGLETON = "Singleton"
    """Indicates that the partition is based on string names, and is a SingletonPartitionSchemeDescription object, The value is 1."""
    UNIFORM_INT64_RANGE = "UniformInt64Range"
    """Indicates that the partition is based on Int64 key ranges, and is a UniformInt64RangePartitionSchemeDescription object. The value is 2."""
    NAMED = "Named"
    """Indicates that the partition is based on string names, and is a NamedPartitionSchemeDescription object. The value is 3"""


class ProbeProtocol(str, Enum):
    """
    the reference to the load balancer probe used by the load balancing rule.
    """
    TCP = "tcp"
    HTTP = "http"
    HTTPS = "https"


class Protocol(str, Enum):
    """
    The reference to the transport protocol used by the load balancing rule.
    """
    TCP = "tcp"
    UDP = "udp"


class RollingUpgradeMode(str, Enum):
    """
    The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored.
    """
    INVALID = "Invalid"
    """Indicates the upgrade mode is invalid. All Service Fabric enumerations have the invalid type. The value is zero."""
    UNMONITORED_AUTO = "UnmonitoredAuto"
    """The upgrade will proceed automatically without performing any health monitoring. The value is 1"""
    UNMONITORED_MANUAL = "UnmonitoredManual"
    """The upgrade will stop after completing each upgrade domain, giving the opportunity to manually monitor health before proceeding. The value is 2"""
    MONITORED = "Monitored"
    """The upgrade will stop after completing each upgrade domain and automatically monitor health before proceeding. The value is 3"""


class ServiceCorrelationScheme(str, Enum):
    """
    The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
    """
    INVALID = "Invalid"
    """An invalid correlation scheme. Cannot be used. The value is zero."""
    AFFINITY = "Affinity"
    """Indicates that this service has an affinity relationship with another service. Provided for backwards compatibility, consider preferring the Aligned or NonAlignedAffinity options. The value is 1."""
    ALIGNED_AFFINITY = "AlignedAffinity"
    """Aligned affinity ensures that the primaries of the partitions of the affinitized services are collocated on the same nodes. This is the default and is the same as selecting the Affinity scheme. The value is 2."""
    NON_ALIGNED_AFFINITY = "NonAlignedAffinity"
    """Non-Aligned affinity guarantees that all replicas of each service will be placed on the same nodes. Unlike Aligned Affinity, this does not guarantee that replicas of particular role will be collocated. The value is 3."""


class ServiceKind(str, Enum):
    """
    The kind of service (Stateless or Stateful).
    """
    INVALID = "Invalid"
    """Indicates the service kind is invalid. All Service Fabric enumerations have the invalid type. The value is zero."""
    STATELESS = "Stateless"
    """Does not use Service Fabric to make its state highly available or reliable. The value is 1."""
    STATEFUL = "Stateful"
    """Uses Service Fabric to make its state or part of its state highly available and reliable. The value is 2."""


class ServiceLoadMetricWeight(str, Enum):
    """
    The service load metric relative weight, compared to other metrics configured for this service, as a number.
    """
    ZERO = "Zero"
    """Disables resource balancing for this metric. This value is zero."""
    LOW = "Low"
    """Specifies the metric weight of the service load as Low. The value is 1."""
    MEDIUM = "Medium"
    """Specifies the metric weight of the service load as Medium. The value is 2."""
    HIGH = "High"
    """Specifies the metric weight of the service load as High. The value is 3."""


class ServicePlacementPolicyType(str, Enum):
    """
    The type of placement policy for a service fabric service. Following are the possible values.
    """
    INVALID = "Invalid"
    """Indicates the type of the placement policy is invalid. All Service Fabric enumerations have the invalid type. The value is zero."""
    INVALID_DOMAIN = "InvalidDomain"
    """Indicates that the ServicePlacementPolicyDescription is of type ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or upgrade domain cannot be used for placement of this service. The value is 1."""
    REQUIRED_DOMAIN = "RequiredDomain"
    """Indicates that the ServicePlacementPolicyDescription is of type ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the service must be placed in a specific domain. The value is 2."""
    PREFERRED_PRIMARY_DOMAIN = "PreferredPrimaryDomain"
    """Indicates that the ServicePlacementPolicyDescription is of type ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the Primary replica for the partitions of the service should be located in a particular domain as an optimization. The value is 3."""
    REQUIRED_DOMAIN_DISTRIBUTION = "RequiredDomainDistribution"
    """Indicates that the ServicePlacementPolicyDescription is of type ServicePlacementRequireDomainDistributionPolicyDescription, indicating that the system will disallow placement of any two replicas from the same partition in the same domain at any time. The value is 4."""
    NON_PARTIALLY_PLACE_SERVICE = "NonPartiallyPlaceService"
    """Indicates that the ServicePlacementPolicyDescription is of type ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible all replicas of a particular partition of the service should be placed atomically. The value is 5."""
