# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'HttpAuthenticationArgs',
    'HttpRequestArgs',
    'JobActionArgs',
    'JobCollectionPropertiesArgs',
    'JobCollectionQuotaArgs',
    'JobErrorActionArgs',
    'JobMaxRecurrenceArgs',
    'JobPropertiesArgs',
    'JobRecurrenceScheduleMonthlyOccurrenceArgs',
    'JobRecurrenceScheduleArgs',
    'JobRecurrenceArgs',
    'RetryPolicyArgs',
    'ServiceBusAuthenticationArgs',
    'ServiceBusBrokeredMessagePropertiesArgs',
    'ServiceBusQueueMessageArgs',
    'ServiceBusTopicMessageArgs',
    'SkuArgs',
    'StorageQueueMessageArgs',
]

@pulumi.input_type
class HttpAuthenticationArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['HttpAuthenticationType']] = None):
        """
        :param pulumi.Input['HttpAuthenticationType'] type: Gets or sets the http authentication type.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['HttpAuthenticationType']]:
        """
        Gets or sets the http authentication type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['HttpAuthenticationType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class HttpRequestArgs:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['HttpAuthenticationArgs']] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['HttpAuthenticationArgs'] authentication: Gets or sets the http authentication.
        :param pulumi.Input[str] body: Gets or sets the request body.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] headers: Gets or sets the headers.
        :param pulumi.Input[str] method: Gets or sets the method of the request.
        :param pulumi.Input[str] uri: Gets or sets the Uri.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['HttpAuthenticationArgs']]:
        """
        Gets or sets the http authentication.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['HttpAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the request body.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Gets or sets the headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the method of the request.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Uri.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class JobActionArgs:
    def __init__(__self__, *,
                 error_action: Optional[pulumi.Input['JobErrorActionArgs']] = None,
                 queue_message: Optional[pulumi.Input['StorageQueueMessageArgs']] = None,
                 request: Optional[pulumi.Input['HttpRequestArgs']] = None,
                 retry_policy: Optional[pulumi.Input['RetryPolicyArgs']] = None,
                 service_bus_queue_message: Optional[pulumi.Input['ServiceBusQueueMessageArgs']] = None,
                 service_bus_topic_message: Optional[pulumi.Input['ServiceBusTopicMessageArgs']] = None,
                 type: Optional[pulumi.Input['JobActionType']] = None):
        """
        :param pulumi.Input['JobErrorActionArgs'] error_action: Gets or sets the error action.
        :param pulumi.Input['StorageQueueMessageArgs'] queue_message: Gets or sets the storage queue message.
        :param pulumi.Input['HttpRequestArgs'] request: Gets or sets the http requests.
        :param pulumi.Input['RetryPolicyArgs'] retry_policy: Gets or sets the retry policy.
        :param pulumi.Input['ServiceBusQueueMessageArgs'] service_bus_queue_message: Gets or sets the service bus queue message.
        :param pulumi.Input['ServiceBusTopicMessageArgs'] service_bus_topic_message: Gets or sets the service bus topic message.
        :param pulumi.Input['JobActionType'] type: Gets or sets the job action type.
        """
        if error_action is not None:
            pulumi.set(__self__, "error_action", error_action)
        if queue_message is not None:
            pulumi.set(__self__, "queue_message", queue_message)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_bus_queue_message is not None:
            pulumi.set(__self__, "service_bus_queue_message", service_bus_queue_message)
        if service_bus_topic_message is not None:
            pulumi.set(__self__, "service_bus_topic_message", service_bus_topic_message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="errorAction")
    def error_action(self) -> Optional[pulumi.Input['JobErrorActionArgs']]:
        """
        Gets or sets the error action.
        """
        return pulumi.get(self, "error_action")

    @error_action.setter
    def error_action(self, value: Optional[pulumi.Input['JobErrorActionArgs']]):
        pulumi.set(self, "error_action", value)

    @property
    @pulumi.getter(name="queueMessage")
    def queue_message(self) -> Optional[pulumi.Input['StorageQueueMessageArgs']]:
        """
        Gets or sets the storage queue message.
        """
        return pulumi.get(self, "queue_message")

    @queue_message.setter
    def queue_message(self, value: Optional[pulumi.Input['StorageQueueMessageArgs']]):
        pulumi.set(self, "queue_message", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['HttpRequestArgs']]:
        """
        Gets or sets the http requests.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['HttpRequestArgs']]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['RetryPolicyArgs']]:
        """
        Gets or sets the retry policy.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['RetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @property
    @pulumi.getter(name="serviceBusQueueMessage")
    def service_bus_queue_message(self) -> Optional[pulumi.Input['ServiceBusQueueMessageArgs']]:
        """
        Gets or sets the service bus queue message.
        """
        return pulumi.get(self, "service_bus_queue_message")

    @service_bus_queue_message.setter
    def service_bus_queue_message(self, value: Optional[pulumi.Input['ServiceBusQueueMessageArgs']]):
        pulumi.set(self, "service_bus_queue_message", value)

    @property
    @pulumi.getter(name="serviceBusTopicMessage")
    def service_bus_topic_message(self) -> Optional[pulumi.Input['ServiceBusTopicMessageArgs']]:
        """
        Gets or sets the service bus topic message.
        """
        return pulumi.get(self, "service_bus_topic_message")

    @service_bus_topic_message.setter
    def service_bus_topic_message(self, value: Optional[pulumi.Input['ServiceBusTopicMessageArgs']]):
        pulumi.set(self, "service_bus_topic_message", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['JobActionType']]:
        """
        Gets or sets the job action type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['JobActionType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobCollectionPropertiesArgs:
    def __init__(__self__, *,
                 quota: Optional[pulumi.Input['JobCollectionQuotaArgs']] = None,
                 sku: Optional[pulumi.Input['SkuArgs']] = None,
                 state: Optional[pulumi.Input['JobCollectionState']] = None):
        """
        :param pulumi.Input['JobCollectionQuotaArgs'] quota: Gets or sets the job collection quota.
        :param pulumi.Input['SkuArgs'] sku: Gets or sets the SKU.
        :param pulumi.Input['JobCollectionState'] state: Gets or sets the state.
        """
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['JobCollectionQuotaArgs']]:
        """
        Gets or sets the job collection quota.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['JobCollectionQuotaArgs']]):
        pulumi.set(self, "quota", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['SkuArgs']]:
        """
        Gets or sets the SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['SkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['JobCollectionState']]:
        """
        Gets or sets the state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['JobCollectionState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class JobCollectionQuotaArgs:
    def __init__(__self__, *,
                 max_job_count: Optional[pulumi.Input[int]] = None,
                 max_job_occurrence: Optional[pulumi.Input[int]] = None,
                 max_recurrence: Optional[pulumi.Input['JobMaxRecurrenceArgs']] = None):
        """
        :param pulumi.Input[int] max_job_count: Gets or set the maximum job count.
        :param pulumi.Input[int] max_job_occurrence: Gets or sets the maximum job occurrence.
        :param pulumi.Input['JobMaxRecurrenceArgs'] max_recurrence: Gets or set the maximum recurrence.
        """
        if max_job_count is not None:
            pulumi.set(__self__, "max_job_count", max_job_count)
        if max_job_occurrence is not None:
            pulumi.set(__self__, "max_job_occurrence", max_job_occurrence)
        if max_recurrence is not None:
            pulumi.set(__self__, "max_recurrence", max_recurrence)

    @property
    @pulumi.getter(name="maxJobCount")
    def max_job_count(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or set the maximum job count.
        """
        return pulumi.get(self, "max_job_count")

    @max_job_count.setter
    def max_job_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_job_count", value)

    @property
    @pulumi.getter(name="maxJobOccurrence")
    def max_job_occurrence(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the maximum job occurrence.
        """
        return pulumi.get(self, "max_job_occurrence")

    @max_job_occurrence.setter
    def max_job_occurrence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_job_occurrence", value)

    @property
    @pulumi.getter(name="maxRecurrence")
    def max_recurrence(self) -> Optional[pulumi.Input['JobMaxRecurrenceArgs']]:
        """
        Gets or set the maximum recurrence.
        """
        return pulumi.get(self, "max_recurrence")

    @max_recurrence.setter
    def max_recurrence(self, value: Optional[pulumi.Input['JobMaxRecurrenceArgs']]):
        pulumi.set(self, "max_recurrence", value)


@pulumi.input_type
class JobErrorActionArgs:
    def __init__(__self__, *,
                 queue_message: Optional[pulumi.Input['StorageQueueMessageArgs']] = None,
                 request: Optional[pulumi.Input['HttpRequestArgs']] = None,
                 retry_policy: Optional[pulumi.Input['RetryPolicyArgs']] = None,
                 service_bus_queue_message: Optional[pulumi.Input['ServiceBusQueueMessageArgs']] = None,
                 service_bus_topic_message: Optional[pulumi.Input['ServiceBusTopicMessageArgs']] = None,
                 type: Optional[pulumi.Input['JobActionType']] = None):
        """
        :param pulumi.Input['StorageQueueMessageArgs'] queue_message: Gets or sets the storage queue message.
        :param pulumi.Input['HttpRequestArgs'] request: Gets or sets the http requests.
        :param pulumi.Input['RetryPolicyArgs'] retry_policy: Gets or sets the retry policy.
        :param pulumi.Input['ServiceBusQueueMessageArgs'] service_bus_queue_message: Gets or sets the service bus queue message.
        :param pulumi.Input['ServiceBusTopicMessageArgs'] service_bus_topic_message: Gets or sets the service bus topic message.
        :param pulumi.Input['JobActionType'] type: Gets or sets the job error action type.
        """
        if queue_message is not None:
            pulumi.set(__self__, "queue_message", queue_message)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_bus_queue_message is not None:
            pulumi.set(__self__, "service_bus_queue_message", service_bus_queue_message)
        if service_bus_topic_message is not None:
            pulumi.set(__self__, "service_bus_topic_message", service_bus_topic_message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="queueMessage")
    def queue_message(self) -> Optional[pulumi.Input['StorageQueueMessageArgs']]:
        """
        Gets or sets the storage queue message.
        """
        return pulumi.get(self, "queue_message")

    @queue_message.setter
    def queue_message(self, value: Optional[pulumi.Input['StorageQueueMessageArgs']]):
        pulumi.set(self, "queue_message", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['HttpRequestArgs']]:
        """
        Gets or sets the http requests.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['HttpRequestArgs']]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['RetryPolicyArgs']]:
        """
        Gets or sets the retry policy.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['RetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @property
    @pulumi.getter(name="serviceBusQueueMessage")
    def service_bus_queue_message(self) -> Optional[pulumi.Input['ServiceBusQueueMessageArgs']]:
        """
        Gets or sets the service bus queue message.
        """
        return pulumi.get(self, "service_bus_queue_message")

    @service_bus_queue_message.setter
    def service_bus_queue_message(self, value: Optional[pulumi.Input['ServiceBusQueueMessageArgs']]):
        pulumi.set(self, "service_bus_queue_message", value)

    @property
    @pulumi.getter(name="serviceBusTopicMessage")
    def service_bus_topic_message(self) -> Optional[pulumi.Input['ServiceBusTopicMessageArgs']]:
        """
        Gets or sets the service bus topic message.
        """
        return pulumi.get(self, "service_bus_topic_message")

    @service_bus_topic_message.setter
    def service_bus_topic_message(self, value: Optional[pulumi.Input['ServiceBusTopicMessageArgs']]):
        pulumi.set(self, "service_bus_topic_message", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['JobActionType']]:
        """
        Gets or sets the job error action type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['JobActionType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobMaxRecurrenceArgs:
    def __init__(__self__, *,
                 frequency: Optional[pulumi.Input['RecurrenceFrequency']] = None,
                 interval: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['RecurrenceFrequency'] frequency: Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
        :param pulumi.Input[int] interval: Gets or sets the interval between retries.
        """
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input['RecurrenceFrequency']]:
        """
        Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input['RecurrenceFrequency']]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the interval between retries.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)


@pulumi.input_type
class JobPropertiesArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['JobActionArgs']] = None,
                 recurrence: Optional[pulumi.Input['JobRecurrenceArgs']] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['JobState']] = None):
        """
        :param pulumi.Input['JobActionArgs'] action: Gets or sets the job action.
        :param pulumi.Input['JobRecurrenceArgs'] recurrence: Gets or sets the job recurrence.
        :param pulumi.Input[str] start_time: Gets or sets the job start time.
        :param pulumi.Input['JobState'] state: Gets or set the job state.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['JobActionArgs']]:
        """
        Gets or sets the job action.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['JobActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['JobRecurrenceArgs']]:
        """
        Gets or sets the job recurrence.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['JobRecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the job start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['JobState']]:
        """
        Gets or set the job state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['JobState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class JobRecurrenceScheduleMonthlyOccurrenceArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input['JobScheduleDay']] = None,
                 occurrence: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['JobScheduleDay'] day: Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
        :param pulumi.Input[int] occurrence: Gets or sets the occurrence. Must be between -5 and 5.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if occurrence is not None:
            pulumi.set(__self__, "occurrence", occurrence)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input['JobScheduleDay']]:
        """
        Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input['JobScheduleDay']]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def occurrence(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the occurrence. Must be between -5 and 5.
        """
        return pulumi.get(self, "occurrence")

    @occurrence.setter
    def occurrence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "occurrence", value)


@pulumi.input_type
class JobRecurrenceScheduleArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 minutes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 month_days: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 monthly_occurrences: Optional[pulumi.Input[Sequence[pulumi.Input['JobRecurrenceScheduleMonthlyOccurrenceArgs']]]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] hours: Gets or sets the hours of the day that the job should execute at.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] minutes: Gets or sets the minutes of the hour that the job should execute at.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] month_days: Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
        :param pulumi.Input[Sequence[pulumi.Input['JobRecurrenceScheduleMonthlyOccurrenceArgs']]] monthly_occurrences: Gets or sets the occurrences of days within a month.
        :param pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]] week_days: Gets or sets the days of the week that the job should execute on.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if monthly_occurrences is not None:
            pulumi.set(__self__, "monthly_occurrences", monthly_occurrences)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Gets or sets the hours of the day that the job should execute at.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Gets or sets the minutes of the hour that the job should execute at.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
        """
        return pulumi.get(self, "month_days")

    @month_days.setter
    def month_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "month_days", value)

    @property
    @pulumi.getter(name="monthlyOccurrences")
    def monthly_occurrences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobRecurrenceScheduleMonthlyOccurrenceArgs']]]]:
        """
        Gets or sets the occurrences of days within a month.
        """
        return pulumi.get(self, "monthly_occurrences")

    @monthly_occurrences.setter
    def monthly_occurrences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobRecurrenceScheduleMonthlyOccurrenceArgs']]]]):
        pulumi.set(self, "monthly_occurrences", value)

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]:
        """
        Gets or sets the days of the week that the job should execute on.
        """
        return pulumi.get(self, "week_days")

    @week_days.setter
    def week_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]):
        pulumi.set(self, "week_days", value)


@pulumi.input_type
class JobRecurrenceArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input['RecurrenceFrequency']] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 schedule: Optional[pulumi.Input['JobRecurrenceScheduleArgs']] = None):
        """
        :param pulumi.Input[int] count: Gets or sets the maximum number of times that the job should run.
        :param pulumi.Input[str] end_time: Gets or sets the time at which the job will complete.
        :param pulumi.Input['RecurrenceFrequency'] frequency: Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
        :param pulumi.Input[int] interval: Gets or sets the interval between retries.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the maximum number of times that the job should run.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the time at which the job will complete.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input['RecurrenceFrequency']]:
        """
        Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input['RecurrenceFrequency']]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the interval between retries.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['JobRecurrenceScheduleArgs']]:
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['JobRecurrenceScheduleArgs']]):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class RetryPolicyArgs:
    def __init__(__self__, *,
                 retry_count: Optional[pulumi.Input[int]] = None,
                 retry_interval: Optional[pulumi.Input[str]] = None,
                 retry_type: Optional[pulumi.Input['RetryType']] = None):
        """
        :param pulumi.Input[int] retry_count: Gets or sets the number of times a retry should be attempted.
        :param pulumi.Input[str] retry_interval: Gets or sets the retry interval between retries.
        :param pulumi.Input['RetryType'] retry_type: Gets or sets the retry strategy to be used.
        """
        if retry_count is not None:
            pulumi.set(__self__, "retry_count", retry_count)
        if retry_interval is not None:
            pulumi.set(__self__, "retry_interval", retry_interval)
        if retry_type is not None:
            pulumi.set(__self__, "retry_type", retry_type)

    @property
    @pulumi.getter(name="retryCount")
    def retry_count(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the number of times a retry should be attempted.
        """
        return pulumi.get(self, "retry_count")

    @retry_count.setter
    def retry_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry_count", value)

    @property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the retry interval between retries.
        """
        return pulumi.get(self, "retry_interval")

    @retry_interval.setter
    def retry_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retry_interval", value)

    @property
    @pulumi.getter(name="retryType")
    def retry_type(self) -> Optional[pulumi.Input['RetryType']]:
        """
        Gets or sets the retry strategy to be used.
        """
        return pulumi.get(self, "retry_type")

    @retry_type.setter
    def retry_type(self, value: Optional[pulumi.Input['RetryType']]):
        pulumi.set(self, "retry_type", value)


@pulumi.input_type
class ServiceBusAuthenticationArgs:
    def __init__(__self__, *,
                 sas_key: Optional[pulumi.Input[str]] = None,
                 sas_key_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['ServiceBusAuthenticationType']] = None):
        """
        :param pulumi.Input[str] sas_key: Gets or sets the SAS key.
        :param pulumi.Input[str] sas_key_name: Gets or sets the SAS key name.
        :param pulumi.Input['ServiceBusAuthenticationType'] type: Gets or sets the authentication type.
        """
        if sas_key is not None:
            pulumi.set(__self__, "sas_key", sas_key)
        if sas_key_name is not None:
            pulumi.set(__self__, "sas_key_name", sas_key_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="sasKey")
    def sas_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAS key.
        """
        return pulumi.get(self, "sas_key")

    @sas_key.setter
    def sas_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_key", value)

    @property
    @pulumi.getter(name="sasKeyName")
    def sas_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAS key name.
        """
        return pulumi.get(self, "sas_key_name")

    @sas_key_name.setter
    def sas_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_key_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ServiceBusAuthenticationType']]:
        """
        Gets or sets the authentication type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ServiceBusAuthenticationType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceBusBrokeredMessagePropertiesArgs:
    def __init__(__self__, *,
                 content_type: Optional[pulumi.Input[str]] = None,
                 correlation_id: Optional[pulumi.Input[str]] = None,
                 force_persistence: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 message_id: Optional[pulumi.Input[str]] = None,
                 partition_key: Optional[pulumi.Input[str]] = None,
                 reply_to: Optional[pulumi.Input[str]] = None,
                 reply_to_session_id: Optional[pulumi.Input[str]] = None,
                 scheduled_enqueue_time_utc: Optional[pulumi.Input[str]] = None,
                 session_id: Optional[pulumi.Input[str]] = None,
                 time_to_live: Optional[pulumi.Input[str]] = None,
                 to: Optional[pulumi.Input[str]] = None,
                 via_partition_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content_type: Gets or sets the content type.
        :param pulumi.Input[str] correlation_id: Gets or sets the correlation id.
        :param pulumi.Input[bool] force_persistence: Gets or sets the force persistence.
        :param pulumi.Input[str] label: Gets or sets the label.
        :param pulumi.Input[str] message_id: Gets or sets the message id.
        :param pulumi.Input[str] partition_key: Gets or sets the partition key.
        :param pulumi.Input[str] reply_to: Gets or sets the reply to.
        :param pulumi.Input[str] reply_to_session_id: Gets or sets the reply to session id.
        :param pulumi.Input[str] scheduled_enqueue_time_utc: Gets or sets the scheduled enqueue time UTC.
        :param pulumi.Input[str] session_id: Gets or sets the session id.
        :param pulumi.Input[str] time_to_live: Gets or sets the time to live.
        :param pulumi.Input[str] to: Gets or sets the to.
        :param pulumi.Input[str] via_partition_key: Gets or sets the via partition key.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if force_persistence is not None:
            pulumi.set(__self__, "force_persistence", force_persistence)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if reply_to is not None:
            pulumi.set(__self__, "reply_to", reply_to)
        if reply_to_session_id is not None:
            pulumi.set(__self__, "reply_to_session_id", reply_to_session_id)
        if scheduled_enqueue_time_utc is not None:
            pulumi.set(__self__, "scheduled_enqueue_time_utc", scheduled_enqueue_time_utc)
        if session_id is not None:
            pulumi.set(__self__, "session_id", session_id)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)
        if to is not None:
            pulumi.set(__self__, "to", to)
        if via_partition_key is not None:
            pulumi.set(__self__, "via_partition_key", via_partition_key)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the content type.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the correlation id.
        """
        return pulumi.get(self, "correlation_id")

    @correlation_id.setter
    def correlation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "correlation_id", value)

    @property
    @pulumi.getter(name="forcePersistence")
    def force_persistence(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets the force persistence.
        """
        return pulumi.get(self, "force_persistence")

    @force_persistence.setter
    def force_persistence(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_persistence", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the label.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the message id.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_id", value)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the partition key.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_key", value)

    @property
    @pulumi.getter(name="replyTo")
    def reply_to(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the reply to.
        """
        return pulumi.get(self, "reply_to")

    @reply_to.setter
    def reply_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reply_to", value)

    @property
    @pulumi.getter(name="replyToSessionId")
    def reply_to_session_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the reply to session id.
        """
        return pulumi.get(self, "reply_to_session_id")

    @reply_to_session_id.setter
    def reply_to_session_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reply_to_session_id", value)

    @property
    @pulumi.getter(name="scheduledEnqueueTimeUtc")
    def scheduled_enqueue_time_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the scheduled enqueue time UTC.
        """
        return pulumi.get(self, "scheduled_enqueue_time_utc")

    @scheduled_enqueue_time_utc.setter
    def scheduled_enqueue_time_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_enqueue_time_utc", value)

    @property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the session id.
        """
        return pulumi.get(self, "session_id")

    @session_id.setter
    def session_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_id", value)

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the time to live.
        """
        return pulumi.get(self, "time_to_live")

    @time_to_live.setter
    def time_to_live(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_to_live", value)

    @property
    @pulumi.getter
    def to(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the to.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "to", value)

    @property
    @pulumi.getter(name="viaPartitionKey")
    def via_partition_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the via partition key.
        """
        return pulumi.get(self, "via_partition_key")

    @via_partition_key.setter
    def via_partition_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "via_partition_key", value)


@pulumi.input_type
class ServiceBusQueueMessageArgs:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['ServiceBusAuthenticationArgs']] = None,
                 brokered_message_properties: Optional[pulumi.Input['ServiceBusBrokeredMessagePropertiesArgs']] = None,
                 custom_message_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 transport_type: Optional[pulumi.Input['ServiceBusTransportType']] = None):
        """
        :param pulumi.Input['ServiceBusAuthenticationArgs'] authentication: Gets or sets the authentication.
        :param pulumi.Input['ServiceBusBrokeredMessagePropertiesArgs'] brokered_message_properties: Gets or sets the brokered message properties.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_message_properties: Gets or sets the custom message properties.
        :param pulumi.Input[str] message: Gets or sets the message.
        :param pulumi.Input[str] namespace: Gets or sets the namespace.
        :param pulumi.Input[str] queue_name: Gets or sets the queue name.
        :param pulumi.Input['ServiceBusTransportType'] transport_type: Gets or sets the transport type.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if brokered_message_properties is not None:
            pulumi.set(__self__, "brokered_message_properties", brokered_message_properties)
        if custom_message_properties is not None:
            pulumi.set(__self__, "custom_message_properties", custom_message_properties)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if transport_type is not None:
            pulumi.set(__self__, "transport_type", transport_type)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['ServiceBusAuthenticationArgs']]:
        """
        Gets or sets the authentication.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['ServiceBusAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="brokeredMessageProperties")
    def brokered_message_properties(self) -> Optional[pulumi.Input['ServiceBusBrokeredMessagePropertiesArgs']]:
        """
        Gets or sets the brokered message properties.
        """
        return pulumi.get(self, "brokered_message_properties")

    @brokered_message_properties.setter
    def brokered_message_properties(self, value: Optional[pulumi.Input['ServiceBusBrokeredMessagePropertiesArgs']]):
        pulumi.set(self, "brokered_message_properties", value)

    @property
    @pulumi.getter(name="customMessageProperties")
    def custom_message_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Gets or sets the custom message properties.
        """
        return pulumi.get(self, "custom_message_properties")

    @custom_message_properties.setter
    def custom_message_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_message_properties", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the queue name.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> Optional[pulumi.Input['ServiceBusTransportType']]:
        """
        Gets or sets the transport type.
        """
        return pulumi.get(self, "transport_type")

    @transport_type.setter
    def transport_type(self, value: Optional[pulumi.Input['ServiceBusTransportType']]):
        pulumi.set(self, "transport_type", value)


@pulumi.input_type
class ServiceBusTopicMessageArgs:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['ServiceBusAuthenticationArgs']] = None,
                 brokered_message_properties: Optional[pulumi.Input['ServiceBusBrokeredMessagePropertiesArgs']] = None,
                 custom_message_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 topic_path: Optional[pulumi.Input[str]] = None,
                 transport_type: Optional[pulumi.Input['ServiceBusTransportType']] = None):
        """
        :param pulumi.Input['ServiceBusAuthenticationArgs'] authentication: Gets or sets the authentication.
        :param pulumi.Input['ServiceBusBrokeredMessagePropertiesArgs'] brokered_message_properties: Gets or sets the brokered message properties.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_message_properties: Gets or sets the custom message properties.
        :param pulumi.Input[str] message: Gets or sets the message.
        :param pulumi.Input[str] namespace: Gets or sets the namespace.
        :param pulumi.Input[str] topic_path: Gets or sets the topic path.
        :param pulumi.Input['ServiceBusTransportType'] transport_type: Gets or sets the transport type.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if brokered_message_properties is not None:
            pulumi.set(__self__, "brokered_message_properties", brokered_message_properties)
        if custom_message_properties is not None:
            pulumi.set(__self__, "custom_message_properties", custom_message_properties)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if topic_path is not None:
            pulumi.set(__self__, "topic_path", topic_path)
        if transport_type is not None:
            pulumi.set(__self__, "transport_type", transport_type)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['ServiceBusAuthenticationArgs']]:
        """
        Gets or sets the authentication.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['ServiceBusAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="brokeredMessageProperties")
    def brokered_message_properties(self) -> Optional[pulumi.Input['ServiceBusBrokeredMessagePropertiesArgs']]:
        """
        Gets or sets the brokered message properties.
        """
        return pulumi.get(self, "brokered_message_properties")

    @brokered_message_properties.setter
    def brokered_message_properties(self, value: Optional[pulumi.Input['ServiceBusBrokeredMessagePropertiesArgs']]):
        pulumi.set(self, "brokered_message_properties", value)

    @property
    @pulumi.getter(name="customMessageProperties")
    def custom_message_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Gets or sets the custom message properties.
        """
        return pulumi.get(self, "custom_message_properties")

    @custom_message_properties.setter
    def custom_message_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_message_properties", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="topicPath")
    def topic_path(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the topic path.
        """
        return pulumi.get(self, "topic_path")

    @topic_path.setter
    def topic_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_path", value)

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> Optional[pulumi.Input['ServiceBusTransportType']]:
        """
        Gets or sets the transport type.
        """
        return pulumi.get(self, "transport_type")

    @transport_type.setter
    def transport_type(self, value: Optional[pulumi.Input['ServiceBusTransportType']]):
        pulumi.set(self, "transport_type", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input['SkuDefinition']] = None):
        """
        :param pulumi.Input['SkuDefinition'] name: Gets or set the SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input['SkuDefinition']]:
        """
        Gets or set the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input['SkuDefinition']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class StorageQueueMessageArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 sas_token: Optional[pulumi.Input[str]] = None,
                 storage_account: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] message: Gets or sets the message.
        :param pulumi.Input[str] queue_name: Gets or sets the queue name.
        :param pulumi.Input[str] sas_token: Gets or sets the SAS key.
        :param pulumi.Input[str] storage_account: Gets or sets the storage account name.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if storage_account is not None:
            pulumi.set(__self__, "storage_account", storage_account)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the queue name.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAS key.
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_token", value)

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the storage account name.
        """
        return pulumi.get(self, "storage_account")

    @storage_account.setter
    def storage_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account", value)


