# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'ConnectionType',
    'CreateOption',
    'EnableState',
    'RecurrenceFrequency',
    'ShutdownOnIdleMode',
    'SkuTier',
    'WeekDay',
]


class ConnectionType(str, Enum):
    """
    The enabled access level for Web Access over SSH.
    """
    PUBLIC = "Public"
    PRIVATE = "Private"
    NONE = "None"


class CreateOption(str, Enum):
    """
    Indicates what lab virtual machines are created from.
    """
    IMAGE = "Image"
    """An image is used to create all lab user virtual machines. When this option is set, no template VM will be created."""
    TEMPLATE_VM = "TemplateVM"
    """A template VM will be used to create all lab user virtual machines."""


class EnableState(str, Enum):
    """
    Whether a VM will get shutdown when it hasn't been connected to after a period of time.
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class RecurrenceFrequency(str, Enum):
    """
    The frequency of the recurrence.
    """
    DAILY = "Daily"
    """Schedule will run every days."""
    WEEKLY = "Weekly"
    """Schedule will run every week on days specified in weekDays."""


class ShutdownOnIdleMode(str, Enum):
    """
    Whether a VM will get shutdown when it has idled for a period of time.
    """
    NONE = "None"
    """The VM won't be shut down when it is idle."""
    USER_ABSENCE = "UserAbsence"
    """The VM will be considered as idle when there is no keyboard or mouse input."""
    LOW_USAGE = "LowUsage"
    """The VM will be considered as idle when user is absent and the resource (CPU and disk) consumption is low."""


class SkuTier(str, Enum):
    """
    This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
    """
    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class WeekDay(str, Enum):
    """
    Days of the week.
    """
    SUNDAY = "Sunday"
    """Schedule will run on Sunday"""
    MONDAY = "Monday"
    """Schedule will run on Monday"""
    TUESDAY = "Tuesday"
    """Schedule will run on Tuesday"""
    WEDNESDAY = "Wednesday"
    """Schedule will run on Wednesday"""
    THURSDAY = "Thursday"
    """Schedule will run on Thursday"""
    FRIDAY = "Friday"
    """Schedule will run on Friday"""
    SATURDAY = "Saturday"
    """Schedule will run on Saturday"""
