# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'DataSourceConfigurationResponse',
    'DataSourceResponse',
    'EtwEventConfigurationResponse',
    'EtwProviderConfigurationResponse',
    'EventLogConfigurationResponse',
    'PerformanceCounterConfigurationResponse',
    'SinkConfigurationResponse',
]

@pulumi.output_type
class DataSourceConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventLogs":
            suggest = "event_logs"
        elif key == "perfCounters":
            suggest = "perf_counters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_logs: Optional[Sequence['outputs.EventLogConfigurationResponse']] = None,
                 perf_counters: Optional[Sequence['outputs.PerformanceCounterConfigurationResponse']] = None,
                 providers: Optional[Sequence['outputs.EtwProviderConfigurationResponse']] = None):
        """
        :param Sequence['EventLogConfigurationResponse'] event_logs: Windows event logs configuration.
        :param Sequence['PerformanceCounterConfigurationResponse'] perf_counters: Performance counter configuration
        :param Sequence['EtwProviderConfigurationResponse'] providers: ETW providers configuration
        """
        if event_logs is not None:
            pulumi.set(__self__, "event_logs", event_logs)
        if perf_counters is not None:
            pulumi.set(__self__, "perf_counters", perf_counters)
        if providers is not None:
            pulumi.set(__self__, "providers", providers)

    @property
    @pulumi.getter(name="eventLogs")
    def event_logs(self) -> Optional[Sequence['outputs.EventLogConfigurationResponse']]:
        """
        Windows event logs configuration.
        """
        return pulumi.get(self, "event_logs")

    @property
    @pulumi.getter(name="perfCounters")
    def perf_counters(self) -> Optional[Sequence['outputs.PerformanceCounterConfigurationResponse']]:
        """
        Performance counter configuration
        """
        return pulumi.get(self, "perf_counters")

    @property
    @pulumi.getter
    def providers(self) -> Optional[Sequence['outputs.EtwProviderConfigurationResponse']]:
        """
        ETW providers configuration
        """
        return pulumi.get(self, "providers")


@pulumi.output_type
class DataSourceResponse(dict):
    """
    Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to
    """
    def __init__(__self__, *,
                 configuration: 'outputs.DataSourceConfigurationResponse',
                 kind: str,
                 sinks: Sequence['outputs.SinkConfigurationResponse']):
        """
        Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to
        :param str kind: Datasource kind
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "sinks", sinks)

    @property
    @pulumi.getter
    def configuration(self) -> 'outputs.DataSourceConfigurationResponse':
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Datasource kind
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def sinks(self) -> Sequence['outputs.SinkConfigurationResponse']:
        return pulumi.get(self, "sinks")


@pulumi.output_type
class EtwEventConfigurationResponse(dict):
    def __init__(__self__, *,
                 id: int,
                 name: str,
                 filter: Optional[str] = None):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        return pulumi.get(self, "filter")


@pulumi.output_type
class EtwProviderConfigurationResponse(dict):
    def __init__(__self__, *,
                 events: Sequence['outputs.EtwEventConfigurationResponse'],
                 id: str):
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def events(self) -> Sequence['outputs.EtwEventConfigurationResponse']:
        return pulumi.get(self, "events")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


@pulumi.output_type
class EventLogConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logName":
            suggest = "log_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventLogConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventLogConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventLogConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_name: str,
                 filter: Optional[str] = None):
        pulumi.set(__self__, "log_name", log_name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter(name="logName")
    def log_name(self) -> str:
        return pulumi.get(self, "log_name")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        return pulumi.get(self, "filter")


@pulumi.output_type
class PerformanceCounterConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingPeriod":
            suggest = "sampling_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PerformanceCounterConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PerformanceCounterConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PerformanceCounterConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 sampling_period: str,
                 instance: Optional[str] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sampling_period", sampling_period)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samplingPeriod")
    def sampling_period(self) -> str:
        return pulumi.get(self, "sampling_period")

    @property
    @pulumi.getter
    def instance(self) -> Optional[str]:
        return pulumi.get(self, "instance")


@pulumi.output_type
class SinkConfigurationResponse(dict):
    def __init__(__self__, *,
                 kind: str):
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


