# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ListShareSynchronizationDetailsResult',
    'AwaitableListShareSynchronizationDetailsResult',
    'list_share_synchronization_details',
]

@pulumi.output_type
class ListShareSynchronizationDetailsResult:
    """
    details of synchronization
    """
    def __init__(__self__, next_link=None, value=None):
        if next_link and not isinstance(next_link, str):
            raise TypeError("Expected argument 'next_link' to be a str")
        pulumi.set(__self__, "next_link", next_link)
        if value and not isinstance(value, list):
            raise TypeError("Expected argument 'value' to be a list")
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="nextLink")
    def next_link(self) -> Optional[str]:
        """
        The Url of next result page.
        """
        return pulumi.get(self, "next_link")

    @property
    @pulumi.getter
    def value(self) -> Sequence['outputs.SynchronizationDetailsResponse']:
        """
        Collection of items of type DataTransferObjects.
        """
        return pulumi.get(self, "value")


class AwaitableListShareSynchronizationDetailsResult(ListShareSynchronizationDetailsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListShareSynchronizationDetailsResult(
            next_link=self.next_link,
            value=self.value)


def list_share_synchronization_details(account_name: Optional[str] = None,
                                       consumer_email: Optional[str] = None,
                                       consumer_name: Optional[str] = None,
                                       consumer_tenant_name: Optional[str] = None,
                                       duration_ms: Optional[int] = None,
                                       end_time: Optional[str] = None,
                                       filter: Optional[str] = None,
                                       message: Optional[str] = None,
                                       orderby: Optional[str] = None,
                                       resource_group_name: Optional[str] = None,
                                       share_name: Optional[str] = None,
                                       skip_token: Optional[str] = None,
                                       start_time: Optional[str] = None,
                                       status: Optional[str] = None,
                                       synchronization_id: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListShareSynchronizationDetailsResult:
    """
    details of synchronization


    :param str account_name: The name of the share account.
    :param str consumer_email: Email of the user who created the synchronization
    :param str consumer_name: Name of the user who created the synchronization
    :param str consumer_tenant_name: Tenant name of the consumer who created the synchronization
    :param int duration_ms: synchronization duration
    :param str end_time: End time of synchronization
    :param str filter: Filters the results using OData syntax.
    :param str message: message of synchronization
    :param str orderby: Sorts the results using OData syntax.
    :param str resource_group_name: The resource group name.
    :param str share_name: The name of the share.
    :param str skip_token: Continuation token
    :param str start_time: start time of synchronization
    :param str status: Raw Status
    :param str synchronization_id: Synchronization id
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['consumerEmail'] = consumer_email
    __args__['consumerName'] = consumer_name
    __args__['consumerTenantName'] = consumer_tenant_name
    __args__['durationMs'] = duration_ms
    __args__['endTime'] = end_time
    __args__['filter'] = filter
    __args__['message'] = message
    __args__['orderby'] = orderby
    __args__['resourceGroupName'] = resource_group_name
    __args__['shareName'] = share_name
    __args__['skipToken'] = skip_token
    __args__['startTime'] = start_time
    __args__['status'] = status
    __args__['synchronizationId'] = synchronization_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:datashare/v20191101:listShareSynchronizationDetails', __args__, opts=opts, typ=ListShareSynchronizationDetailsResult).value

    return AwaitableListShareSynchronizationDetailsResult(
        next_link=__ret__.next_link,
        value=__ret__.value)
