# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AgentPoolMode',
    'AgentPoolType',
    'ConnectionStatus',
    'Expander',
    'ExtendedLocationTypes',
    'GPUInstanceProfile',
    'KubeletDiskType',
    'LicenseType',
    'LoadBalancerSku',
    'ManagedClusterSKUName',
    'ManagedClusterSKUTier',
    'NetworkMode',
    'NetworkPlugin',
    'NetworkPolicy',
    'OSDiskType',
    'OSSKU',
    'OSType',
    'OpenShiftAgentPoolProfileRole',
    'OpenShiftContainerServiceVMSize',
    'OutboundType',
    'ResourceIdentityType',
    'ScaleSetEvictionPolicy',
    'ScaleSetPriority',
    'SnapshotType',
    'UpgradeChannel',
    'WeekDay',
]


class AgentPoolMode(str, Enum):
    """
    AgentPoolMode represents mode of an agent pool
    """
    SYSTEM = "System"
    USER = "User"


class AgentPoolType(str, Enum):
    """
    AgentPoolType represents types of an agent pool
    """
    VIRTUAL_MACHINE_SCALE_SETS = "VirtualMachineScaleSets"
    AVAILABILITY_SET = "AvailabilitySet"


class ConnectionStatus(str, Enum):
    """
    The private link service connection status.
    """
    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class Expander(str, Enum):
    LEAST_WASTE = "least-waste"
    MOST_PODS = "most-pods"
    PRIORITY = "priority"
    RANDOM = "random"


class ExtendedLocationTypes(str, Enum):
    """
    The type of the extended location.
    """
    EDGE_ZONE = "EdgeZone"


class GPUInstanceProfile(str, Enum):
    """
    GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU. Supported values are MIG1g, MIG2g, MIG3g, MIG4g and MIG7g.
    """
    MIG1G = "MIG1g"
    MIG2G = "MIG2g"
    MIG3G = "MIG3g"
    MIG4G = "MIG4g"
    MIG7G = "MIG7g"


class KubeletDiskType(str, Enum):
    """
    KubeletDiskType determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS, resulting in Kubelet using the OS disk for data.
    """
    OS = "OS"
    TEMPORARY = "Temporary"


class LicenseType(str, Enum):
    """
    The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs.
    """
    NONE = "None"
    WINDOWS_SERVER = "Windows_Server"


class LoadBalancerSku(str, Enum):
    """
    The load balancer sku for the managed cluster.
    """
    STANDARD = "standard"
    BASIC = "basic"


class ManagedClusterSKUName(str, Enum):
    """
    Name of a managed cluster SKU.
    """
    BASIC = "Basic"


class ManagedClusterSKUTier(str, Enum):
    """
    Tier of a managed cluster SKU.
    """
    PAID = "Paid"
    FREE = "Free"


class NetworkMode(str, Enum):
    """
    Network mode used for building Kubernetes network.
    """
    TRANSPARENT = "transparent"
    BRIDGE = "bridge"


class NetworkPlugin(str, Enum):
    """
    Network plugin used for building Kubernetes network.
    """
    AZURE = "azure"
    KUBENET = "kubenet"


class NetworkPolicy(str, Enum):
    """
    Network policy used for building Kubernetes network.
    """
    CALICO = "calico"
    AZURE = "azure"


class OSDiskType(str, Enum):
    """
    OS disk type to be used for machines in a given agent pool. Allowed values are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation.
    """
    MANAGED = "Managed"
    EPHEMERAL = "Ephemeral"


class OSSKU(str, Enum):
    """
    OsSKU to be used to specify os sku. Choose from Ubuntu(default) and CBLMariner for Linux OSType. Not applicable to Windows OSType.
    """
    UBUNTU = "Ubuntu"
    CBL_MARINER = "CBLMariner"


class OSType(str, Enum):
    """
    OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
    """
    LINUX = "Linux"
    WINDOWS = "Windows"


class OpenShiftAgentPoolProfileRole(str, Enum):
    """
    Define the role of the AgentPoolProfile.
    """
    COMPUTE = "compute"
    INFRA = "infra"


class OpenShiftContainerServiceVMSize(str, Enum):
    """
    Size of agent VMs.
    """
    STANDARD_D2S_V3 = "Standard_D2s_v3"
    STANDARD_D4S_V3 = "Standard_D4s_v3"
    STANDARD_D8S_V3 = "Standard_D8s_v3"
    STANDARD_D16S_V3 = "Standard_D16s_v3"
    STANDARD_D32S_V3 = "Standard_D32s_v3"
    STANDARD_D64S_V3 = "Standard_D64s_v3"
    STANDARD_DS4_V2 = "Standard_DS4_v2"
    STANDARD_DS5_V2 = "Standard_DS5_v2"
    STANDARD_F8S_V2 = "Standard_F8s_v2"
    STANDARD_F16S_V2 = "Standard_F16s_v2"
    STANDARD_F32S_V2 = "Standard_F32s_v2"
    STANDARD_F64S_V2 = "Standard_F64s_v2"
    STANDARD_F72S_V2 = "Standard_F72s_v2"
    STANDARD_F8S = "Standard_F8s"
    STANDARD_F16S = "Standard_F16s"
    STANDARD_E4S_V3 = "Standard_E4s_v3"
    STANDARD_E8S_V3 = "Standard_E8s_v3"
    STANDARD_E16S_V3 = "Standard_E16s_v3"
    STANDARD_E20S_V3 = "Standard_E20s_v3"
    STANDARD_E32S_V3 = "Standard_E32s_v3"
    STANDARD_E64S_V3 = "Standard_E64s_v3"
    STANDARD_GS2 = "Standard_GS2"
    STANDARD_GS3 = "Standard_GS3"
    STANDARD_GS4 = "Standard_GS4"
    STANDARD_GS5 = "Standard_GS5"
    STANDARD_DS12_V2 = "Standard_DS12_v2"
    STANDARD_DS13_V2 = "Standard_DS13_v2"
    STANDARD_DS14_V2 = "Standard_DS14_v2"
    STANDARD_DS15_V2 = "Standard_DS15_v2"
    STANDARD_L4S = "Standard_L4s"
    STANDARD_L8S = "Standard_L8s"
    STANDARD_L16S = "Standard_L16s"
    STANDARD_L32S = "Standard_L32s"


class OutboundType(str, Enum):
    """
    The outbound (egress) routing method.
    """
    LOAD_BALANCER = "loadBalancer"
    USER_DEFINED_ROUTING = "userDefinedRouting"


class ResourceIdentityType(str, Enum):
    """
    The type of identity used for the managed cluster. Type 'SystemAssigned' will use an implicitly created identity in master components and an auto-created user assigned identity in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed cluster, service principal will be used instead.
    """
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    NONE = "None"


class ScaleSetEvictionPolicy(str, Enum):
    """
    ScaleSetEvictionPolicy to be used to specify eviction policy for Spot virtual machine scale set. Default to Delete.
    """
    DELETE = "Delete"
    DEALLOCATE = "Deallocate"


class ScaleSetPriority(str, Enum):
    """
    ScaleSetPriority to be used to specify virtual machine scale set priority. Default to regular.
    """
    SPOT = "Spot"
    REGULAR = "Regular"


class SnapshotType(str, Enum):
    """
    The type of a snapshot. The default is NodePool.
    """
    NODE_POOL = "NodePool"
    """The snapshot is a snapshot of a node pool."""


class UpgradeChannel(str, Enum):
    """
    upgrade channel for auto upgrade.
    """
    RAPID = "rapid"
    STABLE = "stable"
    PATCH = "patch"
    NODE_IMAGE = "node-image"
    NONE = "none"


class WeekDay(str, Enum):
    """
    A day in a week.
    """
    SUNDAY = "Sunday"
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
