# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AssetItemArgs',
    'BlobLocationArgs',
    'ColumnSpecificationArgs',
    'CommitmentPlanArgs',
    'DiagnosticsConfigurationArgs',
    'ExampleRequestArgs',
    'GraphEdgeArgs',
    'GraphNodeArgs',
    'GraphPackageArgs',
    'GraphParameterLinkArgs',
    'GraphParameterArgs',
    'InputPortArgs',
    'MachineLearningWorkspaceArgs',
    'ModeValueInfoArgs',
    'ModuleAssetParameterArgs',
    'OutputPortArgs',
    'RealtimeConfigurationArgs',
    'ResourceSkuArgs',
    'ServiceInputOutputSpecificationArgs',
    'StorageAccountArgs',
    'TableSpecificationArgs',
    'WebServiceKeysArgs',
    'WebServiceParameterArgs',
    'WebServicePropertiesForGraphArgs',
]

@pulumi.input_type
class AssetItemArgs:
    def __init__(__self__, *,
                 location_info: pulumi.Input['BlobLocationArgs'],
                 name: pulumi.Input[str],
                 type: pulumi.Input[Union[str, 'AssetType']],
                 id: Optional[pulumi.Input[str]] = None,
                 input_ports: Optional[pulumi.Input[Mapping[str, pulumi.Input['InputPortArgs']]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 output_ports: Optional[pulumi.Input[Mapping[str, pulumi.Input['OutputPortArgs']]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ModuleAssetParameterArgs']]]] = None):
        """
        Information about an asset associated with the web service.
        :param pulumi.Input['BlobLocationArgs'] location_info: Access information for the asset.
        :param pulumi.Input[str] name: Asset's friendly name.
        :param pulumi.Input[Union[str, 'AssetType']] type: Asset's type.
        :param pulumi.Input[str] id: Asset's Id.
        :param pulumi.Input[Mapping[str, pulumi.Input['InputPortArgs']]] input_ports: Information about the asset's input ports.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: If the asset is a custom module, this holds the module's metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input['OutputPortArgs']]] output_ports: Information about the asset's output ports.
        :param pulumi.Input[Sequence[pulumi.Input['ModuleAssetParameterArgs']]] parameters: If the asset is a custom module, this holds the module's parameters.
        """
        pulumi.set(__self__, "location_info", location_info)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if input_ports is not None:
            pulumi.set(__self__, "input_ports", input_ports)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if output_ports is not None:
            pulumi.set(__self__, "output_ports", output_ports)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="locationInfo")
    def location_info(self) -> pulumi.Input['BlobLocationArgs']:
        """
        Access information for the asset.
        """
        return pulumi.get(self, "location_info")

    @location_info.setter
    def location_info(self, value: pulumi.Input['BlobLocationArgs']):
        pulumi.set(self, "location_info", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Asset's friendly name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'AssetType']]:
        """
        Asset's type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'AssetType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Asset's Id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="inputPorts")
    def input_ports(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['InputPortArgs']]]]:
        """
        Information about the asset's input ports.
        """
        return pulumi.get(self, "input_ports")

    @input_ports.setter
    def input_ports(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['InputPortArgs']]]]):
        pulumi.set(self, "input_ports", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        If the asset is a custom module, this holds the module's metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="outputPorts")
    def output_ports(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['OutputPortArgs']]]]:
        """
        Information about the asset's output ports.
        """
        return pulumi.get(self, "output_ports")

    @output_ports.setter
    def output_ports(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['OutputPortArgs']]]]):
        pulumi.set(self, "output_ports", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModuleAssetParameterArgs']]]]:
        """
        If the asset is a custom module, this holds the module's parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModuleAssetParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class BlobLocationArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[str],
                 credentials: Optional[pulumi.Input[str]] = None):
        """
        Describes the access location for a blob.
        :param pulumi.Input[str] uri: The URI from which the blob is accessible from. For example, aml://abc for system assets or https://xyz for user assets or payload.
        :param pulumi.Input[str] credentials: Access credentials for the blob, if applicable (e.g. blob specified by storage account connection string + blob URI)
        """
        pulumi.set(__self__, "uri", uri)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The URI from which the blob is accessible from. For example, aml://abc for system assets or https://xyz for user assets or payload.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[str]]:
        """
        Access credentials for the blob, if applicable (e.g. blob specified by storage account connection string + blob URI)
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials", value)


@pulumi.input_type
class ColumnSpecificationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ColumnType']],
                 enum: Optional[pulumi.Input[Sequence[Any]]] = None,
                 format: Optional[pulumi.Input[Union[str, 'ColumnFormat']]] = None,
                 x_ms_isnullable: Optional[pulumi.Input[bool]] = None,
                 x_ms_isordered: Optional[pulumi.Input[bool]] = None):
        """
        Swagger 2.0 schema for a column within the data table representing a web service input or output. See Swagger specification: http://swagger.io/specification/
        :param pulumi.Input[Union[str, 'ColumnType']] type: Data type of the column.
        :param pulumi.Input[Sequence[Any]] enum: If the data type is categorical, this provides the list of accepted categories.
        :param pulumi.Input[Union[str, 'ColumnFormat']] format: Additional format information for the data type.
        :param pulumi.Input[bool] x_ms_isnullable: Flag indicating if the type supports null values or not.
        :param pulumi.Input[bool] x_ms_isordered: Flag indicating whether the categories are treated as an ordered set or not, if this is a categorical column.
        """
        pulumi.set(__self__, "type", type)
        if enum is not None:
            pulumi.set(__self__, "enum", enum)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if x_ms_isnullable is not None:
            pulumi.set(__self__, "x_ms_isnullable", x_ms_isnullable)
        if x_ms_isordered is not None:
            pulumi.set(__self__, "x_ms_isordered", x_ms_isordered)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ColumnType']]:
        """
        Data type of the column.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ColumnType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def enum(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        If the data type is categorical, this provides the list of accepted categories.
        """
        return pulumi.get(self, "enum")

    @enum.setter
    def enum(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "enum", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[Union[str, 'ColumnFormat']]]:
        """
        Additional format information for the data type.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[Union[str, 'ColumnFormat']]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="xMsIsnullable")
    def x_ms_isnullable(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating if the type supports null values or not.
        """
        return pulumi.get(self, "x_ms_isnullable")

    @x_ms_isnullable.setter
    def x_ms_isnullable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "x_ms_isnullable", value)

    @property
    @pulumi.getter(name="xMsIsordered")
    def x_ms_isordered(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating whether the categories are treated as an ordered set or not, if this is a categorical column.
        """
        return pulumi.get(self, "x_ms_isordered")

    @x_ms_isordered.setter
    def x_ms_isordered(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "x_ms_isordered", value)


@pulumi.input_type
class CommitmentPlanArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Information about the machine learning commitment plan associated with the web service.
        :param pulumi.Input[str] id: Specifies the Azure Resource Manager ID of the commitment plan associated with the web service.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Specifies the Azure Resource Manager ID of the commitment plan associated with the web service.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class DiagnosticsConfigurationArgs:
    def __init__(__self__, *,
                 level: pulumi.Input[Union[str, 'DiagnosticsLevel']],
                 expiry: Optional[pulumi.Input[str]] = None):
        """
        Diagnostics settings for an Azure ML web service.
        :param pulumi.Input[Union[str, 'DiagnosticsLevel']] level: Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr).
        :param pulumi.Input[str] expiry: Specifies the date and time when the logging will cease. If null, diagnostic collection is not time limited.
        """
        pulumi.set(__self__, "level", level)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)

    @property
    @pulumi.getter
    def level(self) -> pulumi.Input[Union[str, 'DiagnosticsLevel']]:
        """
        Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr).
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: pulumi.Input[Union[str, 'DiagnosticsLevel']]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the date and time when the logging will cease. If null, diagnostic collection is not time limited.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry", value)


@pulumi.input_type
class ExampleRequestArgs:
    def __init__(__self__, *,
                 global_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 inputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[Sequence[Any]]]]]]] = None):
        """
        Sample input data for the service's input(s).
        :param pulumi.Input[Mapping[str, Any]] global_parameters: Sample input data for the web service's global parameters
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[Sequence[Any]]]]]] inputs: Sample input data for the web service's input(s) given as an input name to sample input values matrix map.
        """
        if global_parameters is not None:
            pulumi.set(__self__, "global_parameters", global_parameters)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter(name="globalParameters")
    def global_parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Sample input data for the web service's global parameters
        """
        return pulumi.get(self, "global_parameters")

    @global_parameters.setter
    def global_parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "global_parameters", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[Sequence[Any]]]]]]]:
        """
        Sample input data for the web service's input(s) given as an input name to sample input values matrix map.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[Sequence[Any]]]]]]]):
        pulumi.set(self, "inputs", value)


@pulumi.input_type
class GraphEdgeArgs:
    def __init__(__self__, *,
                 source_node_id: Optional[pulumi.Input[str]] = None,
                 source_port_id: Optional[pulumi.Input[str]] = None,
                 target_node_id: Optional[pulumi.Input[str]] = None,
                 target_port_id: Optional[pulumi.Input[str]] = None):
        """
        Defines an edge within the web service's graph.
        :param pulumi.Input[str] source_node_id: The source graph node's identifier.
        :param pulumi.Input[str] source_port_id: The identifier of the source node's port that the edge connects from.
        :param pulumi.Input[str] target_node_id: The destination graph node's identifier.
        :param pulumi.Input[str] target_port_id: The identifier of the destination node's port that the edge connects into.
        """
        if source_node_id is not None:
            pulumi.set(__self__, "source_node_id", source_node_id)
        if source_port_id is not None:
            pulumi.set(__self__, "source_port_id", source_port_id)
        if target_node_id is not None:
            pulumi.set(__self__, "target_node_id", target_node_id)
        if target_port_id is not None:
            pulumi.set(__self__, "target_port_id", target_port_id)

    @property
    @pulumi.getter(name="sourceNodeId")
    def source_node_id(self) -> Optional[pulumi.Input[str]]:
        """
        The source graph node's identifier.
        """
        return pulumi.get(self, "source_node_id")

    @source_node_id.setter
    def source_node_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_node_id", value)

    @property
    @pulumi.getter(name="sourcePortId")
    def source_port_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the source node's port that the edge connects from.
        """
        return pulumi.get(self, "source_port_id")

    @source_port_id.setter
    def source_port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port_id", value)

    @property
    @pulumi.getter(name="targetNodeId")
    def target_node_id(self) -> Optional[pulumi.Input[str]]:
        """
        The destination graph node's identifier.
        """
        return pulumi.get(self, "target_node_id")

    @target_node_id.setter
    def target_node_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_node_id", value)

    @property
    @pulumi.getter(name="targetPortId")
    def target_port_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the destination node's port that the edge connects into.
        """
        return pulumi.get(self, "target_port_id")

    @target_port_id.setter
    def target_port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_port_id", value)


@pulumi.input_type
class GraphNodeArgs:
    def __init__(__self__, *,
                 asset_id: Optional[pulumi.Input[str]] = None,
                 input_id: Optional[pulumi.Input[str]] = None,
                 output_id: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['WebServiceParameterArgs']]]] = None):
        """
        Specifies a node in the web service graph. The node can either be an input, output or asset node, so only one of the corresponding id properties is populated at any given time.
        :param pulumi.Input[str] asset_id: The id of the asset represented by this node.
        :param pulumi.Input[str] input_id: The id of the input element represented by this node.
        :param pulumi.Input[str] output_id: The id of the output element represented by this node.
        :param pulumi.Input[Mapping[str, pulumi.Input['WebServiceParameterArgs']]] parameters: If applicable, parameters of the node. Global graph parameters map into these, with values set at runtime.
        """
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if input_id is not None:
            pulumi.set(__self__, "input_id", input_id)
        if output_id is not None:
            pulumi.set(__self__, "output_id", output_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the asset represented by this node.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_id", value)

    @property
    @pulumi.getter(name="inputId")
    def input_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the input element represented by this node.
        """
        return pulumi.get(self, "input_id")

    @input_id.setter
    def input_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_id", value)

    @property
    @pulumi.getter(name="outputId")
    def output_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the output element represented by this node.
        """
        return pulumi.get(self, "output_id")

    @output_id.setter
    def output_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_id", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['WebServiceParameterArgs']]]]:
        """
        If applicable, parameters of the node. Global graph parameters map into these, with values set at runtime.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['WebServiceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class GraphPackageArgs:
    def __init__(__self__, *,
                 edges: Optional[pulumi.Input[Sequence[pulumi.Input['GraphEdgeArgs']]]] = None,
                 graph_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['GraphParameterArgs']]]] = None,
                 nodes: Optional[pulumi.Input[Mapping[str, pulumi.Input['GraphNodeArgs']]]] = None):
        """
        Defines the graph of modules making up the machine learning solution.
        :param pulumi.Input[Sequence[pulumi.Input['GraphEdgeArgs']]] edges: The list of edges making up the graph.
        :param pulumi.Input[Mapping[str, pulumi.Input['GraphParameterArgs']]] graph_parameters: The collection of global parameters for the graph, given as a global parameter name to GraphParameter map. Each parameter here has a 1:1 match with the global parameters values map declared at the WebServiceProperties level.
        :param pulumi.Input[Mapping[str, pulumi.Input['GraphNodeArgs']]] nodes: The set of nodes making up the graph, provided as a nodeId to GraphNode map
        """
        if edges is not None:
            pulumi.set(__self__, "edges", edges)
        if graph_parameters is not None:
            pulumi.set(__self__, "graph_parameters", graph_parameters)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)

    @property
    @pulumi.getter
    def edges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GraphEdgeArgs']]]]:
        """
        The list of edges making up the graph.
        """
        return pulumi.get(self, "edges")

    @edges.setter
    def edges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GraphEdgeArgs']]]]):
        pulumi.set(self, "edges", value)

    @property
    @pulumi.getter(name="graphParameters")
    def graph_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['GraphParameterArgs']]]]:
        """
        The collection of global parameters for the graph, given as a global parameter name to GraphParameter map. Each parameter here has a 1:1 match with the global parameters values map declared at the WebServiceProperties level.
        """
        return pulumi.get(self, "graph_parameters")

    @graph_parameters.setter
    def graph_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['GraphParameterArgs']]]]):
        pulumi.set(self, "graph_parameters", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['GraphNodeArgs']]]]:
        """
        The set of nodes making up the graph, provided as a nodeId to GraphNode map
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['GraphNodeArgs']]]]):
        pulumi.set(self, "nodes", value)


@pulumi.input_type
class GraphParameterLinkArgs:
    def __init__(__self__, *,
                 node_id: pulumi.Input[str],
                 parameter_key: pulumi.Input[str]):
        """
        Association link for a graph global parameter to a node in the graph.
        :param pulumi.Input[str] node_id: The graph node's identifier
        :param pulumi.Input[str] parameter_key: The identifier of the node parameter that the global parameter maps to.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "parameter_key", parameter_key)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Input[str]:
        """
        The graph node's identifier
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> pulumi.Input[str]:
        """
        The identifier of the node parameter that the global parameter maps to.
        """
        return pulumi.get(self, "parameter_key")

    @parameter_key.setter
    def parameter_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_key", value)


@pulumi.input_type
class GraphParameterArgs:
    def __init__(__self__, *,
                 links: pulumi.Input[Sequence[pulumi.Input['GraphParameterLinkArgs']]],
                 type: pulumi.Input[Union[str, 'ParameterType']],
                 description: Optional[pulumi.Input[str]] = None):
        """
        Defines a global parameter in the graph.
        :param pulumi.Input[Sequence[pulumi.Input['GraphParameterLinkArgs']]] links: Association links for this parameter to nodes in the graph.
        :param pulumi.Input[Union[str, 'ParameterType']] type: Graph parameter's type.
        :param pulumi.Input[str] description: Description of this graph parameter.
        """
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def links(self) -> pulumi.Input[Sequence[pulumi.Input['GraphParameterLinkArgs']]]:
        """
        Association links for this parameter to nodes in the graph.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: pulumi.Input[Sequence[pulumi.Input['GraphParameterLinkArgs']]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ParameterType']]:
        """
        Graph parameter's type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ParameterType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of this graph parameter.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class InputPortArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'InputPortType']]] = None):
        """
        Asset input port
        :param pulumi.Input[Union[str, 'InputPortType']] type: Port data type.
        """
        if type is None:
            type = 'Dataset'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'InputPortType']]]:
        """
        Port data type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'InputPortType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MachineLearningWorkspaceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Information about the machine learning workspace containing the experiment that is source for the web service.
        :param pulumi.Input[str] id: Specifies the workspace ID of the machine learning workspace associated with the web service
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Specifies the workspace ID of the machine learning workspace associated with the web service
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ModeValueInfoArgs:
    def __init__(__self__, *,
                 interface_string: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ModuleAssetParameterArgs']]]] = None):
        """
        Nested parameter definition.
        :param pulumi.Input[str] interface_string: The interface string name for the nested parameter.
        :param pulumi.Input[Sequence[pulumi.Input['ModuleAssetParameterArgs']]] parameters: The definition of the parameter.
        """
        if interface_string is not None:
            pulumi.set(__self__, "interface_string", interface_string)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="interfaceString")
    def interface_string(self) -> Optional[pulumi.Input[str]]:
        """
        The interface string name for the nested parameter.
        """
        return pulumi.get(self, "interface_string")

    @interface_string.setter
    def interface_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_string", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModuleAssetParameterArgs']]]]:
        """
        The definition of the parameter.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModuleAssetParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class ModuleAssetParameterArgs:
    def __init__(__self__, *,
                 mode_values_info: Optional[pulumi.Input[Mapping[str, pulumi.Input['ModeValueInfoArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_type: Optional[pulumi.Input[str]] = None):
        """
        Parameter definition for a module asset.
        :param pulumi.Input[Mapping[str, pulumi.Input['ModeValueInfoArgs']]] mode_values_info: Definitions for nested interface parameters if this is a complex module parameter.
        :param pulumi.Input[str] name: Parameter name.
        :param pulumi.Input[str] parameter_type: Parameter type.
        """
        if mode_values_info is not None:
            pulumi.set(__self__, "mode_values_info", mode_values_info)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_type is not None:
            pulumi.set(__self__, "parameter_type", parameter_type)

    @property
    @pulumi.getter(name="modeValuesInfo")
    def mode_values_info(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ModeValueInfoArgs']]]]:
        """
        Definitions for nested interface parameters if this is a complex module parameter.
        """
        return pulumi.get(self, "mode_values_info")

    @mode_values_info.setter
    def mode_values_info(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ModeValueInfoArgs']]]]):
        pulumi.set(self, "mode_values_info", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter type.
        """
        return pulumi.get(self, "parameter_type")

    @parameter_type.setter
    def parameter_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_type", value)


@pulumi.input_type
class OutputPortArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'OutputPortType']]] = None):
        """
        Asset output port
        :param pulumi.Input[Union[str, 'OutputPortType']] type: Port data type.
        """
        if type is None:
            type = 'Dataset'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'OutputPortType']]]:
        """
        Port data type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'OutputPortType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RealtimeConfigurationArgs:
    def __init__(__self__, *,
                 max_concurrent_calls: Optional[pulumi.Input[int]] = None):
        """
        Holds the available configuration options for an Azure ML web service endpoint.
        :param pulumi.Input[int] max_concurrent_calls: Specifies the maximum concurrent calls that can be made to the web service. Minimum value: 4, Maximum value: 200.
        """
        if max_concurrent_calls is not None:
            pulumi.set(__self__, "max_concurrent_calls", max_concurrent_calls)

    @property
    @pulumi.getter(name="maxConcurrentCalls")
    def max_concurrent_calls(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum concurrent calls that can be made to the web service. Minimum value: 4, Maximum value: 200.
        """
        return pulumi.get(self, "max_concurrent_calls")

    @max_concurrent_calls.setter
    def max_concurrent_calls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_calls", value)


@pulumi.input_type
class ResourceSkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        The SKU of a resource.
        :param pulumi.Input[int] capacity: The scale-out capacity of the resource. 1 is 1x, 2 is 2x, etc. This impacts the quantities and cost of any commitment plan resource.
        :param pulumi.Input[str] name: The SKU name. Along with tier, uniquely identifies the SKU.
        :param pulumi.Input[str] tier: The SKU tier. Along with name, uniquely identifies the SKU.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The scale-out capacity of the resource. 1 is 1x, 2 is 2x, etc. This impacts the quantities and cost of any commitment plan resource.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU name. Along with tier, uniquely identifies the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU tier. Along with name, uniquely identifies the SKU.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class ServiceInputOutputSpecificationArgs:
    def __init__(__self__, *,
                 properties: pulumi.Input[Mapping[str, pulumi.Input['TableSpecificationArgs']]],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The swagger 2.0 schema describing the service's inputs or outputs. See Swagger specification: http://swagger.io/specification/
        :param pulumi.Input[Mapping[str, pulumi.Input['TableSpecificationArgs']]] properties: Specifies a collection that contains the column schema for each input or output of the web service. For more information, see the Swagger specification.
        :param pulumi.Input[str] type: The type of the entity described in swagger. Always 'object'.
        :param pulumi.Input[str] description: The description of the Swagger schema.
        :param pulumi.Input[str] title: The title of your Swagger schema.
        """
        pulumi.set(__self__, "properties", properties)
        if type is None:
            type = 'object'
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input[Mapping[str, pulumi.Input['TableSpecificationArgs']]]:
        """
        Specifies a collection that contains the column schema for each input or output of the web service. For more information, see the Swagger specification.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input[Mapping[str, pulumi.Input['TableSpecificationArgs']]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the entity described in swagger. Always 'object'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Swagger schema.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The title of your Swagger schema.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class StorageAccountArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Access information for a storage account.
        :param pulumi.Input[str] key: Specifies the key used to access the storage account.
        :param pulumi.Input[str] name: Specifies the name of the storage account.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key used to access the storage account.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the storage account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class TableSpecificationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input['ColumnSpecificationArgs']]]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The swagger 2.0 schema describing a single service input or output. See Swagger specification: http://swagger.io/specification/
        :param pulumi.Input[str] type: The type of the entity described in swagger.
        :param pulumi.Input[str] description: Swagger schema description.
        :param pulumi.Input[str] format: The format, if 'type' is not 'object'
        :param pulumi.Input[Mapping[str, pulumi.Input['ColumnSpecificationArgs']]] properties: The set of columns within the data table.
        :param pulumi.Input[str] title: Swagger schema title.
        """
        if type is None:
            type = 'object'
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the entity described in swagger.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Swagger schema description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The format, if 'type' is not 'object'
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ColumnSpecificationArgs']]]]:
        """
        The set of columns within the data table.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ColumnSpecificationArgs']]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Swagger schema title.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class WebServiceKeysArgs:
    def __init__(__self__, *,
                 primary: Optional[pulumi.Input[str]] = None,
                 secondary: Optional[pulumi.Input[str]] = None):
        """
        Access keys for the web service calls.
        :param pulumi.Input[str] primary: The primary access key.
        :param pulumi.Input[str] secondary: The secondary access key.
        """
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if secondary is not None:
            pulumi.set(__self__, "secondary", secondary)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[str]]:
        """
        The primary access key.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter
    def secondary(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary access key.
        """
        return pulumi.get(self, "secondary")

    @secondary.setter
    def secondary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary", value)


@pulumi.input_type
class WebServiceParameterArgs:
    def __init__(__self__, *,
                 certificate_thumbprint: Optional[pulumi.Input[str]] = None,
                 value: Optional[Any] = None):
        """
        Web Service Parameter object for node and global parameter
        :param pulumi.Input[str] certificate_thumbprint: If the parameter value in 'value' field is encrypted, the thumbprint of the certificate should be put here.
        :param Any value: The parameter value
        """
        if certificate_thumbprint is not None:
            pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        If the parameter value in 'value' field is encrypted, the thumbprint of the certificate should be put here.
        """
        return pulumi.get(self, "certificate_thumbprint")

    @certificate_thumbprint.setter
    def certificate_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_thumbprint", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The parameter value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[Any]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class WebServicePropertiesForGraphArgs:
    def __init__(__self__, *,
                 package_type: pulumi.Input[str],
                 assets: Optional[pulumi.Input[Mapping[str, pulumi.Input['AssetItemArgs']]]] = None,
                 commitment_plan: Optional[pulumi.Input['CommitmentPlanArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 diagnostics: Optional[pulumi.Input['DiagnosticsConfigurationArgs']] = None,
                 example_request: Optional[pulumi.Input['ExampleRequestArgs']] = None,
                 expose_sample_data: Optional[pulumi.Input[bool]] = None,
                 input: Optional[pulumi.Input['ServiceInputOutputSpecificationArgs']] = None,
                 keys: Optional[pulumi.Input['WebServiceKeysArgs']] = None,
                 machine_learning_workspace: Optional[pulumi.Input['MachineLearningWorkspaceArgs']] = None,
                 output: Optional[pulumi.Input['ServiceInputOutputSpecificationArgs']] = None,
                 package: Optional[pulumi.Input['GraphPackageArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['WebServiceParameterArgs']]]] = None,
                 payloads_in_blob_storage: Optional[pulumi.Input[bool]] = None,
                 payloads_location: Optional[pulumi.Input['BlobLocationArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 realtime_configuration: Optional[pulumi.Input['RealtimeConfigurationArgs']] = None,
                 storage_account: Optional[pulumi.Input['StorageAccountArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Properties specific to a Graph based web service.
        :param pulumi.Input[str] package_type: Specifies the package type. Valid values are Graph (Specifies a web service published through the Machine Learning Studio) and Code (Specifies a web service published using code such as Python). Note: Code is not supported at this time.
               Expected value is 'Graph'.
        :param pulumi.Input[Mapping[str, pulumi.Input['AssetItemArgs']]] assets: Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
        :param pulumi.Input['CommitmentPlanArgs'] commitment_plan: Contains the commitment plan associated with this web service. Set at creation time. Once set, this value cannot be changed. Note: The commitment plan is not returned from calls to GET operations.
        :param pulumi.Input[str] description: The description of the web service.
        :param pulumi.Input['DiagnosticsConfigurationArgs'] diagnostics: Settings controlling the diagnostics traces collection for the web service.
        :param pulumi.Input['ExampleRequestArgs'] example_request: Defines sample input data for one or more of the service's inputs.
        :param pulumi.Input[bool] expose_sample_data: When set to true, sample data is included in the web service's swagger definition. The default value is true.
        :param pulumi.Input['ServiceInputOutputSpecificationArgs'] input: Contains the Swagger 2.0 schema describing one or more of the web service's inputs. For more information, see the Swagger specification.
        :param pulumi.Input['WebServiceKeysArgs'] keys: Contains the web service provisioning keys. If you do not specify provisioning keys, the Azure Machine Learning system generates them for you. Note: The keys are not returned from calls to GET operations.
        :param pulumi.Input['MachineLearningWorkspaceArgs'] machine_learning_workspace: Specifies the Machine Learning workspace containing the experiment that is source for the web service.
        :param pulumi.Input['ServiceInputOutputSpecificationArgs'] output: Contains the Swagger 2.0 schema describing one or more of the web service's outputs. For more information, see the Swagger specification.
        :param pulumi.Input['GraphPackageArgs'] package: The definition of the graph package making up this web service.
        :param pulumi.Input[Mapping[str, pulumi.Input['WebServiceParameterArgs']]] parameters: The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
        :param pulumi.Input[bool] payloads_in_blob_storage: When set to true, indicates that the payload size is larger than 3 MB. Otherwise false. If the payload size exceed 3 MB, the payload is stored in a blob and the PayloadsLocation parameter contains the URI of the blob. Otherwise, this will be set to false and Assets, Input, Output, Package, Parameters, ExampleRequest are inline. The Payload sizes is determined by adding the size of the Assets, Input, Output, Package, Parameters, and the ExampleRequest.
        :param pulumi.Input['BlobLocationArgs'] payloads_location: The URI of the payload blob. This parameter contains a value only if the payloadsInBlobStorage parameter is set to true. Otherwise is set to null.
        :param pulumi.Input[bool] read_only: When set to true, indicates that the web service is read-only and can no longer be updated or patched, only removed. Default, is false. Note: Once set to true, you cannot change its value.
        :param pulumi.Input['RealtimeConfigurationArgs'] realtime_configuration: Contains the configuration settings for the web service endpoint.
        :param pulumi.Input['StorageAccountArgs'] storage_account: Specifies the storage account that Azure Machine Learning uses to store information about the web service. Only the name of the storage account is returned from calls to GET operations. When updating the storage account information, you must ensure that all necessary assets are available in the new storage account or calls to your web service will fail.
        :param pulumi.Input[str] title: The title of the web service.
        """
        pulumi.set(__self__, "package_type", 'Graph')
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if commitment_plan is not None:
            pulumi.set(__self__, "commitment_plan", commitment_plan)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if example_request is not None:
            pulumi.set(__self__, "example_request", example_request)
        if expose_sample_data is not None:
            pulumi.set(__self__, "expose_sample_data", expose_sample_data)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if machine_learning_workspace is not None:
            pulumi.set(__self__, "machine_learning_workspace", machine_learning_workspace)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if payloads_in_blob_storage is not None:
            pulumi.set(__self__, "payloads_in_blob_storage", payloads_in_blob_storage)
        if payloads_location is not None:
            pulumi.set(__self__, "payloads_location", payloads_location)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if realtime_configuration is not None:
            pulumi.set(__self__, "realtime_configuration", realtime_configuration)
        if storage_account is not None:
            pulumi.set(__self__, "storage_account", storage_account)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Input[str]:
        """
        Specifies the package type. Valid values are Graph (Specifies a web service published through the Machine Learning Studio) and Code (Specifies a web service published using code such as Python). Note: Code is not supported at this time.
        Expected value is 'Graph'.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['AssetItemArgs']]]]:
        """
        Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['AssetItemArgs']]]]):
        pulumi.set(self, "assets", value)

    @property
    @pulumi.getter(name="commitmentPlan")
    def commitment_plan(self) -> Optional[pulumi.Input['CommitmentPlanArgs']]:
        """
        Contains the commitment plan associated with this web service. Set at creation time. Once set, this value cannot be changed. Note: The commitment plan is not returned from calls to GET operations.
        """
        return pulumi.get(self, "commitment_plan")

    @commitment_plan.setter
    def commitment_plan(self, value: Optional[pulumi.Input['CommitmentPlanArgs']]):
        pulumi.set(self, "commitment_plan", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the web service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional[pulumi.Input['DiagnosticsConfigurationArgs']]:
        """
        Settings controlling the diagnostics traces collection for the web service.
        """
        return pulumi.get(self, "diagnostics")

    @diagnostics.setter
    def diagnostics(self, value: Optional[pulumi.Input['DiagnosticsConfigurationArgs']]):
        pulumi.set(self, "diagnostics", value)

    @property
    @pulumi.getter(name="exampleRequest")
    def example_request(self) -> Optional[pulumi.Input['ExampleRequestArgs']]:
        """
        Defines sample input data for one or more of the service's inputs.
        """
        return pulumi.get(self, "example_request")

    @example_request.setter
    def example_request(self, value: Optional[pulumi.Input['ExampleRequestArgs']]):
        pulumi.set(self, "example_request", value)

    @property
    @pulumi.getter(name="exposeSampleData")
    def expose_sample_data(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, sample data is included in the web service's swagger definition. The default value is true.
        """
        return pulumi.get(self, "expose_sample_data")

    @expose_sample_data.setter
    def expose_sample_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "expose_sample_data", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['ServiceInputOutputSpecificationArgs']]:
        """
        Contains the Swagger 2.0 schema describing one or more of the web service's inputs. For more information, see the Swagger specification.
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['ServiceInputOutputSpecificationArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input['WebServiceKeysArgs']]:
        """
        Contains the web service provisioning keys. If you do not specify provisioning keys, the Azure Machine Learning system generates them for you. Note: The keys are not returned from calls to GET operations.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input['WebServiceKeysArgs']]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="machineLearningWorkspace")
    def machine_learning_workspace(self) -> Optional[pulumi.Input['MachineLearningWorkspaceArgs']]:
        """
        Specifies the Machine Learning workspace containing the experiment that is source for the web service.
        """
        return pulumi.get(self, "machine_learning_workspace")

    @machine_learning_workspace.setter
    def machine_learning_workspace(self, value: Optional[pulumi.Input['MachineLearningWorkspaceArgs']]):
        pulumi.set(self, "machine_learning_workspace", value)

    @property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input['ServiceInputOutputSpecificationArgs']]:
        """
        Contains the Swagger 2.0 schema describing one or more of the web service's outputs. For more information, see the Swagger specification.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input['ServiceInputOutputSpecificationArgs']]):
        pulumi.set(self, "output", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input['GraphPackageArgs']]:
        """
        The definition of the graph package making up this web service.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input['GraphPackageArgs']]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['WebServiceParameterArgs']]]]:
        """
        The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['WebServiceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="payloadsInBlobStorage")
    def payloads_in_blob_storage(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, indicates that the payload size is larger than 3 MB. Otherwise false. If the payload size exceed 3 MB, the payload is stored in a blob and the PayloadsLocation parameter contains the URI of the blob. Otherwise, this will be set to false and Assets, Input, Output, Package, Parameters, ExampleRequest are inline. The Payload sizes is determined by adding the size of the Assets, Input, Output, Package, Parameters, and the ExampleRequest.
        """
        return pulumi.get(self, "payloads_in_blob_storage")

    @payloads_in_blob_storage.setter
    def payloads_in_blob_storage(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "payloads_in_blob_storage", value)

    @property
    @pulumi.getter(name="payloadsLocation")
    def payloads_location(self) -> Optional[pulumi.Input['BlobLocationArgs']]:
        """
        The URI of the payload blob. This parameter contains a value only if the payloadsInBlobStorage parameter is set to true. Otherwise is set to null.
        """
        return pulumi.get(self, "payloads_location")

    @payloads_location.setter
    def payloads_location(self, value: Optional[pulumi.Input['BlobLocationArgs']]):
        pulumi.set(self, "payloads_location", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, indicates that the web service is read-only and can no longer be updated or patched, only removed. Default, is false. Note: Once set to true, you cannot change its value.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="realtimeConfiguration")
    def realtime_configuration(self) -> Optional[pulumi.Input['RealtimeConfigurationArgs']]:
        """
        Contains the configuration settings for the web service endpoint.
        """
        return pulumi.get(self, "realtime_configuration")

    @realtime_configuration.setter
    def realtime_configuration(self, value: Optional[pulumi.Input['RealtimeConfigurationArgs']]):
        pulumi.set(self, "realtime_configuration", value)

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> Optional[pulumi.Input['StorageAccountArgs']]:
        """
        Specifies the storage account that Azure Machine Learning uses to store information about the web service. Only the name of the storage account is returned from calls to GET operations. When updating the storage account information, you must ensure that all necessary assets are available in the new storage account or calls to your web service will fail.
        """
        return pulumi.get(self, "storage_account")

    @storage_account.setter
    def storage_account(self, value: Optional[pulumi.Input['StorageAccountArgs']]):
        pulumi.set(self, "storage_account", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The title of the web service.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


