# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetManagedInstanceVulnerabilityAssessmentResult',
    'AwaitableGetManagedInstanceVulnerabilityAssessmentResult',
    'get_managed_instance_vulnerability_assessment',
]

@pulumi.output_type
class GetManagedInstanceVulnerabilityAssessmentResult:
    """
    A managed instance vulnerability assessment.
    """
    def __init__(__self__, id=None, name=None, recurring_scans=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recurring_scans and not isinstance(recurring_scans, dict):
            raise TypeError("Expected argument 'recurring_scans' to be a dict")
        pulumi.set(__self__, "recurring_scans", recurring_scans)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> Optional['outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse']:
        """
        The recurring scans settings
        """
        return pulumi.get(self, "recurring_scans")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetManagedInstanceVulnerabilityAssessmentResult(GetManagedInstanceVulnerabilityAssessmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceVulnerabilityAssessmentResult(
            id=self.id,
            name=self.name,
            recurring_scans=self.recurring_scans,
            type=self.type)


def get_managed_instance_vulnerability_assessment(managed_instance_name: Optional[str] = None,
                                                  resource_group_name: Optional[str] = None,
                                                  vulnerability_assessment_name: Optional[str] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceVulnerabilityAssessmentResult:
    """
    A managed instance vulnerability assessment.


    :param str managed_instance_name: The name of the managed instance for which the vulnerability assessment is defined.
    :param str resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    :param str vulnerability_assessment_name: The name of the vulnerability assessment.
    """
    __args__ = dict()
    __args__['managedInstanceName'] = managed_instance_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['vulnerabilityAssessmentName'] = vulnerability_assessment_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:sql/v20210201preview:getManagedInstanceVulnerabilityAssessment', __args__, opts=opts, typ=GetManagedInstanceVulnerabilityAssessmentResult).value

    return AwaitableGetManagedInstanceVulnerabilityAssessmentResult(
        id=__ret__.id,
        name=__ret__.name,
        recurring_scans=__ret__.recurring_scans,
        type=__ret__.type)
