# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'ApplicationGroupType',
    'CommandLineSetting',
    'HostPoolType',
    'LoadBalancerType',
    'Operation',
    'PersonalDesktopAssignmentType',
    'PreferredAppGroupType',
    'PrivateEndpointServiceConnectionStatus',
    'PublicNetworkAccess',
    'RegistrationTokenOperation',
    'RemoteApplicationType',
    'ResourceIdentityType',
    'SSOSecretType',
    'ScalingHostPoolType',
    'SessionHostLoadBalancingAlgorithm',
    'SkuTier',
    'StopHostsWhen',
]


class ApplicationGroupType(str, Enum):
    """
    Resource Type of ApplicationGroup.
    """
    REMOTE_APP = "RemoteApp"
    DESKTOP = "Desktop"


class CommandLineSetting(str, Enum):
    """
    Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all.
    """
    DO_NOT_ALLOW = "DoNotAllow"
    ALLOW = "Allow"
    REQUIRE = "Require"


class HostPoolType(str, Enum):
    """
    HostPool type for desktop.
    """
    PERSONAL = "Personal"
    """Users will be assigned a SessionHost either by administrators (PersonalDesktopAssignmentType = Direct) or upon connecting to the pool (PersonalDesktopAssignmentType = Automatic). They will always be redirected to their assigned SessionHost."""
    POOLED = "Pooled"
    """Users get a new (random) SessionHost every time it connects to the HostPool."""
    BYO_DESKTOP = "BYODesktop"
    """Users assign their own machines, load balancing logic remains the same as Personal. PersonalDesktopAssignmentType must be Direct."""


class LoadBalancerType(str, Enum):
    """
    The type of the load balancer.
    """
    BREADTH_FIRST = "BreadthFirst"
    DEPTH_FIRST = "DepthFirst"
    PERSISTENT = "Persistent"


class Operation(str, Enum):
    """
    The type of operation for migration.
    """
    START = "Start"
    """Start the migration."""
    REVOKE = "Revoke"
    """Revoke the migration."""
    COMPLETE = "Complete"
    """Complete the migration."""
    HIDE = "Hide"
    """Hide the hostpool."""
    UNHIDE = "Unhide"
    """Unhide the hostpool."""


class PersonalDesktopAssignmentType(str, Enum):
    """
    PersonalDesktopAssignment type for HostPool.
    """
    AUTOMATIC = "Automatic"
    DIRECT = "Direct"


class PreferredAppGroupType(str, Enum):
    """
    The type of preferred application group type, default to Desktop Application Group
    """
    NONE = "None"
    DESKTOP = "Desktop"
    RAIL_APPLICATIONS = "RailApplications"


class PrivateEndpointServiceConnectionStatus(str, Enum):
    """
    Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
    """
    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class PublicNetworkAccess(str, Enum):
    """
    Enabled allows this resource to be accessed from both public and private networks, Disabled allows this resource to only be accessed via private endpoints
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class RegistrationTokenOperation(str, Enum):
    """
    The type of resetting the token.
    """
    DELETE = "Delete"
    NONE = "None"
    UPDATE = "Update"


class RemoteApplicationType(str, Enum):
    """
    Resource Type of Application.
    """
    IN_BUILT = "InBuilt"
    MSIX_APPLICATION = "MsixApplication"


class ResourceIdentityType(str, Enum):
    """
    The identity type.
    """
    SYSTEM_ASSIGNED = "SystemAssigned"


class SSOSecretType(str, Enum):
    """
    The type of single sign on Secret Type.
    """
    SHARED_KEY = "SharedKey"
    CERTIFICATE = "Certificate"
    SHARED_KEY_IN_KEY_VAULT = "SharedKeyInKeyVault"
    CERTIFICATE_IN_KEY_VAULT = "CertificateInKeyVault"


class ScalingHostPoolType(str, Enum):
    """
    HostPool type for desktop.
    """
    POOLED = "Pooled"
    """Users get a new (random) SessionHost every time it connects to the HostPool."""


class SessionHostLoadBalancingAlgorithm(str, Enum):
    """
    Load balancing algorithm for ramp up period.
    """
    BREADTH_FIRST = "BreadthFirst"
    DEPTH_FIRST = "DepthFirst"


class SkuTier(str, Enum):
    """
    This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
    """
    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class StopHostsWhen(str, Enum):
    """
    Specifies when to stop hosts during ramp down period.
    """
    ZERO_SESSIONS = "ZeroSessions"
    ZERO_ACTIVE_SESSIONS = "ZeroActiveSessions"
