# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AccessPolicyEntryArgs',
    'PermissionsArgs',
    'SkuArgs',
    'VaultPropertiesArgs',
]

@pulumi.input_type
class AccessPolicyEntryArgs:
    def __init__(__self__, *,
                 object_id: pulumi.Input[str],
                 permissions: pulumi.Input['PermissionsArgs'],
                 tenant_id: pulumi.Input[str],
                 application_id: Optional[pulumi.Input[str]] = None):
        """
        An identity that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
        :param pulumi.Input[str] object_id: The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
        :param pulumi.Input['PermissionsArgs'] permissions: Permissions the identity has for keys, secrets and certificates.
        :param pulumi.Input[str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        :param pulumi.Input[str] application_id:  Application ID of the client making request on behalf of a principal
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[str]:
        """
        The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input['PermissionsArgs']:
        """
        Permissions the identity has for keys, secrets and certificates.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input['PermissionsArgs']):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
         Application ID of the client making request on behalf of a principal
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)


@pulumi.input_type
class PermissionsArgs:
    def __init__(__self__, *,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'CertificatePermissions']]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KeyPermissions']]]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'SecretPermissions']]]]] = None):
        """
        Permissions the identity has for keys, secrets and certificates.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'CertificatePermissions']]]] certificates: Permissions to certificates
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KeyPermissions']]]] keys: Permissions to keys
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'SecretPermissions']]]] secrets: Permissions to secrets
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'CertificatePermissions']]]]]:
        """
        Permissions to certificates
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'CertificatePermissions']]]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KeyPermissions']]]]]:
        """
        Permissions to keys
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KeyPermissions']]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'SecretPermissions']]]]]:
        """
        Permissions to secrets
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'SecretPermissions']]]]]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 family: pulumi.Input[Union[str, 'SkuFamily']],
                 name: pulumi.Input['SkuName']):
        """
        SKU details
        :param pulumi.Input[Union[str, 'SkuFamily']] family: SKU family name
        :param pulumi.Input['SkuName'] name: SKU name to specify whether the key vault is a standard vault or a premium vault.
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def family(self) -> pulumi.Input[Union[str, 'SkuFamily']]:
        """
        SKU family name
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: pulumi.Input[Union[str, 'SkuFamily']]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input['SkuName']:
        """
        SKU name to specify whether the key vault is a standard vault or a premium vault.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input['SkuName']):
        pulumi.set(self, "name", value)


@pulumi.input_type
class VaultPropertiesArgs:
    def __init__(__self__, *,
                 access_policies: pulumi.Input[Sequence[pulumi.Input['AccessPolicyEntryArgs']]],
                 sku: pulumi.Input['SkuArgs'],
                 tenant_id: pulumi.Input[str],
                 enable_soft_delete: Optional[pulumi.Input[bool]] = None,
                 enabled_for_deployment: Optional[pulumi.Input[bool]] = None,
                 enabled_for_disk_encryption: Optional[pulumi.Input[bool]] = None,
                 enabled_for_template_deployment: Optional[pulumi.Input[bool]] = None,
                 vault_uri: Optional[pulumi.Input[str]] = None):
        """
        Properties of the vault
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyEntryArgs']]] access_policies: An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
        :param pulumi.Input['SkuArgs'] sku: SKU details
        :param pulumi.Input[str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        :param pulumi.Input[bool] enable_soft_delete: Property to specify whether the 'soft delete' functionality is enabled for this key vault.
        :param pulumi.Input[bool] enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        :param pulumi.Input[bool] enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        :param pulumi.Input[bool] enabled_for_template_deployment: Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        :param pulumi.Input[str] vault_uri: The URI of the vault for performing operations on keys and secrets.
        """
        pulumi.set(__self__, "access_policies", access_policies)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if enable_soft_delete is not None:
            pulumi.set(__self__, "enable_soft_delete", enable_soft_delete)
        if enabled_for_deployment is not None:
            pulumi.set(__self__, "enabled_for_deployment", enabled_for_deployment)
        if enabled_for_disk_encryption is not None:
            pulumi.set(__self__, "enabled_for_disk_encryption", enabled_for_disk_encryption)
        if enabled_for_template_deployment is not None:
            pulumi.set(__self__, "enabled_for_template_deployment", enabled_for_template_deployment)
        if vault_uri is not None:
            pulumi.set(__self__, "vault_uri", vault_uri)

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> pulumi.Input[Sequence[pulumi.Input['AccessPolicyEntryArgs']]]:
        """
        An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
        """
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: pulumi.Input[Sequence[pulumi.Input['AccessPolicyEntryArgs']]]):
        pulumi.set(self, "access_policies", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input['SkuArgs']:
        """
        SKU details
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['SkuArgs']):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="enableSoftDelete")
    def enable_soft_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Property to specify whether the 'soft delete' functionality is enabled for this key vault.
        """
        return pulumi.get(self, "enable_soft_delete")

    @enable_soft_delete.setter
    def enable_soft_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_soft_delete", value)

    @property
    @pulumi.getter(name="enabledForDeployment")
    def enabled_for_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_deployment")

    @enabled_for_deployment.setter
    def enabled_for_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_for_deployment", value)

    @property
    @pulumi.getter(name="enabledForDiskEncryption")
    def enabled_for_disk_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        """
        return pulumi.get(self, "enabled_for_disk_encryption")

    @enabled_for_disk_encryption.setter
    def enabled_for_disk_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_for_disk_encryption", value)

    @property
    @pulumi.getter(name="enabledForTemplateDeployment")
    def enabled_for_template_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_template_deployment")

    @enabled_for_template_deployment.setter
    def enabled_for_template_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_for_template_deployment", value)

    @property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the vault for performing operations on keys and secrets.
        """
        return pulumi.get(self, "vault_uri")

    @vault_uri.setter
    def vault_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_uri", value)


