# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApplicationPackageReferenceResponse',
    'AutoScaleRunErrorResponse',
    'AutoScaleRunResponse',
    'AutoScaleSettingsResponse',
    'AutoStoragePropertiesResponse',
    'AutoUserSpecificationResponse',
    'AzureBlobFileSystemConfigurationResponse',
    'AzureFileShareConfigurationResponse',
    'BatchAccountIdentityResponse',
    'BatchAccountIdentityResponseUserAssignedIdentities',
    'BatchPoolIdentityResponse',
    'BatchPoolIdentityResponseUserAssignedIdentities',
    'CIFSMountConfigurationResponse',
    'CertificateReferenceResponse',
    'CloudServiceConfigurationResponse',
    'ContainerConfigurationResponse',
    'ContainerRegistryResponse',
    'DataDiskResponse',
    'DeleteCertificateErrorResponse',
    'DeploymentConfigurationResponse',
    'DiskEncryptionConfigurationResponse',
    'EncryptionPropertiesResponse',
    'EnvironmentSettingResponse',
    'FixedScaleSettingsResponse',
    'ImageReferenceResponse',
    'InboundNatPoolResponse',
    'KeyVaultPropertiesResponse',
    'KeyVaultReferenceResponse',
    'LinuxUserConfigurationResponse',
    'MetadataItemResponse',
    'MountConfigurationResponse',
    'NFSMountConfigurationResponse',
    'NetworkConfigurationResponse',
    'NetworkSecurityGroupRuleResponse',
    'NodePlacementConfigurationResponse',
    'PoolEndpointConfigurationResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'PublicIPAddressConfigurationResponse',
    'ResizeErrorResponse',
    'ResizeOperationStatusResponse',
    'ResourceFileResponse',
    'ScaleSettingsResponse',
    'StartTaskResponse',
    'TaskContainerSettingsResponse',
    'TaskSchedulingPolicyResponse',
    'UserAccountResponse',
    'UserIdentityResponse',
    'VMExtensionResponse',
    'VirtualMachineConfigurationResponse',
    'VirtualMachineFamilyCoreQuotaResponse',
    'WindowsConfigurationResponse',
    'WindowsUserConfigurationResponse',
]

@pulumi.output_type
class ApplicationPackageReferenceResponse(dict):
    def __init__(__self__, *,
                 id: str,
                 version: Optional[str] = None):
        """
        :param str version: If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
        """
        pulumi.set(__self__, "id", id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AutoScaleRunErrorResponse(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.AutoScaleRunErrorResponse']] = None):
        """
        :param str code: An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        :param str message: A message describing the error, intended to be suitable for display in a user interface.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message describing the error, intended to be suitable for display in a user interface.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.AutoScaleRunErrorResponse']]:
        return pulumi.get(self, "details")


@pulumi.output_type
class AutoScaleRunResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationTime":
            suggest = "evaluation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScaleRunResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScaleRunResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScaleRunResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_time: str,
                 error: Optional['outputs.AutoScaleRunErrorResponse'] = None,
                 results: Optional[str] = None):
        """
        :param str results: Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
        """
        pulumi.set(__self__, "evaluation_time", evaluation_time)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if results is not None:
            pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter(name="evaluationTime")
    def evaluation_time(self) -> str:
        return pulumi.get(self, "evaluation_time")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.AutoScaleRunErrorResponse']:
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def results(self) -> Optional[str]:
        """
        Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
        """
        return pulumi.get(self, "results")


@pulumi.output_type
class AutoScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationInterval":
            suggest = "evaluation_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 formula: str,
                 evaluation_interval: Optional[str] = None):
        """
        :param str evaluation_interval: If omitted, the default value is 15 minutes (PT15M).
        """
        pulumi.set(__self__, "formula", formula)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @property
    @pulumi.getter
    def formula(self) -> str:
        return pulumi.get(self, "formula")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[str]:
        """
        If omitted, the default value is 15 minutes (PT15M).
        """
        return pulumi.get(self, "evaluation_interval")


@pulumi.output_type
class AutoStoragePropertiesResponse(dict):
    """
    Contains information about the auto-storage account associated with a Batch account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastKeySync":
            suggest = "last_key_sync"
        elif key == "storageAccountId":
            suggest = "storage_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoStoragePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoStoragePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoStoragePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_key_sync: str,
                 storage_account_id: str):
        """
        Contains information about the auto-storage account associated with a Batch account.
        :param str last_key_sync: The UTC time at which storage keys were last synchronized with the Batch account.
        :param str storage_account_id: The resource ID of the storage account to be used for auto-storage account.
        """
        pulumi.set(__self__, "last_key_sync", last_key_sync)
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter(name="lastKeySync")
    def last_key_sync(self) -> str:
        """
        The UTC time at which storage keys were last synchronized with the Batch account.
        """
        return pulumi.get(self, "last_key_sync")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> str:
        """
        The resource ID of the storage account to be used for auto-storage account.
        """
        return pulumi.get(self, "storage_account_id")


@pulumi.output_type
class AutoUserSpecificationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elevationLevel":
            suggest = "elevation_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoUserSpecificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoUserSpecificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoUserSpecificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elevation_level: Optional[str] = None,
                 scope: Optional[str] = None):
        """
        :param str elevation_level: The default value is nonAdmin.
        :param str scope: The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks.
        """
        if elevation_level is not None:
            pulumi.set(__self__, "elevation_level", elevation_level)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> Optional[str]:
        """
        The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class AzureBlobFileSystemConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "relativeMountPath":
            suggest = "relative_mount_path"
        elif key == "accountKey":
            suggest = "account_key"
        elif key == "blobfuseOptions":
            suggest = "blobfuse_options"
        elif key == "sasKey":
            suggest = "sas_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBlobFileSystemConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBlobFileSystemConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBlobFileSystemConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 container_name: str,
                 relative_mount_path: str,
                 account_key: Optional[str] = None,
                 blobfuse_options: Optional[str] = None,
                 sas_key: Optional[str] = None):
        """
        :param str relative_mount_path: All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :param str account_key: This property is mutually exclusive with sasKey and one must be specified.
        :param str blobfuse_options: These are 'net use' options in Windows and 'mount' options in Linux.
        :param str sas_key: This property is mutually exclusive with accountKey and one must be specified.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if blobfuse_options is not None:
            pulumi.set(__self__, "blobfuse_options", blobfuse_options)
        if sas_key is not None:
            pulumi.set(__self__, "sas_key", sas_key)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> str:
        """
        All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[str]:
        """
        This property is mutually exclusive with sasKey and one must be specified.
        """
        return pulumi.get(self, "account_key")

    @property
    @pulumi.getter(name="blobfuseOptions")
    def blobfuse_options(self) -> Optional[str]:
        """
        These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "blobfuse_options")

    @property
    @pulumi.getter(name="sasKey")
    def sas_key(self) -> Optional[str]:
        """
        This property is mutually exclusive with accountKey and one must be specified.
        """
        return pulumi.get(self, "sas_key")


@pulumi.output_type
class AzureFileShareConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountKey":
            suggest = "account_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "azureFileUrl":
            suggest = "azure_file_url"
        elif key == "relativeMountPath":
            suggest = "relative_mount_path"
        elif key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileShareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileShareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileShareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_key: str,
                 account_name: str,
                 azure_file_url: str,
                 relative_mount_path: str,
                 mount_options: Optional[str] = None):
        """
        :param str azure_file_url: This is of the form 'https://{account}.file.core.windows.net/'.
        :param str relative_mount_path: All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :param str mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "account_key", account_key)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "azure_file_url", azure_file_url)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> str:
        return pulumi.get(self, "account_key")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="azureFileUrl")
    def azure_file_url(self) -> str:
        """
        This is of the form 'https://{account}.file.core.windows.net/'.
        """
        return pulumi.get(self, "azure_file_url")

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> str:
        """
        All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[str]:
        """
        These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class BatchAccountIdentityResponse(dict):
    """
    The identity of the Batch account, if configured. This is only used when the user specifies 'Microsoft.KeyVault' as their Batch account encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchAccountIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchAccountIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchAccountIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.BatchAccountIdentityResponseUserAssignedIdentities']] = None):
        """
        The identity of the Batch account, if configured. This is only used when the user specifies 'Microsoft.KeyVault' as their Batch account encryption configuration.
        :param str principal_id: The principal id of the Batch account. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant id associated with the Batch account. This property will only be provided for a system assigned identity.
        :param str type: The type of identity used for the Batch account.
        :param Mapping[str, 'BatchAccountIdentityResponseUserAssignedIdentities'] user_assigned_identities: The list of user identities associated with the Batch account. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the Batch account. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the Batch account. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of identity used for the Batch account.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.BatchAccountIdentityResponseUserAssignedIdentities']]:
        """
        The list of user identities associated with the Batch account. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class BatchAccountIdentityResponseUserAssignedIdentities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchAccountIdentityResponseUserAssignedIdentities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchAccountIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchAccountIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class BatchPoolIdentityResponse(dict):
    """
    The identity of the Batch pool, if configured. If the pool identity is updated during update an existing pool, only the new vms which are created after the pool shrinks to 0 will have the updated identities
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchPoolIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchPoolIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchPoolIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.BatchPoolIdentityResponseUserAssignedIdentities']] = None):
        """
        The identity of the Batch pool, if configured. If the pool identity is updated during update an existing pool, only the new vms which are created after the pool shrinks to 0 will have the updated identities
        :param str type: The type of identity used for the Batch Pool.
        :param Mapping[str, 'BatchPoolIdentityResponseUserAssignedIdentities'] user_assigned_identities: The list of user identities associated with the Batch pool. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of identity used for the Batch Pool.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.BatchPoolIdentityResponseUserAssignedIdentities']]:
        """
        The list of user identities associated with the Batch pool. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class BatchPoolIdentityResponseUserAssignedIdentities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchPoolIdentityResponseUserAssignedIdentities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchPoolIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchPoolIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class CIFSMountConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relativeMountPath":
            suggest = "relative_mount_path"
        elif key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CIFSMountConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CIFSMountConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CIFSMountConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 relative_mount_path: str,
                 source: str,
                 username: str,
                 mount_options: Optional[str] = None):
        """
        :param str relative_mount_path: All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :param str mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "username", username)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> str:
        """
        All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @property
    @pulumi.getter
    def source(self) -> str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[str]:
        """
        These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class CertificateReferenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storeLocation":
            suggest = "store_location"
        elif key == "storeName":
            suggest = "store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 store_location: Optional[str] = None,
                 store_name: Optional[str] = None,
                 visibility: Optional[Sequence[str]] = None):
        """
        :param str store_location: The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
        :param str store_name: This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
        """
        pulumi.set(__self__, "id", id)
        if store_location is not None:
            pulumi.set(__self__, "store_location", store_location)
        if store_name is not None:
            pulumi.set(__self__, "store_name", store_name)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storeLocation")
    def store_location(self) -> Optional[str]:
        """
        The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
        """
        return pulumi.get(self, "store_location")

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> Optional[str]:
        """
        This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
        """
        return pulumi.get(self, "store_name")

    @property
    @pulumi.getter
    def visibility(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "visibility")


@pulumi.output_type
class CloudServiceConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osFamily":
            suggest = "os_family"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudServiceConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudServiceConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudServiceConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_family: str,
                 os_version: Optional[str] = None):
        """
        :param str os_family: Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
        :param str os_version: The default value is * which specifies the latest operating system version for the specified OS family.
        """
        pulumi.set(__self__, "os_family", os_family)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> str:
        """
        Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        The default value is * which specifies the latest operating system version for the specified OS family.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class ContainerConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImageNames":
            suggest = "container_image_names"
        elif key == "containerRegistries":
            suggest = "container_registries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 container_image_names: Optional[Sequence[str]] = None,
                 container_registries: Optional[Sequence['outputs.ContainerRegistryResponse']] = None):
        """
        :param Sequence[str] container_image_names: This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
        :param Sequence['ContainerRegistryResponse'] container_registries: If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
        """
        pulumi.set(__self__, "type", type)
        if container_image_names is not None:
            pulumi.set(__self__, "container_image_names", container_image_names)
        if container_registries is not None:
            pulumi.set(__self__, "container_registries", container_registries)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="containerImageNames")
    def container_image_names(self) -> Optional[Sequence[str]]:
        """
        This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
        """
        return pulumi.get(self, "container_image_names")

    @property
    @pulumi.getter(name="containerRegistries")
    def container_registries(self) -> Optional[Sequence['outputs.ContainerRegistryResponse']]:
        """
        If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
        """
        return pulumi.get(self, "container_registries")


@pulumi.output_type
class ContainerRegistryResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"
        elif key == "registryServer":
            suggest = "registry_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerRegistryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerRegistryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerRegistryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 user_name: str,
                 registry_server: Optional[str] = None):
        """
        :param str registry_server: If omitted, the default is "docker.io".
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)
        if registry_server is not None:
            pulumi.set(__self__, "registry_server", registry_server)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> Optional[str]:
        """
        If omitted, the default is "docker.io".
        """
        return pulumi.get(self, "registry_server")


@pulumi.output_type
class DataDiskResponse(dict):
    """
    Settings which will be used by the data disks associated to Compute Nodes in the Pool. When using attached data disks, you need to mount and format the disks from within a VM to use them.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: int,
                 lun: int,
                 caching: Optional[str] = None,
                 storage_account_type: Optional[str] = None):
        """
        Settings which will be used by the data disks associated to Compute Nodes in the Pool. When using attached data disks, you need to mount and format the disks from within a VM to use them.
        :param int lun: The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
        :param str caching: Values are:
               
                none - The caching mode for the disk is not enabled.
                readOnly - The caching mode for the disk is read only.
                readWrite - The caching mode for the disk is read and write.
               
                The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
        :param str storage_account_type: If omitted, the default is "Standard_LRS". Values are:
               
                Standard_LRS - The data disk should use standard locally redundant storage.
                Premium_LRS - The data disk should use premium locally redundant storage.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> int:
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Values are:

         none - The caching mode for the disk is not enabled.
         readOnly - The caching mode for the disk is read only.
         readWrite - The caching mode for the disk is read and write.

         The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        If omitted, the default is "Standard_LRS". Values are:

         Standard_LRS - The data disk should use standard locally redundant storage.
         Premium_LRS - The data disk should use premium locally redundant storage.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class DeleteCertificateErrorResponse(dict):
    """
    An error response from the Batch service.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.DeleteCertificateErrorResponse']] = None,
                 target: Optional[str] = None):
        """
        An error response from the Batch service.
        :param str code: An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        :param str message: A message describing the error, intended to be suitable for display in a user interface.
        :param Sequence['DeleteCertificateErrorResponse'] details: A list of additional details about the error.
        :param str target: The target of the particular error. For example, the name of the property in error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message describing the error, intended to be suitable for display in a user interface.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.DeleteCertificateErrorResponse']]:
        """
        A list of additional details about the error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target of the particular error. For example, the name of the property in error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class DeploymentConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudServiceConfiguration":
            suggest = "cloud_service_configuration"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_service_configuration: Optional['outputs.CloudServiceConfigurationResponse'] = None,
                 virtual_machine_configuration: Optional['outputs.VirtualMachineConfigurationResponse'] = None):
        """
        :param 'CloudServiceConfigurationResponse' cloud_service_configuration: This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
        """
        if cloud_service_configuration is not None:
            pulumi.set(__self__, "cloud_service_configuration", cloud_service_configuration)
        if virtual_machine_configuration is not None:
            pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="cloudServiceConfiguration")
    def cloud_service_configuration(self) -> Optional['outputs.CloudServiceConfigurationResponse']:
        """
        This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
        """
        return pulumi.get(self, "cloud_service_configuration")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> Optional['outputs.VirtualMachineConfigurationResponse']:
        """
        This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
        """
        return pulumi.get(self, "virtual_machine_configuration")


@pulumi.output_type
class DiskEncryptionConfigurationResponse(dict):
    """
    The disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
    """
    def __init__(__self__, *,
                 targets: Optional[Sequence[str]] = None):
        """
        The disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
        :param Sequence[str] targets: On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
        """
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence[str]]:
        """
        On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class EncryptionPropertiesResponse(dict):
    """
    Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keySource":
            suggest = "key_source"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_source: Optional[str] = None,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None):
        """
        Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
        :param str key_source: Type of the key source.
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Additional details when using Microsoft.KeyVault
        """
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> Optional[str]:
        """
        Type of the key source.
        """
        return pulumi.get(self, "key_source")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        Additional details when using Microsoft.KeyVault
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class EnvironmentSettingResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class FixedScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeDeallocationOption":
            suggest = "node_deallocation_option"
        elif key == "resizeTimeout":
            suggest = "resize_timeout"
        elif key == "targetDedicatedNodes":
            suggest = "target_dedicated_nodes"
        elif key == "targetLowPriorityNodes":
            suggest = "target_low_priority_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FixedScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FixedScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FixedScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_deallocation_option: Optional[str] = None,
                 resize_timeout: Optional[str] = None,
                 target_dedicated_nodes: Optional[int] = None,
                 target_low_priority_nodes: Optional[int] = None):
        """
        :param str node_deallocation_option: If omitted, the default value is Requeue.
        :param str resize_timeout: The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        :param int target_dedicated_nodes: At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
        :param int target_low_priority_nodes: At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
        """
        if node_deallocation_option is not None:
            pulumi.set(__self__, "node_deallocation_option", node_deallocation_option)
        if resize_timeout is not None:
            pulumi.set(__self__, "resize_timeout", resize_timeout)
        if target_dedicated_nodes is not None:
            pulumi.set(__self__, "target_dedicated_nodes", target_dedicated_nodes)
        if target_low_priority_nodes is not None:
            pulumi.set(__self__, "target_low_priority_nodes", target_low_priority_nodes)

    @property
    @pulumi.getter(name="nodeDeallocationOption")
    def node_deallocation_option(self) -> Optional[str]:
        """
        If omitted, the default value is Requeue.
        """
        return pulumi.get(self, "node_deallocation_option")

    @property
    @pulumi.getter(name="resizeTimeout")
    def resize_timeout(self) -> Optional[str]:
        """
        The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        """
        return pulumi.get(self, "resize_timeout")

    @property
    @pulumi.getter(name="targetDedicatedNodes")
    def target_dedicated_nodes(self) -> Optional[int]:
        """
        At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
        """
        return pulumi.get(self, "target_dedicated_nodes")

    @property
    @pulumi.getter(name="targetLowPriorityNodes")
    def target_low_priority_nodes(self) -> Optional[int]:
        """
        At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
        """
        return pulumi.get(self, "target_low_priority_nodes")


@pulumi.output_type
class ImageReferenceResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str id: This property is mutually exclusive with other properties. The Shared Image Gallery image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
        :param str offer: For example, UbuntuServer or WindowsServer.
        :param str publisher: For example, Canonical or MicrosoftWindowsServer.
        :param str sku: For example, 18.04-LTS or 2019-Datacenter.
        :param str version: A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        This property is mutually exclusive with other properties. The Shared Image Gallery image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        For example, UbuntuServer or WindowsServer.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        For example, Canonical or MicrosoftWindowsServer.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        For example, 18.04-LTS or 2019-Datacenter.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class InboundNatPoolResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPortRangeEnd":
            suggest = "frontend_port_range_end"
        elif key == "frontendPortRangeStart":
            suggest = "frontend_port_range_start"
        elif key == "networkSecurityGroupRules":
            suggest = "network_security_group_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: int,
                 frontend_port_range_end: int,
                 frontend_port_range_start: int,
                 name: str,
                 protocol: str,
                 network_security_group_rules: Optional[Sequence['outputs.NetworkSecurityGroupRuleResponse']] = None):
        """
        :param int backend_port: This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
        :param int frontend_port_range_end: Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        :param int frontend_port_range_start: Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        :param str name: The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
        :param Sequence['NetworkSecurityGroupRuleResponse'] network_security_group_rules: The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range_end", frontend_port_range_end)
        pulumi.set(__self__, "frontend_port_range_start", frontend_port_range_start)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        if network_security_group_rules is not None:
            pulumi.set(__self__, "network_security_group_rules", network_security_group_rules)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> int:
        """
        This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="frontendPortRangeEnd")
    def frontend_port_range_end(self) -> int:
        """
        Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "frontend_port_range_end")

    @property
    @pulumi.getter(name="frontendPortRangeStart")
    def frontend_port_range_start(self) -> int:
        """
        Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "frontend_port_range_start")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="networkSecurityGroupRules")
    def network_security_group_rules(self) -> Optional[Sequence['outputs.NetworkSecurityGroupRuleResponse']]:
        """
        The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "network_security_group_rules")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    """
    KeyVault configuration when using an encryption KeySource of Microsoft.KeyVault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyIdentifier":
            suggest = "key_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_identifier: Optional[str] = None):
        """
        KeyVault configuration when using an encryption KeySource of Microsoft.KeyVault.
        :param str key_identifier: Full path to the versioned secret. Example https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. To be usable the following prerequisites must be met:
               
                The Batch Account has a System Assigned identity
                The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
                The KeyVault has soft-delete and purge protection enabled
        """
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[str]:
        """
        Full path to the versioned secret. Example https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. To be usable the following prerequisites must be met:

         The Batch Account has a System Assigned identity
         The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
         The KeyVault has soft-delete and purge protection enabled
        """
        return pulumi.get(self, "key_identifier")


@pulumi.output_type
class KeyVaultReferenceResponse(dict):
    """
    Identifies the Azure key vault associated with a Batch account.
    """
    def __init__(__self__, *,
                 id: str,
                 url: str):
        """
        Identifies the Azure key vault associated with a Batch account.
        :param str id: The resource ID of the Azure key vault associated with the Batch account.
        :param str url: The URL of the Azure key vault associated with the Batch account.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource ID of the Azure key vault associated with the Batch account.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL of the Azure key vault associated with the Batch account.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LinuxUserConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshPrivateKey":
            suggest = "ssh_private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxUserConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxUserConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxUserConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: Optional[int] = None,
                 ssh_private_key: Optional[str] = None,
                 uid: Optional[int] = None):
        """
        :param int gid: The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        :param str ssh_private_key: The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        :param int uid: The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        """
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if ssh_private_key is not None:
            pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def gid(self) -> Optional[int]:
        """
        The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> Optional[str]:
        """
        The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        """
        return pulumi.get(self, "ssh_private_key")

    @property
    @pulumi.getter
    def uid(self) -> Optional[int]:
        """
        The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class MetadataItemResponse(dict):
    """
    The Batch service does not assign any meaning to this metadata; it is solely for the use of user code.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        The Batch service does not assign any meaning to this metadata; it is solely for the use of user code.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class MountConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureBlobFileSystemConfiguration":
            suggest = "azure_blob_file_system_configuration"
        elif key == "azureFileShareConfiguration":
            suggest = "azure_file_share_configuration"
        elif key == "cifsMountConfiguration":
            suggest = "cifs_mount_configuration"
        elif key == "nfsMountConfiguration":
            suggest = "nfs_mount_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MountConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MountConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MountConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_blob_file_system_configuration: Optional['outputs.AzureBlobFileSystemConfigurationResponse'] = None,
                 azure_file_share_configuration: Optional['outputs.AzureFileShareConfigurationResponse'] = None,
                 cifs_mount_configuration: Optional['outputs.CIFSMountConfigurationResponse'] = None,
                 nfs_mount_configuration: Optional['outputs.NFSMountConfigurationResponse'] = None):
        """
        :param 'AzureBlobFileSystemConfigurationResponse' azure_blob_file_system_configuration: This property is mutually exclusive with all other properties.
        :param 'AzureFileShareConfigurationResponse' azure_file_share_configuration: This property is mutually exclusive with all other properties.
        :param 'CIFSMountConfigurationResponse' cifs_mount_configuration: This property is mutually exclusive with all other properties.
        :param 'NFSMountConfigurationResponse' nfs_mount_configuration: This property is mutually exclusive with all other properties.
        """
        if azure_blob_file_system_configuration is not None:
            pulumi.set(__self__, "azure_blob_file_system_configuration", azure_blob_file_system_configuration)
        if azure_file_share_configuration is not None:
            pulumi.set(__self__, "azure_file_share_configuration", azure_file_share_configuration)
        if cifs_mount_configuration is not None:
            pulumi.set(__self__, "cifs_mount_configuration", cifs_mount_configuration)
        if nfs_mount_configuration is not None:
            pulumi.set(__self__, "nfs_mount_configuration", nfs_mount_configuration)

    @property
    @pulumi.getter(name="azureBlobFileSystemConfiguration")
    def azure_blob_file_system_configuration(self) -> Optional['outputs.AzureBlobFileSystemConfigurationResponse']:
        """
        This property is mutually exclusive with all other properties.
        """
        return pulumi.get(self, "azure_blob_file_system_configuration")

    @property
    @pulumi.getter(name="azureFileShareConfiguration")
    def azure_file_share_configuration(self) -> Optional['outputs.AzureFileShareConfigurationResponse']:
        """
        This property is mutually exclusive with all other properties.
        """
        return pulumi.get(self, "azure_file_share_configuration")

    @property
    @pulumi.getter(name="cifsMountConfiguration")
    def cifs_mount_configuration(self) -> Optional['outputs.CIFSMountConfigurationResponse']:
        """
        This property is mutually exclusive with all other properties.
        """
        return pulumi.get(self, "cifs_mount_configuration")

    @property
    @pulumi.getter(name="nfsMountConfiguration")
    def nfs_mount_configuration(self) -> Optional['outputs.NFSMountConfigurationResponse']:
        """
        This property is mutually exclusive with all other properties.
        """
        return pulumi.get(self, "nfs_mount_configuration")


@pulumi.output_type
class NFSMountConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relativeMountPath":
            suggest = "relative_mount_path"
        elif key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NFSMountConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NFSMountConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NFSMountConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 relative_mount_path: str,
                 source: str,
                 mount_options: Optional[str] = None):
        """
        :param str relative_mount_path: All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :param str mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> str:
        """
        All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @property
    @pulumi.getter
    def source(self) -> str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[str]:
        """
        These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class NetworkConfigurationResponse(dict):
    """
    The network configuration for a pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointConfiguration":
            suggest = "endpoint_configuration"
        elif key == "publicIPAddressConfiguration":
            suggest = "public_ip_address_configuration"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_configuration: Optional['outputs.PoolEndpointConfigurationResponse'] = None,
                 public_ip_address_configuration: Optional['outputs.PublicIPAddressConfigurationResponse'] = None,
                 subnet_id: Optional[str] = None):
        """
        The network configuration for a pool.
        :param 'PoolEndpointConfigurationResponse' endpoint_configuration: Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
        :param 'PublicIPAddressConfigurationResponse' public_ip_address_configuration: This property is only supported on Pools with the virtualMachineConfiguration property.
        :param str subnet_id: The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
        """
        if endpoint_configuration is not None:
            pulumi.set(__self__, "endpoint_configuration", endpoint_configuration)
        if public_ip_address_configuration is not None:
            pulumi.set(__self__, "public_ip_address_configuration", public_ip_address_configuration)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="endpointConfiguration")
    def endpoint_configuration(self) -> Optional['outputs.PoolEndpointConfigurationResponse']:
        """
        Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
        """
        return pulumi.get(self, "endpoint_configuration")

    @property
    @pulumi.getter(name="publicIPAddressConfiguration")
    def public_ip_address_configuration(self) -> Optional['outputs.PublicIPAddressConfigurationResponse']:
        """
        This property is only supported on Pools with the virtualMachineConfiguration property.
        """
        return pulumi.get(self, "public_ip_address_configuration")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class NetworkSecurityGroupRuleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceAddressPrefix":
            suggest = "source_address_prefix"
        elif key == "sourcePortRanges":
            suggest = "source_port_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSecurityGroupRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSecurityGroupRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSecurityGroupRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 priority: int,
                 source_address_prefix: str,
                 source_port_ranges: Optional[Sequence[str]] = None):
        """
        :param int priority: Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
        :param str source_address_prefix: Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
        :param Sequence[str] source_port_ranges: Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @property
    @pulumi.getter
    def access(self) -> str:
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> str:
        """
        Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "source_address_prefix")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[Sequence[str]]:
        """
        Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
        """
        return pulumi.get(self, "source_port_ranges")


@pulumi.output_type
class NodePlacementConfigurationResponse(dict):
    """
    Allocation configuration used by Batch Service to provision the nodes.
    """
    def __init__(__self__, *,
                 policy: Optional[str] = None):
        """
        Allocation configuration used by Batch Service to provision the nodes.
        :param str policy: Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class PoolEndpointConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundNatPools":
            suggest = "inbound_nat_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolEndpointConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolEndpointConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolEndpointConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inbound_nat_pools: Sequence['outputs.InboundNatPoolResponse']):
        """
        :param Sequence['InboundNatPoolResponse'] inbound_nat_pools: The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
        """
        pulumi.set(__self__, "inbound_nat_pools", inbound_nat_pools)

    @property
    @pulumi.getter(name="inboundNatPools")
    def inbound_nat_pools(self) -> Sequence['outputs.InboundNatPoolResponse']:
        """
        The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
        """
        return pulumi.get(self, "inbound_nat_pools")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    Contains information about a private link resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        Contains information about a private link resource.
        :param str etag: The ETag of the resource, used for concurrency statements.
        :param str id: The ID of the resource.
        :param str name: The name of the resource.
        :param str type: The type of the resource.
        :param 'PrivateEndpointResponse' private_endpoint: The private endpoint of the private endpoint connection.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: The private link service connection state of the private endpoint connection
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The ETag of the resource, used for concurrency statements.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The private endpoint of the private endpoint connection.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        The private link service connection state of the private endpoint connection
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The private endpoint of the private endpoint connection.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The private endpoint of the private endpoint connection.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    The private link service connection state of the private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionRequired":
            suggest = "action_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_required: str,
                 status: str,
                 description: Optional[str] = None):
        """
        The private link service connection state of the private endpoint connection
        """
        pulumi.set(__self__, "action_required", action_required)
        pulumi.set(__self__, "status", status)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="actionRequired")
    def action_required(self) -> str:
        return pulumi.get(self, "action_required")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class PublicIPAddressConfigurationResponse(dict):
    """
    The public IP Address configuration of the networking configuration of a Pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddressIds":
            suggest = "ip_address_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIPAddressConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIPAddressConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIPAddressConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address_ids: Optional[Sequence[str]] = None,
                 provision: Optional[str] = None):
        """
        The public IP Address configuration of the networking configuration of a Pool.
        :param Sequence[str] ip_address_ids: The number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100 low-priority nodes can be allocated for each public IP. For example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
        :param str provision: The default value is BatchManaged
        """
        if ip_address_ids is not None:
            pulumi.set(__self__, "ip_address_ids", ip_address_ids)
        if provision is not None:
            pulumi.set(__self__, "provision", provision)

    @property
    @pulumi.getter(name="ipAddressIds")
    def ip_address_ids(self) -> Optional[Sequence[str]]:
        """
        The number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100 low-priority nodes can be allocated for each public IP. For example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
        """
        return pulumi.get(self, "ip_address_ids")

    @property
    @pulumi.getter
    def provision(self) -> Optional[str]:
        """
        The default value is BatchManaged
        """
        return pulumi.get(self, "provision")


@pulumi.output_type
class ResizeErrorResponse(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.ResizeErrorResponse']] = None):
        """
        :param str code: An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        :param str message: A message describing the error, intended to be suitable for display in a user interface.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message describing the error, intended to be suitable for display in a user interface.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ResizeErrorResponse']]:
        return pulumi.get(self, "details")


@pulumi.output_type
class ResizeOperationStatusResponse(dict):
    """
    Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeDeallocationOption":
            suggest = "node_deallocation_option"
        elif key == "resizeTimeout":
            suggest = "resize_timeout"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "targetDedicatedNodes":
            suggest = "target_dedicated_nodes"
        elif key == "targetLowPriorityNodes":
            suggest = "target_low_priority_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResizeOperationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResizeOperationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResizeOperationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Optional[Sequence['outputs.ResizeErrorResponse']] = None,
                 node_deallocation_option: Optional[str] = None,
                 resize_timeout: Optional[str] = None,
                 start_time: Optional[str] = None,
                 target_dedicated_nodes: Optional[int] = None,
                 target_low_priority_nodes: Optional[int] = None):
        """
        Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady).
        :param Sequence['ResizeErrorResponse'] errors: This property is set only if an error occurred during the last pool resize, and only when the pool allocationState is Steady.
        :param str node_deallocation_option: The default value is requeue.
        :param str resize_timeout: The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        """
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if node_deallocation_option is not None:
            pulumi.set(__self__, "node_deallocation_option", node_deallocation_option)
        if resize_timeout is not None:
            pulumi.set(__self__, "resize_timeout", resize_timeout)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if target_dedicated_nodes is not None:
            pulumi.set(__self__, "target_dedicated_nodes", target_dedicated_nodes)
        if target_low_priority_nodes is not None:
            pulumi.set(__self__, "target_low_priority_nodes", target_low_priority_nodes)

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.ResizeErrorResponse']]:
        """
        This property is set only if an error occurred during the last pool resize, and only when the pool allocationState is Steady.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="nodeDeallocationOption")
    def node_deallocation_option(self) -> Optional[str]:
        """
        The default value is requeue.
        """
        return pulumi.get(self, "node_deallocation_option")

    @property
    @pulumi.getter(name="resizeTimeout")
    def resize_timeout(self) -> Optional[str]:
        """
        The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        """
        return pulumi.get(self, "resize_timeout")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="targetDedicatedNodes")
    def target_dedicated_nodes(self) -> Optional[int]:
        return pulumi.get(self, "target_dedicated_nodes")

    @property
    @pulumi.getter(name="targetLowPriorityNodes")
    def target_low_priority_nodes(self) -> Optional[int]:
        return pulumi.get(self, "target_low_priority_nodes")


@pulumi.output_type
class ResourceFileResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoStorageContainerName":
            suggest = "auto_storage_container_name"
        elif key == "blobPrefix":
            suggest = "blob_prefix"
        elif key == "fileMode":
            suggest = "file_mode"
        elif key == "filePath":
            suggest = "file_path"
        elif key == "httpUrl":
            suggest = "http_url"
        elif key == "storageContainerUrl":
            suggest = "storage_container_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_storage_container_name: Optional[str] = None,
                 blob_prefix: Optional[str] = None,
                 file_mode: Optional[str] = None,
                 file_path: Optional[str] = None,
                 http_url: Optional[str] = None,
                 storage_container_url: Optional[str] = None):
        """
        :param str auto_storage_container_name: The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
        :param str blob_prefix: The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        :param str file_mode: This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        :param str file_path: If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        :param str http_url: The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        :param str storage_container_url: The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        if auto_storage_container_name is not None:
            pulumi.set(__self__, "auto_storage_container_name", auto_storage_container_name)
        if blob_prefix is not None:
            pulumi.set(__self__, "blob_prefix", blob_prefix)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if http_url is not None:
            pulumi.set(__self__, "http_url", http_url)
        if storage_container_url is not None:
            pulumi.set(__self__, "storage_container_url", storage_container_url)

    @property
    @pulumi.getter(name="autoStorageContainerName")
    def auto_storage_container_name(self) -> Optional[str]:
        """
        The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
        """
        return pulumi.get(self, "auto_storage_container_name")

    @property
    @pulumi.getter(name="blobPrefix")
    def blob_prefix(self) -> Optional[str]:
        """
        The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        """
        return pulumi.get(self, "blob_prefix")

    @property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[str]:
        """
        This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        """
        return pulumi.get(self, "file_mode")

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        """
        If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> Optional[str]:
        """
        The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "http_url")

    @property
    @pulumi.getter(name="storageContainerUrl")
    def storage_container_url(self) -> Optional[str]:
        """
        The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "storage_container_url")


@pulumi.output_type
class ScaleSettingsResponse(dict):
    """
    Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScale":
            suggest = "auto_scale"
        elif key == "fixedScale":
            suggest = "fixed_scale"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scale: Optional['outputs.AutoScaleSettingsResponse'] = None,
                 fixed_scale: Optional['outputs.FixedScaleSettingsResponse'] = None):
        """
        Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
        :param 'AutoScaleSettingsResponse' auto_scale: This property and fixedScale are mutually exclusive and one of the properties must be specified.
        :param 'FixedScaleSettingsResponse' fixed_scale: This property and autoScale are mutually exclusive and one of the properties must be specified.
        """
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if fixed_scale is not None:
            pulumi.set(__self__, "fixed_scale", fixed_scale)

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional['outputs.AutoScaleSettingsResponse']:
        """
        This property and fixedScale are mutually exclusive and one of the properties must be specified.
        """
        return pulumi.get(self, "auto_scale")

    @property
    @pulumi.getter(name="fixedScale")
    def fixed_scale(self) -> Optional['outputs.FixedScaleSettingsResponse']:
        """
        This property and autoScale are mutually exclusive and one of the properties must be specified.
        """
        return pulumi.get(self, "fixed_scale")


@pulumi.output_type
class StartTaskResponse(dict):
    """
    In some cases the start task may be re-run even though the node was not rebooted. Due to this, start tasks should be idempotent and exit gracefully if the setup they're performing has already been done. Special care should be taken to avoid start tasks which create breakaway process or install/launch services from the start task working directory, as this will block Batch from being able to re-run the start task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandLine":
            suggest = "command_line"
        elif key == "containerSettings":
            suggest = "container_settings"
        elif key == "environmentSettings":
            suggest = "environment_settings"
        elif key == "maxTaskRetryCount":
            suggest = "max_task_retry_count"
        elif key == "resourceFiles":
            suggest = "resource_files"
        elif key == "userIdentity":
            suggest = "user_identity"
        elif key == "waitForSuccess":
            suggest = "wait_for_success"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StartTaskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StartTaskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StartTaskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command_line: Optional[str] = None,
                 container_settings: Optional['outputs.TaskContainerSettingsResponse'] = None,
                 environment_settings: Optional[Sequence['outputs.EnvironmentSettingResponse']] = None,
                 max_task_retry_count: Optional[int] = None,
                 resource_files: Optional[Sequence['outputs.ResourceFileResponse']] = None,
                 user_identity: Optional['outputs.UserIdentityResponse'] = None,
                 wait_for_success: Optional[bool] = None):
        """
        In some cases the start task may be re-run even though the node was not rebooted. Due to this, start tasks should be idempotent and exit gracefully if the setup they're performing has already been done. Special care should be taken to avoid start tasks which create breakaway process or install/launch services from the start task working directory, as this will block Batch from being able to re-run the start task.
        :param str command_line: The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
        :param 'TaskContainerSettingsResponse' container_settings: When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        :param int max_task_retry_count: The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
        :param 'UserIdentityResponse' user_identity: If omitted, the task runs as a non-administrative user unique to the task.
        :param bool wait_for_success: If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is true.
        """
        if command_line is not None:
            pulumi.set(__self__, "command_line", command_line)
        if container_settings is not None:
            pulumi.set(__self__, "container_settings", container_settings)
        if environment_settings is not None:
            pulumi.set(__self__, "environment_settings", environment_settings)
        if max_task_retry_count is not None:
            pulumi.set(__self__, "max_task_retry_count", max_task_retry_count)
        if resource_files is not None:
            pulumi.set(__self__, "resource_files", resource_files)
        if user_identity is not None:
            pulumi.set(__self__, "user_identity", user_identity)
        if wait_for_success is not None:
            pulumi.set(__self__, "wait_for_success", wait_for_success)

    @property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> Optional[str]:
        """
        The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
        """
        return pulumi.get(self, "command_line")

    @property
    @pulumi.getter(name="containerSettings")
    def container_settings(self) -> Optional['outputs.TaskContainerSettingsResponse']:
        """
        When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        """
        return pulumi.get(self, "container_settings")

    @property
    @pulumi.getter(name="environmentSettings")
    def environment_settings(self) -> Optional[Sequence['outputs.EnvironmentSettingResponse']]:
        return pulumi.get(self, "environment_settings")

    @property
    @pulumi.getter(name="maxTaskRetryCount")
    def max_task_retry_count(self) -> Optional[int]:
        """
        The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
        """
        return pulumi.get(self, "max_task_retry_count")

    @property
    @pulumi.getter(name="resourceFiles")
    def resource_files(self) -> Optional[Sequence['outputs.ResourceFileResponse']]:
        return pulumi.get(self, "resource_files")

    @property
    @pulumi.getter(name="userIdentity")
    def user_identity(self) -> Optional['outputs.UserIdentityResponse']:
        """
        If omitted, the task runs as a non-administrative user unique to the task.
        """
        return pulumi.get(self, "user_identity")

    @property
    @pulumi.getter(name="waitForSuccess")
    def wait_for_success(self) -> Optional[bool]:
        """
        If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is true.
        """
        return pulumi.get(self, "wait_for_success")


@pulumi.output_type
class TaskContainerSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageName":
            suggest = "image_name"
        elif key == "containerRunOptions":
            suggest = "container_run_options"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskContainerSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskContainerSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskContainerSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_name: str,
                 container_run_options: Optional[str] = None,
                 registry: Optional['outputs.ContainerRegistryResponse'] = None,
                 working_directory: Optional[str] = None):
        """
        :param str image_name: This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        :param str container_run_options: These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        :param 'ContainerRegistryResponse' registry: This setting can be omitted if was already provided at pool creation.
        """
        pulumi.set(__self__, "image_name", image_name)
        if container_run_options is not None:
            pulumi.set(__self__, "container_run_options", container_run_options)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="containerRunOptions")
    def container_run_options(self) -> Optional[str]:
        """
        These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        """
        return pulumi.get(self, "container_run_options")

    @property
    @pulumi.getter
    def registry(self) -> Optional['outputs.ContainerRegistryResponse']:
        """
        This setting can be omitted if was already provided at pool creation.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[str]:
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class TaskSchedulingPolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeFillType":
            suggest = "node_fill_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSchedulingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSchedulingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSchedulingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_fill_type: str):
        pulumi.set(__self__, "node_fill_type", node_fill_type)

    @property
    @pulumi.getter(name="nodeFillType")
    def node_fill_type(self) -> str:
        return pulumi.get(self, "node_fill_type")


@pulumi.output_type
class UserAccountResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elevationLevel":
            suggest = "elevation_level"
        elif key == "linuxUserConfiguration":
            suggest = "linux_user_configuration"
        elif key == "windowsUserConfiguration":
            suggest = "windows_user_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAccountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAccountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAccountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 password: str,
                 elevation_level: Optional[str] = None,
                 linux_user_configuration: Optional['outputs.LinuxUserConfigurationResponse'] = None,
                 windows_user_configuration: Optional['outputs.WindowsUserConfigurationResponse'] = None):
        """
        :param str elevation_level: nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        :param 'LinuxUserConfigurationResponse' linux_user_configuration: This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        :param 'WindowsUserConfigurationResponse' windows_user_configuration: This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        if elevation_level is not None:
            pulumi.set(__self__, "elevation_level", elevation_level)
        if linux_user_configuration is not None:
            pulumi.set(__self__, "linux_user_configuration", linux_user_configuration)
        if windows_user_configuration is not None:
            pulumi.set(__self__, "windows_user_configuration", windows_user_configuration)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> Optional[str]:
        """
        nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @property
    @pulumi.getter(name="linuxUserConfiguration")
    def linux_user_configuration(self) -> Optional['outputs.LinuxUserConfigurationResponse']:
        """
        This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        """
        return pulumi.get(self, "linux_user_configuration")

    @property
    @pulumi.getter(name="windowsUserConfiguration")
    def windows_user_configuration(self) -> Optional['outputs.WindowsUserConfigurationResponse']:
        """
        This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        return pulumi.get(self, "windows_user_configuration")


@pulumi.output_type
class UserIdentityResponse(dict):
    """
    Specify either the userName or autoUser property, but not both.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoUser":
            suggest = "auto_user"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_user: Optional['outputs.AutoUserSpecificationResponse'] = None,
                 user_name: Optional[str] = None):
        """
        Specify either the userName or autoUser property, but not both.
        :param 'AutoUserSpecificationResponse' auto_user: The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        :param str user_name: The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        """
        if auto_user is not None:
            pulumi.set(__self__, "auto_user", auto_user)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="autoUser")
    def auto_user(self) -> Optional['outputs.AutoUserSpecificationResponse']:
        """
        The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        """
        return pulumi.get(self, "auto_user")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class VMExtensionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "provisionAfterExtensions":
            suggest = "provision_after_extensions"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 publisher: str,
                 type: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 protected_settings: Optional[Any] = None,
                 provision_after_extensions: Optional[Sequence[str]] = None,
                 settings: Optional[Any] = None,
                 type_handler_version: Optional[str] = None):
        """
        :param bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all. 
        :param Sequence[str] provision_after_extensions: Collection of extension names after which this extension needs to be provisioned.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all. 
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[Sequence[str]]:
        """
        Collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageReference":
            suggest = "image_reference"
        elif key == "nodeAgentSkuId":
            suggest = "node_agent_sku_id"
        elif key == "containerConfiguration":
            suggest = "container_configuration"
        elif key == "dataDisks":
            suggest = "data_disks"
        elif key == "diskEncryptionConfiguration":
            suggest = "disk_encryption_configuration"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "nodePlacementConfiguration":
            suggest = "node_placement_configuration"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_reference: 'outputs.ImageReferenceResponse',
                 node_agent_sku_id: str,
                 container_configuration: Optional['outputs.ContainerConfigurationResponse'] = None,
                 data_disks: Optional[Sequence['outputs.DataDiskResponse']] = None,
                 disk_encryption_configuration: Optional['outputs.DiskEncryptionConfigurationResponse'] = None,
                 extensions: Optional[Sequence['outputs.VMExtensionResponse']] = None,
                 license_type: Optional[str] = None,
                 node_placement_configuration: Optional['outputs.NodePlacementConfigurationResponse'] = None,
                 windows_configuration: Optional['outputs.WindowsConfigurationResponse'] = None):
        """
        :param str node_agent_sku_id: The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
        :param 'ContainerConfigurationResponse' container_configuration: If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
        :param Sequence['DataDiskResponse'] data_disks: This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
        :param 'DiskEncryptionConfigurationResponse' disk_encryption_configuration: If specified, encryption is performed on each node in the pool during node provisioning.
        :param Sequence['VMExtensionResponse'] extensions: If specified, the extensions mentioned in this configuration will be installed on each node.
        :param str license_type: This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
               
                Windows_Server - The on-premises license is for Windows Server.
                Windows_Client - The on-premises license is for Windows Client.
        :param 'NodePlacementConfigurationResponse' node_placement_configuration: This configuration will specify rules on how nodes in the pool will be physically allocated.
        :param 'WindowsConfigurationResponse' windows_configuration: This property must not be specified if the imageReference specifies a Linux OS image.
        """
        pulumi.set(__self__, "image_reference", image_reference)
        pulumi.set(__self__, "node_agent_sku_id", node_agent_sku_id)
        if container_configuration is not None:
            pulumi.set(__self__, "container_configuration", container_configuration)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if disk_encryption_configuration is not None:
            pulumi.set(__self__, "disk_encryption_configuration", disk_encryption_configuration)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if node_placement_configuration is not None:
            pulumi.set(__self__, "node_placement_configuration", node_placement_configuration)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> 'outputs.ImageReferenceResponse':
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="nodeAgentSkuId")
    def node_agent_sku_id(self) -> str:
        """
        The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
        """
        return pulumi.get(self, "node_agent_sku_id")

    @property
    @pulumi.getter(name="containerConfiguration")
    def container_configuration(self) -> Optional['outputs.ContainerConfigurationResponse']:
        """
        If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
        """
        return pulumi.get(self, "container_configuration")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.DataDiskResponse']]:
        """
        This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="diskEncryptionConfiguration")
    def disk_encryption_configuration(self) -> Optional['outputs.DiskEncryptionConfigurationResponse']:
        """
        If specified, encryption is performed on each node in the pool during node provisioning.
        """
        return pulumi.get(self, "disk_encryption_configuration")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.VMExtensionResponse']]:
        """
        If specified, the extensions mentioned in this configuration will be installed on each node.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:

         Windows_Server - The on-premises license is for Windows Server.
         Windows_Client - The on-premises license is for Windows Client.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="nodePlacementConfiguration")
    def node_placement_configuration(self) -> Optional['outputs.NodePlacementConfigurationResponse']:
        """
        This configuration will specify rules on how nodes in the pool will be physically allocated.
        """
        return pulumi.get(self, "node_placement_configuration")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.WindowsConfigurationResponse']:
        """
        This property must not be specified if the imageReference specifies a Linux OS image.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class VirtualMachineFamilyCoreQuotaResponse(dict):
    """
    A VM Family and its associated core quota for the Batch account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreQuota":
            suggest = "core_quota"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineFamilyCoreQuotaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineFamilyCoreQuotaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineFamilyCoreQuotaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_quota: int,
                 name: str):
        """
        A VM Family and its associated core quota for the Batch account.
        :param int core_quota: The core quota for the VM family for the Batch account.
        :param str name: The Virtual Machine family name.
        """
        pulumi.set(__self__, "core_quota", core_quota)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="coreQuota")
    def core_quota(self) -> int:
        """
        The core quota for the VM family for the Batch account.
        """
        return pulumi.get(self, "core_quota")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Virtual Machine family name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WindowsConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_automatic_updates: Optional[bool] = None):
        """
        :param bool enable_automatic_updates: If omitted, the default value is true.
        """
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[bool]:
        """
        If omitted, the default value is true.
        """
        return pulumi.get(self, "enable_automatic_updates")


@pulumi.output_type
class WindowsUserConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginMode":
            suggest = "login_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsUserConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsUserConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsUserConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_mode: Optional[str] = None):
        """
        :param str login_mode: Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
        """
        if login_mode is not None:
            pulumi.set(__self__, "login_mode", login_mode)

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> Optional[str]:
        """
        Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
        """
        return pulumi.get(self, "login_mode")


