# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AdditionalWorkspacesPropertiesArgs',
    'AllowlistCustomAlertRuleArgs',
    'AssessmentStatusArgs',
    'AutomationActionEventHubArgs',
    'AutomationActionLogicAppArgs',
    'AutomationActionWorkspaceArgs',
    'AutomationRuleSetArgs',
    'AutomationScopeArgs',
    'AutomationSourceArgs',
    'AutomationTriggeringRuleArgs',
    'AwAssumeRoleAuthenticationDetailsPropertiesArgs',
    'AwsCredsAuthenticationDetailsPropertiesArgs',
    'AzureResourceDetailsArgs',
    'DenylistCustomAlertRuleArgs',
    'GcpCredentialsDetailsPropertiesArgs',
    'HybridComputeSettingsPropertiesArgs',
    'JitNetworkAccessPolicyVirtualMachineArgs',
    'JitNetworkAccessPortRuleArgs',
    'JitNetworkAccessRequestPortArgs',
    'JitNetworkAccessRequestVirtualMachineArgs',
    'JitNetworkAccessRequestArgs',
    'OnPremiseResourceDetailsArgs',
    'OnPremiseSqlResourceDetailsArgs',
    'PathRecommendationArgs',
    'ProtectionModeArgs',
    'ProxyServerPropertiesArgs',
    'PublisherInfoArgs',
    'RecommendationConfigurationPropertiesArgs',
    'ScopeElementArgs',
    'SecurityAssessmentMetadataPartnerDataArgs',
    'SecurityAssessmentMetadataPropertiesArgs',
    'SecurityAssessmentPartnerDataArgs',
    'SecurityContactPropertiesAlertNotificationsArgs',
    'SecurityContactPropertiesNotificationsByRoleArgs',
    'ServicePrincipalPropertiesArgs',
    'SuppressionAlertsScopeArgs',
    'ThresholdCustomAlertRuleArgs',
    'TimeWindowCustomAlertRuleArgs',
    'UserDefinedResourcesPropertiesArgs',
    'UserRecommendationArgs',
    'VmRecommendationArgs',
]

@pulumi.input_type
class AdditionalWorkspacesPropertiesArgs:
    def __init__(__self__, *,
                 data_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AdditionalWorkspaceDataType']]]]] = None,
                 type: Optional[pulumi.Input[Union[str, 'AdditionalWorkspaceType']]] = None,
                 workspace: Optional[pulumi.Input[str]] = None):
        """
        Properties of the additional workspaces.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'AdditionalWorkspaceDataType']]]] data_types: List of data types sent to workspace
        :param pulumi.Input[Union[str, 'AdditionalWorkspaceType']] type: Workspace type.
        :param pulumi.Input[str] workspace: Workspace resource id
        """
        if data_types is not None:
            pulumi.set(__self__, "data_types", data_types)
        if type is None:
            type = 'Sentinel'
        if type is not None:
            pulumi.set(__self__, "type", type)
        if workspace is not None:
            pulumi.set(__self__, "workspace", workspace)

    @property
    @pulumi.getter(name="dataTypes")
    def data_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AdditionalWorkspaceDataType']]]]]:
        """
        List of data types sent to workspace
        """
        return pulumi.get(self, "data_types")

    @data_types.setter
    def data_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AdditionalWorkspaceDataType']]]]]):
        pulumi.set(self, "data_types", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'AdditionalWorkspaceType']]]:
        """
        Workspace type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'AdditionalWorkspaceType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def workspace(self) -> Optional[pulumi.Input[str]]:
        """
        Workspace resource id
        """
        return pulumi.get(self, "workspace")

    @workspace.setter
    def workspace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace", value)


@pulumi.input_type
class AllowlistCustomAlertRuleArgs:
    def __init__(__self__, *,
                 allowlist_values: pulumi.Input[Sequence[pulumi.Input[str]]],
                 is_enabled: pulumi.Input[bool],
                 rule_type: pulumi.Input[str]):
        """
        A custom alert rule that checks if a value (depends on the custom alert type) is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowlist_values: The values to allow. The format of the values depends on the rule type.
        :param pulumi.Input[bool] is_enabled: Status of the custom alert.
        :param pulumi.Input[str] rule_type: The type of the custom alert rule.
               Expected value is 'AllowlistCustomAlertRule'.
        """
        pulumi.set(__self__, "allowlist_values", allowlist_values)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "rule_type", 'AllowlistCustomAlertRule')

    @property
    @pulumi.getter(name="allowlistValues")
    def allowlist_values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The values to allow. The format of the values depends on the rule type.
        """
        return pulumi.get(self, "allowlist_values")

    @allowlist_values.setter
    def allowlist_values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowlist_values", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Status of the custom alert.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        The type of the custom alert rule.
        Expected value is 'AllowlistCustomAlertRule'.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)


@pulumi.input_type
class AssessmentStatusArgs:
    def __init__(__self__, *,
                 code: pulumi.Input[Union[str, 'AssessmentStatusCode']],
                 cause: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        The result of the assessment
        :param pulumi.Input[Union[str, 'AssessmentStatusCode']] code: Programmatic code for the status of the assessment
        :param pulumi.Input[str] cause: Programmatic code for the cause of the assessment status
        :param pulumi.Input[str] description: Human readable description of the assessment status
        """
        pulumi.set(__self__, "code", code)
        if cause is not None:
            pulumi.set(__self__, "cause", cause)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def code(self) -> pulumi.Input[Union[str, 'AssessmentStatusCode']]:
        """
        Programmatic code for the status of the assessment
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input[Union[str, 'AssessmentStatusCode']]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def cause(self) -> Optional[pulumi.Input[str]]:
        """
        Programmatic code for the cause of the assessment status
        """
        return pulumi.get(self, "cause")

    @cause.setter
    def cause(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cause", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description of the assessment status
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AutomationActionEventHubArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[str],
                 connection_string: Optional[pulumi.Input[str]] = None,
                 event_hub_resource_id: Optional[pulumi.Input[str]] = None):
        """
        The target Event Hub to which event data will be exported. To learn more about Security Center continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
        :param pulumi.Input[str] action_type: The type of the action that will be triggered by the Automation
               Expected value is 'EventHub'.
        :param pulumi.Input[str] connection_string: The target Event Hub connection string (it will not be included in any response).
        :param pulumi.Input[str] event_hub_resource_id: The target Event Hub Azure Resource ID.
        """
        pulumi.set(__self__, "action_type", 'EventHub')
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if event_hub_resource_id is not None:
            pulumi.set(__self__, "event_hub_resource_id", event_hub_resource_id)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        The type of the action that will be triggered by the Automation
        Expected value is 'EventHub'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        The target Event Hub connection string (it will not be included in any response).
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="eventHubResourceId")
    def event_hub_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The target Event Hub Azure Resource ID.
        """
        return pulumi.get(self, "event_hub_resource_id")

    @event_hub_resource_id.setter
    def event_hub_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_hub_resource_id", value)


@pulumi.input_type
class AutomationActionLogicAppArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[str],
                 logic_app_resource_id: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        The logic app action that should be triggered. To learn more about Security Center's Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore
        :param pulumi.Input[str] action_type: The type of the action that will be triggered by the Automation
               Expected value is 'LogicApp'.
        :param pulumi.Input[str] logic_app_resource_id: The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
        :param pulumi.Input[str] uri: The Logic App trigger URI endpoint (it will not be included in any response).
        """
        pulumi.set(__self__, "action_type", 'LogicApp')
        if logic_app_resource_id is not None:
            pulumi.set(__self__, "logic_app_resource_id", logic_app_resource_id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        The type of the action that will be triggered by the Automation
        Expected value is 'LogicApp'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="logicAppResourceId")
    def logic_app_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
        """
        return pulumi.get(self, "logic_app_resource_id")

    @logic_app_resource_id.setter
    def logic_app_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logic_app_resource_id", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Logic App trigger URI endpoint (it will not be included in any response).
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class AutomationActionWorkspaceArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[str],
                 workspace_resource_id: Optional[pulumi.Input[str]] = None):
        """
        The Log Analytics Workspace to which event data will be exported. Security alerts data will reside in the 'SecurityAlert' table and the assessments data will reside in the 'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order to view the data in the workspace, the Security Center Log Analytics free/standard solution needs to be enabled on that workspace. To learn more about Security Center continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
        :param pulumi.Input[str] action_type: The type of the action that will be triggered by the Automation
               Expected value is 'Workspace'.
        :param pulumi.Input[str] workspace_resource_id: The fully qualified Log Analytics Workspace Azure Resource ID.
        """
        pulumi.set(__self__, "action_type", 'Workspace')
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        The type of the action that will be triggered by the Automation
        Expected value is 'Workspace'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified Log Analytics Workspace Azure Resource ID.
        """
        return pulumi.get(self, "workspace_resource_id")

    @workspace_resource_id.setter
    def workspace_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_resource_id", value)


@pulumi.input_type
class AutomationRuleSetArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationTriggeringRuleArgs']]]] = None):
        """
        A rule set which evaluates all its rules upon an event interception. Only when all the included rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutomationTriggeringRuleArgs']]]]:
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationTriggeringRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class AutomationScopeArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 scope_path: Optional[pulumi.Input[str]] = None):
        """
        A single automation scope.
        :param pulumi.Input[str] description: The resources scope description.
        :param pulumi.Input[str] scope_path: The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if scope_path is not None:
            pulumi.set(__self__, "scope_path", scope_path)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The resources scope description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="scopePath")
    def scope_path(self) -> Optional[pulumi.Input[str]]:
        """
        The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
        """
        return pulumi.get(self, "scope_path")

    @scope_path.setter
    def scope_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope_path", value)


@pulumi.input_type
class AutomationSourceArgs:
    def __init__(__self__, *,
                 event_source: Optional[pulumi.Input[Union[str, 'EventSource']]] = None,
                 rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationRuleSetArgs']]]] = None):
        """
        The source event types which evaluate the security automation set of rules. For example - security alerts and security assessments. To learn more about the supported security events data models schemas - please visit https://aka.ms/ASCAutomationSchemas.
        :param pulumi.Input[Union[str, 'EventSource']] event_source: A valid event source type.
        :param pulumi.Input[Sequence[pulumi.Input['AutomationRuleSetArgs']]] rule_sets: A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
        """
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if rule_sets is not None:
            pulumi.set(__self__, "rule_sets", rule_sets)

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional[pulumi.Input[Union[str, 'EventSource']]]:
        """
        A valid event source type.
        """
        return pulumi.get(self, "event_source")

    @event_source.setter
    def event_source(self, value: Optional[pulumi.Input[Union[str, 'EventSource']]]):
        pulumi.set(self, "event_source", value)

    @property
    @pulumi.getter(name="ruleSets")
    def rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutomationRuleSetArgs']]]]:
        """
        A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
        """
        return pulumi.get(self, "rule_sets")

    @rule_sets.setter
    def rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationRuleSetArgs']]]]):
        pulumi.set(self, "rule_sets", value)


@pulumi.input_type
class AutomationTriggeringRuleArgs:
    def __init__(__self__, *,
                 expected_value: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[Union[str, 'Operator']]] = None,
                 property_j_path: Optional[pulumi.Input[str]] = None,
                 property_type: Optional[pulumi.Input[Union[str, 'PropertyType']]] = None):
        """
        A rule which is evaluated upon event interception. The rule is configured by comparing a specific value from the event model to an expected value. This comparison is done by using one of the supported operators set.
        :param pulumi.Input[str] expected_value: The expected value.
        :param pulumi.Input[Union[str, 'Operator']] operator: A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
        :param pulumi.Input[str] property_j_path: The JPath of the entity model property that should be checked.
        :param pulumi.Input[Union[str, 'PropertyType']] property_type: The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
        """
        if expected_value is not None:
            pulumi.set(__self__, "expected_value", expected_value)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if property_j_path is not None:
            pulumi.set(__self__, "property_j_path", property_j_path)
        if property_type is not None:
            pulumi.set(__self__, "property_type", property_type)

    @property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> Optional[pulumi.Input[str]]:
        """
        The expected value.
        """
        return pulumi.get(self, "expected_value")

    @expected_value.setter
    def expected_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_value", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[Union[str, 'Operator']]]:
        """
        A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[Union[str, 'Operator']]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="propertyJPath")
    def property_j_path(self) -> Optional[pulumi.Input[str]]:
        """
        The JPath of the entity model property that should be checked.
        """
        return pulumi.get(self, "property_j_path")

    @property_j_path.setter
    def property_j_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_j_path", value)

    @property
    @pulumi.getter(name="propertyType")
    def property_type(self) -> Optional[pulumi.Input[Union[str, 'PropertyType']]]:
        """
        The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
        """
        return pulumi.get(self, "property_type")

    @property_type.setter
    def property_type(self, value: Optional[pulumi.Input[Union[str, 'PropertyType']]]):
        pulumi.set(self, "property_type", value)


@pulumi.input_type
class AwAssumeRoleAuthenticationDetailsPropertiesArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[str],
                 aws_assume_role_arn: pulumi.Input[str],
                 aws_external_id: pulumi.Input[str]):
        """
        AWS cloud account connector based assume role, the role enables delegating access to your AWS resources. The role is composed of role Amazon Resource Name (ARN) and external ID. For more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating a Role to Delegate Permissions to an IAM User (write only)</a>
        :param pulumi.Input[str] authentication_type: Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
               Expected value is 'awsAssumeRole'.
        :param pulumi.Input[str] aws_assume_role_arn: Assumed role ID is an identifier that you can use to create temporary security credentials.
        :param pulumi.Input[str] aws_external_id: A unique identifier that is required when you assume a role in another account.
        """
        pulumi.set(__self__, "authentication_type", 'awsAssumeRole')
        pulumi.set(__self__, "aws_assume_role_arn", aws_assume_role_arn)
        pulumi.set(__self__, "aws_external_id", aws_external_id)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[str]:
        """
        Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
        Expected value is 'awsAssumeRole'.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="awsAssumeRoleArn")
    def aws_assume_role_arn(self) -> pulumi.Input[str]:
        """
        Assumed role ID is an identifier that you can use to create temporary security credentials.
        """
        return pulumi.get(self, "aws_assume_role_arn")

    @aws_assume_role_arn.setter
    def aws_assume_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "aws_assume_role_arn", value)

    @property
    @pulumi.getter(name="awsExternalId")
    def aws_external_id(self) -> pulumi.Input[str]:
        """
        A unique identifier that is required when you assume a role in another account.
        """
        return pulumi.get(self, "aws_external_id")

    @aws_external_id.setter
    def aws_external_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "aws_external_id", value)


@pulumi.input_type
class AwsCredsAuthenticationDetailsPropertiesArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[str],
                 aws_access_key_id: pulumi.Input[str],
                 aws_secret_access_key: pulumi.Input[str]):
        """
        AWS cloud account connector based credentials, the credentials is composed of access key ID and secret key, for more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating an IAM User in Your AWS Account (write only)</a>
        :param pulumi.Input[str] authentication_type: Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
               Expected value is 'awsCreds'.
        :param pulumi.Input[str] aws_access_key_id: Public key element of the AWS credential object (write only)
        :param pulumi.Input[str] aws_secret_access_key: Secret key element of the AWS credential object (write only)
        """
        pulumi.set(__self__, "authentication_type", 'awsCreds')
        pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[str]:
        """
        Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
        Expected value is 'awsCreds'.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> pulumi.Input[str]:
        """
        Public key element of the AWS credential object (write only)
        """
        return pulumi.get(self, "aws_access_key_id")

    @aws_access_key_id.setter
    def aws_access_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "aws_access_key_id", value)

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> pulumi.Input[str]:
        """
        Secret key element of the AWS credential object (write only)
        """
        return pulumi.get(self, "aws_secret_access_key")

    @aws_secret_access_key.setter
    def aws_secret_access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "aws_secret_access_key", value)


@pulumi.input_type
class AzureResourceDetailsArgs:
    def __init__(__self__, *,
                 source: pulumi.Input[str]):
        """
        Details of the Azure resource that was assessed
        :param pulumi.Input[str] source: The platform where the assessed resource resides
               Expected value is 'Azure'.
        """
        pulumi.set(__self__, "source", 'Azure')

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The platform where the assessed resource resides
        Expected value is 'Azure'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class DenylistCustomAlertRuleArgs:
    def __init__(__self__, *,
                 denylist_values: pulumi.Input[Sequence[pulumi.Input[str]]],
                 is_enabled: pulumi.Input[bool],
                 rule_type: pulumi.Input[str]):
        """
        A custom alert rule that checks if a value (depends on the custom alert type) is denied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] denylist_values: The values to deny. The format of the values depends on the rule type.
        :param pulumi.Input[bool] is_enabled: Status of the custom alert.
        :param pulumi.Input[str] rule_type: The type of the custom alert rule.
               Expected value is 'DenylistCustomAlertRule'.
        """
        pulumi.set(__self__, "denylist_values", denylist_values)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "rule_type", 'DenylistCustomAlertRule')

    @property
    @pulumi.getter(name="denylistValues")
    def denylist_values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The values to deny. The format of the values depends on the rule type.
        """
        return pulumi.get(self, "denylist_values")

    @denylist_values.setter
    def denylist_values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "denylist_values", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Status of the custom alert.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        The type of the custom alert rule.
        Expected value is 'DenylistCustomAlertRule'.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)


@pulumi.input_type
class GcpCredentialsDetailsPropertiesArgs:
    def __init__(__self__, *,
                 auth_provider_x509_cert_url: pulumi.Input[str],
                 auth_uri: pulumi.Input[str],
                 authentication_type: pulumi.Input[str],
                 client_email: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 client_x509_cert_url: pulumi.Input[str],
                 organization_id: pulumi.Input[str],
                 private_key: pulumi.Input[str],
                 private_key_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 token_uri: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        GCP cloud account connector based service to service credentials, the credentials are composed of the organization ID and a JSON API key (write only)
        :param pulumi.Input[str] auth_provider_x509_cert_url: Auth provider x509 certificate URL field of the API key (write only)
        :param pulumi.Input[str] auth_uri: Auth URI field of the API key (write only)
        :param pulumi.Input[str] authentication_type: Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
               Expected value is 'gcpCredentials'.
        :param pulumi.Input[str] client_email: Client email field of the API key (write only)
        :param pulumi.Input[str] client_id: Client ID field of the API key (write only)
        :param pulumi.Input[str] client_x509_cert_url: Client x509 certificate URL field of the API key (write only)
        :param pulumi.Input[str] organization_id: The organization ID of the GCP cloud account
        :param pulumi.Input[str] private_key: Private key field of the API key (write only)
        :param pulumi.Input[str] private_key_id: Private key ID field of the API key (write only)
        :param pulumi.Input[str] project_id: Project ID field of the API key (write only)
        :param pulumi.Input[str] token_uri: Token URI field of the API key (write only)
        :param pulumi.Input[str] type: Type field of the API key (write only)
        """
        pulumi.set(__self__, "auth_provider_x509_cert_url", auth_provider_x509_cert_url)
        pulumi.set(__self__, "auth_uri", auth_uri)
        pulumi.set(__self__, "authentication_type", 'gcpCredentials')
        pulumi.set(__self__, "client_email", client_email)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_x509_cert_url", client_x509_cert_url)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "private_key_id", private_key_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "token_uri", token_uri)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="authProviderX509CertUrl")
    def auth_provider_x509_cert_url(self) -> pulumi.Input[str]:
        """
        Auth provider x509 certificate URL field of the API key (write only)
        """
        return pulumi.get(self, "auth_provider_x509_cert_url")

    @auth_provider_x509_cert_url.setter
    def auth_provider_x509_cert_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_provider_x509_cert_url", value)

    @property
    @pulumi.getter(name="authUri")
    def auth_uri(self) -> pulumi.Input[str]:
        """
        Auth URI field of the API key (write only)
        """
        return pulumi.get(self, "auth_uri")

    @auth_uri.setter
    def auth_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_uri", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[str]:
        """
        Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
        Expected value is 'gcpCredentials'.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Input[str]:
        """
        Client email field of the API key (write only)
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_email", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        Client ID field of the API key (write only)
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientX509CertUrl")
    def client_x509_cert_url(self) -> pulumi.Input[str]:
        """
        Client x509 certificate URL field of the API key (write only)
        """
        return pulumi.get(self, "client_x509_cert_url")

    @client_x509_cert_url.setter
    def client_x509_cert_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_x509_cert_url", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        The organization ID of the GCP cloud account
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[str]:
        """
        Private key field of the API key (write only)
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Input[str]:
        """
        Private key ID field of the API key (write only)
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Project ID field of the API key (write only)
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="tokenUri")
    def token_uri(self) -> pulumi.Input[str]:
        """
        Token URI field of the API key (write only)
        """
        return pulumi.get(self, "token_uri")

    @token_uri.setter
    def token_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "token_uri", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type field of the API key (write only)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class HybridComputeSettingsPropertiesArgs:
    def __init__(__self__, *,
                 auto_provision: pulumi.Input[Union[str, 'AutoProvision']],
                 proxy_server: Optional[pulumi.Input['ProxyServerPropertiesArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 service_principal: Optional[pulumi.Input['ServicePrincipalPropertiesArgs']] = None):
        """
        Settings for hybrid compute management
        :param pulumi.Input[Union[str, 'AutoProvision']] auto_provision: Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
        :param pulumi.Input['ProxyServerPropertiesArgs'] proxy_server: For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
        :param pulumi.Input[str] region: The location where the metadata of machines will be stored
        :param pulumi.Input[str] resource_group_name: The name of the resource group where Arc (Hybrid Compute) connectors are connected.
        :param pulumi.Input['ServicePrincipalPropertiesArgs'] service_principal: An object to access resources that are secured by an Azure AD tenant.
        """
        pulumi.set(__self__, "auto_provision", auto_provision)
        if proxy_server is not None:
            pulumi.set(__self__, "proxy_server", proxy_server)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_principal is not None:
            pulumi.set(__self__, "service_principal", service_principal)

    @property
    @pulumi.getter(name="autoProvision")
    def auto_provision(self) -> pulumi.Input[Union[str, 'AutoProvision']]:
        """
        Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
        """
        return pulumi.get(self, "auto_provision")

    @auto_provision.setter
    def auto_provision(self, value: pulumi.Input[Union[str, 'AutoProvision']]):
        pulumi.set(self, "auto_provision", value)

    @property
    @pulumi.getter(name="proxyServer")
    def proxy_server(self) -> Optional[pulumi.Input['ProxyServerPropertiesArgs']]:
        """
        For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
        """
        return pulumi.get(self, "proxy_server")

    @proxy_server.setter
    def proxy_server(self, value: Optional[pulumi.Input['ProxyServerPropertiesArgs']]):
        pulumi.set(self, "proxy_server", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the metadata of machines will be stored
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource group where Arc (Hybrid Compute) connectors are connected.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> Optional[pulumi.Input['ServicePrincipalPropertiesArgs']]:
        """
        An object to access resources that are secured by an Azure AD tenant.
        """
        return pulumi.get(self, "service_principal")

    @service_principal.setter
    def service_principal(self, value: Optional[pulumi.Input['ServicePrincipalPropertiesArgs']]):
        pulumi.set(self, "service_principal", value)


@pulumi.input_type
class JitNetworkAccessPolicyVirtualMachineArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 ports: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]],
                 public_ip_address: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: Resource ID of the virtual machine that is linked to this policy
        :param pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]] ports: Port configurations for the virtual machine
        :param pulumi.Input[str] public_ip_address: Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]]:
        """
        Port configurations for the virtual machine
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)


@pulumi.input_type
class JitNetworkAccessPortRuleArgs:
    def __init__(__self__, *,
                 max_request_access_duration: pulumi.Input[str],
                 number: pulumi.Input[int],
                 protocol: pulumi.Input[Union[str, 'Protocol']],
                 allowed_source_address_prefix: Optional[pulumi.Input[str]] = None,
                 allowed_source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] max_request_access_duration: Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        :param pulumi.Input[str] allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        pulumi.set(__self__, "max_request_access_duration", max_request_access_duration)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "protocol", protocol)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)

    @property
    @pulumi.getter(name="maxRequestAccessDuration")
    def max_request_access_duration(self) -> pulumi.Input[str]:
        """
        Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        """
        return pulumi.get(self, "max_request_access_duration")

    @max_request_access_duration.setter
    def max_request_access_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "max_request_access_duration", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[int]:
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[int]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'Protocol']]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'Protocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @allowed_source_address_prefix.setter
    def allowed_source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_source_address_prefix", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")

    @allowed_source_address_prefixes.setter
    def allowed_source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_source_address_prefixes", value)


@pulumi.input_type
class JitNetworkAccessRequestPortArgs:
    def __init__(__self__, *,
                 end_time_utc: pulumi.Input[str],
                 number: pulumi.Input[int],
                 status: pulumi.Input[Union[str, 'Status']],
                 status_reason: pulumi.Input[Union[str, 'StatusReason']],
                 allowed_source_address_prefix: Optional[pulumi.Input[str]] = None,
                 allowed_source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mapped_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] end_time_utc: The date & time at which the request ends in UTC
        :param pulumi.Input[Union[str, 'Status']] status: The status of the port
        :param pulumi.Input[Union[str, 'StatusReason']] status_reason: A description of why the `status` has its value
        :param pulumi.Input[str] allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        :param pulumi.Input[int] mapped_port: The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)
        if mapped_port is not None:
            pulumi.set(__self__, "mapped_port", mapped_port)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> pulumi.Input[str]:
        """
        The date & time at which the request ends in UTC
        """
        return pulumi.get(self, "end_time_utc")

    @end_time_utc.setter
    def end_time_utc(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_time_utc", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[int]:
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[int]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'Status']]:
        """
        The status of the port
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'Status']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Input[Union[str, 'StatusReason']]:
        """
        A description of why the `status` has its value
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: pulumi.Input[Union[str, 'StatusReason']]):
        pulumi.set(self, "status_reason", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @allowed_source_address_prefix.setter
    def allowed_source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_source_address_prefix", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")

    @allowed_source_address_prefixes.setter
    def allowed_source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_source_address_prefixes", value)

    @property
    @pulumi.getter(name="mappedPort")
    def mapped_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        return pulumi.get(self, "mapped_port")

    @mapped_port.setter
    def mapped_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mapped_port", value)


@pulumi.input_type
class JitNetworkAccessRequestVirtualMachineArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 ports: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]]):
        """
        :param pulumi.Input[str] id: Resource ID of the virtual machine that is linked to this policy
        :param pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]] ports: The ports that were opened for the virtual machine
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]]:
        """
        The ports that were opened for the virtual machine
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class JitNetworkAccessRequestArgs:
    def __init__(__self__, *,
                 requestor: pulumi.Input[str],
                 start_time_utc: pulumi.Input[str],
                 virtual_machines: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestVirtualMachineArgs']]],
                 justification: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] requestor: The identity of the person who made the request
        :param pulumi.Input[str] start_time_utc: The start time of the request in UTC
        :param pulumi.Input[str] justification: The justification for making the initiate request
        """
        pulumi.set(__self__, "requestor", requestor)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "virtual_machines", virtual_machines)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)

    @property
    @pulumi.getter
    def requestor(self) -> pulumi.Input[str]:
        """
        The identity of the person who made the request
        """
        return pulumi.get(self, "requestor")

    @requestor.setter
    def requestor(self, value: pulumi.Input[str]):
        pulumi.set(self, "requestor", value)

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> pulumi.Input[str]:
        """
        The start time of the request in UTC
        """
        return pulumi.get(self, "start_time_utc")

    @start_time_utc.setter
    def start_time_utc(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time_utc", value)

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestVirtualMachineArgs']]]:
        return pulumi.get(self, "virtual_machines")

    @virtual_machines.setter
    def virtual_machines(self, value: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestVirtualMachineArgs']]]):
        pulumi.set(self, "virtual_machines", value)

    @property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[str]]:
        """
        The justification for making the initiate request
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "justification", value)


@pulumi.input_type
class OnPremiseResourceDetailsArgs:
    def __init__(__self__, *,
                 machine_name: pulumi.Input[str],
                 source: pulumi.Input[str],
                 source_computer_id: pulumi.Input[str],
                 vmuuid: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        Details of the On Premise resource that was assessed
        :param pulumi.Input[str] machine_name: The name of the machine
        :param pulumi.Input[str] source: The platform where the assessed resource resides
               Expected value is 'OnPremise'.
        :param pulumi.Input[str] source_computer_id: The oms agent Id installed on the machine
        :param pulumi.Input[str] vmuuid: The unique Id of the machine
        :param pulumi.Input[str] workspace_id: Azure resource Id of the workspace the machine is attached to
        """
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "source", 'OnPremise')
        pulumi.set(__self__, "source_computer_id", source_computer_id)
        pulumi.set(__self__, "vmuuid", vmuuid)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> pulumi.Input[str]:
        """
        The name of the machine
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The platform where the assessed resource resides
        Expected value is 'OnPremise'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceComputerId")
    def source_computer_id(self) -> pulumi.Input[str]:
        """
        The oms agent Id installed on the machine
        """
        return pulumi.get(self, "source_computer_id")

    @source_computer_id.setter
    def source_computer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_computer_id", value)

    @property
    @pulumi.getter
    def vmuuid(self) -> pulumi.Input[str]:
        """
        The unique Id of the machine
        """
        return pulumi.get(self, "vmuuid")

    @vmuuid.setter
    def vmuuid(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmuuid", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        Azure resource Id of the workspace the machine is attached to
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class OnPremiseSqlResourceDetailsArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 machine_name: pulumi.Input[str],
                 server_name: pulumi.Input[str],
                 source: pulumi.Input[str],
                 source_computer_id: pulumi.Input[str],
                 vmuuid: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        Details of the On Premise Sql resource that was assessed
        :param pulumi.Input[str] database_name: The Sql database name installed on the machine
        :param pulumi.Input[str] machine_name: The name of the machine
        :param pulumi.Input[str] server_name: The Sql server name installed on the machine
        :param pulumi.Input[str] source: The platform where the assessed resource resides
               Expected value is 'OnPremiseSql'.
        :param pulumi.Input[str] source_computer_id: The oms agent Id installed on the machine
        :param pulumi.Input[str] vmuuid: The unique Id of the machine
        :param pulumi.Input[str] workspace_id: Azure resource Id of the workspace the machine is attached to
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "source", 'OnPremiseSql')
        pulumi.set(__self__, "source_computer_id", source_computer_id)
        pulumi.set(__self__, "vmuuid", vmuuid)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The Sql database name installed on the machine
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> pulumi.Input[str]:
        """
        The name of the machine
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The Sql server name installed on the machine
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The platform where the assessed resource resides
        Expected value is 'OnPremiseSql'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceComputerId")
    def source_computer_id(self) -> pulumi.Input[str]:
        """
        The oms agent Id installed on the machine
        """
        return pulumi.get(self, "source_computer_id")

    @source_computer_id.setter
    def source_computer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_computer_id", value)

    @property
    @pulumi.getter
    def vmuuid(self) -> pulumi.Input[str]:
        """
        The unique Id of the machine
        """
        return pulumi.get(self, "vmuuid")

    @vmuuid.setter
    def vmuuid(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmuuid", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        Azure resource Id of the workspace the machine is attached to
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class PathRecommendationArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 common: Optional[pulumi.Input[bool]] = None,
                 configuration_status: Optional[pulumi.Input[str]] = None,
                 file_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 publisher_info: Optional[pulumi.Input['PublisherInfoArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_sids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 usernames: Optional[pulumi.Input[Sequence[pulumi.Input['UserRecommendationArgs']]]] = None):
        """
        Represents a path that is recommended to be allowed and its properties
        :param pulumi.Input[str] action: The recommendation action of the machine or rule
        :param pulumi.Input[bool] common: Whether the application is commonly run on the machine
        :param pulumi.Input[str] configuration_status: The configuration status of the machines group or machine or rule
        :param pulumi.Input[str] file_type: The type of the file (for Linux files - Executable is used)
        :param pulumi.Input[str] path: The full path of the file, or an identifier of the application
        :param pulumi.Input['PublisherInfoArgs'] publisher_info: Represents the publisher information of a process/rule
        :param pulumi.Input[str] type: The type of the rule to be allowed
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if common is not None:
            pulumi.set(__self__, "common", common)
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if publisher_info is not None:
            pulumi.set(__self__, "publisher_info", publisher_info)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_sids is not None:
            pulumi.set(__self__, "user_sids", user_sids)
        if usernames is not None:
            pulumi.set(__self__, "usernames", usernames)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation action of the machine or rule
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def common(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the application is commonly run on the machine
        """
        return pulumi.get(self, "common")

    @common.setter
    def common(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "common", value)

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration status of the machines group or machine or rule
        """
        return pulumi.get(self, "configuration_status")

    @configuration_status.setter
    def configuration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_status", value)

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the file (for Linux files - Executable is used)
        """
        return pulumi.get(self, "file_type")

    @file_type.setter
    def file_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The full path of the file, or an identifier of the application
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="publisherInfo")
    def publisher_info(self) -> Optional[pulumi.Input['PublisherInfoArgs']]:
        """
        Represents the publisher information of a process/rule
        """
        return pulumi.get(self, "publisher_info")

    @publisher_info.setter
    def publisher_info(self, value: Optional[pulumi.Input['PublisherInfoArgs']]):
        pulumi.set(self, "publisher_info", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the rule to be allowed
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userSids")
    def user_sids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "user_sids")

    @user_sids.setter
    def user_sids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_sids", value)

    @property
    @pulumi.getter
    def usernames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserRecommendationArgs']]]]:
        return pulumi.get(self, "usernames")

    @usernames.setter
    def usernames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserRecommendationArgs']]]]):
        pulumi.set(self, "usernames", value)


@pulumi.input_type
class ProtectionModeArgs:
    def __init__(__self__, *,
                 exe: Optional[pulumi.Input[str]] = None,
                 executable: Optional[pulumi.Input[str]] = None,
                 msi: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None):
        """
        The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
        :param pulumi.Input[str] exe: The application control policy enforcement/protection mode of the machine group
        :param pulumi.Input[str] executable: The application control policy enforcement/protection mode of the machine group
        :param pulumi.Input[str] msi: The application control policy enforcement/protection mode of the machine group
        :param pulumi.Input[str] script: The application control policy enforcement/protection mode of the machine group
        """
        if exe is not None:
            pulumi.set(__self__, "exe", exe)
        if executable is not None:
            pulumi.set(__self__, "executable", executable)
        if msi is not None:
            pulumi.set(__self__, "msi", msi)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def exe(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "exe")

    @exe.setter
    def exe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exe", value)

    @property
    @pulumi.getter
    def executable(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "executable")

    @executable.setter
    def executable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "executable", value)

    @property
    @pulumi.getter
    def msi(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "msi")

    @msi.setter
    def msi(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msi", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the machine group
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)


@pulumi.input_type
class ProxyServerPropertiesArgs:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None):
        """
        For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
        :param pulumi.Input[str] ip: Proxy server IP
        :param pulumi.Input[str] port: Proxy server port
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        Proxy server IP
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        Proxy server port
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class PublisherInfoArgs:
    def __init__(__self__, *,
                 binary_name: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 publisher_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Represents the publisher information of a process/rule
        :param pulumi.Input[str] binary_name: The "OriginalName" field taken from the file's version resource
        :param pulumi.Input[str] product_name: The product name taken from the file's version resource
        :param pulumi.Input[str] publisher_name: The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        :param pulumi.Input[str] version: The binary file version taken from the file's version resource
        """
        if binary_name is not None:
            pulumi.set(__self__, "binary_name", binary_name)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if publisher_name is not None:
            pulumi.set(__self__, "publisher_name", publisher_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="binaryName")
    def binary_name(self) -> Optional[pulumi.Input[str]]:
        """
        The "OriginalName" field taken from the file's version resource
        """
        return pulumi.get(self, "binary_name")

    @binary_name.setter
    def binary_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binary_name", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        The product name taken from the file's version resource
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)

    @property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        """
        return pulumi.get(self, "publisher_name")

    @publisher_name.setter
    def publisher_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The binary file version taken from the file's version resource
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class RecommendationConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 recommendation_type: pulumi.Input[Union[str, 'RecommendationType']],
                 status: pulumi.Input[Union[str, 'RecommendationConfigStatus']]):
        """
        The type of IoT Security recommendation.
        :param pulumi.Input[Union[str, 'RecommendationType']] recommendation_type: The type of IoT Security recommendation.
        :param pulumi.Input[Union[str, 'RecommendationConfigStatus']] status: Recommendation status. When the recommendation status is disabled recommendations are not generated.
        """
        pulumi.set(__self__, "recommendation_type", recommendation_type)
        if status is None:
            status = 'Enabled'
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="recommendationType")
    def recommendation_type(self) -> pulumi.Input[Union[str, 'RecommendationType']]:
        """
        The type of IoT Security recommendation.
        """
        return pulumi.get(self, "recommendation_type")

    @recommendation_type.setter
    def recommendation_type(self, value: pulumi.Input[Union[str, 'RecommendationType']]):
        pulumi.set(self, "recommendation_type", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'RecommendationConfigStatus']]:
        """
        Recommendation status. When the recommendation status is disabled recommendations are not generated.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'RecommendationConfigStatus']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ScopeElementArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[str]] = None):
        """
        A more specific scope used to identify the alerts to suppress.
        :param pulumi.Input[str] field: The alert entity type to suppress by.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The alert entity type to suppress by.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)


@pulumi.input_type
class SecurityAssessmentMetadataPartnerDataArgs:
    def __init__(__self__, *,
                 partner_name: pulumi.Input[str],
                 secret: pulumi.Input[str],
                 product_name: Optional[pulumi.Input[str]] = None):
        """
        Describes the partner that created the assessment
        :param pulumi.Input[str] partner_name: Name of the company of the partner
        :param pulumi.Input[str] secret: Secret to authenticate the partner and verify it created the assessment - write only
        :param pulumi.Input[str] product_name: Name of the product of the partner that created the assessment
        """
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "secret", secret)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> pulumi.Input[str]:
        """
        Name of the company of the partner
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        Secret to authenticate the partner and verify it created the assessment - write only
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the product of the partner that created the assessment
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)


@pulumi.input_type
class SecurityAssessmentMetadataPropertiesArgs:
    def __init__(__self__, *,
                 assessment_type: pulumi.Input[Union[str, 'AssessmentType']],
                 display_name: pulumi.Input[str],
                 severity: pulumi.Input[Union[str, 'Severity']],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Categories']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 implementation_effort: Optional[pulumi.Input[Union[str, 'ImplementationEffort']]] = None,
                 partner_data: Optional[pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs']] = None,
                 preview: Optional[pulumi.Input[bool]] = None,
                 remediation_description: Optional[pulumi.Input[str]] = None,
                 threats: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Threats']]]]] = None,
                 user_impact: Optional[pulumi.Input[Union[str, 'UserImpact']]] = None):
        """
        Describes properties of an assessment metadata.
        :param pulumi.Input[Union[str, 'AssessmentType']] assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
        :param pulumi.Input[str] display_name: User friendly display name of the assessment
        :param pulumi.Input[Union[str, 'Severity']] severity: The severity level of the assessment
        :param pulumi.Input[str] description: Human readable description of the assessment
        :param pulumi.Input[Union[str, 'ImplementationEffort']] implementation_effort: The implementation effort required to remediate this assessment
        :param pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs'] partner_data: Describes the partner that created the assessment
        :param pulumi.Input[bool] preview: True if this assessment is in preview release status
        :param pulumi.Input[str] remediation_description: Human readable description of what you should do to mitigate this security issue
        :param pulumi.Input[Union[str, 'UserImpact']] user_impact: The user impact of the assessment
        """
        pulumi.set(__self__, "assessment_type", assessment_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "severity", severity)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if implementation_effort is not None:
            pulumi.set(__self__, "implementation_effort", implementation_effort)
        if partner_data is not None:
            pulumi.set(__self__, "partner_data", partner_data)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if remediation_description is not None:
            pulumi.set(__self__, "remediation_description", remediation_description)
        if threats is not None:
            pulumi.set(__self__, "threats", threats)
        if user_impact is not None:
            pulumi.set(__self__, "user_impact", user_impact)

    @property
    @pulumi.getter(name="assessmentType")
    def assessment_type(self) -> pulumi.Input[Union[str, 'AssessmentType']]:
        """
        BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
        """
        return pulumi.get(self, "assessment_type")

    @assessment_type.setter
    def assessment_type(self, value: pulumi.Input[Union[str, 'AssessmentType']]):
        pulumi.set(self, "assessment_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        User friendly display name of the assessment
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[Union[str, 'Severity']]:
        """
        The severity level of the assessment
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[Union[str, 'Severity']]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Categories']]]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Categories']]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description of the assessment
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="implementationEffort")
    def implementation_effort(self) -> Optional[pulumi.Input[Union[str, 'ImplementationEffort']]]:
        """
        The implementation effort required to remediate this assessment
        """
        return pulumi.get(self, "implementation_effort")

    @implementation_effort.setter
    def implementation_effort(self, value: Optional[pulumi.Input[Union[str, 'ImplementationEffort']]]):
        pulumi.set(self, "implementation_effort", value)

    @property
    @pulumi.getter(name="partnerData")
    def partner_data(self) -> Optional[pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs']]:
        """
        Describes the partner that created the assessment
        """
        return pulumi.get(self, "partner_data")

    @partner_data.setter
    def partner_data(self, value: Optional[pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs']]):
        pulumi.set(self, "partner_data", value)

    @property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input[bool]]:
        """
        True if this assessment is in preview release status
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preview", value)

    @property
    @pulumi.getter(name="remediationDescription")
    def remediation_description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description of what you should do to mitigate this security issue
        """
        return pulumi.get(self, "remediation_description")

    @remediation_description.setter
    def remediation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remediation_description", value)

    @property
    @pulumi.getter
    def threats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Threats']]]]]:
        return pulumi.get(self, "threats")

    @threats.setter
    def threats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Threats']]]]]):
        pulumi.set(self, "threats", value)

    @property
    @pulumi.getter(name="userImpact")
    def user_impact(self) -> Optional[pulumi.Input[Union[str, 'UserImpact']]]:
        """
        The user impact of the assessment
        """
        return pulumi.get(self, "user_impact")

    @user_impact.setter
    def user_impact(self, value: Optional[pulumi.Input[Union[str, 'UserImpact']]]):
        pulumi.set(self, "user_impact", value)


@pulumi.input_type
class SecurityAssessmentPartnerDataArgs:
    def __init__(__self__, *,
                 partner_name: pulumi.Input[str],
                 secret: pulumi.Input[str]):
        """
        Data regarding 3rd party partner integration
        :param pulumi.Input[str] partner_name: Name of the company of the partner
        :param pulumi.Input[str] secret: secret to authenticate the partner - write only
        """
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> pulumi.Input[str]:
        """
        Name of the company of the partner
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        secret to authenticate the partner - write only
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class SecurityContactPropertiesAlertNotificationsArgs:
    def __init__(__self__, *,
                 minimal_severity: Optional[pulumi.Input[Union[str, 'MinimalSeverity']]] = None,
                 state: Optional[pulumi.Input[Union[str, 'State']]] = None):
        """
        Defines whether to send email notifications about new security alerts
        :param pulumi.Input[Union[str, 'MinimalSeverity']] minimal_severity: Defines the minimal alert severity which will be sent as email notifications
        :param pulumi.Input[Union[str, 'State']] state: Defines if email notifications will be sent about new security alerts
        """
        if minimal_severity is not None:
            pulumi.set(__self__, "minimal_severity", minimal_severity)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="minimalSeverity")
    def minimal_severity(self) -> Optional[pulumi.Input[Union[str, 'MinimalSeverity']]]:
        """
        Defines the minimal alert severity which will be sent as email notifications
        """
        return pulumi.get(self, "minimal_severity")

    @minimal_severity.setter
    def minimal_severity(self, value: Optional[pulumi.Input[Union[str, 'MinimalSeverity']]]):
        pulumi.set(self, "minimal_severity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'State']]]:
        """
        Defines if email notifications will be sent about new security alerts
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'State']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class SecurityContactPropertiesNotificationsByRoleArgs:
    def __init__(__self__, *,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Roles']]]]] = None,
                 state: Optional[pulumi.Input[Union[str, 'State']]] = None):
        """
        Defines whether to send email notifications from Azure Security Center to persons with specific RBAC roles on the subscription.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Roles']]]] roles: Defines which RBAC roles will get email notifications from Azure Security Center. List of allowed RBAC roles: 
        :param pulumi.Input[Union[str, 'State']] state: Defines whether to send email notifications from Azure Security Center to persons with specific RBAC roles on the subscription.
        """
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Roles']]]]]:
        """
        Defines which RBAC roles will get email notifications from Azure Security Center. List of allowed RBAC roles: 
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Roles']]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'State']]]:
        """
        Defines whether to send email notifications from Azure Security Center to persons with specific RBAC roles on the subscription.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'State']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class ServicePrincipalPropertiesArgs:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None):
        """
        Details of the service principal.
        :param pulumi.Input[str] application_id: Application ID of service principal.
        :param pulumi.Input[str] secret: A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Application ID of service principal.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class SuppressionAlertsScopeArgs:
    def __init__(__self__, *,
                 all_of: pulumi.Input[Sequence[pulumi.Input['ScopeElementArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ScopeElementArgs']]] all_of: All the conditions inside need to be true in order to suppress the alert
        """
        pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> pulumi.Input[Sequence[pulumi.Input['ScopeElementArgs']]]:
        """
        All the conditions inside need to be true in order to suppress the alert
        """
        return pulumi.get(self, "all_of")

    @all_of.setter
    def all_of(self, value: pulumi.Input[Sequence[pulumi.Input['ScopeElementArgs']]]):
        pulumi.set(self, "all_of", value)


@pulumi.input_type
class ThresholdCustomAlertRuleArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 max_threshold: pulumi.Input[int],
                 min_threshold: pulumi.Input[int],
                 rule_type: pulumi.Input[str]):
        """
        A custom alert rule that checks if a value (depends on the custom alert type) is within the given range.
        :param pulumi.Input[bool] is_enabled: Status of the custom alert.
        :param pulumi.Input[int] max_threshold: The maximum threshold.
        :param pulumi.Input[int] min_threshold: The minimum threshold.
        :param pulumi.Input[str] rule_type: The type of the custom alert rule.
               Expected value is 'ThresholdCustomAlertRule'.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "max_threshold", max_threshold)
        pulumi.set(__self__, "min_threshold", min_threshold)
        pulumi.set(__self__, "rule_type", 'ThresholdCustomAlertRule')

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Status of the custom alert.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="maxThreshold")
    def max_threshold(self) -> pulumi.Input[int]:
        """
        The maximum threshold.
        """
        return pulumi.get(self, "max_threshold")

    @max_threshold.setter
    def max_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_threshold", value)

    @property
    @pulumi.getter(name="minThreshold")
    def min_threshold(self) -> pulumi.Input[int]:
        """
        The minimum threshold.
        """
        return pulumi.get(self, "min_threshold")

    @min_threshold.setter
    def min_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_threshold", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        The type of the custom alert rule.
        Expected value is 'ThresholdCustomAlertRule'.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)


@pulumi.input_type
class TimeWindowCustomAlertRuleArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 max_threshold: pulumi.Input[int],
                 min_threshold: pulumi.Input[int],
                 rule_type: pulumi.Input[str],
                 time_window_size: pulumi.Input[str]):
        """
        A custom alert rule that checks if the number of activities (depends on the custom alert type) in a time window is within the given range.
        :param pulumi.Input[bool] is_enabled: Status of the custom alert.
        :param pulumi.Input[int] max_threshold: The maximum threshold.
        :param pulumi.Input[int] min_threshold: The minimum threshold.
        :param pulumi.Input[str] rule_type: The type of the custom alert rule.
               Expected value is 'TimeWindowCustomAlertRule'.
        :param pulumi.Input[str] time_window_size: The time window size in iso8601 format.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "max_threshold", max_threshold)
        pulumi.set(__self__, "min_threshold", min_threshold)
        pulumi.set(__self__, "rule_type", 'TimeWindowCustomAlertRule')
        pulumi.set(__self__, "time_window_size", time_window_size)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Status of the custom alert.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="maxThreshold")
    def max_threshold(self) -> pulumi.Input[int]:
        """
        The maximum threshold.
        """
        return pulumi.get(self, "max_threshold")

    @max_threshold.setter
    def max_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_threshold", value)

    @property
    @pulumi.getter(name="minThreshold")
    def min_threshold(self) -> pulumi.Input[int]:
        """
        The minimum threshold.
        """
        return pulumi.get(self, "min_threshold")

    @min_threshold.setter
    def min_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_threshold", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[str]:
        """
        The type of the custom alert rule.
        Expected value is 'TimeWindowCustomAlertRule'.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="timeWindowSize")
    def time_window_size(self) -> pulumi.Input[str]:
        """
        The time window size in iso8601 format.
        """
        return pulumi.get(self, "time_window_size")

    @time_window_size.setter
    def time_window_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_window_size", value)


@pulumi.input_type
class UserDefinedResourcesPropertiesArgs:
    def __init__(__self__, *,
                 query: pulumi.Input[str],
                 query_subscriptions: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Properties of the IoT Security solution's user defined resources.
        :param pulumi.Input[str] query: Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs""
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_subscriptions: List of Azure subscription ids on which the user defined resources query should be executed.
        """
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "query_subscriptions", query_subscriptions)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs""
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="querySubscriptions")
    def query_subscriptions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of Azure subscription ids on which the user defined resources query should be executed.
        """
        return pulumi.get(self, "query_subscriptions")

    @query_subscriptions.setter
    def query_subscriptions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "query_subscriptions", value)


@pulumi.input_type
class UserRecommendationArgs:
    def __init__(__self__, *,
                 recommendation_action: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Represents a user that is recommended to be allowed for a certain rule
        :param pulumi.Input[str] recommendation_action: The recommendation action of the machine or rule
        :param pulumi.Input[str] username: Represents a user that is recommended to be allowed for a certain rule
        """
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation action of the machine or rule
        """
        return pulumi.get(self, "recommendation_action")

    @recommendation_action.setter
    def recommendation_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recommendation_action", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Represents a user that is recommended to be allowed for a certain rule
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VmRecommendationArgs:
    def __init__(__self__, *,
                 configuration_status: Optional[pulumi.Input[str]] = None,
                 enforcement_support: Optional[pulumi.Input[str]] = None,
                 recommendation_action: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Represents a machine that is part of a machine group
        :param pulumi.Input[str] configuration_status: The configuration status of the machines group or machine or rule
        :param pulumi.Input[str] enforcement_support: The machine supportability of Enforce feature
        :param pulumi.Input[str] recommendation_action: The recommendation action of the machine or rule
        :param pulumi.Input[str] resource_id: The full resource id of the machine
        """
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if enforcement_support is not None:
            pulumi.set(__self__, "enforcement_support", enforcement_support)
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration status of the machines group or machine or rule
        """
        return pulumi.get(self, "configuration_status")

    @configuration_status.setter
    def configuration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_status", value)

    @property
    @pulumi.getter(name="enforcementSupport")
    def enforcement_support(self) -> Optional[pulumi.Input[str]]:
        """
        The machine supportability of Enforce feature
        """
        return pulumi.get(self, "enforcement_support")

    @enforcement_support.setter
    def enforcement_support(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enforcement_support", value)

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation action of the machine or rule
        """
        return pulumi.get(self, "recommendation_action")

    @recommendation_action.setter
    def recommendation_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recommendation_action", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource id of the machine
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


