# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult',
    'AwaitableGetWorkspaceManagedSqlServerVulnerabilityAssessmentResult',
    'get_workspace_managed_sql_server_vulnerability_assessment',
]

@pulumi.output_type
class GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult:
    """
    A server vulnerability assessment.
    """
    def __init__(__self__, id=None, name=None, recurring_scans=None, storage_container_path=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recurring_scans and not isinstance(recurring_scans, dict):
            raise TypeError("Expected argument 'recurring_scans' to be a dict")
        pulumi.set(__self__, "recurring_scans", recurring_scans)
        if storage_container_path and not isinstance(storage_container_path, str):
            raise TypeError("Expected argument 'storage_container_path' to be a str")
        pulumi.set(__self__, "storage_container_path", storage_container_path)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> Optional['outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse']:
        """
        The recurring scans settings
        """
        return pulumi.get(self, "recurring_scans")

    @property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> str:
        """
        A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
        """
        return pulumi.get(self, "storage_container_path")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetWorkspaceManagedSqlServerVulnerabilityAssessmentResult(GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult(
            id=self.id,
            name=self.name,
            recurring_scans=self.recurring_scans,
            storage_container_path=self.storage_container_path,
            type=self.type)


def get_workspace_managed_sql_server_vulnerability_assessment(resource_group_name: Optional[str] = None,
                                                              vulnerability_assessment_name: Optional[str] = None,
                                                              workspace_name: Optional[str] = None,
                                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceManagedSqlServerVulnerabilityAssessmentResult:
    """
    A server vulnerability assessment.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str vulnerability_assessment_name: The name of the vulnerability assessment.
    :param str workspace_name: The name of the workspace
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['vulnerabilityAssessmentName'] = vulnerability_assessment_name
    __args__['workspaceName'] = workspace_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:synapse/v20210601:getWorkspaceManagedSqlServerVulnerabilityAssessment', __args__, opts=opts, typ=GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult).value

    return AwaitableGetWorkspaceManagedSqlServerVulnerabilityAssessmentResult(
        id=__ret__.id,
        name=__ret__.name,
        recurring_scans=__ret__.recurring_scans,
        storage_container_path=__ret__.storage_container_path,
        type=__ret__.type)
