# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiEntityResponse',
    'ApiOAuthSettingsParameterResponse',
    'ApiOAuthSettingsResponse',
    'ApiPoliciesResponse',
    'ArmPlanResponse',
    'BackendServiceDefinitionResponse',
    'ConnectionErrorResponse',
    'ConnectionParameterResponse',
    'ConnectionStatusResponse',
    'ConsentLinkResponse',
    'CustomLoginSettingValueResponse',
    'ExpandedParentApiEntityResponse',
    'GeneralApiInformationResponse',
    'HostingEnvironmentServiceDescriptionsResponse',
    'ParameterCustomLoginSettingValuesResponse',
    'ResponseMessageEnvelopeApiEntityResponse',
    'SkuDescriptionResponse',
]

@pulumi.output_type
class ApiEntityResponse(dict):
    """
    API Management
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiDefinitionUrl":
            suggest = "api_definition_url"
        elif key == "backendService":
            suggest = "backend_service"
        elif key == "changedTime":
            suggest = "changed_time"
        elif key == "connectionParameters":
            suggest = "connection_parameters"
        elif key == "createdTime":
            suggest = "created_time"
        elif key == "generalInformation":
            suggest = "general_information"
        elif key == "runtimeUrls":
            suggest = "runtime_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEntityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEntityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEntityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 api_definition_url: Optional[str] = None,
                 backend_service: Optional['outputs.BackendServiceDefinitionResponse'] = None,
                 capabilities: Optional[Sequence[str]] = None,
                 changed_time: Optional[str] = None,
                 connection_parameters: Optional[Mapping[str, 'outputs.ConnectionParameterResponse']] = None,
                 created_time: Optional[str] = None,
                 general_information: Optional['outputs.GeneralApiInformationResponse'] = None,
                 id: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional[Any] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 policies: Optional['outputs.ApiPoliciesResponse'] = None,
                 protocols: Optional[Sequence[str]] = None,
                 runtime_urls: Optional[Sequence[str]] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        API Management
        :param str location: Resource Location
        :param str api_definition_url: API definition Url - url where the swagger can be downloaded from
        :param 'BackendServiceDefinitionResponse' backend_service: Backend service definition
        :param Sequence[str] capabilities: Capabilities
        :param str changed_time: Timestamp of last connection change.
        :param Mapping[str, 'ConnectionParameterResponse'] connection_parameters: Connection parameters
        :param str created_time: Timestamp of the connection creation
        :param 'GeneralApiInformationResponse' general_information: the URL path of this API when exposed via APIM
        :param str id: Resource Id
        :param str kind: Kind of resource
        :param Any metadata: Free form object for the data caller wants to store
        :param str name: Resource Name
        :param str path: the URL path of this API when exposed via APIM
        :param 'ApiPoliciesResponse' policies: API policies
        :param Sequence[str] protocols: Protocols supported by the front end - http/https
        :param Sequence[str] runtime_urls: Read only property returning the runtime endpoints where the API can be called
        :param Mapping[str, str] tags: Resource tags
        :param str type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if api_definition_url is not None:
            pulumi.set(__self__, "api_definition_url", api_definition_url)
        if backend_service is not None:
            pulumi.set(__self__, "backend_service", backend_service)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if changed_time is not None:
            pulumi.set(__self__, "changed_time", changed_time)
        if connection_parameters is not None:
            pulumi.set(__self__, "connection_parameters", connection_parameters)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if general_information is not None:
            pulumi.set(__self__, "general_information", general_information)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if runtime_urls is not None:
            pulumi.set(__self__, "runtime_urls", runtime_urls)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="apiDefinitionUrl")
    def api_definition_url(self) -> Optional[str]:
        """
        API definition Url - url where the swagger can be downloaded from
        """
        return pulumi.get(self, "api_definition_url")

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> Optional['outputs.BackendServiceDefinitionResponse']:
        """
        Backend service definition
        """
        return pulumi.get(self, "backend_service")

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[Sequence[str]]:
        """
        Capabilities
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="changedTime")
    def changed_time(self) -> Optional[str]:
        """
        Timestamp of last connection change.
        """
        return pulumi.get(self, "changed_time")

    @property
    @pulumi.getter(name="connectionParameters")
    def connection_parameters(self) -> Optional[Mapping[str, 'outputs.ConnectionParameterResponse']]:
        """
        Connection parameters
        """
        return pulumi.get(self, "connection_parameters")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        Timestamp of the connection creation
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="generalInformation")
    def general_information(self) -> Optional['outputs.GeneralApiInformationResponse']:
        """
        the URL path of this API when exposed via APIM
        """
        return pulumi.get(self, "general_information")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        """
        Free form object for the data caller wants to store
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        the URL path of this API when exposed via APIM
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def policies(self) -> Optional['outputs.ApiPoliciesResponse']:
        """
        API policies
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[str]]:
        """
        Protocols supported by the front end - http/https
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="runtimeUrls")
    def runtime_urls(self) -> Optional[Sequence[str]]:
        """
        Read only property returning the runtime endpoints where the API can be called
        """
        return pulumi.get(self, "runtime_urls")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApiOAuthSettingsParameterResponse(dict):
    """
    OAuth Settings Parameter
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "uiDefinition":
            suggest = "ui_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOAuthSettingsParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOAuthSettingsParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOAuthSettingsParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 options: Optional[Any] = None,
                 ui_definition: Optional[Any] = None,
                 value: Optional[str] = None):
        """
        OAuth Settings Parameter
        :param Any options: Read only: Options available to this parameter
        :param Any ui_definition: UI definitions per culture as caller can specify the culture
        :param str value: Value
        """
        if options is not None:
            pulumi.set(__self__, "options", options)
        if ui_definition is not None:
            pulumi.set(__self__, "ui_definition", ui_definition)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[Any]:
        """
        Read only: Options available to this parameter
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="uiDefinition")
    def ui_definition(self) -> Optional[Any]:
        """
        UI definitions per culture as caller can specify the culture
        """
        return pulumi.get(self, "ui_definition")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ApiOAuthSettingsResponse(dict):
    """
    OAuth settings for the connection provider
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "customParameters":
            suggest = "custom_parameters"
        elif key == "identityProvider":
            suggest = "identity_provider"
        elif key == "redirectUrl":
            suggest = "redirect_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiOAuthSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiOAuthSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiOAuthSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 custom_parameters: Optional[Mapping[str, 'outputs.ApiOAuthSettingsParameterResponse']] = None,
                 identity_provider: Optional[str] = None,
                 properties: Optional[Any] = None,
                 redirect_url: Optional[str] = None,
                 scopes: Optional[Sequence[str]] = None):
        """
        OAuth settings for the connection provider
        :param str client_id: Resource provider client id
        :param str client_secret: Client Secret needed for OAuth
        :param Mapping[str, 'ApiOAuthSettingsParameterResponse'] custom_parameters: OAuth parameters key is the name of parameter
        :param str identity_provider: Identity provider
        :param Any properties: Read only properties for this oauth setting.
        :param str redirect_url: Url
        :param Sequence[str] scopes: OAuth scopes
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if custom_parameters is not None:
            pulumi.set(__self__, "custom_parameters", custom_parameters)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Resource provider client id
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        Client Secret needed for OAuth
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="customParameters")
    def custom_parameters(self) -> Optional[Mapping[str, 'outputs.ApiOAuthSettingsParameterResponse']]:
        """
        OAuth parameters key is the name of parameter
        """
        return pulumi.get(self, "custom_parameters")

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[str]:
        """
        Identity provider
        """
        return pulumi.get(self, "identity_provider")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Any]:
        """
        Read only properties for this oauth setting.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        """
        Url
        """
        return pulumi.get(self, "redirect_url")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        OAuth scopes
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class ApiPoliciesResponse(dict):
    """
    API policies
    """
    def __init__(__self__, *,
                 location: str,
                 content: Optional[str] = None,
                 id: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        API policies
        :param str location: Resource Location
        :param str content: Content of xml policy
        :param str id: Resource Id
        :param str kind: Kind of resource
        :param str name: Resource Name
        :param Mapping[str, str] tags: Resource tags
        :param str type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        Content of xml policy
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ArmPlanResponse(dict):
    """
    The plan object in an ARM, represents a marketplace plan
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionCode":
            suggest = "promotion_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmPlanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmPlanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmPlanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 product: Optional[str] = None,
                 promotion_code: Optional[str] = None,
                 publisher: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The plan object in an ARM, represents a marketplace plan
        :param str name: The name
        :param str product: The product
        :param str promotion_code: The promotion code
        :param str publisher: The publisher
        :param str version: Version of product
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        The product
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[str]:
        """
        The promotion code
        """
        return pulumi.get(self, "promotion_code")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The publisher
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of product
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class BackendServiceDefinitionResponse(dict):
    """
    API definitions with backend urls
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostingEnvironmentServiceUrls":
            suggest = "hosting_environment_service_urls"
        elif key == "serviceUrl":
            suggest = "service_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 hosting_environment_service_urls: Optional[Sequence['outputs.HostingEnvironmentServiceDescriptionsResponse']] = None,
                 id: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 service_url: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        API definitions with backend urls
        :param str location: Resource Location
        :param Sequence['HostingEnvironmentServiceDescriptionsResponse'] hosting_environment_service_urls: Service Urls per Hosting environment
        :param str id: Resource Id
        :param str kind: Kind of resource
        :param str name: Resource Name
        :param str service_url: Url from which the swagger payload will be fetched
        :param Mapping[str, str] tags: Resource tags
        :param str type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if hosting_environment_service_urls is not None:
            pulumi.set(__self__, "hosting_environment_service_urls", hosting_environment_service_urls)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="hostingEnvironmentServiceUrls")
    def hosting_environment_service_urls(self) -> Optional[Sequence['outputs.HostingEnvironmentServiceDescriptionsResponse']]:
        """
        Service Urls per Hosting environment
        """
        return pulumi.get(self, "hosting_environment_service_urls")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[str]:
        """
        Url from which the swagger payload will be fetched
        """
        return pulumi.get(self, "service_url")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnectionErrorResponse(dict):
    """
    Connection error
    """
    def __init__(__self__, *,
                 location: str,
                 code: Optional[str] = None,
                 id: Optional[str] = None,
                 kind: Optional[str] = None,
                 message: Optional[str] = None,
                 name: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        Connection error
        :param str location: Resource Location
        :param str code: code of the status
        :param str id: Resource Id
        :param str kind: Kind of resource
        :param str message: Description of the status
        :param str name: Resource Name
        :param Mapping[str, str] tags: Resource tags
        :param str type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        code of the status
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Description of the status
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnectionParameterResponse(dict):
    """
    connection provider parameters
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "oAuthSettings":
            suggest = "o_auth_settings"
        elif key == "uiDefinition":
            suggest = "ui_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[Any] = None,
                 o_auth_settings: Optional['outputs.ApiOAuthSettingsResponse'] = None,
                 type: Optional[str] = None,
                 ui_definition: Optional[Any] = None):
        """
        connection provider parameters
        :param Any default_value: Default parameter value
        :param 'ApiOAuthSettingsResponse' o_auth_settings: Settings defining OAuth flow for the back end provider
        :param str type: Type of the parameter
        :param Any ui_definition: UI definitions
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if o_auth_settings is not None:
            pulumi.set(__self__, "o_auth_settings", o_auth_settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if ui_definition is not None:
            pulumi.set(__self__, "ui_definition", ui_definition)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[Any]:
        """
        Default parameter value
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="oAuthSettings")
    def o_auth_settings(self) -> Optional['outputs.ApiOAuthSettingsResponse']:
        """
        Settings defining OAuth flow for the back end provider
        """
        return pulumi.get(self, "o_auth_settings")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the parameter
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uiDefinition")
    def ui_definition(self) -> Optional[Any]:
        """
        UI definitions
        """
        return pulumi.get(self, "ui_definition")


@pulumi.output_type
class ConnectionStatusResponse(dict):
    """
    Connection status
    """
    def __init__(__self__, *,
                 location: str,
                 error: Optional['outputs.ConnectionErrorResponse'] = None,
                 id: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 status: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 target: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Connection status
        :param str location: Resource Location
        :param 'ConnectionErrorResponse' error: Error details
        :param str id: Resource Id
        :param str kind: Kind of resource
        :param str name: Resource Name
        :param str status: Status
        :param Mapping[str, str] tags: Resource tags
        :param str target: Target of the error
        :param str type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ConnectionErrorResponse']:
        """
        Error details
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Target of the error
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConsentLinkResponse(dict):
    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 first_party_login_uri: Optional[str] = None,
                 link: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str display_name: Display Name of the parameter in the connection provider's oauthSettings
        :param str first_party_login_uri: Uri for first party login
        :param str link: Uri for the consent link
        :param str status: Status of the link
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if first_party_login_uri is not None:
            pulumi.set(__self__, "first_party_login_uri", first_party_login_uri)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display Name of the parameter in the connection provider's oauthSettings
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="firstPartyLoginUri")
    def first_party_login_uri(self) -> Optional[str]:
        """
        Uri for first party login
        """
        return pulumi.get(self, "first_party_login_uri")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Uri for the consent link
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the link
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CustomLoginSettingValueResponse(dict):
    """
    Custom logging setting value
    """
    def __init__(__self__, *,
                 location: str,
                 id: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 option: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        Custom logging setting value
        :param str location: Resource Location
        :param str id: Resource Id
        :param str kind: Kind of resource
        :param str name: Resource Name
        :param str option: Option selected for this custom login setting value
        :param Mapping[str, str] tags: Resource tags
        :param str type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if option is not None:
            pulumi.set(__self__, "option", option)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        Option selected for this custom login setting value
        """
        return pulumi.get(self, "option")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ExpandedParentApiEntityResponse(dict):
    """
    expanded parent object for expansion
    """
    def __init__(__self__, *,
                 location: str,
                 entity: Optional['outputs.ResponseMessageEnvelopeApiEntityResponse'] = None,
                 id: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        expanded parent object for expansion
        :param str location: Resource Location
        :param 'ResponseMessageEnvelopeApiEntityResponse' entity: Id of connection provider
        :param str id: Resource Id
        :param str kind: Kind of resource
        :param str name: Resource Name
        :param Mapping[str, str] tags: Resource tags
        :param str type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def entity(self) -> Optional['outputs.ResponseMessageEnvelopeApiEntityResponse']:
        """
        Id of connection provider
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GeneralApiInformationResponse(dict):
    """
    General API information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionDisplayName":
            suggest = "connection_display_name"
        elif key == "connectionPortalUrl":
            suggest = "connection_portal_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "iconUrl":
            suggest = "icon_url"
        elif key == "termsOfUseUrl":
            suggest = "terms_of_use_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GeneralApiInformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GeneralApiInformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GeneralApiInformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 connection_display_name: Optional[str] = None,
                 connection_portal_url: Optional[Any] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 icon_url: Optional[str] = None,
                 id: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 terms_of_use_url: Optional[str] = None,
                 type: Optional[str] = None):
        """
        General API information
        :param str location: Resource Location
        :param str connection_display_name: DefaultConnectionNameTemplate
        :param Any connection_portal_url: ConnectionPortalUrl
        :param str description: Description
        :param str display_name: Display Name
        :param str icon_url: Icon Url
        :param str id: Resource Id
        :param str kind: Kind of resource
        :param str name: Resource Name
        :param Mapping[str, str] tags: Resource tags
        :param str terms_of_use_url: a public accessible url of the Terms Of Use Url of this API
        :param str type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if connection_display_name is not None:
            pulumi.set(__self__, "connection_display_name", connection_display_name)
        if connection_portal_url is not None:
            pulumi.set(__self__, "connection_portal_url", connection_portal_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terms_of_use_url is not None:
            pulumi.set(__self__, "terms_of_use_url", terms_of_use_url)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="connectionDisplayName")
    def connection_display_name(self) -> Optional[str]:
        """
        DefaultConnectionNameTemplate
        """
        return pulumi.get(self, "connection_display_name")

    @property
    @pulumi.getter(name="connectionPortalUrl")
    def connection_portal_url(self) -> Optional[Any]:
        """
        ConnectionPortalUrl
        """
        return pulumi.get(self, "connection_portal_url")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display Name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[str]:
        """
        Icon Url
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="termsOfUseUrl")
    def terms_of_use_url(self) -> Optional[str]:
        """
        a public accessible url of the Terms Of Use Url of this API
        """
        return pulumi.get(self, "terms_of_use_url")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostingEnvironmentServiceDescriptionsResponse(dict):
    """
    Back end service per ASE
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostId":
            suggest = "host_id"
        elif key == "hostingEnvironmentId":
            suggest = "hosting_environment_id"
        elif key == "serviceUrl":
            suggest = "service_url"
        elif key == "useInternalRouting":
            suggest = "use_internal_routing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostingEnvironmentServiceDescriptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostingEnvironmentServiceDescriptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostingEnvironmentServiceDescriptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_id: Optional[str] = None,
                 hosting_environment_id: Optional[str] = None,
                 service_url: Optional[str] = None,
                 use_internal_routing: Optional[bool] = None):
        """
        Back end service per ASE
        :param str host_id: Host Id
        :param str hosting_environment_id: Hosting environment Id
        :param str service_url: service url to use
        :param bool use_internal_routing: When the backend url is in same ASE, for performance reason this flag can be set to true
                           If WebApp.DisableHostNames is also set it improves the security by making the back end accessible only 
                           via API calls
                           Note: calls will fail if this option is used but back end is not on the same ASE
        """
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if hosting_environment_id is not None:
            pulumi.set(__self__, "hosting_environment_id", hosting_environment_id)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if use_internal_routing is not None:
            pulumi.set(__self__, "use_internal_routing", use_internal_routing)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[str]:
        """
        Host Id
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> Optional[str]:
        """
        Hosting environment Id
        """
        return pulumi.get(self, "hosting_environment_id")

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[str]:
        """
        service url to use
        """
        return pulumi.get(self, "service_url")

    @property
    @pulumi.getter(name="useInternalRouting")
    def use_internal_routing(self) -> Optional[bool]:
        """
        When the backend url is in same ASE, for performance reason this flag can be set to true
                    If WebApp.DisableHostNames is also set it improves the security by making the back end accessible only 
                    via API calls
                    Note: calls will fail if this option is used but back end is not on the same ASE
        """
        return pulumi.get(self, "use_internal_routing")


@pulumi.output_type
class ParameterCustomLoginSettingValuesResponse(dict):
    """
    Custom logging setting values
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customParameters":
            suggest = "custom_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterCustomLoginSettingValuesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterCustomLoginSettingValuesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterCustomLoginSettingValuesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 custom_parameters: Optional[Mapping[str, 'outputs.CustomLoginSettingValueResponse']] = None,
                 id: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        Custom logging setting values
        :param str location: Resource Location
        :param Mapping[str, 'CustomLoginSettingValueResponse'] custom_parameters: Custom parameters.
        :param str id: Resource Id
        :param str kind: Kind of resource
        :param str name: Resource Name
        :param Mapping[str, str] tags: Resource tags
        :param str type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if custom_parameters is not None:
            pulumi.set(__self__, "custom_parameters", custom_parameters)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="customParameters")
    def custom_parameters(self) -> Optional[Mapping[str, 'outputs.CustomLoginSettingValueResponse']]:
        """
        Custom parameters.
        """
        return pulumi.get(self, "custom_parameters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ResponseMessageEnvelopeApiEntityResponse(dict):
    """
    Message envelope that contains the common Azure resource manager properties and the resource provider specific content
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 name: Optional[str] = None,
                 plan: Optional['outputs.ArmPlanResponse'] = None,
                 properties: Optional['outputs.ApiEntityResponse'] = None,
                 sku: Optional['outputs.SkuDescriptionResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        Message envelope that contains the common Azure resource manager properties and the resource provider specific content
        :param str id: Resource Id. Typically id is populated only for responses to GET requests. Caller is responsible for passing in this
                           value for GET requests only.
                           For example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
        :param str location: Geo region resource belongs to e.g. SouthCentralUS, SouthEastAsia
        :param str name: Name of resource
        :param 'ArmPlanResponse' plan: Azure resource manager plan
        :param 'ApiEntityResponse' properties: Resource specific properties
        :param 'SkuDescriptionResponse' sku: Sku description of the resource
        :param Mapping[str, str] tags: Tags associated with resource
        :param str type: Type of resource e.g Microsoft.Web/sites
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id. Typically id is populated only for responses to GET requests. Caller is responsible for passing in this
                    value for GET requests only.
                    For example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Geo region resource belongs to e.g. SouthCentralUS, SouthEastAsia
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> Optional['outputs.ArmPlanResponse']:
        """
        Azure resource manager plan
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ApiEntityResponse']:
        """
        Resource specific properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.SkuDescriptionResponse']:
        """
        Sku description of the resource
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tags associated with resource
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of resource e.g Microsoft.Web/sites
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SkuDescriptionResponse(dict):
    """
    Describes a sku for a scalable resource
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 name: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Describes a sku for a scalable resource
        :param int capacity: Current number of instances assigned to the resource
        :param str family: Family code of the resource sku
        :param str name: Name of the resource sku
        :param str size: Size specifier of the resource sku
        :param str tier: Service Tier of the resource sku
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Current number of instances assigned to the resource
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        Family code of the resource sku
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource sku
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        Size specifier of the resource sku
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Service Tier of the resource sku
        """
        return pulumi.get(self, "tier")


